/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.controller;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.TimerTask;
import javafx.collections.ObservableList;
import kst4contest.controller.ChatController;
import kst4contest.controller.UCXLogFileToHashsetParser;
import kst4contest.model.ChatMember;
import kst4contest.model.ClusterMessage;

public class UserActualizationTask
extends TimerTask {
    private ChatController client;

    public UserActualizationTask(ChatController client) {
        this.client = client;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("UserActualizationTask");
        HashMap<Object, Object> fetchedWorkedSet = new HashMap();
        File f = new File(this.client.getChatPreferences().getLogsynch_fileBasedWkdCallInterpreterFileNameReadOnly());
        if (!f.exists() && !f.isDirectory()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        UCXLogFileToHashsetParser getWorkedCallsignsOfUCXLogFile = new UCXLogFileToHashsetParser(this.client.getChatPreferences().getLogsynch_fileBasedWkdCallInterpreterFileNameReadOnly());
        try {
            fetchedWorkedSet = getWorkedCallsignsOfUCXLogFile.parse();
            System.out.println("USERACT: fetchedWorkedSet size: " + fetchedWorkedSet.size());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ObservableList<ChatMember> praktiKSTActiveUserList = this.client.getLst_chatMemberList();
        for (ChatMember chatMember : praktiKSTActiveUserList) {
            if (!fetchedWorkedSet.containsKey(chatMember.getCallSign())) continue;
            chatMember.setWorked(true);
            System.out.println("[USERACT, info:] marking Chatuser " + chatMember.getCallSign() + " as worked, based on READONLY-Logfile.");
        }
        ObservableList<ClusterMessage> praktiKSTClusterList = this.client.getLst_clusterMemberList();
        for (ClusterMessage clusterMessage : praktiKSTClusterList) {
            if (!fetchedWorkedSet.containsKey(clusterMessage.getReceiver().getCallSign())) continue;
            clusterMessage.setReceiverWkd(true);
            System.out.println("[USERACT, info:] marking Clusterspotted " + clusterMessage.getReceiver().getCallSign() + " as worked.");
        }
    }
}

