/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.controller;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Comparator;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import kst4contest.controller.ChatController;
import kst4contest.controller.ThreadStatusCallback;
import kst4contest.model.AirPlane;
import kst4contest.model.AirPlaneReflectionInfo;
import kst4contest.model.ChatMember;
import kst4contest.model.ThreadStateMessage;

public class ReadUDPbyAirScoutMessageThread
extends Thread {
    private BufferedReader reader;
    private Socket socket;
    private ChatController client;
    private int localPort;
    private String ASIdentificator;
    private String ChatClientIdentificator;
    private ThreadStatusCallback callBackToController;
    private String ThreadNickName = "AirScout msg";

    public ReadUDPbyAirScoutMessageThread(int localPort, ChatController client, String ASIdentificator, String ChatClientIdentificator, ThreadStatusCallback callback) {
        this.callBackToController = callback;
        this.localPort = localPort;
        this.client = client;
        this.ASIdentificator = ASIdentificator;
        this.ChatClientIdentificator = ChatClientIdentificator;
    }

    @Override
    public void interrupt() {
        System.out.println("ReadUDP");
        super.interrupt();
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void callThreadStateToUi(ThreadStateMessage threadStateMessage) {
        if (this.callBackToController != null) {
            this.callBackToController.onThreadStatus("AirScout", threadStateMessage);
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName("ReadUDPByAirScoutThread");
        DatagramSocket socket = null;
        byte[] buf = new byte[1777];
        DatagramPacket packet = new DatagramPacket(buf, buf.length);
        try {
            socket = new DatagramSocket(null);
            socket.setReuseAddress(true);
            socket.bind(new InetSocketAddress(this.localPort));
            socket.receive(packet);
            socket.setSoTimeout(3000);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            // empty catch block
        }
        while (true) {
            try {
                if (this.client.isDisconnectionPerformedByUser()) break;
                socket.receive(packet);
            }
            catch (SocketTimeoutException e) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            InetAddress address = packet.getAddress();
            int port = packet.getPort();
            String received = new String(packet.getData(), packet.getOffset(), packet.getLength());
            received = received.trim();
            if (received.contains("POISONPILL_KILLTHREAD")) {
                System.out.println("ReadUdpByASMsgTh, Info: got poison, now dieing....");
                try {
                    this.terminateConnection();
                }
                catch (Exception e) {
                    System.out.println("ASUDPRDR: catched error " + e.getMessage());
                }
                break;
            }
            if (!received.contains("ASSETPATH") && !received.contains("ASWATCHLIST") && received.contains("ASNEAREST:")) {
                AirPlaneReflectionInfo apReflectInfoForChatMember = this.processASUDPMessage(received);
                if (!this.client.getLst_chatMemberList().isEmpty()) {
                    try {
                        ((ChatMember)this.client.getLst_chatMemberList().get(this.client.checkListForChatMemberIndexByCallSign(apReflectInfoForChatMember.getReceiver()))).setAirPlaneReflectInfo(apReflectInfoForChatMember);
                    }
                    catch (Exception e) {
                        System.out.println("ReadUdpByAsMsgTh, Warning:" + apReflectInfoForChatMember.getReceiver().getCallSign() + " is not in the Chatmemberlist or the Chatmemberlist is modified by another Thread");
                    }
                    ThreadStateMessage threadStateMessage = new ThreadStateMessage(this.ThreadNickName, true, "received line\n" + apReflectInfoForChatMember.toString(), false);
                    this.callBackToController.onThreadStatus(this.ThreadNickName, threadStateMessage);
                }
            }
            buf = new byte[1777];
        }
    }

    public AirPlaneReflectionInfo processASUDPMessage(String udpStringToProcess) {
        AirPlaneReflectionInfo apInfo = new AirPlaneReflectionInfo();
        ObservableList airplaneList = FXCollections.observableArrayList();
        if (udpStringToProcess.contains("ASNEAREST: ")) {
            udpStringToProcess = udpStringToProcess.replace("ASNEAREST: ", "");
            udpStringToProcess = udpStringToProcess.replace(" ", "");
            String[] fullStringSplitter = udpStringToProcess.split("\"");
            String APInfoString = fullStringSplitter[5];
            String[] apStringSplitter = APInfoString.split(",");
            String[] allAPInfos = new String[apStringSplitter.length - 6];
            for (int i = 0; i < apStringSplitter.length; ++i) {
                if (i < 6) continue;
                allAPInfos[i - 6] = apStringSplitter[i];
            }
            AirPlane airPlane = new AirPlane();
            for (int i = 0; i < allAPInfos.length; ++i) {
                if (i % 5 == 0) {
                    airPlane = new AirPlane();
                    airPlane.setApCallSign(allAPInfos[i]);
                } else if (i % 5 == 1) {
                    airPlane.setApSizeCategory(allAPInfos[i]);
                } else if (i % 5 == 2) {
                    airPlane.setDistanceKm(Integer.parseInt(allAPInfos[i]));
                } else if (i % 5 == 3) {
                    airPlane.setPotential(Integer.parseInt(allAPInfos[i]));
                }
                if (i % 5 != 4) continue;
                airPlane.setArrivingDurationMinutes(Integer.parseInt(allAPInfos[i]));
                airplaneList.add((Object)airPlane);
            }
            apInfo.setDate(apStringSplitter[0]);
            ChatMember apStartCallSign = new ChatMember();
            apStartCallSign.setCallSign(apStringSplitter[1]);
            apStartCallSign.setQra(apStringSplitter[2]);
            apInfo.setSender(apStartCallSign);
            ChatMember apDestCallSign = new ChatMember();
            apDestCallSign.setCallSign(apStringSplitter[3]);
            apDestCallSign.setQra(apStringSplitter[4]);
            apInfo.setReceiver(apDestCallSign);
            apInfo.setAirPlanesReachableCntr(Integer.parseInt(apStringSplitter[5]));
            apInfo.setRisingAirplanes((ObservableList<AirPlane>)airplaneList);
            airplaneList.sort(Comparator.comparing(AirPlane::getPotential).reversed().thenComparing(AirPlane::getArrivingDurationMinutes));
        }
        return apInfo;
    }

    public boolean terminateConnection() {
        try {
            this.socket.close();
        }
        catch (Exception e) {
            System.out.println("udpbyas: catched " + e.getMessage());
        }
        return true;
    }
}

