/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.view;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.Polygon;
import javafx.scene.text.Font;
import kst4contest.model.ChatCategory;
import kst4contest.model.ContestSked;

public class TimelineView
extends Pane {
    private double currentAntennaAzimuth = 0.0;
    private double beamWidth = 50.0;
    private final long PREVIEW_TIME_MS = 1800000L;
    double margin = 30.0;
    private Function<ContestSked, String> skedTooltipExtraTextProvider;
    private Consumer<CandidateEvent> onCandidateClicked;

    public TimelineView() {
        this.setPrefHeight(40.0);
        this.setStyle("-fx-background-color: #2b2b2b;");
    }

    @Deprecated
    public TimelineView(int opportunityPotentialPercent, String tooltipText) {
        this();
    }

    public void setCurrentAntennaAzimuth(double az) {
        this.currentAntennaAzimuth = az;
    }

    public long getPreviewTimeMs() {
        return 1800000L;
    }

    public void setOnCandidateClicked(Consumer<CandidateEvent> handler) {
        this.onCandidateClicked = handler;
    }

    public void updateVisuals(List<ContestSked> skeds) {
        this.updateVisuals(skeds, Collections.emptyList());
    }

    public void updateVisuals(List<ContestSked> skeds, List<CandidateEvent> candidates) {
        Node marker;
        double xPos;
        double percent;
        long timeDiff;
        this.getChildren().clear();
        double width = this.getWidth();
        if (width <= 5.0) {
            return;
        }
        double axisY = 30.0;
        Line axis = new Line(0.0, axisY, width, axisY);
        axis.setStroke((Paint)Color.GRAY);
        this.getChildren().add((Object)axis);
        long now = System.currentTimeMillis();
        for (CandidateEvent ev : candidates) {
            timeDiff = ev.getTimeUntilMs();
            if (timeDiff < 0L || timeDiff > 1800000L) continue;
            percent = (double)timeDiff / 1800000.0;
            xPos = percent * width;
            xPos = Math.max(this.margin, Math.min(this.getWidth() - this.margin, xPos));
            marker = this.createCandidateMarker(ev);
            this.applyAntennaEffect(marker, ev.getTargetAzimuth());
            double laneBaseY = 2.0;
            double laneOffsetY = 14.0 * (double)ev.getLaneIndex();
            marker.setLayoutX(xPos);
            marker.setLayoutY(laneBaseY + laneOffsetY);
            this.getChildren().add((Object)marker);
        }
        for (ContestSked sked : skeds) {
            timeDiff = sked.getSkedTimeEpoch() - now;
            if (timeDiff < 0L || timeDiff > 1800000L) continue;
            percent = (double)timeDiff / 1800000.0;
            xPos = percent * width;
            xPos = this.clamp(xPos, 10.0, width - 10.0);
            marker = this.createSkedMarker(sked);
            this.applyAntennaEffect(marker, sked.getTargetAzimuth());
            marker.setLayoutX(xPos);
            marker.setLayoutY(axisY - 18.0);
            this.getChildren().add((Object)marker);
        }
    }

    private double clamp(double v, double min, double max) {
        return Math.max(min, Math.min(max, v));
    }

    private void applyAntennaEffect(Node marker, double targetAz) {
        double iconOpacity;
        if (!Double.isFinite(targetAz) || targetAz < 0.0) {
            return;
        }
        double delta = Math.abs(this.currentAntennaAzimuth - targetAz);
        if (delta > 180.0) {
            delta = 360.0 - delta;
        }
        boolean onTarget = delta <= this.beamWidth / 2.0;
        boolean inBeam = delta <= this.beamWidth;
        double d = iconOpacity = inBeam ? 1.0 : 0.3;
        if (marker instanceof Group) {
            Group g = (Group)marker;
            g.setOpacity(1.0);
            for (Node child : g.getChildren()) {
                if (child instanceof Label) {
                    child.setOpacity(1.0);
                    continue;
                }
                child.setOpacity(iconOpacity);
            }
            if (onTarget) {
                g.setEffect((Effect)new DropShadow(10.0, Color.LIMEGREEN));
                g.setScaleX(1.1);
                g.setScaleY(1.1);
            } else {
                g.setEffect(null);
                g.setScaleX(1.0);
                g.setScaleY(1.0);
            }
            return;
        }
        marker.setOpacity(iconOpacity);
        marker.setEffect((Effect)(onTarget ? new DropShadow(10.0, Color.LIMEGREEN) : null));
    }

    public void setSkedTooltipExtraTextProvider(Function<ContestSked, String> provider) {
        this.skedTooltipExtraTextProvider = provider;
    }

    private Node createSkedMarker(ContestSked sked) {
        String extra;
        Polygon diamond = new Polygon(new double[]{0.0, 0.0, 6.0, 6.0, 0.0, 12.0, -6.0, 6.0});
        diamond.setFill((Paint)this.colorForPotential(sked.getOpportunityPotentialPercent()));
        String baseToolTipFallBack = sked.getTargetCallsign() + " (" + sked.getBand() + ")\nAz: " + sked.getTargetAzimuth();
        if (this.skedTooltipExtraTextProvider != null && (extra = this.skedTooltipExtraTextProvider.apply(sked)) != null && !extra.isBlank()) {
            baseToolTipFallBack = baseToolTipFallBack + "\n" + extra;
        }
        Tooltip t = new Tooltip(baseToolTipFallBack);
        Tooltip.install((Node)diamond, (Tooltip)t);
        Label lbl = new Label("SKED: " + sked.getTargetCallsign());
        lbl.setLayoutY(14.0);
        lbl.setLayoutX(-10.0);
        lbl.setStyle("-fx-text-fill: white;-fx-font-weight: bold;-fx-background-color: rgba(0,0,0,0.65);-fx-background-radius: 6;-fx-padding: 1 4 1 4;");
        lbl.setEffect((Effect)new DropShadow(2.0, Color.BLACK));
        return new Group(new Node[]{diamond, lbl});
    }

    private Color colorForPotential(int p) {
        if (p >= 95) {
            return Color.MAGENTA;
        }
        if (p >= 75) {
            return Color.RED;
        }
        if (p >= 50) {
            return Color.YELLOW;
        }
        return Color.DEEPSKYBLUE;
    }

    private Node createCandidateMarker(CandidateEvent ev) {
        Color markerColor = this.colorForPotential(ev.getOpportunityPotentialPercent());
        Polygon tri = new Polygon(new double[]{-6.0, 0.0, 6.0, 0.0, 0.0, 10.0});
        tri.setFill((Paint)markerColor);
        Circle dot = new Circle(4.0, (Paint)markerColor);
        dot.setLayoutY(5.0);
        Label lbl = new Label(ev.getDisplayCallSign());
        lbl.setFont(new Font(9.0));
        lbl.setTextFill((Paint)Color.WHITE);
        lbl.setLayoutY(10.0);
        lbl.setLayoutX(-12.0);
        lbl.setStyle("-fx-text-fill: white;-fx-font-weight: bold;-fx-background-color: rgba(0,0,0,0.65);-fx-background-radius: 6;-fx-padding: 1 4 1 4;");
        lbl.setEffect((Effect)new DropShadow(8.0, Color.BLACK));
        Group g = new Group(new Node[]{dot, tri, lbl});
        if (ev.getTooltipText() != null && !ev.getTooltipText().isBlank()) {
            Tooltip.install((Node)g, (Tooltip)new Tooltip(ev.getTooltipText()));
        }
        g.setOnMouseClicked(e -> {
            if (this.onCandidateClicked != null) {
                this.onCandidateClicked.accept(ev);
            }
        });
        return g;
    }

    public void setBeamWidthDeg(double beamWidthDeg) {
        if (beamWidthDeg > 0.0 && Double.isFinite(beamWidthDeg)) {
            this.beamWidth = beamWidthDeg;
        }
    }

    public static class CandidateEvent {
        private final String callSignRaw;
        private final String displayCallSign;
        private final ChatCategory preferredChatCategory;
        private final long timeUntilMs;
        private final int minuteBucket;
        private final int laneIndex;
        private final double targetAzimuth;
        private final double score;
        private final String tooltipText;
        private final int opportunityPotentialPercent;

        public CandidateEvent(String callSignRaw, String displayCallSign, ChatCategory preferredChatCategory, long timeUntilMs, int minuteBucket, int laneIndex, double targetAzimuth, double score, int opportunityPotentialPercent, String tooltipText) {
            this.callSignRaw = callSignRaw;
            this.displayCallSign = displayCallSign;
            this.preferredChatCategory = preferredChatCategory;
            this.timeUntilMs = timeUntilMs;
            this.minuteBucket = minuteBucket;
            this.laneIndex = laneIndex;
            this.targetAzimuth = targetAzimuth;
            this.score = score;
            this.opportunityPotentialPercent = opportunityPotentialPercent;
            this.tooltipText = tooltipText;
        }

        public String getCallSignRaw() {
            return this.callSignRaw;
        }

        public String getDisplayCallSign() {
            return this.displayCallSign;
        }

        public ChatCategory getPreferredChatCategory() {
            return this.preferredChatCategory;
        }

        public long getTimeUntilMs() {
            return this.timeUntilMs;
        }

        public int getMinuteBucket() {
            return this.minuteBucket;
        }

        public int getLaneIndex() {
            return this.laneIndex;
        }

        public double getTargetAzimuth() {
            return this.targetAzimuth;
        }

        public double getScore() {
            return this.score;
        }

        public String getTooltipText() {
            return this.tooltipText;
        }

        public int getOpportunityPotentialPercent() {
            return this.opportunityPotentialPercent;
        }
    }
}

