/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;

public class MockKstServer {
    private static final int PORT = 23001;
    private static final String CHAT_ID = "2";
    private final List<PrintWriter> clients = new CopyOnWriteArrayList<PrintWriter>();
    private final Map<String, User> onlineUsers = new HashMap<String, User>();
    private final List<String> historyChat = Collections.synchronizedList(new ArrayList());
    private final List<String> historyDx = Collections.synchronizedList(new ArrayList());
    private boolean running = false;
    private ServerSocket serverSocket;

    public MockKstServer() {
        this.addUser("DK5EW", "Erwin", "JN47NX");
        this.addUser("DL1TEST", "TestOp", "JO50XX");
        this.addUser("ON4KST", "Alain", "JO20HI");
        this.addUser("PA9R-2", CHAT_ID, "JO20HI");
        this.addUser("PA9R-70", "70", "JO20HI");
        this.addUser("PA9R", "general", "JO20HI");
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        new Thread(() -> {
            block3: {
                try {
                    this.serverSocket = new ServerSocket(23001);
                    System.out.println("[Server] ON4KST Simulation gestartet auf Port 23001");
                    new Thread(this::simulationLoop).start();
                    while (this.running) {
                        Socket clientSocket = this.serverSocket.accept();
                        System.out.println("[Server] Neuer Client verbunden: " + clientSocket.getInetAddress());
                        new Thread(new ClientHandler(clientSocket)).start();
                    }
                }
                catch (IOException e) {
                    if (!this.running) break block3;
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public void stop() {
        this.running = false;
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addUser(String call, String name, String loc) {
        this.onlineUsers.put(call, new User(call, name, loc));
    }

    private void removeUser(String call) {
        this.onlineUsers.remove(call);
    }

    private void broadcast(String message) {
        if (!((String)message).endsWith("\r\n")) {
            message = (String)message + "\r\n";
        }
        String finalMsg = message;
        for (PrintWriter writer : this.clients) {
            try {
                writer.print(finalMsg);
                writer.flush();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChatMessage(String call, String name, String text) {
        String date = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String frame = String.format("CH|%s|%s|%s|%s|0|%s|0|", CHAT_ID, date, call, name, text);
        List<String> list = this.historyChat;
        synchronized (list) {
            this.historyChat.add(frame);
            if (this.historyChat.size() > 50) {
                this.historyChat.remove(0);
            }
        }
        this.broadcast(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDxSpot(String spotter, String dx, String freq) {
        long unixTime = System.currentTimeMillis() / 1000L;
        String utc = new SimpleDateFormat("HHmm").format(new Date());
        String frame = String.format("DL|%d|%s|%s|%s|%s|Simulated|JO00|JO99|", unixTime, utc, spotter, freq, dx);
        List<String> list = this.historyDx;
        synchronized (list) {
            this.historyDx.add(frame);
            if (this.historyDx.size() > 20) {
                this.historyDx.remove(0);
            }
        }
        this.broadcast(frame);
    }

    private void simulationLoop() {
        String[] randomCalls = new String[]{"PA0GUS", "F6APE", "OH8K", "OZ2M", "G4CBW"};
        String[] msgs = new String[]{"CQ 144.300", "Tnx for QSO", "Any sked?", "QRV 432.200"};
        Random rand = new Random();
        while (this.running) {
            try {
                Thread.sleep(3000 + rand.nextInt(5000));
                int action = rand.nextInt(10);
                String call = randomCalls[rand.nextInt(randomCalls.length)];
                if (action < 4) {
                    this.handleChatMessage(call, "SimOp", msgs[rand.nextInt(msgs.length)]);
                } else if (action < 7) {
                    this.handleDxSpot(call, randomCalls[rand.nextInt(randomCalls.length)], "144." + rand.nextInt(400));
                } else if (action == 8) {
                    if (!this.onlineUsers.containsKey(call)) {
                        this.addUser(call, "SimOp", "JO11");
                        this.broadcast("UA5|2|" + call + "|SimOp|JO11|2|");
                    }
                } else if (action == 9 && this.onlineUsers.containsKey(call) && !call.equals("DK5EW")) {
                    this.removeUser(call);
                    this.broadcast("UR6|2|" + call + "|");
                }
                if (rand.nextInt(5) != 0) continue;
                this.broadcast("CK|");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static class User {
        String call;
        String name;
        String loc;

        User(String c, String n, String l) {
            this.call = c;
            this.name = n;
            this.loc = l;
        }
    }

    private class ClientHandler
    implements Runnable {
        private Socket socket;
        private PrintWriter out;
        private BufferedReader in;
        private String myCall = "MYCLIENT";

        public ClientHandler(Socket socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String line;
                this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "ISO-8859-1"));
                this.out = new PrintWriter((Writer)new OutputStreamWriter(this.socket.getOutputStream(), "ISO-8859-1"), true);
                MockKstServer.this.clients.add(this.out);
                boolean loginComplete = false;
                while ((line = this.in.readLine()) != null) {
                    String[] parts = line.split("\\|");
                    String cmd = parts[0];
                    if (cmd.equals("LOGIN") || cmd.equals("LOGINC")) {
                        if (parts.length > 1) {
                            this.myCall = parts[1];
                        }
                        this.send("LOGSTAT|100|2|JavaSim|KEY123|Config|3|");
                        if (!cmd.equals("LOGIN")) continue;
                        this.sendInitialData();
                        loginComplete = true;
                        continue;
                    }
                    if (cmd.equals("SDONE")) {
                        this.sendInitialData();
                        loginComplete = true;
                        continue;
                    }
                    if (cmd.equals("MSG")) {
                        if (parts.length < 4) continue;
                        String text = parts[3];
                        MockKstServer.this.handleChatMessage(this.myCall, "Me", text);
                        continue;
                    }
                    if (!cmd.equals("CK")) continue;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                MockKstServer.this.clients.remove(this.out);
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {}
            }
        }

        private void send(String msg) {
            if (!((String)msg).endsWith("\r\n")) {
                msg = (String)msg + "\r\n";
            }
            this.out.print((String)msg);
            this.out.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendInitialData() {
            for (User u : MockKstServer.this.onlineUsers.values()) {
                this.send("UA0|2|" + u.call + "|" + u.name + "|" + u.loc + "|0|");
            }
            List<String> list = MockKstServer.this.historyChat;
            synchronized (list) {
                for (String h : MockKstServer.this.historyChat) {
                    this.send(h);
                }
            }
            list = MockKstServer.this.historyDx;
            synchronized (list) {
                for (String d : MockKstServer.this.historyDx) {
                    this.send(d);
                }
            }
            this.send("UE|2|" + MockKstServer.this.onlineUsers.size() + "|");
        }
    }
}

