/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.model;

public enum Band {
    B_144(144.0, 146.0, "144"),
    B_432(432.0, 434.0, "432"),
    B_1296(1296.0, 1298.0, "1296"),
    B_2320(2320.0, 2322.0, "2320"),
    B_3400(3400.0, 3410.0, "3400"),
    B_5760(5760.0, 5762.0, "5760"),
    B_10G(10368.0, 10370.0, "10368"),
    B_24G(24048.0, 24050.0, "24048");

    private final double minFreq;
    private final double maxFreq;
    private final String prefix;

    private Band(double min, double max, String prefix) {
        this.minFreq = min;
        this.maxFreq = max;
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isPlausible(double freq) {
        return freq >= this.minFreq && freq <= this.maxFreq;
    }

    public static Band fromFrequency(double freq) {
        for (Band b : Band.values()) {
            if (!b.isPlausible(freq)) continue;
            return b;
        }
        return null;
    }
}

