/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.logic;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

public final class SignalDetector {
    private static final AtomicReference<String> lastPatterns = new AtomicReference<String>("");
    private static final AtomicReference<List<Pattern>> cached = new AtomicReference(List.of());

    private SignalDetector() {
    }

    public static boolean containsPositiveSignal(String messageText, String patternsDelimited) {
        if (messageText == null || messageText.isBlank()) {
            return false;
        }
        List<Pattern> patterns = SignalDetector.compileIfChanged(patternsDelimited);
        String txt = messageText.toUpperCase();
        for (Pattern p : patterns) {
            if (!p.matcher(txt).find()) continue;
            return true;
        }
        return false;
    }

    private static List<Pattern> compileIfChanged(String patternsDelimited) {
        String prev;
        String p = patternsDelimited == null ? "" : patternsDelimited.trim();
        if (p.equals(prev = lastPatterns.get())) {
            return cached.get();
        }
        ArrayList<Pattern> out = new ArrayList<Pattern>();
        for (String token : p.split("[;\\n\\r]+")) {
            String t = token.trim();
            if (t.isEmpty()) continue;
            String regex = Pattern.quote(t.toUpperCase());
            out.add(Pattern.compile(regex));
        }
        lastPatterns.set(p);
        cached.set(List.copyOf(out));
        return out;
    }
}

