/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.logic;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import kst4contest.controller.StationMetricsService;
import kst4contest.model.AirPlane;
import kst4contest.model.AirPlaneReflectionInfo;
import kst4contest.model.Band;
import kst4contest.model.ChatMember;
import kst4contest.model.ChatPreferences;
import kst4contest.model.ContestSked;

public class PriorityCalculator {
    private static final long RX_BANDS_MAX_AGE_MS = 1800000L;

    public double calculatePriority(ChatMember member, ChatPreferences prefs, List<ContestSked> activeSkeds, StationMetricsService.Snapshot metricsSnapshot, long nowEpochMs) {
        StationMetricsService.Snapshot.Metrics mx;
        double halfBeam;
        double targetAz;
        double myAz;
        double diff;
        AirPlaneReflectionInfo apInfo;
        double distKm;
        EnumSet<Band> possibleBands;
        if (member == null || prefs == null) {
            return 0.0;
        }
        String callRaw = PriorityCalculator.normalize(member.getCallSignRaw());
        if (callRaw == null || callRaw.isBlank()) {
            return 0.0;
        }
        EnumSet<Band> myEnabledBands = PriorityCalculator.getMyEnabledBands(prefs);
        EnumSet<Band> workedBandsForScoring = PriorityCalculator.getWorkedBands(member);
        EnumSet<Band> unworkedPossible = EnumSet.noneOf(Band.class);
        EnumSet<Band> stationOfferedBands = PriorityCalculator.getStationOfferedBandsFromHistory(member, nowEpochMs);
        EnumSet<Band> enumSet = possibleBands = stationOfferedBands.isEmpty() ? EnumSet.noneOf(Band.class) : EnumSet.copyOf(stationOfferedBands);
        if (!possibleBands.isEmpty()) {
            possibleBands.retainAll(myEnabledBands);
            if (possibleBands.isEmpty()) {
                return 0.0;
            }
            unworkedPossible = EnumSet.copyOf(possibleBands);
            unworkedPossible.removeAll(workedBandsForScoring);
            if (unworkedPossible.isEmpty()) {
                return 0.0;
            }
        }
        double score = 100.0;
        score = workedBandsForScoring.isEmpty() ? (score += 200.0) : (score -= 150.0);
        if (!possibleBands.isEmpty()) {
            int bandCount = possibleBands.size();
            score += (double)(bandCount - 1) * 80.0;
        }
        if (prefs.isNotify_bandUpgradePriorityBoostEnabled() && !workedBandsForScoring.isEmpty() && !unworkedPossible.isEmpty()) {
            score += 180.0;
        }
        double d = distKm = member.getQrb() == null ? 0.0 : member.getQrb();
        if (distKm > 0.0) {
            score = distKm < 200.0 ? (score *= 0.7) : (distKm > prefs.getStn_maxQRBDefault() ? (score *= 0.3) : (score *= 1.15));
        }
        if ((apInfo = member.getAirPlaneReflectInfo()) != null && apInfo.getAirPlanesReachableCntr() > 0) {
            score += 200.0;
            int nextMinutes = PriorityCalculator.findNextAirplaneArrivingMinutes(apInfo);
            if (nextMinutes == 0) {
                score += 120.0;
            } else if (nextMinutes == 1) {
                score += 60.0;
            } else if (nextMinutes == 2) {
                score += 30.0;
            }
        }
        if (member.getQTFdirection() != null && (diff = PriorityCalculator.minimalAngleDiffDeg(myAz = prefs.getActualQTF().getValue().doubleValue(), targetAz = member.getQTFdirection().doubleValue())) <= (halfBeam = Math.max(1.0, prefs.getStn_antennaBeamWidthDeg()) / 2.0)) {
            double centerFactor = 1.0 - diff / halfBeam;
            score += 80.0 + 120.0 * centerFactor;
        }
        if (metricsSnapshot != null && (mx = metricsSnapshot.get(callRaw)) != null) {
            long ageMs;
            long l = ageMs = mx.lastInboundEpochMs > 0L ? nowEpochMs - mx.lastInboundEpochMs : Long.MAX_VALUE;
            if (ageMs < 60000L) {
                score += 120.0;
            } else if (ageMs < 180000L) {
                score += 60.0;
            }
            int cnt = mx.inboundCountInWindow;
            if (cnt >= 6) {
                score += 160.0;
            } else if (cnt >= 4) {
                score += 110.0;
            } else if (cnt >= 2) {
                score += 60.0;
            }
            if (mx.lastPositiveSignalEpochMs > 0L && nowEpochMs - mx.lastPositiveSignalEpochMs < 300000L) {
                score += 120.0;
            }
            if (mx.avgResponseTimeMs > 0.0) {
                if (mx.avgResponseTimeMs < 60000.0) {
                    score += 80.0;
                } else if (mx.avgResponseTimeMs < 180000.0) {
                    score += 40.0;
                }
            }
            if (mx.noReplyStrikes > 0) {
                score /= 1.0 + (double)mx.noReplyStrikes * 0.6;
            }
            if (mx.manualSkedFailed) {
                score *= 0.15;
            }
        }
        if (activeSkeds != null && !activeSkeds.isEmpty()) {
            for (ContestSked sked : activeSkeds) {
                if (sked == null || !callRaw.equals(PriorityCalculator.normalize(sked.getTargetCallsign()))) continue;
                long seconds = sked.getTimeUntilSkedSeconds();
                if (seconds < 180L && seconds > -60L) {
                    score += 5000.0;
                    continue;
                }
                if (seconds >= 0L && seconds <= 900L) {
                    double t = (double)(900L - seconds) / 900.0;
                    score += 300.0 + 900.0 * t;
                    continue;
                }
                if (seconds <= 900L) continue;
                score += 40.0;
            }
        }
        if (member.getFailedQSOAttempts() > 0) {
            score /= (double)(member.getFailedQSOAttempts() + 1);
        }
        return Math.max(0.0, score);
    }

    private static EnumSet<Band> getMyEnabledBands(ChatPreferences prefs) {
        EnumSet<Band> out = EnumSet.noneOf(Band.class);
        if (prefs.isStn_bandActive144()) {
            out.add(Band.B_144);
        }
        if (prefs.isStn_bandActive432()) {
            out.add(Band.B_432);
        }
        if (prefs.isStn_bandActive1240()) {
            out.add(Band.B_1296);
        }
        if (prefs.isStn_bandActive2300()) {
            out.add(Band.B_2320);
        }
        if (prefs.isStn_bandActive3400()) {
            out.add(Band.B_3400);
        }
        if (prefs.isStn_bandActive5600()) {
            out.add(Band.B_5760);
        }
        if (prefs.isStn_bandActive10G()) {
            out.add(Band.B_10G);
        }
        return out;
    }

    private static EnumSet<Band> getStationOfferedBandsFromHistory(ChatMember member, long nowEpochMs) {
        EnumSet<Band> out = EnumSet.noneOf(Band.class);
        Map<Band, ChatMember.ActiveFrequencyInfo> map = member.getKnownActiveBands();
        if (map == null || map.isEmpty()) {
            return out;
        }
        for (Map.Entry<Band, ChatMember.ActiveFrequencyInfo> e : map.entrySet()) {
            long age;
            if (e == null || e.getKey() == null || e.getValue() == null || (age = nowEpochMs - e.getValue().timestampEpoch) > 1800000L) continue;
            out.add(e.getKey());
        }
        return out;
    }

    private static EnumSet<Band> getWorkedBands(ChatMember member) {
        EnumSet<Band> out = EnumSet.noneOf(Band.class);
        if (member.isWorked144()) {
            out.add(Band.B_144);
        }
        if (member.isWorked432()) {
            out.add(Band.B_432);
        }
        if (member.isWorked1240()) {
            out.add(Band.B_1296);
        }
        if (member.isWorked2300()) {
            out.add(Band.B_2320);
        }
        if (member.isWorked3400()) {
            out.add(Band.B_3400);
        }
        if (member.isWorked5600()) {
            out.add(Band.B_5760);
        }
        if (member.isWorked10G()) {
            out.add(Band.B_10G);
        }
        if (member.isWorked24G()) {
            out.add(Band.B_24G);
        }
        return out;
    }

    private static int findNextAirplaneArrivingMinutes(AirPlaneReflectionInfo apInfo) {
        try {
            if (apInfo.getRisingAirplanes() == null || apInfo.getRisingAirplanes().isEmpty()) {
                return -1;
            }
            int min = Integer.MAX_VALUE;
            for (AirPlane ap : apInfo.getRisingAirplanes()) {
                if (ap == null) continue;
                min = Math.min(min, ap.getArrivingDurationMinutes());
            }
            return min == Integer.MAX_VALUE ? -1 : min;
        }
        catch (Exception ignore) {
            return -1;
        }
    }

    private static double minimalAngleDiffDeg(double a, double b) {
        double diff = Math.abs((a - b) % 360.0);
        return diff > 180.0 ? 360.0 - diff : diff;
    }

    private static String normalize(String s) {
        if (s == null) {
            return null;
        }
        return s.trim().toUpperCase();
    }
}

