/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import kst4contest.ApplicationConstants;
import kst4contest.controller.ChatController;
import kst4contest.model.ChatMessage;

public class WriteThread
extends Thread {
    private PrintWriter writer;
    private Socket socket;
    private ChatController client;
    private OutputStream output;
    private ChatMessage messageToBeSend;

    public WriteThread(Socket socket, ChatController client) throws InterruptedException {
        this.socket = socket;
        this.client = client;
        try {
            this.output = socket.getOutputStream();
            this.writer = new PrintWriter(this.output, true, StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            System.out.println("Error getting output stream: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void tx(ChatMessage messageToServer) throws InterruptedException {
        System.out.println(messageToServer.getMessageText() + "< sended to the writer");
        this.writer.println(messageToServer.getMessageText());
    }

    public void txByRxmsgCatOrigin(ChatMessage messageToServer) throws InterruptedException {
        String originalMessageText = messageToServer.getMessageText();
        Object newMessageText = "";
        newMessageText = "MSG|" + messageToServer.getChatCategory().getCategoryNumber() + "|0|" + originalMessageText + "|0|";
        System.out.println((String)newMessageText + "< sended to the writer (DIRECTED REPLY)");
        this.writer.println((String)newMessageText);
    }

    public void txKSTFormatted(ChatMessage messageToServer) throws InterruptedException {
        this.messageToBeSend = messageToServer;
        try {
            this.messageToBeSend = this.client.getMessageTXBus().take();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String messageLine = this.messageToBeSend.getMessageText();
        if (this.messageToBeSend.isMessageDirectedToServer()) {
            try {
                this.tx(this.messageToBeSend);
                System.out.println("BUS: tx: " + this.messageToBeSend.getMessageText());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            ChatMessage ownMSG = new ChatMessage();
            ownMSG.setMessageText("MSG|" + this.client.getChatPreferences().getLoginChatCategoryMain().getCategoryNumber() + "|0|" + messageLine + "|0|");
            try {
                this.tx(ownMSG);
                System.out.println("BUS: tx: " + ownMSG.getMessageText());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.messageToBeSend.equals("/QUIT")) {
            try {
                this.client.getReadThread().terminateConnection();
                this.client.getReadThread().interrupt();
                this.client.getWriteThread().terminateConnection();
                this.client.getWriteThread().interrupt();
                this.interrupt();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean terminateConnection() throws IOException {
        this.output.close();
        this.socket.close();
        return true;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("WriteToTelnetThread");
        block6: while (true) {
            try {
                while (true) {
                    this.messageToBeSend = this.client.getMessageTXBus().take();
                    if (this.messageToBeSend.getMessageText().equals(ApplicationConstants.DISCONNECT_RDR_POISONPILL) && this.messageToBeSend.getMessageSenderName().equals(ApplicationConstants.DISCONNECT_RDR_POISONPILL)) {
                        this.client.getMessageRXBus().clear();
                        this.interrupt();
                        break block6;
                    }
                    String messageLine = this.messageToBeSend.getMessageText();
                    if (this.messageToBeSend.isMessageDirectedToServer()) {
                        try {
                            this.tx(this.messageToBeSend);
                            System.out.println("BUS: tx: " + this.messageToBeSend.getMessageText());
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    } else if (this.messageToBeSend.getChatCategory() == this.client.getChatCategoryMain() || this.messageToBeSend.getChatCategory() == this.client.getChatCategorySecondChat()) {
                        this.txByRxmsgCatOrigin(this.messageToBeSend);
                    } else {
                        ChatMessage ownMSG = new ChatMessage();
                        ownMSG.setMessageText("MSG|" + this.client.getChatPreferences().getLoginChatCategoryMain().getCategoryNumber() + "|0|" + messageLine + "|0|");
                        try {
                            this.tx(ownMSG);
                            System.out.println("WT: tx (raw): " + ownMSG.getMessageText());
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    System.out.println("WritheTh: got message out of the queue: " + this.messageToBeSend.getMessageText());
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.client.getMessageTXBus().clear();
                continue;
            }
            break;
        }
    }
}

