/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.controller;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kst4contest.logic.SignalDetector;
import kst4contest.model.ChatPreferences;

public final class StationMetricsService {
    private static final Pattern OUTBOUND_CQ_PATTERN = Pattern.compile("(?i)^\\s*/cq\\s+([A-Z0-9/]+)\\b.*");
    private static final int MAX_STORED_INBOUND_TIMESTAMPS = 32;
    private final ConcurrentHashMap<String, StationMetrics> byCallRaw = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> tryRecordOutboundCq(String messageText, long nowEpochMs) {
        StationMetrics metrics;
        if (messageText == null) {
            return Optional.empty();
        }
        Matcher m = OUTBOUND_CQ_PATTERN.matcher(messageText.trim());
        if (!m.matches()) {
            return Optional.empty();
        }
        String callRaw = StationMetricsService.normalizeCallRaw(m.group(1));
        if (callRaw == null || callRaw.isBlank()) {
            return Optional.empty();
        }
        StationMetrics stationMetrics = metrics = this.byCallRaw.computeIfAbsent(callRaw, k -> new StationMetrics());
        synchronized (stationMetrics) {
            metrics.pendingCqSentAtEpochMs = nowEpochMs;
            metrics.lastOutboundCqEpochMs = nowEpochMs;
        }
        return Optional.of(callRaw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInboundMessage(String senderCallSignRaw, long nowEpochMs, String messageText, ChatPreferences prefs, String ownCallSignRaw) {
        StationMetrics metrics;
        String callRaw = StationMetricsService.normalizeCallRaw(senderCallSignRaw);
        if (callRaw == null || callRaw.isBlank()) {
            return;
        }
        if (ownCallSignRaw != null && callRaw.equalsIgnoreCase(StationMetricsService.normalizeCallRaw(ownCallSignRaw))) {
            return;
        }
        StationMetrics stationMetrics = metrics = this.byCallRaw.computeIfAbsent(callRaw, k -> new StationMetrics());
        synchronized (stationMetrics) {
            metrics.lastInboundEpochMs = nowEpochMs;
            metrics.recentInboundEpochMs.addLast(nowEpochMs);
            while (metrics.recentInboundEpochMs.size() > 32) {
                metrics.recentInboundEpochMs.removeFirst();
            }
            if (messageText != null && prefs != null && SignalDetector.containsPositiveSignal(messageText, prefs.getNotify_positiveSignalsPatterns())) {
                metrics.lastPositiveSignalEpochMs = nowEpochMs;
            }
            if (metrics.pendingCqSentAtEpochMs > 0L) {
                long rttMs = Math.max(0L, nowEpochMs - metrics.pendingCqSentAtEpochMs);
                metrics.pendingCqSentAtEpochMs = 0L;
                double alpha = 0.25;
                metrics.avgResponseTimeMs = metrics.avgResponseTimeMs <= 0.0 ? (double)rttMs : 0.25 * (double)rttMs + 0.75 * metrics.avgResponseTimeMs;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateNoReplyTimeouts(long nowEpochMs, ChatPreferences prefs) {
        if (prefs == null) {
            return;
        }
        long timeoutMs = (long)Math.max(1, prefs.getNotify_noReplyPenaltyMinutes()) * 60000L;
        for (Map.Entry<String, StationMetrics> e : this.byCallRaw.entrySet()) {
            StationMetrics metrics = e.getValue();
            if (metrics == null) continue;
            StationMetrics stationMetrics = metrics;
            synchronized (stationMetrics) {
                if (metrics.pendingCqSentAtEpochMs <= 0L) {
                    continue;
                }
                long age = nowEpochMs - metrics.pendingCqSentAtEpochMs;
                if (age >= timeoutMs) {
                    metrics.pendingCqSentAtEpochMs = 0L;
                    ++metrics.noReplyStrikes;
                    metrics.lastNoReplyStrikeEpochMs = nowEpochMs;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markManualSkedFail(String callSignRaw) {
        StationMetrics metrics;
        String callRaw = StationMetricsService.normalizeCallRaw(callSignRaw);
        if (callRaw == null || callRaw.isBlank()) {
            return;
        }
        StationMetrics stationMetrics = metrics = this.byCallRaw.computeIfAbsent(callRaw, k -> new StationMetrics());
        synchronized (stationMetrics) {
            metrics.manualSkedFailed = true;
            ++metrics.manualSkedFailCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetManualSkedFail(String callSignRaw) {
        StationMetrics metrics;
        String callRaw = StationMetricsService.normalizeCallRaw(callSignRaw);
        if (callRaw == null || callRaw.isBlank()) {
            return;
        }
        StationMetrics stationMetrics = metrics = this.byCallRaw.computeIfAbsent(callRaw, k -> new StationMetrics());
        synchronized (stationMetrics) {
            metrics.manualSkedFailed = false;
            metrics.manualSkedFailCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isManualSkedFailed(String callSignRaw) {
        String callRaw = StationMetricsService.normalizeCallRaw(callSignRaw);
        if (callRaw == null || callRaw.isBlank()) {
            return false;
        }
        StationMetrics metrics = this.byCallRaw.get(callRaw);
        if (metrics == null) {
            return false;
        }
        StationMetrics stationMetrics = metrics;
        synchronized (stationMetrics) {
            return metrics.manualSkedFailed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snapshot snapshot(long nowEpochMs, ChatPreferences prefs) {
        long momentumWindowMs = (long)(prefs != null ? prefs.getNotify_momentumWindowSeconds() : 180) * 1000L;
        Snapshot snap = new Snapshot(nowEpochMs, momentumWindowMs);
        for (Map.Entry<String, StationMetrics> e : this.byCallRaw.entrySet()) {
            String callRaw = e.getKey();
            StationMetrics m = e.getValue();
            if (m == null) continue;
            StationMetrics stationMetrics = m;
            synchronized (stationMetrics) {
                snap.byCallRaw.put(callRaw, new Snapshot.Metrics(m.lastInboundEpochMs, StationMetricsService.countRecent(m.recentInboundEpochMs, nowEpochMs, momentumWindowMs), m.avgResponseTimeMs, m.noReplyStrikes, m.manualSkedFailed, m.manualSkedFailCount, m.lastPositiveSignalEpochMs));
            }
        }
        return snap;
    }

    private static int countRecent(Deque<Long> timestamps, long nowEpochMs, long windowMs) {
        if (timestamps == null || timestamps.isEmpty()) {
            return 0;
        }
        int cnt = 0;
        for (Long t : timestamps) {
            if (t == null || nowEpochMs - t > windowMs) continue;
            ++cnt;
        }
        return cnt;
    }

    private static String normalizeCallRaw(String s) {
        if (s == null) {
            return null;
        }
        return s.trim().toUpperCase();
    }

    private static final class StationMetrics {
        long lastInboundEpochMs;
        long lastOutboundCqEpochMs;
        long pendingCqSentAtEpochMs;
        int noReplyStrikes;
        long lastNoReplyStrikeEpochMs;
        double avgResponseTimeMs;
        final Deque<Long> recentInboundEpochMs = new ArrayDeque<Long>();
        long lastPositiveSignalEpochMs;
        boolean manualSkedFailed;
        int manualSkedFailCount;

        private StationMetrics() {
        }
    }

    public static final class Snapshot {
        private final long snapshotEpochMs;
        private final long momentumWindowMs;
        private final ConcurrentHashMap<String, Metrics> byCallRaw = new ConcurrentHashMap();

        private Snapshot(long snapshotEpochMs, long momentumWindowMs) {
            this.snapshotEpochMs = snapshotEpochMs;
            this.momentumWindowMs = momentumWindowMs;
        }

        public Metrics get(String callSignRaw) {
            if (callSignRaw == null) {
                return null;
            }
            return this.byCallRaw.get(StationMetricsService.normalizeCallRaw(callSignRaw));
        }

        public long getSnapshotEpochMs() {
            return this.snapshotEpochMs;
        }

        public long getMomentumWindowMs() {
            return this.momentumWindowMs;
        }

        public static final class Metrics {
            public final long lastInboundEpochMs;
            public final int inboundCountInWindow;
            public final double avgResponseTimeMs;
            public final int noReplyStrikes;
            public final boolean manualSkedFailed;
            public final int manualSkedFailCount;
            public final long lastPositiveSignalEpochMs;

            public Metrics(long lastInboundEpochMs, int inboundCountInWindow, double avgResponseTimeMs, int noReplyStrikes, boolean manualSkedFailed, int manualSkedFailCount, long lastPositiveSignalEpochMs) {
                this.lastInboundEpochMs = lastInboundEpochMs;
                this.inboundCountInWindow = inboundCountInWindow;
                this.avgResponseTimeMs = avgResponseTimeMs;
                this.noReplyStrikes = noReplyStrikes;
                this.manualSkedFailed = manualSkedFailed;
                this.manualSkedFailCount = manualSkedFailCount;
                this.lastPositiveSignalEpochMs = lastPositiveSignalEpochMs;
            }
        }
    }
}

