/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kst4contest.controller.ChatController;
import kst4contest.model.ChatCategory;
import kst4contest.model.ThreadStateMessage;

public final class SkedReminderService {
    private final ChatController controller;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.setName("SkedReminderService");
        return t;
    });
    private final ConcurrentHashMap<String, List<ScheduledFuture<?>>> scheduledByCallRaw = new ConcurrentHashMap();

    public SkedReminderService(ChatController controller) {
        this.controller = controller;
    }

    public void armReminders(String callSignRaw, ChatCategory preferredCategory, long skedTimeEpochMs, List<Integer> offsetsMinutes) {
        String callRaw = SkedReminderService.normalize(callSignRaw);
        if (callRaw == null || callRaw.isBlank()) {
            return;
        }
        this.cancelReminders(callRaw);
        long now = System.currentTimeMillis();
        List<Object> offsets = offsetsMinutes == null ? List.of() : offsetsMinutes;
        ArrayList futures = new ArrayList();
        for (Integer n : offsets) {
            long fireAt;
            long delayMs;
            if (n == null || (delayMs = (fireAt = skedTimeEpochMs - (long)n.intValue() * 60000L) - now) <= 0L) continue;
            ScheduledFuture<?> f = this.scheduler.schedule(() -> this.fireReminder(callRaw, preferredCategory, offMin), delayMs, TimeUnit.MILLISECONDS);
            futures.add(f);
        }
        this.scheduledByCallRaw.put(callRaw, futures);
        this.controller.onThreadStatus("SkedReminderService", new ThreadStateMessage("SkedReminder", true, "Armed for " + callRaw + " (" + offsets + " min before)", false));
    }

    public void cancelReminders(String callSignRaw) {
        String callRaw = SkedReminderService.normalize(callSignRaw);
        if (callRaw == null || callRaw.isBlank()) {
            return;
        }
        List<ScheduledFuture<?>> futures = this.scheduledByCallRaw.remove(callRaw);
        if (futures != null) {
            for (ScheduledFuture<?> f : futures) {
                if (f == null) continue;
                f.cancel(false);
            }
        }
    }

    private void fireReminder(String callRaw, ChatCategory preferredCategory, int minutesBefore) {
        try {
            this.controller.queuePrivateCqMessage(callRaw, preferredCategory, "[KST4C Autoreminder] sked in " + minutesBefore + " min");
            this.controller.fireUiReminderEvent(callRaw, minutesBefore);
            try {
                if (this.controller.getChatPreferences().isNotify_playSimpleSounds()) {
                    this.controller.getPlayAudioUtils().playNoiseLauncher('!');
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.controller.onThreadStatus("SkedReminderService", new ThreadStateMessage("SkedReminder", true, "PM reminder sent to " + callRaw + " (" + minutesBefore + " min)", false));
        }
        catch (Exception e) {
            this.controller.onThreadStatus("SkedReminderService", new ThreadStateMessage("SkedReminder", false, "ERROR sending reminder to " + callRaw + ": " + e.getMessage(), true));
            e.printStackTrace();
        }
    }

    private static String normalize(String s) {
        if (s == null) {
            return null;
        }
        return s.trim().toUpperCase();
    }
}

