/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import kst4contest.controller.ChatController;
import kst4contest.controller.StationMetricsService;
import kst4contest.logic.PriorityCalculator;
import kst4contest.model.ChatCategory;
import kst4contest.model.ChatMember;
import kst4contest.model.ChatPreferences;
import kst4contest.model.ContestSked;

public final class ScoreService {
    public static final int DEFAULT_TOP_N = 15;
    private static final long MAX_SNAPSHOT_AGE_MS = 10000L;
    private final ChatController controller;
    private final PriorityCalculator priorityCalculator;
    private final AtomicBoolean recomputeRequested = new AtomicBoolean(true);
    private final AtomicReference<ScoreSnapshot> latestSnapshot = new AtomicReference<ScoreSnapshot>(ScoreSnapshot.empty());
    private final ObservableList<TopCandidate> topCandidatesFx = FXCollections.observableArrayList();
    private final ReadOnlyDoubleWrapper selectedCallPriorityScore = new ReadOnlyDoubleWrapper(Double.NaN);
    private final LongProperty uiPulse = new SimpleLongProperty(0L);
    private volatile String selectedCallSignRaw;
    private volatile long lastComputedEpochMs = 0L;
    private final int topN;
    private final ObjectProperty<ChatMember> selectedChatMember = new SimpleObjectProperty(null);

    public ScoreService(ChatController controller, PriorityCalculator priorityCalculator, int topN) {
        this.controller = Objects.requireNonNull(controller, "controller");
        this.priorityCalculator = Objects.requireNonNull(priorityCalculator, "priorityCalculator");
        this.topN = topN > 0 ? topN : 15;
    }

    public ObservableList<TopCandidate> getTopCandidatesFx() {
        return this.topCandidatesFx;
    }

    public ReadOnlyDoubleProperty selectedCallPriorityScoreProperty() {
        return this.selectedCallPriorityScore.getReadOnlyProperty();
    }

    public LongProperty uiPulseProperty() {
        return this.uiPulse;
    }

    public ScoreSnapshot getLatestSnapshot() {
        return this.latestSnapshot.get();
    }

    public void requestRecompute(String reason) {
        this.recomputeRequested.set(true);
    }

    public void setSelectedChatMember(ChatMember member) {
        if (Platform.isFxApplicationThread()) {
            this.selectedChatMember.set((Object)member);
        } else {
            Platform.runLater(() -> this.selectedChatMember.set((Object)member));
        }
        String string = this.selectedCallSignRaw = member == null ? null : ScoreService.normalizeCallRaw(member.getCallSignRaw());
        if (Platform.isFxApplicationThread()) {
            this.updateSelectedScoreFromSnapshot(this.latestSnapshot.get());
        } else {
            Platform.runLater(() -> this.updateSelectedScoreFromSnapshot(this.latestSnapshot.get()));
        }
    }

    public void tick() {
        boolean shouldRecompute;
        long now = System.currentTimeMillis();
        boolean bl = shouldRecompute = this.recomputeRequested.getAndSet(false) || now - this.lastComputedEpochMs > 10000L;
        if (!shouldRecompute) {
            return;
        }
        try {
            this.controller.getStationMetricsService().evaluateNoReplyTimeouts(now, this.controller.getChatPreferences());
            this.recompute(now);
        }
        catch (Exception e) {
            System.err.println("[ScoreService] CRITICAL error while recomputing scores");
            e.printStackTrace();
        }
    }

    private void recompute(long nowEpochMs) {
        this.controller.requestRemoveExpiredSkeds(nowEpochMs);
        List<ChatMember> members = this.controller.snapshotChatMembers();
        List<ContestSked> activeSkeds = this.controller.snapshotActiveSkeds();
        ChatPreferences prefs = this.controller.getChatPreferences();
        Map<String, ChatCategory> lastInbound = this.controller.snapshotLastInboundCategoryMap();
        StationMetricsService.Snapshot metricsSnapshot = this.controller.getStationMetricsService().snapshot(nowEpochMs, prefs);
        Map<String, ChatMember> representativeByCallRaw = this.chooseRepresentativeMembers(members, lastInbound);
        HashMap<String, Double> scoreByCallRaw = new HashMap<String, Double>(representativeByCallRaw.size());
        HashMap<String, ChatCategory> preferredCategoryByCallRaw = new HashMap<String, ChatCategory>(representativeByCallRaw.size());
        ArrayList<TopCandidate> topAll = new ArrayList<TopCandidate>(representativeByCallRaw.size());
        for (Map.Entry<String, ChatMember> e : representativeByCallRaw.entrySet()) {
            String callRaw = e.getKey();
            ChatMember representative = e.getValue();
            if (representative == null) continue;
            double score = this.priorityCalculator.calculatePriority(representative, prefs, activeSkeds, metricsSnapshot, nowEpochMs);
            scoreByCallRaw.put(callRaw, score);
            preferredCategoryByCallRaw.put(callRaw, representative.getChatCategory());
            topAll.add(new TopCandidate(callRaw, representative.getCallSign(), representative.getChatCategory(), score));
        }
        topAll.sort(Comparator.comparingDouble(TopCandidate::getScore).reversed());
        ArrayList<TopCandidate> topNList = topAll.size() <= this.topN ? topAll : new ArrayList<TopCandidate>(topAll.subList(0, this.topN));
        ScoreSnapshot snap = new ScoreSnapshot(nowEpochMs, Collections.unmodifiableMap(scoreByCallRaw), Collections.unmodifiableMap(preferredCategoryByCallRaw), Collections.unmodifiableList(topNList));
        this.latestSnapshot.set(snap);
        this.lastComputedEpochMs = nowEpochMs;
        Platform.runLater(() -> {
            this.topCandidatesFx.setAll(snap.getTopCandidates());
            this.updateSelectedScoreFromSnapshot(snap);
            this.uiPulse.set(this.uiPulse.get() + 1L);
        });
    }

    private Map<String, ChatMember> chooseRepresentativeMembers(List<ChatMember> members, Map<String, ChatCategory> lastInboundCategoryByCallRaw) {
        HashMap<String, List> byCallRaw = new HashMap<String, List>();
        for (ChatMember m : members) {
            String callRaw;
            if (m == null || (callRaw = ScoreService.normalizeCallRaw(m.getCallSignRaw())) == null || callRaw.isEmpty()) continue;
            byCallRaw.computeIfAbsent(callRaw, k -> new ArrayList()).add(m);
        }
        HashMap<String, ChatMember> representative = new HashMap<String, ChatMember>(byCallRaw.size());
        for (Map.Entry entry : byCallRaw.entrySet()) {
            String callRaw = (String)entry.getKey();
            List variants = (List)entry.getValue();
            ChatCategory preferredCat = lastInboundCategoryByCallRaw.get(callRaw);
            ChatMember chosen = null;
            if (preferredCat != null) {
                for (ChatMember v : variants) {
                    if (v == null || v.getChatCategory() != preferredCat) continue;
                    chosen = v;
                    break;
                }
            }
            if (chosen == null) {
                chosen = variants.stream().filter(Objects::nonNull).max(Comparator.comparingLong(ChatMember::getActivityTimeLastInEpoch)).orElse(null);
            }
            if (chosen == null) continue;
            representative.put(callRaw, chosen);
        }
        return representative;
    }

    private void updateSelectedScoreFromSnapshot(ScoreSnapshot snap) {
        if (snap == null || this.selectedCallSignRaw == null) {
            this.selectedCallPriorityScore.set(Double.NaN);
            return;
        }
        Double v = snap.getScoreByCallSignRaw().get(this.selectedCallSignRaw);
        this.selectedCallPriorityScore.set(v == null ? Double.NaN : v);
    }

    private static String normalizeCallRaw(String callRaw) {
        if (callRaw == null) {
            return null;
        }
        return callRaw.trim().toUpperCase();
    }

    public ReadOnlyObjectProperty<ChatMember> selectedChatMemberProperty() {
        return this.selectedChatMember;
    }

    public ChatMember getSelectedChatMember() {
        return (ChatMember)this.selectedChatMember.get();
    }

    public static final class ScoreSnapshot {
        private final long computedAtEpochMs;
        private final Map<String, Double> scoreByCallSignRaw;
        private final Map<String, ChatCategory> preferredCategoryByCallSignRaw;
        private final List<TopCandidate> topCandidates;

        public ScoreSnapshot(long computedAtEpochMs, Map<String, Double> scoreByCallSignRaw, Map<String, ChatCategory> preferredCategoryByCallSignRaw, List<TopCandidate> topCandidates) {
            this.computedAtEpochMs = computedAtEpochMs;
            this.scoreByCallSignRaw = scoreByCallSignRaw;
            this.preferredCategoryByCallSignRaw = preferredCategoryByCallSignRaw;
            this.topCandidates = topCandidates;
        }

        public static ScoreSnapshot empty() {
            return new ScoreSnapshot(System.currentTimeMillis(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList());
        }

        public long getComputedAtEpochMs() {
            return this.computedAtEpochMs;
        }

        public Map<String, Double> getScoreByCallSignRaw() {
            return this.scoreByCallSignRaw;
        }

        public Map<String, ChatCategory> getPreferredCategoryByCallSignRaw() {
            return this.preferredCategoryByCallSignRaw;
        }

        public List<TopCandidate> getTopCandidates() {
            return this.topCandidates;
        }
    }

    public static final class TopCandidate {
        private final String callSignRaw;
        private final String displayCallSign;
        private final ChatCategory preferredChatCategory;
        private final double score;

        public TopCandidate(String callSignRaw, String displayCallSign, ChatCategory preferredChatCategory, double score) {
            this.callSignRaw = callSignRaw;
            this.displayCallSign = displayCallSign;
            this.preferredChatCategory = preferredChatCategory;
            this.score = score;
        }

        public String getCallSignRaw() {
            return this.callSignRaw;
        }

        public String getDisplayCallSign() {
            return this.displayCallSign;
        }

        public ChatCategory getPreferredChatCategory() {
            return this.preferredChatCategory;
        }

        public double getScore() {
            return this.score;
        }
    }
}

