/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.controller;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kst4contest.ApplicationConstants;
import kst4contest.controller.ChatController;
import kst4contest.controller.ThreadStatusCallback;
import kst4contest.controller.Utils4KST;
import kst4contest.model.ChatMember;
import kst4contest.model.ThreadStateMessage;
import kst4contest.view.GuiUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ReadUDPbyUCXMessageThread
extends Thread {
    private BufferedReader reader;
    private Socket socket;
    private ChatController client;
    private int udpPortNr = 12060;
    private ThreadStatusCallback callBackToController;
    private String ThreadNickName = "UDP-Log msg";

    public ReadUDPbyUCXMessageThread(int localPort, ChatController client, ThreadStatusCallback callback) {
        this.udpPortNr = localPort;
        this.client = client;
        this.callBackToController = callback;
    }

    @Override
    public void interrupt() {
        super.interrupt();
        try {
            if (this.socket != null) {
                System.out.println(">>>>>>>>>>>>>>ReadUdpbyUCS: closing socket");
                this.terminateConnection();
            }
        }
        catch (Exception e) {
            System.out.println("UCXUDPRDR: catched error " + e.getMessage());
        }
    }

    @Override
    public void run() {
        System.out.println("ReadUDPByUCXLogThread: started Thread for UCXLog getUDP");
        Thread.currentThread().setName("ReadUDPByUCXLogThread");
        ThreadStateMessage threadStateMessage = new ThreadStateMessage(this.ThreadNickName, true, "initialized", false);
        this.callBackToController.onThreadStatus(this.ThreadNickName, threadStateMessage);
        DatagramSocket socket = null;
        byte[] buf = new byte[1777];
        DatagramPacket packet = new DatagramPacket(buf, buf.length);
        try {
            socket = new DatagramSocket(this.udpPortNr);
            socket.setSoTimeout(2000);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        while (true) {
            boolean timeOutIndicator = false;
            try {
                socket.receive(packet);
            }
            catch (SocketTimeoutException e2) {
                timeOutIndicator = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (NullPointerException nE) {
                nE.printStackTrace();
                System.out.println("ReadUdpByUCXTH: Socket not ready");
                try {
                    socket = new DatagramSocket(this.client.getChatPreferences().getLogsynch_ucxUDPWkdCallListenerPort());
                    socket.setSoTimeout(2000);
                }
                catch (SocketException e) {
                    System.out.println("[ReadUDPByUCSMsgTH, Error]: socket in use or something:");
                    e.printStackTrace();
                    try {
                        socket = new DatagramSocket(null);
                        socket.setReuseAddress(true);
                        socket.bind(new InetSocketAddress(this.client.getChatPreferences().getLogsynch_ucxUDPWkdCallListenerPort()));
                        socket.receive(packet);
                        socket.setSoTimeout(3000);
                    }
                    catch (Exception ex) {
                        System.out.println("ReadUDPByUCXMsgTh: Could not solve that. Program Restart needed.");
                        throw new RuntimeException(ex);
                    }
                }
            }
            InetAddress address = packet.getAddress();
            int port = packet.getPort();
            String received = new String(packet.getData(), packet.getOffset(), packet.getLength());
            received = received.trim();
            if (received.contains(ApplicationConstants.DISCONNECT_RDR_POISONPILL)) {
                System.out.println("ReadUdpByUCX, Info: got poison, now dieing....");
                socket.close();
                timeOutIndicator = true;
                threadStateMessage = new ThreadStateMessage(this.ThreadNickName, false, "stopped by Poisonpill", false);
                this.callBackToController.onThreadStatus(this.ThreadNickName, threadStateMessage);
                break;
            }
            if (this.client.isDisconnectionPerformedByUser()) break;
            if (!timeOutIndicator) {
                this.processUCXUDPMessage(received);
            }
            buf = new byte[1777];
        }
    }

    public String processUCXUDPMessage(String udpPacketToProcess) {
        block56: {
            String udpMsg = udpPacketToProcess;
            ChatMember modifyThat = null;
            ThreadStateMessage threadStateMessage = new ThreadStateMessage(this.ThreadNickName, true, "received Message\n" + udpMsg, false);
            this.callBackToController.onThreadStatus(this.ThreadNickName, threadStateMessage);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (ParserConfigurationException e1) {
                e1.printStackTrace();
            }
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(new InputSource(new StringReader(udpMsg)));
                NodeList list = doc.getElementsByTagName("contactinfo");
                if (list.getLength() != 0) {
                    for (int temp = 0; temp < list.getLength(); ++temp) {
                        Node node = list.item(temp);
                        if (node.getNodeType() != 1) continue;
                        Element element = (Element)node;
                        String call = element.getElementsByTagName("call").item(0).getTextContent();
                        String band = element.getElementsByTagName("band").item(0).getTextContent();
                        String points = element.getElementsByTagName("points").item(0).getTextContent();
                        System.out.println("[Readudp, info ]: received Current Element :" + node.getNodeName() + "call: " + call + " / " + band + " ----> " + points + " POINTS");
                        ChatMember workedCall = new ChatMember();
                        workedCall.setCallSign(call);
                        workedCall.setWorked(true);
                        switch (band) {
                            case "144": {
                                workedCall.setWorked144(true);
                                break;
                            }
                            case "432": {
                                workedCall.setWorked432(true);
                                break;
                            }
                            case "1240": {
                                workedCall.setWorked1240(true);
                                break;
                            }
                            case "2300": {
                                workedCall.setWorked2300(true);
                                break;
                            }
                            case "3400": {
                                workedCall.setWorked3400(true);
                                break;
                            }
                            case "5600": {
                                workedCall.setWorked5600(true);
                                break;
                            }
                            case "10G": {
                                workedCall.setWorked10G(true);
                                break;
                            }
                            case "2m": {
                                workedCall.setWorked144(true);
                                break;
                            }
                            case "70cm": {
                                workedCall.setWorked432(true);
                                break;
                            }
                            case "23cm": {
                                workedCall.setWorked1240(true);
                                break;
                            }
                            case "13cm": {
                                workedCall.setWorked2300(true);
                                break;
                            }
                            case "9cm": {
                                workedCall.setWorked3400(true);
                                break;
                            }
                            case "6cm": {
                                workedCall.setWorked5600(true);
                                break;
                            }
                            case "3cm": {
                                workedCall.setWorked10G(true);
                            }
                            default: {
                                System.out.println("[ReadUDPFromUCX, Error:] unexpected band value: \"" + band + "\"");
                            }
                        }
                        ArrayList<Integer> markTheseChattersAsWorked = this.client.checkListForChatMemberIndexesByCallSign(workedCall);
                        if (!markTheseChattersAsWorked.isEmpty()) {
                            for (int index : markTheseChattersAsWorked) {
                                modifyThat = (ChatMember)this.client.getLst_chatMemberList().get(index);
                                modifyThat.setWorked(true);
                                if (workedCall.isWorked144()) {
                                    modifyThat.setWorked144(true);
                                    continue;
                                }
                                if (workedCall.isWorked432()) {
                                    modifyThat.setWorked432(true);
                                    continue;
                                }
                                if (workedCall.isWorked1240()) {
                                    modifyThat.setWorked1240(true);
                                    continue;
                                }
                                if (workedCall.isWorked2300()) {
                                    modifyThat.setWorked2300(true);
                                    continue;
                                }
                                if (workedCall.isWorked3400()) {
                                    modifyThat.setWorked3400(true);
                                    continue;
                                }
                                if (workedCall.isWorked5600()) {
                                    modifyThat.setWorked5600(true);
                                    continue;
                                }
                                if (!workedCall.isWorked10G()) continue;
                                modifyThat.setWorked10G(true);
                            }
                            try {
                                GuiUtils.triggerGUIFilteredChatMemberListChange(this.client);
                                try {
                                    this.client.onExternalLogEntryReceived(workedCall.getCallSignRaw());
                                }
                                catch (Exception e) {
                                    System.out.println("[UCXUDPRcvr, warning]: band-upgrade hint failed: " + e.getMessage());
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        boolean isInChat = this.client.getDbHandler().updateWkdInfoOnChatMember(workedCall);
                        if (!isInChat) {
                            workedCall.setName("unknown");
                            workedCall.setQra("unknown");
                            workedCall.setLastActivity(new Utils4KST().time_generateActualTimeInDateFormat());
                            this.client.getDbHandler().storeChatMember(workedCall);
                        }
                        File logUDPMessageToThisFile = new File(this.client.getChatPreferences().getLogSynch_storeWorkedCallSignsFileNameUDPMessageBackup());
                        FileWriter fileWriterPersistUDPToFile = null;
                        try {
                            fileWriterPersistUDPToFile = new FileWriter(logUDPMessageToThisFile, true);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        BufferedWriter bufwrtrRawMSGOut = new BufferedWriter(fileWriterPersistUDPToFile);
                        if (modifyThat != null) {
                            bufwrtrRawMSGOut.write("\n" + modifyThat.toString());
                            bufwrtrRawMSGOut.flush();
                            bufwrtrRawMSGOut.close();
                            continue;
                        }
                        bufwrtrRawMSGOut.write("\n" + workedCall.toString());
                        bufwrtrRawMSGOut.flush();
                        bufwrtrRawMSGOut.close();
                    }
                    break block56;
                }
                list = doc.getElementsByTagName("RadioInfo");
                for (int temp = 0; temp < list.getLength(); ++temp) {
                    Node node = list.item(temp);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    String qrg = element.getElementsByTagName("Freq").item(0).getTextContent();
                    String mode = element.getElementsByTagName("Mode").item(0).getTextContent();
                    String formattedQRG = qrg.length() == 6 ? String.format("%s.%s.%s", qrg.substring(0, 1), qrg.substring(2, 5), qrg.substring(5, 6)) : (qrg.length() == 7 ? String.format("%s.%s.%s", qrg.substring(0, 2), qrg.substring(2, 5), qrg.substring(5, 7)) : (qrg.length() == 8 ? String.format("%s.%s.%s", qrg.substring(0, 3), qrg.substring(3, 6), qrg.substring(6, 8)) : (qrg.length() == 9 ? String.format("%s.%s.%s", qrg.substring(0, 4), qrg.substring(4, 7), qrg.substring(7, 9)) : (qrg.length() == 10 ? String.format("%s.%s.%s", qrg.substring(0, 5), qrg.substring(5, 8), qrg.substring(8, 10)) : qrg))));
                    this.client.getChatPreferences().getMYQRGFirstCat().set((Object)formattedQRG);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                e.printStackTrace();
                System.out.println(e.getCause());
                System.out.println(e.getMessage());
                threadStateMessage = new ThreadStateMessage(this.ThreadNickName, true, "CRASHED" + udpMsg, true);
                threadStateMessage.setCriticalStateFurtherInfo(Arrays.toString(e.getStackTrace()));
                this.callBackToController.onThreadStatus(this.ThreadNickName, threadStateMessage);
            }
            catch (SQLException e) {
                e.printStackTrace();
                threadStateMessage = new ThreadStateMessage(this.ThreadNickName, true, "CRASHED" + udpMsg, true);
                threadStateMessage.setCriticalStateFurtherInfo(Arrays.toString(e.getStackTrace()));
                this.callBackToController.onThreadStatus(this.ThreadNickName, threadStateMessage);
            }
        }
        return "";
    }

    public boolean terminateConnection() throws IOException {
        ThreadStateMessage threadStateMessage = new ThreadStateMessage(this.ThreadNickName, false, "terminated", false);
        this.callBackToController.onThreadStatus(this.ThreadNickName, threadStateMessage);
        this.socket.close();
        return true;
    }
}

