/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.controller;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import kst4contest.controller.ChatController;
import kst4contest.model.ChatMessage;

public class ReadThread
extends Thread {
    private BufferedReader reader;
    private Socket socket;
    private ChatController client;
    public boolean accidentalDisconnected;
    private boolean readingFinished = true;
    InputStream input;

    public boolean isAccidentalDisconnected() {
        return this.accidentalDisconnected;
    }

    public void setAccidentalDisconnected(boolean accidentalDisconnected) {
        this.accidentalDisconnected = accidentalDisconnected;
    }

    public ReadThread(Socket socket, ChatController client) {
        this.socket = socket;
        this.client = client;
        try {
            this.input = socket.getInputStream();
            this.reader = new BufferedReader(new InputStreamReader(this.input, StandardCharsets.UTF_8));
        }
        catch (IOException ex) {
            System.out.println("Error getting input stream: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName("ReadFromTelnetThread");
        while (true) {
            try {
                while (true) {
                    String response = this.reader.readLine();
                    ChatMessage message = new ChatMessage();
                    message.setMessageText(response);
                    if (response != null) {
                        this.client.getMessageRXBus().put(message);
                        continue;
                    }
                    System.out.println("[RT]: read message responsed a nullstring, do nothing, buffersize = " + this.socket.getReceiveBufferSize() + ", reader ready? " + this.reader.ready());
                    this.client.getSocket().close();
                    this.interrupt();
                }
            }
            catch (Exception sexc) {
                System.out.println("[ReadThread, CRITICAL: ] Socket geschlossen: " + sexc.getMessage());
                try {
                    this.client.getSocket().close();
                    this.interrupt();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                return;
            }
            break;
        }
    }

    public boolean terminateConnection() throws IOException {
        this.reader.close();
        this.input.close();
        this.socket.close();
        return true;
    }

    public boolean isReadingFinished() {
        return this.readingFinished;
    }

    public void setReadingFinished(boolean readingReady) {
        this.readingFinished = readingReady;
    }
}

