/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.controller;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import kst4contest.controller.ThreadStatusCallback;
import kst4contest.controller.interfaces.PstRotatorEventListener;
import kst4contest.model.ThreadStateMessage;

public class PstRotatorClient
implements Runnable {
    private ThreadStatusCallback callBackToController;
    private String ThreadNickName = "PSTRotator";
    private static final Logger LOGGER = Logger.getLogger(PstRotatorClient.class.getName());
    private static final int BUFFER_SIZE = 1024;
    private final String host;
    private final int remotePort;
    private final int localPort;
    private DatagramSocket socket;
    private volatile boolean running = false;
    private PstRotatorEventListener listener;
    private ScheduledExecutorService poller;

    public PstRotatorClient(String host, int remotePort, PstRotatorEventListener listener, ThreadStatusCallback callBack) {
        this.callBackToController = callBack;
        this.host = host;
        this.remotePort = remotePort;
        this.localPort = remotePort + 1;
        this.listener = listener;
    }

    public PstRotatorClient(String host, int remotePort, int localPort, PstRotatorEventListener listener) {
        this.host = host;
        this.remotePort = remotePort;
        this.localPort = localPort;
        this.listener = listener;
    }

    public void start() {
        try {
            this.socket = new DatagramSocket(null);
            this.socket.setReuseAddress(true);
            this.socket.bind(new InetSocketAddress(this.localPort));
            this.running = true;
            Thread thread = new Thread((Runnable)this, "PSTRotator-Listener-" + this.remotePort);
            thread.start();
            this.poller = Executors.newSingleThreadScheduledExecutor();
            this.poller.scheduleAtFixedRate(this::pollStatus, 1L, 2L, TimeUnit.SECONDS);
            ThreadStateMessage threadStateMessage = new ThreadStateMessage(this.ThreadNickName, this.running, "initialized", false);
            this.callBackToController.onThreadStatus(this.ThreadNickName, threadStateMessage);
            LOGGER.info("PstRotatorClient started. Remote: " + this.remotePort + ", Local: " + this.localPort);
        }
        catch (SocketException e) {
            LOGGER.log(Level.SEVERE, "Fehler beim \u00d6ffnen des UDP Sockets", e);
        }
    }

    public void stop() {
        this.running = false;
        if (this.poller != null && !this.poller.isShutdown()) {
            this.poller.shutdownNow();
        }
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
    }

    @Override
    public void run() {
        byte[] buffer = new byte[1024];
        while (this.running && !this.socket.isClosed()) {
            try {
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                this.socket.receive(packet);
                String received = new String(packet.getData(), 0, packet.getLength(), StandardCharsets.US_ASCII).trim();
                ThreadStateMessage threadStateMessage = new ThreadStateMessage(this.ThreadNickName, true, "received line\n" + received, false);
                this.callBackToController.onThreadStatus(this.ThreadNickName, threadStateMessage);
                this.parseResponse(received);
            }
            catch (IOException e) {
                if (!this.running) continue;
                LOGGER.log(Level.WARNING, "Fehler beim Empfangen des Pakets", e);
            }
        }
    }

    private void parseResponse(String msg) {
        if (this.listener != null) {
            this.listener.onMessageReceived(msg);
        }
        msg = msg.replace("<CR>", "").trim();
        try {
            if (msg.startsWith("AZ:")) {
                String val = msg.substring(3);
                if (this.listener != null) {
                    this.listener.onAzimuthUpdate(Double.parseDouble(val));
                }
            } else if (msg.startsWith("EL:")) {
                String val = msg.substring(3);
                if (this.listener != null) {
                    this.listener.onElevationUpdate(Double.parseDouble(val));
                }
            } else if (msg.startsWith("MODE:")) {
                String val = msg.substring(5);
                boolean tracking = "1".equals(val);
                if (this.listener != null) {
                    this.listener.onModeUpdate(tracking);
                }
            } else if (msg.startsWith("OK:")) {
                LOGGER.fine("Befehl best\u00e4tigt: " + msg);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warning("Konnte Wert nicht parsen: " + msg);
        }
    }

    private void sendUdp(String message) {
        if (this.socket == null || this.socket.isClosed()) {
            return;
        }
        try {
            byte[] data = message.getBytes(StandardCharsets.US_ASCII);
            InetAddress address = InetAddress.getByName(this.host);
            DatagramPacket packet = new DatagramPacket(data, data.length, address, this.remotePort);
            this.socket.send(packet);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Fehler beim Senden an PstRotator", e);
        }
    }

    private void sendCommand(String tag, String value) {
        String xml = String.format("<PST><%s>%s</%s></PST>", tag, value, tag);
        System.out.println("PSTRotatorClient: sent: " + xml);
        this.sendUdp(xml);
    }

    public void setAzimuth(double degrees) {
        this.sendCommand("AZIMUTH", String.valueOf((int)degrees));
    }

    public void setElevation(double degrees) {
        this.sendCommand("ELEVATION", String.valueOf(degrees));
    }

    public void stopRotor() {
        this.sendCommand("STOP", "1");
    }

    public void park() {
        this.sendCommand("PARK", "1");
    }

    public void setTrackingMode(boolean enable) {
        this.sendCommand("TRACK", enable ? "1" : "0");
    }

    public void pollStatus() {
        String query = "<PST><AZ?></AZ?><EL?></EL?><MODE?></MODE?></PST>";
        this.sendUdp("<PST>AZ?</PST>");
        this.sendUdp("<PST>MODE?</PST>");
    }
}

