/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import kst4contest.controller.ChatController;
import kst4contest.controller.ThreadStatusCallback;

class DXClusterServerWorkerRunnable
implements Runnable {
    protected Socket clientSocket = null;
    protected String serverText = null;
    private ChatController client = null;
    private List<Socket> dxClusterClientSocketsConnectedList;
    private ThreadStatusCallback callBackToController;
    private String ThreadNickName = "DXCluster-Server";

    public DXClusterServerWorkerRunnable(Socket clientSocket, String serverText, ChatController chatController, List<Socket> clientSockets, ThreadStatusCallback callback) {
        this.clientSocket = clientSocket;
        this.serverText = serverText;
        this.client = chatController;
        this.dxClusterClientSocketsConnectedList = clientSockets;
        this.callBackToController = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            OutputStream output = this.clientSocket.getOutputStream();
            this.dxClusterClientSocketsConnectedList.add(this.clientSocket);
            final Timer dXCkeepAliveTimer = new Timer();
            dXCkeepAliveTimer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    StringBuilder connectedClients = new StringBuilder();
                    for (Socket socket : DXClusterServerWorkerRunnable.this.dxClusterClientSocketsConnectedList) {
                        connectedClients.append(socket.getInetAddress()).append("\n");
                        try {
                            OutputStream output = socket.getOutputStream();
                            output.write("\r\n".getBytes());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            System.out.println("[DXClusterSrvr, Error:] broadcasting DXC-message to clients went wrong!");
                            dXCkeepAliveTimer.purge();
                            try {
                                socket.close();
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                            finally {
                                this.cancel();
                            }
                            DXClusterServerWorkerRunnable.this.dxClusterClientSocketsConnectedList.remove(socket);
                        }
                    }
                }
            }, 30000L, 30000L);
            output.write("login: ".getBytes());
            System.out.println("[DXClusterThreadPooledServer, Info:] New cluster client connected! ");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            List<Socket> list = this.dxClusterClientSocketsConnectedList;
            synchronized (list) {
                this.dxClusterClientSocketsConnectedList.remove(this.clientSocket);
            }
        }
    }
}

