/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.controller;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.sql.SQLException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import kst4contest.ApplicationConstants;
import kst4contest.controller.AirScoutPeriodicalAPReflectionInquirerTask;
import kst4contest.controller.BeaconTask;
import kst4contest.controller.DBController;
import kst4contest.controller.DXClusterThreadPooledServer;
import kst4contest.controller.InputReaderThread;
import kst4contest.controller.MessageBusManagementThread;
import kst4contest.controller.PstRotatorClient;
import kst4contest.controller.ReadThread;
import kst4contest.controller.ReadUDPByWintestThread;
import kst4contest.controller.ReadUDPbyAirScoutMessageThread;
import kst4contest.controller.ReadUDPbyUCXMessageThread;
import kst4contest.controller.ScoreService;
import kst4contest.controller.SkedReminderService;
import kst4contest.controller.StationMetricsService;
import kst4contest.controller.StatusUpdateListener;
import kst4contest.controller.ThreadStatusCallback;
import kst4contest.controller.UpdateChecker;
import kst4contest.controller.UserActualizationTask;
import kst4contest.controller.WriteThread;
import kst4contest.controller.interfaces.PstRotatorEventListener;
import kst4contest.controller.keepAliveMessageSenderTask;
import kst4contest.locatorUtils.DirectionUtils;
import kst4contest.logic.PriorityCalculator;
import kst4contest.model.Band;
import kst4contest.model.ChatCategory;
import kst4contest.model.ChatMember;
import kst4contest.model.ChatMessage;
import kst4contest.model.ChatPreferences;
import kst4contest.model.ClusterMessage;
import kst4contest.model.ContestSked;
import kst4contest.model.ThreadStateMessage;
import kst4contest.model.UpdateInformation;
import kst4contest.utils.PlayAudioUtils;
import kst4contest.view.Kst4ContestApplication;

public class ChatController
implements ThreadStatusCallback,
PstRotatorEventListener {
    private static final boolean DEBUG_BAND_UPGRADE_HINT = true;
    private PstRotatorClient rotatorClient;
    private Consumer<Double> viewRotorCallback;
    private Kst4ContestApplication view;
    private StatusUpdateListener statusListener;
    private UpdateInformation updateInformation;
    private ChatPreferences chatPreferences;
    private ChatCategory chatCategoryMain;
    private ChatCategory chatCategorySecondChat;
    boolean connectedAndLoggedIn;
    boolean connectedAndNOTLoggedIn;
    boolean disconnected;
    boolean disconnectionPerformedByUser = false;
    private ObservableList<ContestSked> activeSkeds = FXCollections.synchronizedObservableList((ObservableList)FXCollections.observableArrayList());
    private final Map<String, ChatCategory> lastInboundCategoryByCallSignRaw = new ConcurrentHashMap<String, ChatCategory>();
    private final ScoreService scoreService = new ScoreService(this, new PriorityCalculator(), 15);
    private ScheduledExecutorService scoreScheduler;
    private final StationMetricsService stationMetricsService = new StationMetricsService();
    private final SkedReminderService skedReminderService = new SkedReminderService(this);
    private String userName;
    private String password;
    private String showedName;
    private String qra;
    private String chatState;
    private String hostname;
    private String praktiKSTVersionInfo = "2022-10 - 2022-12\ndeveloped by DO5AMF, Marc\nContact: praktimarc@gmail.com\nDonations via paypal are welcome";
    private int port = 23001;
    private ReadUDPbyUCXMessageThread readUDPbyUCXThread;
    private ReadUDPByWintestThread readUDPByWintestThread;
    private WriteThread writeThread;
    private ReadThread readThread;
    private InputReaderThread consoleReader;
    private ChatMember ownChatMemberObject;
    private ChatController chatController;
    private MessageBusManagementThread messageProcessor;
    private ReadUDPbyAirScoutMessageThread airScoutUDPReaderThread;
    private DXClusterThreadPooledServer dxClusterServer;
    private PlayAudioUtils playAudioUtils = new PlayAudioUtils();
    private TimerTask userActualizationTask;
    private TimerTask keepAliveMessageSenderTask;
    private LinkedBlockingQueue<ChatMessage> messageRXBus;
    private LinkedBlockingQueue<ChatMessage> messageTXBus;
    private String observedSendThisMessageString;
    private DBController dbHandler;
    private Socket socket;
    private ServerSocket cluster_telnetServerSocket;
    private Timer userActualizationtimer;
    private Timer keepAliveTimer;
    private Timer beaconTimer;
    private Timer ASQueryTimer;
    private Timer socketCheckTimer;
    private ObservableList<ChatMessage> lst_globalChatMessageList = FXCollections.observableArrayList();
    private FilteredList<ChatMessage> lst_toAllMessageList = new FilteredList(this.lst_globalChatMessageList);
    private FilteredList<ChatMessage> lst_toMeMessageList = new FilteredList(this.lst_globalChatMessageList);
    private FilteredList<ChatMessage> lst_selectedCallSignInfofilteredMessageList = new FilteredList(this.lst_globalChatMessageList);
    private FilteredList<ChatMessage> lst_toOtherMessageList = new FilteredList(this.lst_globalChatMessageList);
    private ObservableList<String> lstNotify_QSOSniffer_sniffedCallSignList = FXCollections.observableArrayList();
    private ObservableList<ChatMember> chatMemberList = FXCollections.observableArrayList();
    private ObservableList<ChatMember> lst_chatMemberList = FXCollections.synchronizedObservableList(this.chatMemberList);
    private FilteredList<ChatMember> lst_chatMemberListFiltered = new FilteredList(this.chatMemberList);
    private SortedList<ChatMember> lst_chatMemberSortedFilteredList = new SortedList(this.lst_chatMemberListFiltered);
    private ObservableList<Predicate<ChatMember>> lst_chatMemberListFilterPredicates = FXCollections.observableArrayList();
    private ObservableList<ClusterMessage> lst_clusterMemberList = FXCollections.observableArrayList();
    private ObservableList<ChatMember> lst_DBBasedWkdCallSignList = FXCollections.observableArrayList();
    private final ObjectProperty<UiReminderEvent> lastUiReminderEvent = new SimpleObjectProperty(null);

    public void setView(Kst4ContestApplication view) {
        this.view = view;
    }

    public boolean isDisconnectionPerformedByUser() {
        return this.disconnectionPerformedByUser;
    }

    public void setDisconnectionPerformedByUser(boolean disconnectionPerformedByUser) {
        this.disconnectionPerformedByUser = disconnectionPerformedByUser;
    }

    public ChatCategory getChatCategorySecondChat() {
        return this.chatCategorySecondChat;
    }

    public void setChatCategorySecondChat(ChatCategory chatCategorySecondChat) {
        this.chatCategorySecondChat = chatCategorySecondChat;
    }

    public UpdateInformation getUpdateInformation() {
        return this.updateInformation;
    }

    public void setUpdateInformation(UpdateInformation updateInformation) {
        this.updateInformation = updateInformation;
    }

    public String getChatState() {
        return this.chatState;
    }

    public void setChatState(String chatState) {
        this.chatState = chatState;
    }

    public boolean isConnectedAndLoggedIn() {
        return this.connectedAndLoggedIn;
    }

    public void setConnectedAndLoggedIn(boolean connectedAndLoggedIn) {
        this.connectedAndLoggedIn = connectedAndLoggedIn;
    }

    public boolean isConnectedAndNOTLoggedIn() {
        return this.connectedAndNOTLoggedIn;
    }

    public void setConnectedAndNOTLoggedIn(boolean connectedAndNOTLoggedIn) {
        this.connectedAndNOTLoggedIn = connectedAndNOTLoggedIn;
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public void setDisconnected(boolean disconnected) {
        this.disconnected = disconnected;
    }

    public StatusUpdateListener getStatusListener() {
        return this.statusListener;
    }

    public void setStatusListener(StatusUpdateListener statusListener) {
        this.statusListener = statusListener;
    }

    @Override
    public void onThreadStatus(String threadName, ThreadStateMessage threadStateMessage) {
        if (this.statusListener != null) {
            this.statusListener.onThreadStatusChanged(threadName, threadStateMessage);
        } else {
            System.out.println("ERRRRRRRRRRRRRRRRRRRRRRRRRRR\u00d6RRRRRRRRRRRRRRRRRRR");
        }
    }

    public void initRotor() {
        this.rotatorClient = new PstRotatorClient("127.0.0.1", 12000, this, this);
        this.rotatorClient.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotateTo(double azimuth) {
        double beforeRotateAzWas = this.chatPreferences.getActualQTF().getValue();
        if (this.rotatorClient != null) {
            Object lockDelay;
            this.rotatorClient.setTrackingMode(false);
            System.out.println("Chatcontroller, Info: turning ant to " + azimuth + " by user request");
            this.rotatorClient.setAzimuth(azimuth);
            Object object = lockDelay = new Object();
            synchronized (object) {
                try {
                    TimeUnit.SECONDS.sleep(2L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.chatPreferences.getActualQTF().getValue() == beforeRotateAzWas) {
                this.rotatorClient.setAzimuth(0.0);
                this.rotatorClient.setAzimuth(azimuth);
            }
        }
    }

    public void onExternalLogEntryReceived(String callSignRaw) {
        long maxAgeMs;
        if (callSignRaw == null || callSignRaw.isBlank()) {
            return;
        }
        if (this.chatPreferences == null) {
            return;
        }
        if (!this.chatPreferences.isNotify_bandUpgradeHintOnLogEnabled()) {
            return;
        }
        String callRaw = ChatController.normalizeCallRaw(callSignRaw);
        System.out.println("[BandUpgradeHint] LOG received for call=" + callRaw);
        EnumSet<Band> myEnabledBands = ChatController.getMyEnabledBandsFromPrefs(this.chatPreferences);
        if (myEnabledBands.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        EnumSet<Band> stationOfferedBands = this.collectStationOfferedBandsFromHistory(callRaw, now, maxAgeMs = TimeUnit.MINUTES.toMillis(30L));
        if (stationOfferedBands.isEmpty()) {
            return;
        }
        stationOfferedBands.retainAll(myEnabledBands);
        if (stationOfferedBands.isEmpty()) {
            return;
        }
        EnumSet<Band> workedBands = this.collectWorkedBands(callRaw);
        EnumSet<Band> remainingBands = EnumSet.copyOf(stationOfferedBands);
        remainingBands.removeAll(workedBands);
        if (remainingBands.isEmpty()) {
            return;
        }
        System.out.println("[BandUpgradeHint] call=" + callRaw + " enabled=" + ChatController.formatBandsHuman(myEnabledBands) + " offered=" + ChatController.formatBandsHuman(stationOfferedBands) + " worked=" + (workedBands.isEmpty() ? "-" : ChatController.formatBandsHuman(workedBands)) + " remaining=" + ChatController.formatBandsHuman(remainingBands));
        String remainingHuman = ChatController.formatBandsHuman(remainingBands);
        String shortText = "BAND+ " + callRaw + " " + remainingHuman;
        String tooltip = "Logged " + callRaw + ", but station is still QRV on additional band(s): " + remainingHuman + "\n(Enabled: " + ChatController.formatBandsHuman(myEnabledBands) + " | Worked: " + (workedBands.isEmpty() ? "-" : ChatController.formatBandsHuman(workedBands)) + ")";
        ThreadStateMessage msg = new ThreadStateMessage("BandUpgradeHint", true, tooltip, false);
        msg.setRunningInformationTextDescription(shortText);
        this.onThreadStatus("BandUpgradeHint", msg);
        if (this.chatPreferences.isNotify_playSimpleSounds()) {
            try {
                this.getPlayAudioUtils().playNoiseLauncher('!');
            }
            catch (Exception e) {
                System.out.println("[ChatController, warning]: failed to play band-upgrade hint sound: " + e.getMessage());
            }
        }
        if (this.getScoreService() != null) {
            this.getScoreService().requestRecompute("BandUpgradeHint");
        }
    }

    private static String normalizeCallRaw(String callRaw) {
        return callRaw.trim().toUpperCase(Locale.ROOT);
    }

    private static EnumSet<Band> getMyEnabledBandsFromPrefs(ChatPreferences prefs) {
        EnumSet<Band> s = EnumSet.noneOf(Band.class);
        if (prefs.isStn_bandActive144()) {
            s.add(Band.B_144);
        }
        if (prefs.isStn_bandActive432()) {
            s.add(Band.B_432);
        }
        if (prefs.isStn_bandActive1240()) {
            s.add(Band.B_1296);
        }
        if (prefs.isStn_bandActive2300()) {
            s.add(Band.B_2320);
        }
        if (prefs.isStn_bandActive3400()) {
            s.add(Band.B_3400);
        }
        if (prefs.isStn_bandActive5600()) {
            s.add(Band.B_5760);
        }
        if (prefs.isStn_bandActive10G()) {
            s.add(Band.B_10G);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EnumSet<Band> collectStationOfferedBandsFromHistory(String callRaw, long nowMs, long maxAgeMs) {
        EnumSet<Band> offered = EnumSet.noneOf(Band.class);
        ObservableList<ChatMember> observableList = this.getLst_chatMemberList();
        synchronized (observableList) {
            for (ChatMember cm : this.getLst_chatMemberList()) {
                Map<Band, ChatMember.ActiveFrequencyInfo> map;
                if (cm == null || cm.getCallSignRaw() == null || !ChatController.normalizeCallRaw(cm.getCallSignRaw()).equals(callRaw) || (map = cm.getKnownActiveBands()) == null || map.isEmpty()) continue;
                for (Map.Entry<Band, ChatMember.ActiveFrequencyInfo> e : map.entrySet()) {
                    if (e.getKey() == null || e.getValue() == null) continue;
                    long age = nowMs - e.getValue().timestampEpoch;
                    if (age >= 0L && age <= maxAgeMs) {
                        offered.add(e.getKey());
                    }
                    System.out.println("[BandUpgradeHint] history call=" + callRaw + " band=" + (Object)((Object)e.getKey()) + " freq=" + e.getValue().frequency + " ageMs=" + age);
                }
            }
        }
        return offered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EnumSet<Band> collectWorkedBands(String callRaw) {
        EnumSet<Band> worked = EnumSet.noneOf(Band.class);
        ObservableList<ChatMember> observableList = this.getLst_chatMemberList();
        synchronized (observableList) {
            for (ChatMember cm : this.getLst_chatMemberList()) {
                if (cm == null || cm.getCallSignRaw() == null || !ChatController.normalizeCallRaw(cm.getCallSignRaw()).equals(callRaw)) continue;
                if (cm.isWorked144()) {
                    worked.add(Band.B_144);
                }
                if (cm.isWorked432()) {
                    worked.add(Band.B_432);
                }
                if (cm.isWorked1240()) {
                    worked.add(Band.B_1296);
                }
                if (cm.isWorked2300()) {
                    worked.add(Band.B_2320);
                }
                if (cm.isWorked3400()) {
                    worked.add(Band.B_3400);
                }
                if (cm.isWorked5600()) {
                    worked.add(Band.B_5760);
                }
                if (cm.isWorked10G()) {
                    worked.add(Band.B_10G);
                }
                if (!cm.isWorked24G()) continue;
                worked.add(Band.B_24G);
            }
        }
        return worked;
    }

    private static String formatBandsHuman(EnumSet<Band> bands) {
        if (bands == null || bands.isEmpty()) {
            return "-";
        }
        return bands.stream().map(ChatController::bandToHumanLabel).sorted().reduce((a, b) -> a + ", " + b).orElse("-");
    }

    private static String bandToHumanLabel(Band b) {
        if (b == null) {
            return "?";
        }
        return switch (b) {
            case Band.B_144 -> "2m";
            case Band.B_432 -> "70cm";
            case Band.B_1296 -> "23cm";
            case Band.B_2320 -> "13cm";
            case Band.B_3400 -> "9cm";
            case Band.B_5760 -> "6cm";
            case Band.B_10G -> "3cm";
            case Band.B_24G -> "1.2cm";
            default -> b.name();
        };
    }

    public void stopRotator() {
        if (this.rotatorClient != null) {
            this.rotatorClient.stop();
        }
    }

    @Override
    public void onAzimuthUpdate(double azimuth) {
        Runnable fxUpdate = () -> this.chatPreferences.getActualQTF().setValue((Number)azimuth);
        if (Platform.isFxApplicationThread()) {
            fxUpdate.run();
        } else {
            Platform.runLater((Runnable)fxUpdate);
        }
    }

    @Override
    public void onElevationUpdate(double elevation) {
    }

    @Override
    public void onModeUpdate(boolean isTracking) {
    }

    @Override
    public void onMessageReceived(String raw) {
    }

    public void queuePrivateCqMessage(String targetCallSignRaw, ChatCategory preferredCategory, String messageAfterCq) {
        if (targetCallSignRaw == null || targetCallSignRaw.isBlank()) {
            return;
        }
        ChatCategory categoryToUse = preferredCategory;
        if (categoryToUse == null) {
            ChatCategory last = this.lastInboundCategoryByCallSignRaw.get(targetCallSignRaw.trim().toUpperCase());
            categoryToUse = last != null ? last : this.chatCategoryMain;
        }
        String text = "/cq " + targetCallSignRaw.trim().toUpperCase() + " " + (messageAfterCq == null ? "" : messageAfterCq);
        ChatMessage msg = new ChatMessage();
        msg.setChatCategory(categoryToUse);
        msg.setMessageText(text);
        msg.setMessageDirectedToServer(false);
        this.messageTXBus.add(msg);
        this.stationMetricsService.tryRecordOutboundCq(text, System.currentTimeMillis());
        if (this.scoreService != null) {
            this.scoreService.requestRecompute("outbound-cq");
        }
    }

    public void airScout_SendAsShowPathPacket(ChatMember remoteChatMember) {
        String prefix_asSetpath = "ASSHOWPATH: \"" + this.getChatPreferences().getAirScout_asClientNameString() + "\" \"" + this.getChatPreferences().getAirScout_asServerNameString() + "\" ";
        String bandString = "1440000";
        String remoteCallAndLocString = remoteChatMember.getCallSign() + "," + remoteChatMember.getQra();
        String ownCallSign = "";
        try {
            ownCallSign = this.chatPreferences.getStn_loginCallSign().contains("-") ? this.chatPreferences.getStn_loginCallSign().split("-")[0] : this.chatPreferences.getStn_loginCallSign();
        }
        catch (Exception e) {
            System.out.println("[ASPERIODICAL, Error]: " + e.getMessage());
        }
        String myCallAndMyLocString = ownCallSign + "," + this.chatPreferences.getStn_loginLocatorMainCat();
        String host = "255.255.255.255";
        int port = this.chatPreferences.getAirScout_asCommunicationPort();
        Object queryStringToAirScout = "";
        queryStringToAirScout = (String)queryStringToAirScout + prefix_asSetpath + bandString + "," + myCallAndMyLocString + "," + remoteCallAndLocString + "\u00c5";
        byte[] queryStringToAirScoutMSG = ((String)queryStringToAirScout).getBytes();
        try {
            InetAddress address = InetAddress.getByName("255.255.255.255");
            DatagramPacket packet = new DatagramPacket(queryStringToAirScoutMSG, queryStringToAirScoutMSG.length, address, port);
            DatagramSocket dsocket = new DatagramSocket();
            dsocket.setBroadcast(true);
            dsocket.send(packet);
            dsocket.close();
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        catch (NoRouteToHostException e) {
            e.printStackTrace();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void startScoreScheduler() {
        if (this.scoreScheduler != null && !this.scoreScheduler.isShutdown()) {
            return;
        }
        this.scoreScheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r);
            t.setName("ScoreServiceScheduler");
            t.setDaemon(true);
            return t;
        });
        this.scoreScheduler.scheduleAtFixedRate(() -> {
            try {
                this.scoreService.tick();
            }
            catch (Exception e) {
                System.err.println("[ChatController] CRITICAL ERROR in ScoreService tick:");
                e.printStackTrace();
            }
        }, 1L, 3L, TimeUnit.SECONDS);
        this.scoreService.requestRecompute("startup");
        System.out.println("[ChatController] ScoreService scheduler started.");
    }

    private void stopScoreScheduler() {
        if (this.scoreScheduler != null) {
            this.scoreScheduler.shutdownNow();
        }
        this.scoreScheduler = null;
    }

    public void disconnect(String action) {
        DatagramSocket dsocket;
        DatagramPacket packet;
        InetAddress address;
        int port;
        String host;
        this.stopScoreScheduler();
        this.dxClusterServer.stop();
        this.setDisconnectionPerformedByUser(true);
        try {
            host = "255.255.255.255";
            port = this.chatPreferences.getLogsynch_ucxUDPWkdCallListenerPort();
            address = InetAddress.getByName("255.255.255.255");
            packet = new DatagramPacket(ApplicationConstants.DISCONNECT_RDR_POISONPILL.getBytes(), ApplicationConstants.DISCONNECT_RDR_POISONPILL.length(), address, port);
            DatagramPacket killWintestReaderPacket = new DatagramPacket(ApplicationConstants.DISCONNECT_RDR_POISONPILL.getBytes(), ApplicationConstants.DISCONNECT_RDR_POISONPILL.length(), address, this.chatPreferences.getLogsynch_wintestNetworkPort());
            dsocket = new DatagramSocket();
            dsocket.setBroadcast(true);
            dsocket.send(packet);
            dsocket.close();
            dsocket = new DatagramSocket();
            dsocket.setBroadcast(true);
            dsocket.send(killWintestReaderPacket);
            dsocket.close();
            this.readUDPbyUCXThread.interrupt();
            this.stopWintestUdpListener();
        }
        catch (Exception error) {
            System.out.println("Chatcrontroller, ERROR: unable to send poison pill to ucxThread");
        }
        try {
            host = "255.255.255.255";
            port = this.chatPreferences.getAirScout_asCommunicationPort();
            address = InetAddress.getByName("255.255.255.255");
            packet = new DatagramPacket(ApplicationConstants.DISCONNECT_RDR_POISONPILL.getBytes(), ApplicationConstants.DISCONNECT_RDR_POISONPILL.length(), address, port);
            dsocket = new DatagramSocket();
            dsocket.setBroadcast(true);
            dsocket.send(packet);
            dsocket.close();
        }
        catch (Exception error) {
            System.out.println("Chatcrontroller, ERROR: unable to send poison pill to ucxThread");
        }
        if (action.equals("CLOSEALL")) {
            this.lst_chatMemberList.clear();
            this.lst_clusterMemberList.clear();
            this.setDisconnected(true);
            this.setConnectedAndLoggedIn(false);
            this.setConnectedAndNOTLoggedIn(false);
            this.keepAliveTimer.cancel();
            this.keepAliveTimer.purge();
            killThreadPoisonPillMsg = new ChatMessage();
            killThreadPoisonPillMsg.setMessageText(ApplicationConstants.DISCONNECT_RDR_POISONPILL);
            killThreadPoisonPillMsg.setMessageSenderName(ApplicationConstants.DISCONNECT_RDR_POISONPILL);
            this.messageRXBus.clear();
            this.messageTXBus.clear();
            this.messageRXBus.add(killThreadPoisonPillMsg);
            this.messageTXBus.add(killThreadPoisonPillMsg);
            this.beaconTimer.purge();
            this.beaconTimer.cancel();
            this.ASQueryTimer.purge();
            this.ASQueryTimer.cancel();
            this.socketCheckTimer.purge();
            this.socketCheckTimer.cancel();
            this.userActualizationtimer.purge();
            this.userActualizationtimer.cancel();
            this.userActualizationtimer.purge();
            this.userActualizationtimer.cancel();
            this.messageProcessor.interrupt();
            this.readUDPbyUCXThread.interrupt();
            this.stopWintestUdpListener();
            this.airScoutUDPReaderThread.interrupt();
            this.dbHandler.closeDBConnection();
            this.dxClusterServer.stop();
            this.rotatorClient.stopRotor();
            this.rotatorClient.stop();
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        } else if (action.equals("ONLYDISCONNECT")) {
            this.lst_chatMemberList.clear();
            this.lst_clusterMemberList.clear();
            this.setDisconnected(true);
            this.setConnectedAndLoggedIn(false);
            this.setConnectedAndNOTLoggedIn(false);
            this.keepAliveTimer.cancel();
            this.keepAliveTimer.purge();
            killThreadPoisonPillMsg = new ChatMessage();
            killThreadPoisonPillMsg.setMessageText(ApplicationConstants.DISCONNECT_RDR_POISONPILL);
            killThreadPoisonPillMsg.setMessageSenderName(ApplicationConstants.DISCONNECT_RDR_POISONPILL);
            this.messageRXBus.clear();
            this.messageTXBus.clear();
            this.messageRXBus.add(killThreadPoisonPillMsg);
            this.messageTXBus.add(killThreadPoisonPillMsg);
            this.writeThread.interrupt();
            this.readThread.interrupt();
            this.beaconTimer.purge();
            this.beaconTimer.cancel();
            this.ASQueryTimer.purge();
            this.ASQueryTimer.cancel();
            this.socketCheckTimer.purge();
            this.socketCheckTimer.cancel();
            this.userActualizationtimer.purge();
            this.userActualizationtimer.cancel();
            this.readUDPbyUCXThread.interrupt();
            this.stopWintestUdpListener();
            this.airScoutUDPReaderThread.interrupt();
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public ObservableList<ContestSked> getActiveSkeds() {
        return this.activeSkeds;
    }

    public ScoreService getScoreService() {
        return this.scoreService;
    }

    public void addSked(ContestSked sked) {
        Platform.runLater(() -> {
            this.activeSkeds.add((Object)sked);
            this.scoreService.requestRecompute("sked-added");
        });
    }

    public StationMetricsService getStationMetricsService() {
        return this.stationMetricsService;
    }

    public SkedReminderService getSkedReminderService() {
        return this.skedReminderService;
    }

    public void rememberLastInboundCategory(String callSignRaw, ChatCategory category) {
        if (callSignRaw == null || category == null) {
            return;
        }
        this.lastInboundCategoryByCallSignRaw.put(callSignRaw.trim().toUpperCase(), category);
    }

    public Map<String, ChatCategory> snapshotLastInboundCategoryMap() {
        return new HashMap<String, ChatCategory>(this.lastInboundCategoryByCallSignRaw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChatMember> snapshotChatMembers() {
        ObservableList<ChatMember> observableList = this.getLst_chatMemberList();
        synchronized (observableList) {
            return new ArrayList<ChatMember>((Collection<ChatMember>)this.getLst_chatMemberList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ContestSked> snapshotActiveSkeds() {
        ObservableList<ContestSked> observableList = this.activeSkeds;
        synchronized (observableList) {
            return new ArrayList<ContestSked>((Collection<ContestSked>)this.activeSkeds);
        }
    }

    public void requestRemoveExpiredSkeds(long nowEpochMs) {
        Platform.runLater(() -> {
            ObservableList<ContestSked> observableList = this.activeSkeds;
            synchronized (observableList) {
                this.activeSkeds.removeIf(sked -> nowEpochMs - sked.getSkedTimeEpoch() > 300000L);
            }
        });
    }

    public PlayAudioUtils getPlayAudioUtils() {
        return this.playAudioUtils;
    }

    public ArrayList<Integer> checkListForChatMemberIndexesByCallSign(ChatMember lookForThis) {
        ArrayList<Integer> resultingIndexes = new ArrayList<Integer>();
        if (lookForThis == null) {
            return resultingIndexes;
        }
        if (lookForThis.getCallSignRaw() == null) {
            System.out.println("[ChatCtrl] ERROR: null Value in Callsign detected! Member cannot be in the list!");
            return resultingIndexes;
        }
        for (ChatMember chatMember : this.lst_chatMemberList) {
            if (!chatMember.getCallSignRaw().equals(lookForThis.getCallSignRaw())) continue;
            resultingIndexes.add(this.lst_chatMemberList.indexOf((Object)chatMember));
        }
        return resultingIndexes;
    }

    public void fireUserListUpdate(String reason) {
        if (this.statusListener != null) {
            this.statusListener.onUserListUpdated(reason);
        }
    }

    public FilteredList<ChatMessage> getLst_selectedCallSignInfofilteredMessageList() {
        return this.lst_selectedCallSignInfofilteredMessageList;
    }

    public void setLst_selectedCallSignInfofilteredMessageList(FilteredList<ChatMessage> lst_selectedCallSignInfofilteredMessageList) {
        this.lst_selectedCallSignInfofilteredMessageList = lst_selectedCallSignInfofilteredMessageList;
    }

    public ObservableList<ChatMessage> getLst_globalChatMessageList() {
        return this.lst_globalChatMessageList;
    }

    public void setLst_globalChatMessageList(ObservableList<ChatMessage> lst_globalChatMessageList) {
        this.lst_globalChatMessageList = lst_globalChatMessageList;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public void setMessageTXBus(LinkedBlockingQueue<ChatMessage> messageTXBus) {
        this.messageTXBus = messageTXBus;
    }

    public String getPraktiKSTVersionInfo() {
        return this.praktiKSTVersionInfo;
    }

    public void setPraktiKSTVersionInfo(String praktiKSTVersionInfo) {
        this.praktiKSTVersionInfo = praktiKSTVersionInfo;
    }

    public ObservableList<ChatMember> getLst_chatMemberList() {
        return this.lst_chatMemberList;
    }

    public ObservableList<ChatMember> getLst_DBBasedWkdCallSignList() {
        return this.lst_DBBasedWkdCallSignList;
    }

    public void setLst_DBBasedWkdCallSignList(ObservableList<ChatMember> lst_DBBasedWkdCallSignList) {
        this.lst_DBBasedWkdCallSignList = lst_DBBasedWkdCallSignList;
    }

    public void setLst_chatMemberList(ObservableList<ChatMember> lst_chatMemberList) {
        this.lst_chatMemberList = lst_chatMemberList;
    }

    public FilteredList<ChatMember> getLst_chatMemberListFiltered() {
        return this.lst_chatMemberListFiltered;
    }

    public SortedList<ChatMember> getLst_chatMemberSortedFilteredList() {
        return this.lst_chatMemberSortedFilteredList;
    }

    public ObservableList<Predicate<ChatMember>> getLst_chatMemberListFilterPredicates() {
        return this.lst_chatMemberListFilterPredicates;
    }

    public void setLst_chatMemberListFilterPredicates(ObservableList<Predicate<ChatMember>> lst_chatMemberListFilterPredicates) {
        this.lst_chatMemberListFilterPredicates = lst_chatMemberListFilterPredicates;
    }

    public ObservableList<ClusterMessage> getLst_clusterMemberList() {
        return this.lst_clusterMemberList;
    }

    public void setLst_clusterMemberList(ObservableList<ClusterMessage> lst_clusterMemberList) {
        this.lst_clusterMemberList = lst_clusterMemberList;
    }

    public ObservableList<ChatMessage> getLst_toAllMessageList() {
        return this.lst_toAllMessageList;
    }

    public void setLst_toAllMessageList(FilteredList<ChatMessage> lst_toAllMessageList) {
        this.lst_toAllMessageList = lst_toAllMessageList;
    }

    public ObservableList<ChatMessage> getLst_toMeMessageList() {
        return this.lst_toMeMessageList;
    }

    public void setLst_toMeMessageList(FilteredList<ChatMessage> lst_toMeMessageList) {
        this.lst_toMeMessageList = lst_toMeMessageList;
    }

    public ObservableList<ChatMessage> getLst_toOtherMessageList() {
        return this.lst_toOtherMessageList;
    }

    public void setLst_toOtherMessageList(FilteredList<ChatMessage> lst_toOtherMessageList) {
        this.lst_toOtherMessageList = lst_toOtherMessageList;
    }

    public LinkedBlockingQueue<ChatMessage> getMessageTXBus() {
        return this.messageTXBus;
    }

    public ChatController() {
        this.chatCategoryMain = new ChatCategory(2);
        this.chatCategorySecondChat = new ChatCategory(3);
        this.ownChatMemberObject = new ChatMember();
        this.ownChatMemberObject.setCallSign(this.userName);
        this.ownChatMemberObject.setName(this.showedName);
        this.ownChatMemberObject.setQra(this.qra);
        this.userName = this.ownChatMemberObject.getName();
        this.port = this.port;
    }

    public ChatController(ChatMember setOwnChatMemberObject, StatusUpdateListener listener) {
        this.chatPreferences = new ChatPreferences();
        this.chatPreferences.readPreferencesFromXmlFile();
        String dnsFromPrefs = this.chatPreferences.getStn_on4kstServersDns();
        this.hostname = dnsFromPrefs != null && !dnsFromPrefs.isEmpty() ? dnsFromPrefs : "109.90.0.130";
        UpdateChecker checkForUpdates = new UpdateChecker(this);
        if (checkForUpdates.downloadLatestVersionInfoXML()) {
            this.updateInformation = checkForUpdates.parseUpdateXMLFile();
        }
        this.initLst_toMeMessageList();
        this.lst_toAllMessageList.setPredicate((Predicate)new Predicate<ChatMessage>(){

            @Override
            public boolean test(ChatMessage chatMessage) {
                try {
                    return chatMessage.getReceiver().getCallSign().equals("ALL");
                }
                catch (Exception nullPointerExc) {
                    nullPointerExc.printStackTrace();
                    System.out.println("ChatController, ERROR: maybe the receiver was null, mostly like a cq message!");
                    return true;
                }
            }
        });
        this.lst_toOtherMessageList.setPredicate((Predicate)new Predicate<ChatMessage>(){

            @Override
            public boolean test(ChatMessage chatMessage) {
                try {
                    return !chatMessage.getSender().getCallSign().equals(ChatController.this.getChatPreferences().getStn_loginCallSign()) && !chatMessage.getReceiver().getCallSign().equals(ChatController.this.getChatPreferences().getStn_loginCallSign()) && !chatMessage.getReceiver().getCallSign().equals("ALL");
                }
                catch (Exception nullPointerExc) {
                    System.out.println("ChatController, <<<catched ERROR>>>: maybe the receiver was null!");
                    return false;
                }
            }
        });
        this.dbHandler = new DBController();
        this.chatCategoryMain = this.chatPreferences.getLoginChatCategoryMain();
        this.chatCategorySecondChat = this.chatPreferences.getLoginChatCategorySecond();
        this.userName = this.chatPreferences.getStn_loginCallSign();
        this.password = this.chatPreferences.getStn_loginPassword();
        this.ownChatMemberObject = setOwnChatMemberObject;
        this.hostname = this.getChatPreferences().getStn_on4kstServersDns();
    }

    private void initLst_toMeMessageList() {
        Predicate<ChatMessage> chatFilterPredicate = chatMessage -> {
            if (chatMessage == null || chatMessage.getSender() == null || chatMessage.getReceiver() == null) {
                return false;
            }
            String myCallSign = this.getChatPreferences().getStn_loginCallSign();
            String senderCall = chatMessage.getSender().getCallSign();
            String receiverCall = chatMessage.getReceiver().getCallSign();
            Object msgText = chatMessage.getMessageText();
            if ((this.lstNotify_QSOSniffer_sniffedCallSignList.contains((Object)senderCall) || this.lstNotify_QSOSniffer_sniffedCallSignList.contains((Object)receiverCall)) && !receiverCall.equals(this.getChatPreferences().getStn_loginCallSignRaw())) {
                msgText = "Sniffed: (" + senderCall + " > " + receiverCall + ") " + (String)msgText;
                chatMessage.setMessageText((String)msgText);
                return true;
            }
            if (receiverCall.equals(myCallSign)) {
                return true;
            }
            if (senderCall.equals(myCallSign) && !receiverCall.equals("ALL")) {
                return true;
            }
            return msgText != null && !senderCall.equals(myCallSign) && ((String)msgText).toLowerCase().contains(myCallSign.toLowerCase());
        };
        this.lstNotify_QSOSniffer_sniffedCallSignList.addListener(c -> {
            this.lst_toMeMessageList.setPredicate(null);
            this.lst_toMeMessageList.setPredicate(chatFilterPredicate);
        });
        this.lstNotify_QSOSniffer_sniffedCallSignList.add((Object)"DF0GEB");
        this.lst_toMeMessageList.setPredicate(chatFilterPredicate);
    }

    public synchronized void startWintestUdpListener() {
        if (this.readUDPByWintestThread != null && this.readUDPByWintestThread.isAlive()) {
            return;
        }
        this.readUDPByWintestThread = new ReadUDPByWintestThread(this, this);
        this.readUDPByWintestThread.setName("readUDPByWintestThread");
        this.readUDPByWintestThread.start();
        System.out.println("[ChatController] Win-Test UDP listener started.");
    }

    public synchronized void stopWintestUdpListener() {
        if (this.readUDPByWintestThread == null) {
            return;
        }
        try {
            this.readUDPByWintestThread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.readUDPByWintestThread = null;
        System.out.println("[ChatController] Win-Test UDP listener stopped.");
    }

    public synchronized void restartWintestUdpListenerIfEnabled() {
        this.stopWintestUdpListener();
        if (this.chatPreferences.isLogsynch_wintestNetworkListenerEnabled()) {
            this.startWintestUdpListener();
        }
    }

    public ObservableList<String> getLstNotify_QSOSniffer_sniffedCallSignList() {
        return this.lstNotify_QSOSniffer_sniffedCallSignList;
    }

    public void setLstNotify_QSOSniffer_sniffedCallSignList(ObservableList<String> lstNotify_QSOSniffer_sniffedCallSignList) {
        this.lstNotify_QSOSniffer_sniffedCallSignList = lstNotify_QSOSniffer_sniffedCallSignList;
    }

    public ChatPreferences getChatPreferences() {
        return this.chatPreferences;
    }

    public void setChatPreferences(ChatPreferences chatPreferences) {
        this.chatPreferences = chatPreferences;
    }

    public ChatMember getownChatMemberObject() {
        return this.ownChatMemberObject;
    }

    public void setOwnCall(ChatMember ownCall) {
        this.ownChatMemberObject = ownCall;
    }

    public LinkedBlockingQueue<ChatMessage> getMessageRXBus() {
        return this.messageRXBus;
    }

    public void setMessageRXBus(LinkedBlockingQueue<ChatMessage> messageBus) {
        this.messageRXBus = messageBus;
    }

    public WriteThread getWriteThread() {
        return this.writeThread;
    }

    public void setWriteThread(WriteThread writeThread) {
        this.writeThread = writeThread;
    }

    public ReadThread getReadThread() {
        return this.readThread;
    }

    public void setReadThread(ReadThread readThread) {
        this.readThread = readThread;
    }

    public ChatCategory getChatCategoryMain() {
        return this.chatCategoryMain;
    }

    public void setChatCategoryMain(ChatCategory chatCategoryMain) {
        this.chatCategoryMain = chatCategoryMain;
    }

    public DXClusterThreadPooledServer getDxClusterServer() {
        return this.dxClusterServer;
    }

    public DBController getDbHandler() {
        return this.dbHandler;
    }

    public void setDbHandler(DBController dbHandler) {
        this.dbHandler = dbHandler;
    }

    public void execute() throws InterruptedException, IOException {
        this.chatController = this;
        try {
            this.setDisconnectionPerformedByUser(false);
            this.startScoreScheduler();
            this.messageRXBus = new LinkedBlockingQueue();
            this.messageTXBus = new LinkedBlockingQueue();
            this.socket = new Socket(this.chatController.chatPreferences.getStn_on4kstServersDns(), this.port);
            System.out.println("Connected to the chat server: " + this.socket.isConnected());
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            Selector selector = Selector.open();
            this.readThread = new ReadThread(this.socket, this);
            this.readThread.setName("ReadThread-telnetreader");
            this.readThread.start();
            this.writeThread = new WriteThread(this.socket, this);
            this.writeThread.setName("Writethread-telnetwriter");
            this.writeThread.start();
            this.readUDPbyUCXThread = new ReadUDPbyUCXMessageThread(this.chatPreferences.getLogsynch_ucxUDPWkdCallListenerPort(), this, this);
            this.readUDPbyUCXThread.setName("readUDPbyUCXThread");
            this.readUDPbyUCXThread.start();
            if (this.chatPreferences.isLogsynch_wintestNetworkListenerEnabled()) {
                this.startWintestUdpListener();
            } else {
                System.out.println("[ChatController] Win-Test listener disabled by preference -> not starting.");
            }
            this.messageProcessor = new MessageBusManagementThread(this, this);
            this.messageProcessor.setName("messagebusManagementThread");
            this.messageProcessor.start();
            this.airScoutUDPReaderThread = new ReadUDPbyAirScoutMessageThread(this.chatPreferences.getAirScout_asCommunicationPort(), this, this.getChatPreferences().getAirScout_asServerNameString(), this.getChatPreferences().getAirScout_asServerNameString(), this);
            this.airScoutUDPReaderThread.setName("airscoutudpreaderThread");
            this.airScoutUDPReaderThread.start();
            this.userActualizationtimer = new Timer();
            this.userActualizationtimer.schedule((TimerTask)new UserActualizationTask(this), 4000L, 60000L);
            this.keepAliveTimer = new Timer();
            this.keepAliveTimer.schedule((TimerTask)new keepAliveMessageSenderTask(this), 4000L, 60000L);
            if (this.chatPreferences.isStn_pstRotatorEnabled()) {
                this.initRotor();
            } else {
                System.out.println("[ChatController, info]: PSTRotator disabled by user preference -> not starting rotator client.");
            }
            this.dxClusterServer = new DXClusterThreadPooledServer(this.getChatPreferences().getNotify_dxclusterServerPort(), this, this);
            new Thread(this.dxClusterServer).start();
            this.setConnectedAndLoggedIn(true);
            this.beaconTimer = new Timer();
            this.beaconTimer.schedule((TimerTask)new BeaconTask(this, this), 10000L, (long)(this.getChatPreferences().getBcn_beaconIntervalInMinutesMainCat() * 60000));
            this.ASQueryTimer = new Timer();
            this.ASQueryTimer.schedule((TimerTask)new AirScoutPeriodicalAPReflectionInquirerTask(this), 10000L, 60000L);
            this.socketCheckTimer = new Timer();
            this.socketCheckTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Thread.currentThread().setName("SocketcheckTimer");
                    if (!ChatController.this.socket.isConnected() || ChatController.this.socket.isClosed()) {
                        try {
                            ChatController.this.messageRXBus.clear();
                            ChatController.this.messageTXBus.clear();
                            ChatController.this.socket.close();
                            ChatController.this.chatController.setConnectedAndLoggedIn(false);
                            ChatController.this.chatController.getLst_chatMemberList().clear();
                            System.out.println("[Chatcontroller, Warning: ] Socket closed or disconnected");
                            ChatMessage killThreadPoisonPillMsg = new ChatMessage();
                            killThreadPoisonPillMsg.setMessageText(ApplicationConstants.DISCONNECT_RDR_POISONPILL);
                            killThreadPoisonPillMsg.setMessageSenderName(ApplicationConstants.DISCONNECT_RDR_POISONPILL);
                            ChatMessage killThreadPoisonPillMsg2 = new ChatMessage();
                            killThreadPoisonPillMsg2.setMessageText(ApplicationConstants.DISCONNECT_RDR_POISONPILL);
                            killThreadPoisonPillMsg2.setMessageSenderName(ApplicationConstants.DISCONNECT_RDR_POISONPILL);
                            ChatController.this.messageRXBus.add(killThreadPoisonPillMsg);
                            ChatController.this.messageTXBus.add(killThreadPoisonPillMsg2);
                            ChatController.this.chatController.getReadThread().interrupt();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            if (!ChatController.this.disconnectionPerformedByUser) {
                                ChatController.this.messageRXBus.clear();
                                ChatController.this.messageTXBus.clear();
                                ChatController.this.socket = new Socket(ChatController.this.hostname, ChatController.this.port);
                                ChatController.this.chatController.setReadThread(new ReadThread(ChatController.this.socket, ChatController.this.chatController));
                                ChatController.this.chatController.readThread.start();
                                ChatController.this.chatController.setWriteThread(new WriteThread(ChatController.this.socket, ChatController.this.chatController));
                                ChatController.this.chatController.writeThread.start();
                                ChatController.this.messageProcessor = new MessageBusManagementThread(ChatController.this.chatController, ChatController.this.chatController);
                                ChatController.this.messageProcessor.start();
                                System.out.println("[Chatcontroller, info: initialized new socket, is connected? ] " + ChatController.this.socket.isConnected() + " " + ChatController.this.socket.isClosed());
                                ChatController.this.initialize23001();
                                Timer waitABit = new Timer();
                                ChatController.this.socketCheckTimer.schedule(new TimerTask(){

                                    @Override
                                    public void run() {
                                        Thread.currentThread().setName("waiting");
                                        if (ChatController.this.socket.isConnected()) {
                                            ChatController.this.chatController.setConnectedAndLoggedIn(true);
                                        }
                                    }
                                }, 5000L);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }, 10000L, 10000L);
        }
        catch (UnknownHostException ex) {
            System.out.println("Server not found: " + ex.getMessage());
        }
        catch (IOException ex) {
            System.out.println("I/O Error: " + ex.getMessage());
        }
        while (this.readThread == null) {
            System.out.println("Reader not ready.");
        }
        this.initialize23001();
    }

    public long getCurrentEpochTime() {
        OffsetDateTime currentTimeInUtc = OffsetDateTime.now(ZoneOffset.UTC);
        long millisecondsSinceEpoch = currentTimeInUtc.toInstant().toEpochMilli() / 1000L;
        return millisecondsSinceEpoch;
    }

    public void initialize23001() throws InterruptedException, IOException {
        this.messageTXBus.clear();
        ChatMessage message = new ChatMessage();
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                Thread.currentThread().setName("LoginStringTimer");
                Object loginString = "";
                loginString = "LOGINC|" + ChatController.this.chatPreferences.getStn_loginCallSign() + "|" + ChatController.this.chatPreferences.getStn_loginPassword() + "|" + ChatController.this.chatPreferences.getLoginChatCategoryMain().getCategoryNumber() + "|praktiKST v1.4|25|0|1|0|0|";
                ChatMessage message = new ChatMessage();
                message.setMessageText((String)loginString);
                message.setMessageDirectedToServer(true);
                ChatController.this.getMessageTXBus().add(message);
            }
        }, 2000L);
        if (this.chatController.getChatPreferences().isLoginToSecondChatEnabled()) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    Thread.currentThread().setName("LoginStringTimerSecond");
                    Object loginString = "";
                    loginString = "ACHAT|" + ChatController.this.chatController.getChatPreferences().getLoginChatCategorySecond().getCategoryNumber() + "|25|10|2|" + ChatController.this.getCurrentEpochTime() + "|" + ChatController.this.getCurrentEpochTime();
                    ChatMessage message = new ChatMessage();
                    message.setMessageText((String)loginString);
                    message.setMessageDirectedToServer(true);
                    ChatController.this.getMessageTXBus().add(message);
                }
            }, 5000L);
        }
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                Thread.currentThread().setName("SDONEStringTimer");
                ChatMessage message = new ChatMessage();
                message.setMessageText("SDONE|" + ChatController.this.chatPreferences.getLoginChatCategoryMain().getCategoryNumber() + "|\r");
                message.setMessageDirectedToServer(true);
                ChatController.this.getMessageTXBus().add(message);
            }
        }, 3000L);
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                Thread.currentThread().setName("SETLOCTIMER");
                ChatMessage message = new ChatMessage();
                message.setMessageText("MSG|" + ChatController.this.chatPreferences.getLoginChatCategoryMain().getCategoryNumber() + "|0|/SETLOC " + ChatController.this.chatPreferences.getStn_loginLocatorMainCat() + "|0|\r");
                message.setMessageDirectedToServer(true);
                ChatController.this.getMessageTXBus().add(message);
            }
        }, 4000L);
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                Thread.currentThread().setName("SETNAMETIMER");
                ChatMessage message = new ChatMessage();
                message.setMessageText("MSG|" + ChatController.this.chatPreferences.getLoginChatCategoryMain().getCategoryNumber() + "|0|/SETNAME " + ChatController.this.chatPreferences.getStn_loginNameMainCat() + "|0|\r");
                message.setMessageDirectedToServer(true);
                ChatController.this.getMessageTXBus().add(message);
            }
        }, 5000L);
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                Thread.currentThread().setName("SETHereTimerMain");
                ChatMessage message = new ChatMessage();
                message.setMessageText("MSG|" + ChatController.this.chatPreferences.getLoginChatCategoryMain().getCategoryNumber() + "|0|/BACK|0|\r");
                message.setMessageDirectedToServer(true);
                ChatController.this.getMessageTXBus().add(message);
            }
        }, 6500L);
        if (this.chatPreferences.isLoginToSecondChatEnabled()) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    Thread.currentThread().setName("SETNAMETIMER2nd");
                    ChatMessage message = new ChatMessage();
                    message.setMessageText("MSG|" + ChatController.this.chatPreferences.getLoginChatCategorySecond().getCategoryNumber() + "|0|/SETNAME " + ChatController.this.chatPreferences.getStn_loginNameSecondCat() + "|0|\r");
                    message.setMessageDirectedToServer(true);
                    ChatController.this.getMessageTXBus().add(message);
                }
            }, 5500L);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    Thread.currentThread().setName("SETHereTimerSecond");
                    ChatMessage message = new ChatMessage();
                    message.setMessageText("MSG|" + ChatController.this.chatPreferences.getLoginChatCategorySecond().getCategoryNumber() + "|0|/BACK|0|\r");
                    message.setMessageDirectedToServer(true);
                    ChatController.this.getMessageTXBus().add(message);
                }
            }, 7000L);
        }
        new Timer().schedule(new TimerTask(){
            HashMap<String, ChatMember> getWorkedDataFromDb;

            @Override
            public void run() {
                Thread.currentThread().setName("fetchWorkedFromDBTimer");
                try {
                    this.getWorkedDataFromDb = ChatController.this.dbHandler.fetchChatMemberWkdDataFromDB();
                }
                catch (SQLException e) {
                    System.out.println("[Chatctrl, Error: ] got no worked data from DB due to communication error");
                }
                for (ChatMember chatMember : ChatController.this.getLst_chatMemberList()) {
                    System.out.println("[Chatctrl]: Marking ChatMembers wkd information: " + this.getWorkedDataFromDb.get(chatMember.getCallSign()).getCallSign());
                    chatMember.setWorked(this.getWorkedDataFromDb.get(chatMember.getCallSign()).isWorked());
                    chatMember.setWorked144(this.getWorkedDataFromDb.get(chatMember.getCallSignRaw()).isWorked144());
                    chatMember.setWorked432(this.getWorkedDataFromDb.get(chatMember.getCallSignRaw()).isWorked432());
                    chatMember.setWorked1240(this.getWorkedDataFromDb.get(chatMember.getCallSignRaw()).isWorked1240());
                    chatMember.setWorked2300(this.getWorkedDataFromDb.get(chatMember.getCallSignRaw()).isWorked2300());
                    chatMember.setWorked3400(this.getWorkedDataFromDb.get(chatMember.getCallSignRaw()).isWorked3400());
                    chatMember.setWorked5600(this.getWorkedDataFromDb.get(chatMember.getCallSignRaw()).isWorked5600());
                    chatMember.setWorked10G(this.getWorkedDataFromDb.get(chatMember.getCallSignRaw()).isWorked10G());
                    chatMember.setQrv144(this.getWorkedDataFromDb.get(chatMember.getCallSignRaw()).isQrv144());
                    chatMember.setQrv432(this.getWorkedDataFromDb.get(chatMember.getCallSignRaw()).isQrv432());
                    chatMember.setQrv1240(this.getWorkedDataFromDb.get(chatMember.getCallSignRaw()).isQrv1240());
                    chatMember.setQrv2300(this.getWorkedDataFromDb.get(chatMember.getCallSignRaw()).isQrv2300());
                    chatMember.setQrv3400(this.getWorkedDataFromDb.get(chatMember.getCallSignRaw()).isQrv3400());
                    chatMember.setQrv5600(this.getWorkedDataFromDb.get(chatMember.getCallSignRaw()).isQrv5600());
                    chatMember.setQrv10G(this.getWorkedDataFromDb.get(chatMember.getCallSignRaw()).isQrv10G());
                }
                this.getWorkedDataFromDb.forEach((key, value) -> ChatController.this.chatController.getLst_DBBasedWkdCallSignList().add(value));
            }
        }, 10000L);
    }

    public void resetWorkedInfoInGuiLists() {
        this.chatController.getLst_chatMemberList().forEach(chatMember -> chatMember.resetWorkedInformationAtAllBands());
    }

    public void resetQRVInfoInGuiLists() {
        this.chatController.getLst_chatMemberList().forEach(chatMember -> chatMember.resetQRVInformationAtAllBands());
    }

    public void initialize23000() throws InterruptedException, IOException {
        ChatMessage message = new ChatMessage();
        message.setMessageText(this.ownChatMemberObject.getCallSign());
        this.getMessageTXBus().add(message);
        message = new ChatMessage();
        message.setMessageText(this.password);
        this.getMessageTXBus().add(message);
        message = new ChatMessage();
        message.setMessageText("" + this.chatCategoryMain);
        this.getMessageTXBus().add(message);
        message = new ChatMessage();
        message.setMessageText("/set qra " + this.ownChatMemberObject.getQra());
        this.getMessageTXBus().add(message);
        message = new ChatMessage();
        message.setMessageText("/set name " + this.ownChatMemberObject.getName());
        this.getMessageTXBus().add(message);
        message = new ChatMessage();
        message.setMessageText("/set here");
        this.getMessageTXBus().add(message);
    }

    public void fireUiReminderEvent(String callSignRaw, int minutesBefore) {
        String raw = callSignRaw == null ? null : callSignRaw.trim().toUpperCase();
        long now = System.currentTimeMillis();
        if (Platform.isFxApplicationThread()) {
            this.lastUiReminderEvent.set((Object)new UiReminderEvent(raw, minutesBefore, now));
        } else {
            Platform.runLater(() -> this.lastUiReminderEvent.set((Object)new UiReminderEvent(raw, minutesBefore, now)));
        }
    }

    public ReadOnlyObjectProperty<UiReminderEvent> lastUiReminderEventProperty() {
        return this.lastUiReminderEvent;
    }

    public boolean isChatMemberInMyBeam(ChatMember member) {
        if (member == null || member.getQTFdirection() == null) {
            return false;
        }
        double targetAz = member.getQTFdirection();
        double myAz = this.getChatPreferences().getActualQTF().get();
        double beamWidth = this.getChatPreferences().getStn_antennaBeamWidthDeg();
        return DirectionUtils.isAngleInRange(targetAz, myAz, beamWidth);
    }

    public static final class UiReminderEvent {
        private final String callSignRaw;
        private final int minutesBefore;
        private final long epochMs;

        public UiReminderEvent(String callSignRaw, int minutesBefore, long epochMs) {
            this.callSignRaw = callSignRaw;
            this.minutesBefore = minutesBefore;
            this.epochMs = epochMs;
        }

        public String getCallSignRaw() {
            return this.callSignRaw;
        }

        public int getMinutesBefore() {
            return this.minutesBefore;
        }

        public long getEpochMs() {
            return this.epochMs;
        }
    }
}

