/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.view;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Predicate;
import javafx.animation.PauseTransition;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PasswordField;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Polygon;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import javafx.util.Duration;
import kst4contest.controller.ChatController;
import kst4contest.controller.StatusUpdateListener;
import kst4contest.controller.Utils4KST;
import kst4contest.locatorUtils.DirectionUtils;
import kst4contest.model.AirPlane;
import kst4contest.model.ChatCategory;
import kst4contest.model.ChatMember;
import kst4contest.model.ChatMessage;
import kst4contest.model.ClusterMessage;
import kst4contest.model.ThreadStateMessage;
import kst4contest.utils.ApplicationFileUtils;
import kst4contest.view.GuiUtils;

public class Kst4ContestApplication
extends Application
implements StatusUpdateListener {
    private final Map<String, Button> statusButtons = new HashMap<String, Button>();
    public static final String STYLE_DEFAULTCSSDAY_FILE = "KST4ContestDefaultDay.css";
    public static final String STYLE_DEFAULTCSSDAY_RESOURCE = "/KST4ContestDefaultDay.css";
    public static final String STYLE_DEFAULTCSSEVENING_FILE = "KST4ContestDefaultEvening.css";
    public static final String STYLE_DEFAULTCSSEVENING_RESOURCE = "/KST4ContestDefaultEvening.css";
    String chatState;
    ChatController chatcontroller;
    Button MYQRGButton;
    Button MYCALLSetQRGButton;
    Timer timer_buildWindowTitle;
    Timer timer_chatMemberTableSortTimer;
    Timer timer_updatePrivatemessageTable;
    VBox selectedCallSignFurtherInfoPane = new VBox();
    ToggleButton[] btnQtfButtonsAvl = new ToggleButton[8];
    Scene scn_ChatwindowMainScene;
    Scene clusterAndQSOMonScene;
    Scene settingsScene;
    MenuItem menuItemFileDisconnect;
    MenuItem menuItemOptionsAwayBack;
    MenuItem menuItemOptionsSetFrequencyAsName;
    TextField txt_chatMessageUserInput = new TextField();
    Button sendButton;
    TextField txt_ownqrgMainCategory = new TextField();
    TextField txt_ownqrgSecondCategory = new TextField();
    TextField txt_myQTF = new TextField();
    Button btnOptionspnlConnect;
    ContextMenu chatMessageContextMenu;
    ContextMenu chatMemberContextMenu;
    HBox chatMemberTableFilterQTFAndQRBHbox;
    FlowPane flwPane_textSnippets;
    FlowPane flwpne_StatusBar;
    Stage clusterAndQSOMonStage;
    ChatMember selectedCallSignInfoStageChatMember;
    BorderPane selectedCallSignInfoBorderPane;
    Stage stage_updateStage;
    Stage settingsStage;
    Stage notify_setSnifferEntitiesStage;
    ChoiceBox<ChatCategory> stn_choiceBxChatChategorySecond;
    private Queue<Media> musicList = new LinkedList<Media>();
    private MediaPlayer mediaPlayer;

    public static void showUserInputErrorWindow(String message) {
        Alert a = new Alert(Alert.AlertType.INFORMATION);
        a.setTitle("You entered something strange");
        a.setHeaderText("Value not accepted");
        a.setContentText(message);
        a.show();
    }

    public static Node createArrow(double deg) {
        double rad = Math.toRadians(-90.0 - deg);
        double arrowLength = 6.0;
        double tipX = arrowLength * Math.cos(rad);
        double tipY = arrowLength * Math.sin(rad);
        Line arrowLine = new Line(0.0, 0.0, tipX, -tipY);
        arrowLine.setStroke((Paint)Color.LIGHTGREEN);
        double arrowheadAngle = Math.toRadians(20.0);
        double arrowheadLength = 15.0;
        double arrowheadX1 = tipX + arrowheadLength * Math.cos(rad - arrowheadAngle);
        double arrowheadY1 = tipY + arrowheadLength * Math.sin(rad - arrowheadAngle);
        double arrowheadX2 = tipX + arrowheadLength * Math.cos(rad + arrowheadAngle);
        double arrowheadY2 = tipY + arrowheadLength * Math.sin(rad + arrowheadAngle);
        Polygon arrowhead = new Polygon(new double[]{0.0, 0.0, arrowheadX1, -arrowheadY1, arrowheadX2, -arrowheadY2});
        arrowhead.setFill((Paint)Color.GREEN);
        return new Group(new Node[]{arrowLine, arrowhead});
    }

    private void updateStatusButton(String sourceName, ThreadStateMessage threadStateMessage) {
        Button button = this.statusButtons.computeIfAbsent(sourceName, name -> {
            Button b = new Button(threadStateMessage.getThreadNickName());
            b.getStyleClass().removeIf(cls -> cls.startsWith("btn-showstate"));
            b.getStyleClass().add((Object)"btn-showstate-enabled");
            b.setTooltip(new Tooltip(threadStateMessage.getRunningInformation()));
            this.flwpne_StatusBar.getChildren().add((Object)b);
            return b;
        });
        button.setText(sourceName + ": " + threadStateMessage.getRunningInformationTextDescription());
        button.getTooltip().setText(threadStateMessage.getRunningInformation());
        button.getStyleClass().removeIf(cls -> cls.startsWith("btn-showstate"));
        button.getStyleClass().add((Object)"btn-showstate-enabled-furtherInfo");
        PauseTransition pause = new PauseTransition(Duration.seconds((double)0.2));
        pause.setOnFinished(e -> {
            button.getStyleClass().removeIf(cls -> cls.startsWith("btn-showstate"));
            button.getStyleClass().add((Object)"btn-showstate-enabled-default");
        });
        pause.play();
    }

    private BorderPane generateFurtherInfoAbtSelectedCallsignBP(final ChatMember selectedCallSignInfoStageChatMember) {
        this.selectedCallSignInfoBorderPane = new BorderPane();
        final SplitPane selectedCallSignSplitPane = new SplitPane();
        selectedCallSignSplitPane.setOrientation(Orientation.VERTICAL);
        selectedCallSignSplitPane.setDividerPositions(this.chatcontroller.getChatPreferences().getGUIselectedCallSignSplitPane_dividerposition());
        TableView<ChatMessage> initFurtherInfoAbtCallsignMSGTable = this.initFurtherInfoAbtCallsignMSGTable();
        Label selectedCallSignInfoLblQTFInfo = new Label("QTF:" + selectedCallSignInfoStageChatMember.getQTFdirection() + " deg");
        Label selectedCallSignInfoLblQRBInfo = new Label("QRB: " + selectedCallSignInfoStageChatMember.getQrb() + " km");
        GridPane selectedCallSignDownerSiteGridPane = new GridPane();
        selectedCallSignDownerSiteGridPane.setHgap(10.0);
        selectedCallSignDownerSiteGridPane.setVgap(2.0);
        selectedCallSignDownerSiteGridPane.add((Node)selectedCallSignInfoLblQTFInfo, 0, 0, 1, 1);
        selectedCallSignDownerSiteGridPane.add((Node)selectedCallSignInfoLblQRBInfo, 0, 1, 1, 1);
        selectedCallSignDownerSiteGridPane.add((Node)new Label("Last activity: " + new Utils4KST().time_convertEpochToReadable("" + selectedCallSignInfoStageChatMember.getActivityTimeLastInEpoch())), 0, 2, 1, 1);
        selectedCallSignDownerSiteGridPane.add((Node)new Label("(" + Utils4KST.time_getSecondsBetweenEpochAndNow("" + selectedCallSignInfoStageChatMember.getActivityTimeLastInEpoch()) / 60L % 60L + " min ago)"), 0, 3, 1, 1);
        Label selectedCallSignChatCategoryLabelDesc = new Label(selectedCallSignInfoStageChatMember.getCallSign() + " in chatcategory: " + selectedCallSignInfoStageChatMember.getChatCategory().getChatCategoryName(selectedCallSignInfoStageChatMember.getChatCategory().getCategoryNumber()));
        selectedCallSignChatCategoryLabelDesc.getStyleClass().clear();
        selectedCallSignChatCategoryLabelDesc.getStyleClass().add((Object)"label");
        selectedCallSignChatCategoryLabelDesc.getStyleClass().add((Object)"label-callSignChatCatDescriptor");
        selectedCallSignChatCategoryLabelDesc.setAlignment(Pos.CENTER);
        selectedCallSignDownerSiteGridPane.add((Node)selectedCallSignChatCategoryLabelDesc, 1, 4, 1, 3);
        CheckBox furtherInfoPnl_chkbx_notQRV144 = new CheckBox("tag not qrv 144");
        furtherInfoPnl_chkbx_notQRV144.setSelected(!selectedCallSignInfoStageChatMember.isQrv144());
        furtherInfoPnl_chkbx_notQRV144.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    selectedCallSignInfoStageChatMember.setQrv144(true);
                } else {
                    selectedCallSignInfoStageChatMember.setQrv144(false);
                }
                try {
                    Kst4ContestApplication.this.chatcontroller.getDbHandler().updateNotQRVInfoOnChatMember(selectedCallSignInfoStageChatMember);
                    GuiUtils.triggerGUIFilteredChatMemberListChange(Kst4ContestApplication.this.chatcontroller);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        CheckBox furtherInfoPnl_chkbx_notQRV432 = new CheckBox("tag not qrv 432");
        furtherInfoPnl_chkbx_notQRV432.setSelected(!selectedCallSignInfoStageChatMember.isQrv432());
        furtherInfoPnl_chkbx_notQRV432.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    selectedCallSignInfoStageChatMember.setQrv432(true);
                } else {
                    selectedCallSignInfoStageChatMember.setQrv432(false);
                }
                try {
                    Kst4ContestApplication.this.chatcontroller.getDbHandler().updateNotQRVInfoOnChatMember(selectedCallSignInfoStageChatMember);
                    GuiUtils.triggerGUIFilteredChatMemberListChange(Kst4ContestApplication.this.chatcontroller);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        CheckBox furtherInfoPnl_chkbx_notQRV23 = new CheckBox("tag not qrv 23cm");
        furtherInfoPnl_chkbx_notQRV23.setSelected(!selectedCallSignInfoStageChatMember.isQrv1240());
        furtherInfoPnl_chkbx_notQRV23.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    selectedCallSignInfoStageChatMember.setQrv1240(true);
                } else {
                    selectedCallSignInfoStageChatMember.setQrv1240(false);
                }
                try {
                    Kst4ContestApplication.this.chatcontroller.getDbHandler().updateNotQRVInfoOnChatMember(selectedCallSignInfoStageChatMember);
                    GuiUtils.triggerGUIFilteredChatMemberListChange(Kst4ContestApplication.this.chatcontroller);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        CheckBox furtherInfoPnl_chkbx_notQRV13 = new CheckBox("tag not qrv 13cm");
        furtherInfoPnl_chkbx_notQRV13.setSelected(!selectedCallSignInfoStageChatMember.isQrv2300());
        furtherInfoPnl_chkbx_notQRV13.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    selectedCallSignInfoStageChatMember.setQrv2300(true);
                } else {
                    selectedCallSignInfoStageChatMember.setQrv2300(false);
                }
                try {
                    Kst4ContestApplication.this.chatcontroller.getDbHandler().updateNotQRVInfoOnChatMember(selectedCallSignInfoStageChatMember);
                    GuiUtils.triggerGUIFilteredChatMemberListChange(Kst4ContestApplication.this.chatcontroller);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        CheckBox furtherInfoPnl_chkbx_notQRV9 = new CheckBox("tag not qrv 9cm");
        furtherInfoPnl_chkbx_notQRV9.setSelected(!selectedCallSignInfoStageChatMember.isQrv3400());
        furtherInfoPnl_chkbx_notQRV9.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    selectedCallSignInfoStageChatMember.setQrv3400(true);
                } else {
                    selectedCallSignInfoStageChatMember.setQrv3400(false);
                }
                try {
                    Kst4ContestApplication.this.chatcontroller.getDbHandler().updateNotQRVInfoOnChatMember(selectedCallSignInfoStageChatMember);
                    GuiUtils.triggerGUIFilteredChatMemberListChange(Kst4ContestApplication.this.chatcontroller);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        CheckBox furtherInfoPnl_chkbx_notQRV6 = new CheckBox("tag not qrv 6cm");
        furtherInfoPnl_chkbx_notQRV6.setSelected(!selectedCallSignInfoStageChatMember.isQrv5600());
        furtherInfoPnl_chkbx_notQRV6.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    selectedCallSignInfoStageChatMember.setQrv5600(true);
                } else {
                    selectedCallSignInfoStageChatMember.setQrv5600(false);
                }
                try {
                    Kst4ContestApplication.this.chatcontroller.getDbHandler().updateNotQRVInfoOnChatMember(selectedCallSignInfoStageChatMember);
                    GuiUtils.triggerGUIFilteredChatMemberListChange(Kst4ContestApplication.this.chatcontroller);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        CheckBox furtherInfoPnl_chkbx_notQRV3 = new CheckBox("tag not qrv 3cm");
        furtherInfoPnl_chkbx_notQRV3.setSelected(!selectedCallSignInfoStageChatMember.isQrv10G());
        furtherInfoPnl_chkbx_notQRV3.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    selectedCallSignInfoStageChatMember.setQrv10G(true);
                } else {
                    selectedCallSignInfoStageChatMember.setQrv10G(false);
                }
                try {
                    Kst4ContestApplication.this.chatcontroller.getDbHandler().updateNotQRVInfoOnChatMember(selectedCallSignInfoStageChatMember);
                    GuiUtils.triggerGUIFilteredChatMemberListChange(Kst4ContestApplication.this.chatcontroller);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        CheckBox furtherInfoPnl_chkbx_notQRVall = new CheckBox("tag not qrv all");
        furtherInfoPnl_chkbx_notQRVall.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    selectedCallSignInfoStageChatMember.setQrv144(true);
                    selectedCallSignInfoStageChatMember.setQrv432(true);
                    selectedCallSignInfoStageChatMember.setQrv1240(true);
                    selectedCallSignInfoStageChatMember.setQrv2300(true);
                    selectedCallSignInfoStageChatMember.setQrv3400(true);
                    selectedCallSignInfoStageChatMember.setQrv5600(true);
                    selectedCallSignInfoStageChatMember.setQrv10G(true);
                } else {
                    selectedCallSignInfoStageChatMember.setQrv144(false);
                    selectedCallSignInfoStageChatMember.setQrv432(false);
                    selectedCallSignInfoStageChatMember.setQrv1240(false);
                    selectedCallSignInfoStageChatMember.setQrv2300(false);
                    selectedCallSignInfoStageChatMember.setQrv3400(false);
                    selectedCallSignInfoStageChatMember.setQrv5600(false);
                    selectedCallSignInfoStageChatMember.setQrv10G(false);
                }
                try {
                    Kst4ContestApplication.this.chatcontroller.getDbHandler().updateNotQRVInfoOnChatMember(selectedCallSignInfoStageChatMember);
                    GuiUtils.triggerGUIFilteredChatMemberListChange(Kst4ContestApplication.this.chatcontroller);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        selectedCallSignDownerSiteGridPane.add((Node)furtherInfoPnl_chkbx_notQRV144, 2, 0, 1, 1);
        selectedCallSignDownerSiteGridPane.add((Node)furtherInfoPnl_chkbx_notQRV432, 2, 1, 1, 1);
        selectedCallSignDownerSiteGridPane.add((Node)furtherInfoPnl_chkbx_notQRV23, 2, 2, 1, 1);
        selectedCallSignDownerSiteGridPane.add((Node)furtherInfoPnl_chkbx_notQRV13, 2, 3, 1, 1);
        selectedCallSignDownerSiteGridPane.add((Node)furtherInfoPnl_chkbx_notQRV9, 3, 0, 1, 1);
        selectedCallSignDownerSiteGridPane.add((Node)furtherInfoPnl_chkbx_notQRV6, 3, 1, 1, 1);
        selectedCallSignDownerSiteGridPane.add((Node)furtherInfoPnl_chkbx_notQRV3, 3, 2, 1, 1);
        selectedCallSignDownerSiteGridPane.add((Node)furtherInfoPnl_chkbx_notQRVall, 3, 3, 1, 1);
        if (!this.chatcontroller.getChatPreferences().isStn_bandActive144()) {
            furtherInfoPnl_chkbx_notQRV144.setVisible(false);
        }
        if (!this.chatcontroller.getChatPreferences().isStn_bandActive432()) {
            furtherInfoPnl_chkbx_notQRV432.setVisible(false);
        }
        if (!this.chatcontroller.getChatPreferences().isStn_bandActive1240()) {
            furtherInfoPnl_chkbx_notQRV23.setVisible(false);
        }
        if (!this.chatcontroller.getChatPreferences().isStn_bandActive2300()) {
            furtherInfoPnl_chkbx_notQRV13.setVisible(false);
        }
        if (!this.chatcontroller.getChatPreferences().isStn_bandActive3400()) {
            furtherInfoPnl_chkbx_notQRV9.setVisible(false);
        }
        if (!this.chatcontroller.getChatPreferences().isStn_bandActive5600()) {
            furtherInfoPnl_chkbx_notQRV6.setVisible(false);
        }
        if (!this.chatcontroller.getChatPreferences().isStn_bandActive10G()) {
            furtherInfoPnl_chkbx_notQRV3.setVisible(false);
        }
        Button selectedCallSignShowAsPathBtn = new Button("Show path in AS");
        selectedCallSignShowAsPathBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                Kst4ContestApplication.this.chatcontroller.airScout_SendAsShowPathPacket(selectedCallSignInfoStageChatMember);
            }
        });
        selectedCallSignShowAsPathBtn.setGraphic(Kst4ContestApplication.createArrow(selectedCallSignInfoStageChatMember.getQTFdirection()));
        Button selectedCallSignTurnAntBtn = new Button("Turn ant1 to " + selectedCallSignInfoStageChatMember.getCallSignRaw());
        selectedCallSignTurnAntBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                Kst4ContestApplication.this.chatcontroller.rotateTo(selectedCallSignInfoStageChatMember.getQTFdirection());
            }
        });
        selectedCallSignTurnAntBtn.setGraphic(Kst4ContestApplication.createArrow(selectedCallSignInfoStageChatMember.getQTFdirection()));
        Button selectedCallSignShowQRZprofile = new Button("Lookup on qrz.com");
        selectedCallSignShowQRZprofile.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                Kst4ContestApplication.this.getHostServices().showDocument("https://www.qrz.com/db/" + selectedCallSignInfoStageChatMember.getCallSign());
            }
        });
        Button selectedCallSignShowQRZCqprofile = new Button("Lookup on qrzcq.com");
        selectedCallSignShowQRZCqprofile.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                Kst4ContestApplication.this.getHostServices().showDocument("https://www.qrzcq.com/call/" + selectedCallSignInfoStageChatMember.getCallSign());
            }
        });
        selectedCallSignDownerSiteGridPane.add((Node)selectedCallSignShowAsPathBtn, 1, 0, 1, 1);
        selectedCallSignDownerSiteGridPane.add((Node)selectedCallSignTurnAntBtn, 1, 1, 1, 1);
        selectedCallSignDownerSiteGridPane.add((Node)selectedCallSignShowQRZprofile, 1, 2, 1, 1);
        selectedCallSignDownerSiteGridPane.add((Node)selectedCallSignShowQRZCqprofile, 1, 3, 1, 1);
        selectedCallSignSplitPane.getItems().add(initFurtherInfoAbtCallsignMSGTable);
        selectedCallSignSplitPane.getItems().add((Object)selectedCallSignDownerSiteGridPane);
        for (final SplitPane.Divider divider : selectedCallSignSplitPane.getDividers()) {
            divider.positionProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observableValue, Number oldDividerPos, Number newDividerPosition) {
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().getGUIselectedCallSignSplitPane_dividerposition()[selectedCallSignSplitPane.getDividers().indexOf((Object)divider)] = newDividerPosition.doubleValue();
                }
            });
        }
        this.selectedCallSignInfoBorderPane.setCenter((Node)selectedCallSignSplitPane);
        HBox selectedCallSignInfoBottomControlsBox = new HBox();
        selectedCallSignInfoBottomControlsBox.setSpacing(10.0);
        final ToggleGroup selectedCallSignInfoFilterMessagesRadioGrp = new ToggleGroup();
        final RadioButton selectedCallSignFilterToMeMsgRB = new RadioButton("pm to me ");
        selectedCallSignFilterToMeMsgRB.setToggleGroup(selectedCallSignInfoFilterMessagesRadioGrp);
        final RadioButton selectedCallSignFilterMsgToOtherRB = new RadioButton("pm to other");
        selectedCallSignFilterMsgToOtherRB.setToggleGroup(selectedCallSignInfoFilterMessagesRadioGrp);
        final RadioButton selectedCallSignFilterMsgpublic = new RadioButton("public msgs");
        selectedCallSignFilterMsgpublic.setToggleGroup(selectedCallSignInfoFilterMessagesRadioGrp);
        RadioButton selectedCallSignNoFilterRB = new RadioButton("nothing");
        selectedCallSignNoFilterRB.setToggleGroup(selectedCallSignInfoFilterMessagesRadioGrp);
        selectedCallSignInfoFilterMessagesRadioGrp.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> observableValue, Toggle toggle, Toggle t1) {
                RadioButton radioButton = (RadioButton)selectedCallSignInfoFilterMessagesRadioGrp.getSelectedToggle();
                if (radioButton.equals(selectedCallSignFilterToMeMsgRB)) {
                    Kst4ContestApplication.this.chatcontroller.getLst_selectedCallSignInfofilteredMessageList().setPredicate((Predicate)new Predicate<ChatMessage>(){

                        @Override
                        public boolean test(ChatMessage chatMessage) {
                            try {
                                return !(!chatMessage.getReceiver().getCallSign().equals(Kst4ContestApplication.this.chatcontroller.getChatPreferences().getStn_loginCallSign()) && !chatMessage.getSender().getCallSign().equals(Kst4ContestApplication.this.chatcontroller.getChatPreferences().getStn_loginCallSign()) || !chatMessage.getReceiver().getCallSign().equals(selectedCallSignInfoStageChatMember.getCallSign()) && !chatMessage.getSender().getCallSign().equals(selectedCallSignInfoStageChatMember.getCallSign()));
                            }
                            catch (Exception exception) {
                                System.out.println("KST4ContestApp <<<catched error>>> " + exception.getMessage());
                                return true;
                            }
                        }
                    });
                } else if (radioButton.equals(selectedCallSignFilterMsgToOtherRB)) {
                    Kst4ContestApplication.this.chatcontroller.getLst_selectedCallSignInfofilteredMessageList().setPredicate((Predicate)new Predicate<ChatMessage>(){

                        @Override
                        public boolean test(ChatMessage chatMessage) {
                            try {
                                if (chatMessage.getSender().getCallSign().equals(selectedCallSignInfoStageChatMember.getCallSign()) && !chatMessage.getReceiver().getCallSign().equals("ALL") && !chatMessage.getReceiver().getCallSign().equals(Kst4ContestApplication.this.chatcontroller.getChatPreferences().getStn_loginCallSign())) {
                                    return true;
                                }
                                return chatMessage.getReceiver().getCallSign().equals(selectedCallSignInfoStageChatMember.getCallSign()) && !chatMessage.getReceiver().getCallSign().equals("ALL") && !chatMessage.getReceiver().getCallSign().equals(Kst4ContestApplication.this.chatcontroller.getChatPreferences().getStn_loginCallSign());
                            }
                            catch (NullPointerException SenderNull) {
                                System.out.println("KST4ContestApp, <<<catched error>>>: Sender/receiver of the message is unknown, categorizing is impossible: " + SenderNull.getMessage());
                                return false;
                            }
                        }
                    });
                    System.out.println(t1 + " filter to other was selected <<<<<<<<<<<<<<<<<<<");
                } else if (radioButton.equals(selectedCallSignFilterMsgpublic)) {
                    Kst4ContestApplication.this.chatcontroller.getLst_selectedCallSignInfofilteredMessageList().setPredicate((Predicate)new Predicate<ChatMessage>(){

                        @Override
                        public boolean test(ChatMessage chatMessage) {
                            try {
                                return chatMessage.getSender().getCallSign().equals(selectedCallSignInfoStageChatMember.getCallSign()) && chatMessage.getReceiver().getCallSign().equals("ALL");
                            }
                            catch (NullPointerException SenderNull) {
                                System.out.println("KST4ContestApp, <<<catched error>>>: Sender of the message is unknown, categorizing is impossible");
                                return false;
                            }
                        }
                    });
                    System.out.println(t1 + " filter to public was selected <<<<<<<<<<<<<<<<<<<");
                } else {
                    System.out.println(t1 + " no filter was selected <<<<<<<<<<<<<<<<<<<");
                    Kst4ContestApplication.this.chatcontroller.getLst_selectedCallSignInfofilteredMessageList().setPredicate((Predicate)new Predicate<ChatMessage>(){

                        @Override
                        public boolean test(ChatMessage chatMessage) {
                            try {
                                return chatMessage.getSender().getCallSign().equals(selectedCallSignInfoStageChatMember.getCallSign()) || chatMessage.getReceiver().getCallSign().equals(selectedCallSignInfoStageChatMember.getCallSign());
                            }
                            catch (NullPointerException SenderNull) {
                                System.out.println("KST4ContestApp, <<<catched error>>>: Sender/receiver of the message is unknown, categorizing is impossible");
                                return false;
                            }
                        }
                    });
                }
            }
        });
        selectedCallSignInfoBottomControlsBox.getChildren().add((Object)new Label("Messages of " + selectedCallSignInfoStageChatMember.getCallSign() + " -> Filter:  "));
        selectedCallSignInfoBottomControlsBox.getChildren().add((Object)selectedCallSignNoFilterRB);
        selectedCallSignInfoBottomControlsBox.getChildren().add((Object)selectedCallSignFilterToMeMsgRB);
        selectedCallSignInfoBottomControlsBox.getChildren().add((Object)selectedCallSignFilterMsgToOtherRB);
        selectedCallSignInfoBottomControlsBox.getChildren().add((Object)selectedCallSignFilterMsgpublic);
        this.selectedCallSignInfoBorderPane.setTop((Node)selectedCallSignInfoBottomControlsBox);
        this.chatcontroller.getLst_selectedCallSignInfofilteredMessageList().setPredicate((Predicate)new Predicate<ChatMessage>(){

            @Override
            public boolean test(ChatMessage chatMessage) {
                try {
                    return chatMessage.getSender().getCallSign().equals(selectedCallSignInfoStageChatMember.getCallSign()) || chatMessage.getReceiver().getCallSign().equals(selectedCallSignInfoStageChatMember.getCallSign());
                }
                catch (Exception exception) {
                    System.out.println("KST4ContestApplication <<<catched ERROR>>>>: cant get sender infos due to sender is not known yet" + exception.getMessage());
                    return false;
                }
            }
        });
        selectedCallSignNoFilterRB.setSelected(this.chatcontroller.getChatPreferences().isGuiOptions_defaultFilterNothing());
        selectedCallSignFilterMsgpublic.setSelected(this.chatcontroller.getChatPreferences().isGuiOptions_defaultFilterPublicMsgs());
        selectedCallSignFilterToMeMsgRB.setSelected(this.chatcontroller.getChatPreferences().isGuiOptions_defaultFilterPmToMe());
        selectedCallSignFilterMsgToOtherRB.setSelected(this.chatcontroller.getChatPreferences().isGuiOptions_defaultFilterPmToOther());
        return this.selectedCallSignInfoBorderPane;
    }

    private TableView<ChatMember> initChatMemberTable() {
        final TableView tbl_chatMemberTable = new TableView();
        tbl_chatMemberTable.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ENTER) {
                    event.consume();
                    Kst4ContestApplication.this.sendButton.fire();
                }
            }
        });
        tbl_chatMemberTable.setTooltip(new Tooltip("Stations available \n\nUse right click to a station to select predefined texts\nor hit <strg> + <1> ... <9> to write textsnippet to selected station\n\nHit <enter> to send"));
        TableColumn callSignCol = new TableColumn("Callsign");
        callSignCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty callsgn = new SimpleStringProperty();
                if (((ChatMember)cellDataFeatures.getValue()).getState() == 1) {
                    callsgn.setValue("(" + ((ChatMember)cellDataFeatures.getValue()).getCallSign() + ")");
                } else {
                    callsgn.setValue(((ChatMember)cellDataFeatures.getValue()).getCallSign());
                }
                return callsgn;
            }
        });
        callSignCol.setCellFactory((Callback)new Callback<TableColumn<ChatMember, String>, TableCell<ChatMember, String>>(){

            public TableCell call(final TableColumn param) {
                return new TableCell<ChatMember, String>(){

                    public void updateItem(String item, boolean empty) {
                        int currentIndex;
                        super.updateItem((Object)item, empty);
                        int n = currentIndex = this.indexProperty().getValue() < 0 ? 0 : this.indexProperty().getValue();
                        if (item != null) {
                            ChatMember chatMember = (ChatMember)param.getTableView().getItems().get(currentIndex);
                            if (chatMember.getState() == 3) {
                                this.setStyle("-fx-font-weight: bold");
                            } else if (chatMember.getState() == 0) {
                                this.setStyle("-fx-font-weight: normal");
                            } else if (chatMember.getState() == 2) {
                                this.setStyle("-fx-font-weight: bold");
                            } else if (chatMember.getState() == 1) {
                                this.setStyle("-fx-font-weight: normal");
                            }
                            if (chatMember.isInAngleAndRange()) {
                                this.setTextFill((Paint)Color.LIGHTGREEN);
                                this.setStyle("-fx-font-weight: bold");
                            }
                        }
                        this.setText(item);
                    }
                };
            }
        });
        callSignCol.setSortType(TableColumn.SortType.ASCENDING);
        tbl_chatMemberTable.getSortOrder().add((Object)callSignCol);
        TableColumn nameCol = new TableColumn("Name");
        nameCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty name = new SimpleStringProperty();
                name.setValue(((ChatMember)cellDataFeatures.getValue()).getName());
                return name;
            }
        });
        TableColumn qraCol = new TableColumn("QRA");
        qraCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty qra = new SimpleStringProperty();
                qra.setValue(((ChatMember)cellDataFeatures.getValue()).getQra());
                return qra;
            }
        });
        TableColumn qrBCol = new TableColumn("QRB");
        qrBCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty qrb = new SimpleStringProperty();
                qrb.setValue("" + ((ChatMember)cellDataFeatures.getValue()).getQrb());
                if (qrb.getValue().contains(".")) {
                    qrb.setValue(qrb.getValue().substring(0, qrb.getValue().indexOf(".")));
                }
                return qrb;
            }
        });
        qrBCol.setComparator((Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int distance1 = Integer.parseInt(o1);
                int distance2 = Integer.parseInt(o2);
                return Integer.compare(distance1, distance2);
            }
        });
        TableColumn qtfCol = new TableColumn("QTF");
        qtfCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty qra = new SimpleStringProperty();
                qra.setValue(((ChatMember)cellDataFeatures.getValue()).getQTFdirection() + "\u00b0");
                return qra;
            }
        });
        qtfCol.setComparator((Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                double doubleDegreesObj2;
                double doubleDegreesObj1 = Double.parseDouble(o1.split("\u00b0")[0]);
                if (doubleDegreesObj1 < (doubleDegreesObj2 = Double.parseDouble(o2.split("\u00b0")[0]))) {
                    return -1;
                }
                if (doubleDegreesObj1 == doubleDegreesObj2) {
                    return 0;
                }
                if (doubleDegreesObj1 > doubleDegreesObj2) {
                    return 1;
                }
                return 0;
            }
        });
        qtfCol.prefWidthProperty().bind((ObservableValue)tbl_chatMemberTable.widthProperty().divide(15));
        TableColumn qrgCol = new TableColumn("QRG");
        qrgCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                return ((ChatMember)cellDataFeatures.getValue()).getFrequency();
            }
        });
        TableColumn airScoutCol = new TableColumn("AP [minutes / pot%]");
        airScoutCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty airPlaneInfo = new SimpleStringProperty();
                if (((ChatMember)cellDataFeatures.getValue()).getAirPlaneReflectInfo().getRisingAirplanes() == null) {
                    airPlaneInfo.setValue("nil");
                } else if (((ChatMember)cellDataFeatures.getValue()).getAirPlaneReflectInfo().getRisingAirplanes().size() <= 0) {
                    airPlaneInfo.setValue("nil");
                } else {
                    String apInfoText = ((AirPlane)((ChatMember)cellDataFeatures.getValue()).getAirPlaneReflectInfo().getRisingAirplanes().get(0)).getArrivingDurationMinutes() + " (" + ((AirPlane)((ChatMember)cellDataFeatures.getValue()).getAirPlaneReflectInfo().getRisingAirplanes().get(0)).getPotential() + "%)";
                    if (((ChatMember)cellDataFeatures.getValue()).getAirPlaneReflectInfo().getRisingAirplanes().size() > 1) {
                        apInfoText = apInfoText + " / " + ((AirPlane)((ChatMember)cellDataFeatures.getValue()).getAirPlaneReflectInfo().getRisingAirplanes().get(1)).getArrivingDurationMinutes() + " (" + ((AirPlane)((ChatMember)cellDataFeatures.getValue()).getAirPlaneReflectInfo().getRisingAirplanes().get(1)).getPotential() + "%)";
                    }
                    airPlaneInfo.setValue(apInfoText);
                }
                return airPlaneInfo;
            }
        });
        airScoutCol.setCellFactory((Callback)new Callback<TableColumn<ChatMember, String>, TableCell<ChatMember, String>>(){

            public TableCell call(TableColumn param) {
                return new TableCell<ChatMember, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty()) {
                            if (item.contains("nil")) {
                                this.getStyleClass().clear();
                                this.getStyleClass().add((Object)"table-cell");
                            }
                            if (item.contains("100%")) {
                                this.getStyleClass().add((Object)"table-cell-100PercentAP");
                            } else if (item.contains("75%") && !item.contains("100%")) {
                                this.getStyleClass().add((Object)"table-cell-75PercentAP");
                            } else if (!(!item.contains("50%") || item.contains("100%") && item.contains("75%"))) {
                                this.getStyleClass().add((Object)"table-cell-50PercentAP");
                            }
                            this.setText(item);
                        }
                    }
                };
            }
        });
        TableColumn lastActCol = new TableColumn("Act");
        lastActCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty lastActEpoch = new SimpleStringProperty();
                lastActEpoch.setValue("" + Utils4KST.time_getSecondsBetweenEpochAndNow("" + ((ChatMember)cellDataFeatures.getValue()).getActivityTimeLastInEpoch()) / 60L % 60L);
                return lastActEpoch;
            }
        });
        lastActCol.prefWidthProperty().bind((ObservableValue)tbl_chatMemberTable.widthProperty().divide(32));
        TableColumn workedCol = new TableColumn("worked");
        workedCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                if (((ChatMember)cellDataFeatures.getValue()).isWorked()) {
                    wkd.setValue("X");
                } else {
                    wkd.setValue("");
                }
                return wkd;
            }
        });
        TableColumn wkdAny_subcol = new TableColumn("wkdany");
        wkdAny_subcol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                if (((ChatMember)cellDataFeatures.getValue()).isWorked()) {
                    wkd.setValue("X");
                } else {
                    wkd.setValue("");
                }
                return wkd;
            }
        });
        wkdAny_subcol.prefWidthProperty().bind((ObservableValue)tbl_chatMemberTable.widthProperty().divide(14));
        TableColumn vhfCol_subcol = new TableColumn("144");
        vhfCol_subcol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                if (((ChatMember)cellDataFeatures.getValue()).isWorked144()) {
                    wkd.setValue("X");
                } else {
                    wkd.setValue("");
                }
                return wkd;
            }
        });
        vhfCol_subcol.prefWidthProperty().bind((ObservableValue)tbl_chatMemberTable.widthProperty().divide(28));
        TableColumn uhfCol_subcol = new TableColumn("432");
        uhfCol_subcol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                if (((ChatMember)cellDataFeatures.getValue()).isWorked432()) {
                    wkd.setValue("X");
                } else {
                    wkd.setValue("");
                }
                return wkd;
            }
        });
        uhfCol_subcol.prefWidthProperty().bind((ObservableValue)tbl_chatMemberTable.widthProperty().divide(28));
        TableColumn shf23_subcol = new TableColumn("23");
        shf23_subcol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                if (((ChatMember)cellDataFeatures.getValue()).isWorked1240()) {
                    wkd.setValue("X");
                } else {
                    wkd.setValue("");
                }
                return wkd;
            }
        });
        shf23_subcol.prefWidthProperty().bind((ObservableValue)tbl_chatMemberTable.widthProperty().divide(30));
        TableColumn shf13_subcol = new TableColumn("13");
        shf13_subcol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                if (((ChatMember)cellDataFeatures.getValue()).isWorked2300()) {
                    wkd.setValue("X");
                } else {
                    wkd.setValue("");
                }
                return wkd;
            }
        });
        shf13_subcol.prefWidthProperty().bind((ObservableValue)tbl_chatMemberTable.widthProperty().divide(30));
        TableColumn shf9_subcol = new TableColumn("9");
        shf9_subcol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                if (((ChatMember)cellDataFeatures.getValue()).isWorked3400()) {
                    wkd.setValue("X");
                } else {
                    wkd.setValue("");
                }
                return wkd;
            }
        });
        shf9_subcol.prefWidthProperty().bind((ObservableValue)tbl_chatMemberTable.widthProperty().divide(32));
        TableColumn shf6_subcol = new TableColumn("6");
        shf6_subcol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                if (((ChatMember)cellDataFeatures.getValue()).isWorked5600()) {
                    wkd.setValue("X");
                } else {
                    wkd.setValue("");
                }
                return wkd;
            }
        });
        shf6_subcol.prefWidthProperty().bind((ObservableValue)tbl_chatMemberTable.widthProperty().divide(32));
        TableColumn shf3_subcol = new TableColumn("3");
        shf3_subcol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                if (((ChatMember)cellDataFeatures.getValue()).isWorked10G()) {
                    wkd.setValue("X");
                } else {
                    wkd.setValue("");
                }
                return wkd;
            }
        });
        shf3_subcol.prefWidthProperty().bind((ObservableValue)tbl_chatMemberTable.widthProperty().divide(32));
        TableColumn notQRVCol = new TableColumn("NOT QRV @");
        notQRVCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                wkd.setValue("");
                if (!((ChatMember)cellDataFeatures.getValue()).isQrv144()) {
                    wkd.setValue(wkd.getValue() + "144 ");
                } else {
                    wkd.setValue(wkd.getValue().replace("144 ", ""));
                }
                if (!((ChatMember)cellDataFeatures.getValue()).isQrv432()) {
                    wkd.setValue(wkd.getValue() + "70 ");
                } else {
                    wkd.setValue(wkd.getValue().replace("70 ", ""));
                }
                if (!((ChatMember)cellDataFeatures.getValue()).isQrv1240()) {
                    wkd.setValue(wkd.getValue() + "SHF23 ");
                } else {
                    wkd.setValue(wkd.getValue().replace("SHFcm ", ""));
                }
                if (!((ChatMember)cellDataFeatures.getValue()).isQrv2300()) {
                    wkd.setValue(wkd.getValue() + "SHF13 ");
                } else {
                    wkd.setValue(wkd.getValue().replace("SHF13 ", ""));
                }
                if (!((ChatMember)cellDataFeatures.getValue()).isQrv3400()) {
                    wkd.setValue(wkd.getValue() + "SHF9 ");
                } else {
                    wkd.setValue(wkd.getValue().replace("SHF9 ", ""));
                }
                if (!((ChatMember)cellDataFeatures.getValue()).isQrv5600()) {
                    wkd.setValue(wkd.getValue() + "SHF6 ");
                } else {
                    wkd.setValue(wkd.getValue().replace("SHF6 ", ""));
                }
                if (!((ChatMember)cellDataFeatures.getValue()).isQrv10G()) {
                    wkd.setValue(wkd.getValue() + "SHF3 ");
                } else {
                    wkd.setValue(wkd.getValue().replace("SHF3 ", ""));
                }
                return wkd;
            }
        });
        TableColumn chatCategoryCol = new TableColumn("Category");
        chatCategoryCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty category = new SimpleStringProperty();
                category.setValue(((ChatMember)cellDataFeatures.getValue()).getChatCategory().getChatCategoryName(((ChatMember)cellDataFeatures.getValue()).getChatCategory().getCategoryNumber()));
                return category;
            }
        });
        if (this.chatcontroller.getChatPreferences().isStn_bandActive144()) {
            workedCol.getColumns().add((Object)vhfCol_subcol);
        }
        if (this.chatcontroller.getChatPreferences().isStn_bandActive432()) {
            workedCol.getColumns().add((Object)uhfCol_subcol);
        }
        if (this.chatcontroller.getChatPreferences().isStn_bandActive1240()) {
            workedCol.getColumns().add((Object)shf23_subcol);
        }
        if (this.chatcontroller.getChatPreferences().isStn_bandActive2300()) {
            workedCol.getColumns().add((Object)shf13_subcol);
        }
        if (this.chatcontroller.getChatPreferences().isStn_bandActive3400()) {
            workedCol.getColumns().add((Object)shf9_subcol);
        }
        if (this.chatcontroller.getChatPreferences().isStn_bandActive5600()) {
            workedCol.getColumns().add((Object)shf6_subcol);
        }
        if (this.chatcontroller.getChatPreferences().isStn_bandActive10G()) {
            workedCol.getColumns().add((Object)shf3_subcol);
        }
        workedCol.getColumns().add((Object)wkdAny_subcol);
        tbl_chatMemberTable.getColumns().addAll((Object[])new TableColumn[]{callSignCol, nameCol, qraCol, qrBCol, qtfCol, qrgCol, lastActCol, airScoutCol, workedCol, notQRVCol, chatCategoryCol});
        tbl_chatMemberTable.setItems(this.chatcontroller.getLst_chatMemberSortedFilteredList());
        this.chatcontroller.getLst_chatMemberSortedFilteredList().comparatorProperty().bind((ObservableValue)tbl_chatMemberTable.comparatorProperty());
        tbl_chatMemberTable.getSortOrder().add((Object)callSignCol);
        this.timer_chatMemberTableSortTimer = new Timer();
        this.timer_chatMemberTableSortTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Thread.currentThread().setName("chatMemberTableSortTimer");
                Platform.runLater(() -> tbl_chatMemberTable.refresh());
            }
        }, new Date(), 5000L);
        tbl_chatMemberTable.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        tbl_chatMemberTable.autosize();
        return tbl_chatMemberTable;
    }

    private ContextMenu initChatMemberTableContextMenu(ObservableList<String> contextMenuEntries) {
        ContextMenu chatMemberContextMenu = new ContextMenu();
        for (String string : contextMenuEntries) {
            final MenuItem menuItem = new MenuItem(string);
            menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    Kst4ContestApplication.this.txt_chatMessageUserInput.setText(Kst4ContestApplication.this.txt_chatMessageUserInput.getText() + menuItem.getText());
                    Kst4ContestApplication.this.txt_chatMessageUserInput.requestFocus();
                    Kst4ContestApplication.this.txt_chatMessageUserInput.selectEnd();
                }
            });
            chatMemberContextMenu.getItems().add((Object)menuItem);
        }
        return chatMemberContextMenu;
    }

    private TableView<ChatMessage> initFurtherInfoAbtCallsignMSGTable() {
        TableView tbl_furtherInfoAbtCallsignMSGTable = new TableView();
        tbl_furtherInfoAbtCallsignMSGTable.setTooltip(new Tooltip("Messages of selected station are shown here"));
        TableColumn timeCol = new TableColumn("Time");
        timeCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty time = new SimpleStringProperty();
                time.setValue(new Utils4KST().time_convertEpochToReadable(((ChatMessage)cellDataFeatures.getValue()).getMessageGeneratedTime()));
                return time;
            }
        });
        TableColumn callSignTRCVCol = new TableColumn("Call TX");
        callSignTRCVCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty callSign = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getSender() != null) {
                    callSign.setValue(((ChatMessage)cellDataFeatures.getValue()).getSender().getCallSign());
                } else {
                    callSign.setValue("");
                }
                return callSign;
            }
        });
        TableColumn callSignRCVRCol = new TableColumn("Call RX");
        callSignRCVRCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty callTX = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getReceiver().getCallSign() != null) {
                    callTX.setValue(((ChatMessage)cellDataFeatures.getValue()).getReceiver().getCallSign());
                } else {
                    callTX.setValue("");
                }
                return callTX;
            }
        });
        TableColumn qrgTXerCol = new TableColumn("Last QRG TX");
        qrgTXerCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty qrg = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getSender() != null) {
                    qrg = ((ChatMessage)cellDataFeatures.getValue()).getSender().getFrequency();
                } else {
                    qrg.setValue("");
                }
                return qrg;
            }
        });
        TableColumn qrgRXerCol = new TableColumn("Last QRG RX");
        qrgRXerCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty qrg = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getReceiver() != null) {
                    qrg = ((ChatMessage)cellDataFeatures.getValue()).getReceiver().getFrequency();
                } else {
                    qrg.setValue("");
                }
                return qrg;
            }
        });
        TableColumn msgCol = new TableColumn("Message");
        msgCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty msg = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getMessageText() != null) {
                    msg.setValue(((ChatMessage)cellDataFeatures.getValue()).getMessageText());
                } else {
                    msg.setValue("");
                }
                return msg;
            }
        });
        msgCol.prefWidthProperty().bind((ObservableValue)tbl_furtherInfoAbtCallsignMSGTable.widthProperty().divide(2));
        TableColumn workedRXCol = new TableColumn("wkd RX?");
        workedRXCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getReceiver().isWorked()) {
                    wkd.setValue("X");
                } else {
                    wkd.setValue("");
                }
                return wkd;
            }
        });
        TableColumn workedTXCol = new TableColumn("wkd TX?");
        workedRXCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getSender().isWorked()) {
                    wkd.setValue("X");
                } else {
                    wkd.setValue("");
                }
                return wkd;
            }
        });
        tbl_furtherInfoAbtCallsignMSGTable.getColumns().addAll((Object[])new TableColumn[]{timeCol, callSignTRCVCol, callSignRCVRCol, msgCol});
        ObservableList<ChatMessage> toOtherMSGList = this.chatcontroller.getLst_toOtherMessageList();
        tbl_furtherInfoAbtCallsignMSGTable.setItems(this.chatcontroller.getLst_selectedCallSignInfofilteredMessageList());
        return tbl_furtherInfoAbtCallsignMSGTable;
    }

    private TableView initChatGeneralMSGTable() {
        TableView tbl_generalMSGTable = new TableView();
        tbl_generalMSGTable.setTooltip(new Tooltip("General messages are shown here (handle it like CQ messages)"));
        TableColumn timeCol = new TableColumn("Time");
        timeCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty time = new SimpleStringProperty();
                time.setValue(new Utils4KST().time_convertEpochToReadable(((ChatMessage)cellDataFeatures.getValue()).getMessageGeneratedTime()));
                return time;
            }
        });
        TableColumn callSignCol = new TableColumn("Callsign");
        callSignCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty callSign = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getSender() != null) {
                    callSign.setValue(((ChatMessage)cellDataFeatures.getValue()).getSender().getCallSign());
                } else {
                    callSign.setValue("");
                }
                return callSign;
            }
        });
        TableColumn nameCol = new TableColumn("Name");
        nameCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty name = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getSender() != null) {
                    name.setValue(((ChatMessage)cellDataFeatures.getValue()).getSender().getName());
                } else {
                    name.setValue("");
                }
                return name;
            }
        });
        TableColumn qrgCol = new TableColumn("Last QRG");
        qrgCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty qrg = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getSender() != null) {
                    qrg = ((ChatMessage)cellDataFeatures.getValue()).getSender().getFrequency();
                } else {
                    qrg.setValue("");
                }
                return qrg;
            }
        });
        TableColumn msgCol = new TableColumn("Message");
        msgCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty msg = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getMessageText() != null) {
                    msg.setValue(((ChatMessage)cellDataFeatures.getValue()).getMessageText());
                } else {
                    msg.setValue("");
                }
                return msg;
            }
        });
        msgCol.prefWidthProperty().bind((ObservableValue)tbl_generalMSGTable.widthProperty().divide(2));
        msgCol.setCellFactory((Callback)new Callback<TableColumn<ChatMessage, String>, TableCell<ChatMessage, String>>(){

            public TableCell call(TableColumn param) {
                return new TableCell<ChatMessage, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty()) {
                            this.getStyleClass().clear();
                            this.getStyleClass().add((Object)"table-cell");
                            this.getStyleClass().add((Object)"defaultText-column");
                            if (item.toUpperCase().contains(Kst4ContestApplication.this.chatcontroller.getChatPreferences().getStn_loginCallSign().toUpperCase())) {
                                this.getStyleClass().clear();
                                this.getStyleClass().add((Object)"table-cell");
                                this.getStyleClass().add((Object)"messageToMe-column");
                            }
                            this.setText(item);
                        }
                    }
                };
            }
        });
        TableColumn categoryCol = new TableColumn("Category");
        categoryCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty category = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getSender() != null) {
                    category.setValue(((ChatMessage)cellDataFeatures.getValue()).getSender().getChatCategory().getChatCategoryName(((ChatMessage)cellDataFeatures.getValue()).getSender().getChatCategory().getCategoryNumber()));
                } else {
                    category.setValue("UNKNOWN! Report BUG!");
                }
                return category;
            }
        });
        tbl_generalMSGTable.getColumns().addAll((Object[])new TableColumn[]{timeCol, callSignCol, nameCol, msgCol, qrgCol, categoryCol});
        ObservableList<ChatMessage> generalMSGList = this.chatcontroller.getLst_toAllMessageList();
        tbl_generalMSGTable.setItems(generalMSGList);
        tbl_generalMSGTable.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ENTER) {
                    event.consume();
                    Kst4ContestApplication.this.sendButton.fire();
                }
            }
        });
        return tbl_generalMSGTable;
    }

    private TableView<ChatMessage> initChatprivateMSGTable() {
        TableView tbl_privateMSGTable = new TableView();
        tbl_privateMSGTable.setTooltip(new Tooltip("Private messages to you are shown here"));
        TableColumn timeCol = new TableColumn("Time");
        timeCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty time = new SimpleStringProperty();
                time.setValue(new Utils4KST().time_convertEpochToReadable(((ChatMessage)cellDataFeatures.getValue()).getMessageGeneratedTime()));
                return time;
            }
        });
        TableColumn callSignCol = new TableColumn("Callsign");
        callSignCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty callSign = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getSender() != null) {
                    callSign.setValue(((ChatMessage)cellDataFeatures.getValue()).getSender().getCallSign());
                } else {
                    callSign.setValue("");
                }
                return callSign;
            }
        });
        TableColumn nameCol = new TableColumn("Name");
        nameCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty name = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getSender() != null) {
                    name.setValue(((ChatMessage)cellDataFeatures.getValue()).getSender().getName());
                } else {
                    name.setValue("");
                }
                return name;
            }
        });
        TableColumn qraCol = new TableColumn("QRA");
        qraCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty qra = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getSender() != null) {
                    qra.setValue(((ChatMessage)cellDataFeatures.getValue()).getSender().getQra());
                } else {
                    qra.setValue("");
                }
                return qra;
            }
        });
        TableColumn qrgCol = new TableColumn("Last known QRG");
        qrgCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty qrg = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getSender() != null) {
                    qrg = ((ChatMessage)cellDataFeatures.getValue()).getSender().getFrequency();
                } else {
                    qrg.setValue("");
                }
                return qrg;
            }
        });
        TableColumn msgCol = new TableColumn("Message");
        msgCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty msg = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getMessageText() != null) {
                    msg.setValue(((ChatMessage)cellDataFeatures.getValue()).getMessageText());
                } else {
                    msg.setValue("");
                }
                return msg;
            }
        });
        msgCol.prefWidthProperty().bind((ObservableValue)tbl_privateMSGTable.widthProperty().divide(2.5));
        TableColumn airScoutCol = new TableColumn("AP [minutes / pot%]");
        airScoutCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty airPlaneInfo = new SimpleStringProperty();
                try {
                    if (((ChatMessage)cellDataFeatures.getValue()).getSender().getAirPlaneReflectInfo().getRisingAirplanes() == null) {
                        airPlaneInfo.setValue("nil");
                    } else if (((ChatMessage)cellDataFeatures.getValue()).getSender().getAirPlaneReflectInfo().getRisingAirplanes().size() <= 0) {
                        airPlaneInfo.setValue("nil");
                    } else {
                        String apInfoText = ((AirPlane)((ChatMessage)cellDataFeatures.getValue()).getSender().getAirPlaneReflectInfo().getRisingAirplanes().get(0)).getArrivingDurationMinutes() + " (" + ((AirPlane)((ChatMessage)cellDataFeatures.getValue()).getSender().getAirPlaneReflectInfo().getRisingAirplanes().get(0)).getPotential() + "%)";
                        if (((ChatMessage)cellDataFeatures.getValue()).getSender().getAirPlaneReflectInfo().getRisingAirplanes().size() > 1) {
                            apInfoText = apInfoText + " / " + ((AirPlane)((ChatMessage)cellDataFeatures.getValue()).getSender().getAirPlaneReflectInfo().getRisingAirplanes().get(1)).getArrivingDurationMinutes() + " (" + ((AirPlane)((ChatMessage)cellDataFeatures.getValue()).getSender().getAirPlaneReflectInfo().getRisingAirplanes().get(1)).getPotential() + "%)";
                        }
                        airPlaneInfo.setValue(apInfoText);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                return airPlaneInfo;
            }
        });
        airScoutCol.setCellFactory((Callback)new Callback<TableColumn<ChatMessage, String>, TableCell<ChatMessage, String>>(){

            public TableCell call(TableColumn param) {
                return new TableCell<ChatMessage, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty()) {
                            this.setTextFill((Paint)Color.BLACK);
                            try {
                                if (item.contains("100%")) {
                                    this.setTextFill((Paint)Color.BLUEVIOLET);
                                } else if (item.contains("75%") && !item.contains("100%")) {
                                    this.setTextFill((Paint)Color.RED);
                                } else if (!(!item.contains("50%") || item.contains("100%") && item.contains("75%"))) {
                                    this.setTextFill((Paint)Color.ORANGE);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.setText(item);
                        }
                    }
                };
            }
        });
        TableColumn qrbCol = new TableColumn("QRB");
        qrbCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty qrb = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getSender() != null && !((ChatMessage)cellDataFeatures.getValue()).getSender().getCallSign().equals(Kst4ContestApplication.this.chatcontroller.getChatPreferences().getStn_loginCallSign())) {
                    if (!((ChatMessage)cellDataFeatures.getValue()).getSender().getCallSign().equals(Kst4ContestApplication.this.chatcontroller.getChatPreferences().getStn_loginCallSign())) {
                        try {
                            qrb.setValue(((ChatMessage)cellDataFeatures.getValue()).getSender().getQrb().intValue() + " km (" + ((ChatMessage)cellDataFeatures.getValue()).getSender().getQTFdirection().intValue() + ")\u00b0");
                        }
                        catch (Exception nullOrFormatExc) {
                            System.out.println("KST4ContestApp: <<<catched error>>>: qrb was faulty" + nullOrFormatExc.getMessage() + " / " + nullOrFormatExc.getStackTrace());
                        }
                    }
                } else {
                    qrb.setValue("");
                }
                return qrb;
            }
        });
        TableColumn categoryCol = new TableColumn("Category");
        categoryCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty category = new SimpleStringProperty();
                try {
                    category.setValue(((ChatMessage)cellDataFeatures.getValue()).getChatCategory().getChatCategoryName(((ChatMessage)cellDataFeatures.getValue()).getChatCategory().getCategoryNumber()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return category;
            }
        });
        tbl_privateMSGTable.getColumns().addAll((Object[])new TableColumn[]{timeCol, callSignCol, nameCol, qraCol, qrbCol, msgCol, qrgCol, airScoutCol, categoryCol});
        ObservableList<ChatMessage> privateMSGList = this.chatcontroller.getLst_toMeMessageList();
        tbl_privateMSGTable.setItems(privateMSGList);
        tbl_privateMSGTable.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ENTER) {
                    event.consume();
                    Kst4ContestApplication.this.sendButton.fire();
                }
            }
        });
        tbl_privateMSGTable.setRowFactory(tv -> new TableRow<ChatMessage>(){

            protected void updateItem(ChatMessage item, boolean empty) {
                super.updateItem((Object)item, empty);
                try {
                    if (item != null) {
                        if (item.getSender().getCallSign().equals(Kst4ContestApplication.this.chatcontroller.getChatPreferences().getStn_loginCallSign())) {
                            PseudoClass foo = PseudoClass.getPseudoClass((String)"messageHighlightOwn-column");
                            tv.setStyle(null);
                            this.getStyleClass().add((Object)"messageHighlightOwn-column");
                        } else if (new Utils4KST().time_generateCurrentEpochTime() - Long.parseLong(item.getMessageGeneratedTime()) <= 30L) {
                            this.getStyleClass().clear();
                            this.getStyleClass().add((Object)"messageHighlight30-column");
                        } else if (new Utils4KST().time_generateCurrentEpochTime() - Long.parseLong(item.getMessageGeneratedTime()) <= 60L) {
                            this.getStyleClass().clear();
                            this.getStyleClass().add((Object)"messageHighlight60-column");
                        } else if (new Utils4KST().time_generateCurrentEpochTime() - Long.parseLong(item.getMessageGeneratedTime()) <= 90L) {
                            this.getStyleClass().clear();
                            this.getStyleClass().add((Object)"messageHighlight90-column");
                        } else if (new Utils4KST().time_generateCurrentEpochTime() - Long.parseLong(item.getMessageGeneratedTime()) <= 120L) {
                            this.getStyleClass().clear();
                            this.getStyleClass().add((Object)"messageHighlight120-column");
                        } else if (new Utils4KST().time_generateCurrentEpochTime() - Long.parseLong(item.getMessageGeneratedTime()) <= 180L) {
                            this.getStyleClass().clear();
                            this.getStyleClass().add((Object)"messageHighlight180-column");
                        } else if (new Utils4KST().time_generateCurrentEpochTime() - Long.parseLong(item.getMessageGeneratedTime()) <= 300L) {
                            this.getStyleClass().clear();
                            this.getStyleClass().add((Object)"messageHighlight300-column");
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return tbl_privateMSGTable;
    }

    private TableView<ClusterMessage> initDXClusterTable() {
        TableView tbl_DXCTable = new TableView();
        tbl_DXCTable.setTooltip(new Tooltip("Cluster Messages are shown here"));
        TableColumn timeCol = new TableColumn("Time");
        timeCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ClusterMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ClusterMessage, String> cellDataFeatures) {
                SimpleStringProperty time = new SimpleStringProperty();
                time.setValue(new Utils4KST().time_convertEpochToReadable(((ClusterMessage)cellDataFeatures.getValue()).getTimeGenerated()));
                return time;
            }
        });
        TableColumn callSignCol = new TableColumn("Call tx");
        callSignCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ClusterMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ClusterMessage, String> cellDataFeatures) {
                SimpleStringProperty callSign = new SimpleStringProperty();
                if (((ClusterMessage)cellDataFeatures.getValue()).getSender() != null) {
                    callSign.setValue(((ClusterMessage)cellDataFeatures.getValue()).getSender().getCallSign());
                } else {
                    callSign.setValue("");
                }
                return callSign;
            }
        });
        TableColumn locTXCol = new TableColumn("LOC tx");
        locTXCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ClusterMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ClusterMessage, String> cellDataFeatures) {
                SimpleStringProperty locTX = new SimpleStringProperty();
                if (((ClusterMessage)cellDataFeatures.getValue()).getSender() != null) {
                    locTX.setValue(((ClusterMessage)cellDataFeatures.getValue()).getSender().getQra());
                } else {
                    locTX.setValue("");
                }
                return locTX;
            }
        });
        TableColumn callSignRXCol = new TableColumn("Call rx");
        callSignRXCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ClusterMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ClusterMessage, String> cellDataFeatures) {
                SimpleStringProperty callSignRX = new SimpleStringProperty();
                if (((ClusterMessage)cellDataFeatures.getValue()).getReceiver() != null) {
                    callSignRX.setValue(((ClusterMessage)cellDataFeatures.getValue()).getReceiver().getCallSign());
                } else {
                    callSignRX.setValue("");
                }
                return callSignRX;
            }
        });
        TableColumn locRXCol = new TableColumn("LOC rx");
        locRXCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ClusterMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ClusterMessage, String> cellDataFeatures) {
                SimpleStringProperty locRX = new SimpleStringProperty();
                if (((ClusterMessage)cellDataFeatures.getValue()).getSender() != null) {
                    locRX.setValue(((ClusterMessage)cellDataFeatures.getValue()).getReceiver().getQra());
                } else {
                    locRX.setValue("");
                }
                return locRX;
            }
        });
        TableColumn qrgCol = new TableColumn("QRG");
        qrgCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ClusterMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ClusterMessage, String> cellDataFeatures) {
                SimpleStringProperty qrg = new SimpleStringProperty();
                if (((ClusterMessage)cellDataFeatures.getValue()).getReceiver() != null) {
                    qrg = ((ClusterMessage)cellDataFeatures.getValue()).getReceiver().getFrequency();
                } else {
                    qrg.setValue("");
                }
                return qrg;
            }
        });
        TableColumn msgCol = new TableColumn("Message");
        msgCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ClusterMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ClusterMessage, String> cellDataFeatures) {
                SimpleStringProperty msg = new SimpleStringProperty();
                if (((ClusterMessage)cellDataFeatures.getValue()).getMessageInhibited() != null) {
                    msg.setValue(((ClusterMessage)cellDataFeatures.getValue()).getMessageInhibited());
                } else {
                    msg.setValue("");
                }
                return msg;
            }
        });
        TableColumn workedCol = new TableColumn("wkd");
        workedCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ClusterMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ClusterMessage, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                wkd.setValue("" + ((ClusterMessage)cellDataFeatures.getValue()).isReceiverWkd());
                if (((ClusterMessage)cellDataFeatures.getValue()).isReceiverWkd()) {
                    wkd.setValue("X");
                } else {
                    wkd.setValue("");
                }
                return wkd;
            }
        });
        tbl_DXCTable.getColumns().addAll((Object[])new TableColumn[]{timeCol, callSignCol, locTXCol, callSignRXCol, locRXCol, qrgCol, msgCol, workedCol});
        ObservableList<ClusterMessage> clusterMSGList = this.chatcontroller.getLst_clusterMemberList();
        tbl_DXCTable.setItems(clusterMSGList);
        return tbl_DXCTable;
    }

    private TableView<ChatMessage> initChatToOtherMSGTable() {
        TableView tbl_toOtherMSGTable = new TableView();
        tbl_toOtherMSGTable.setTooltip(new Tooltip("Messages between other member are shown here"));
        TableColumn timeCol = new TableColumn("Time");
        timeCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty time = new SimpleStringProperty();
                time.setValue(new Utils4KST().time_convertEpochToReadable(((ChatMessage)cellDataFeatures.getValue()).getMessageGeneratedTime()));
                return time;
            }
        });
        TableColumn callSignTRCVCol = new TableColumn("Call TX");
        callSignTRCVCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty callSign = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getSender() != null) {
                    callSign.setValue(((ChatMessage)cellDataFeatures.getValue()).getSender().getCallSign());
                } else {
                    callSign.setValue("");
                }
                return callSign;
            }
        });
        TableColumn callSignRCVRCol = new TableColumn("Call RX");
        callSignRCVRCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty callTX = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getReceiver().getCallSign() != null) {
                    callTX.setValue(((ChatMessage)cellDataFeatures.getValue()).getReceiver().getCallSign());
                } else {
                    callTX.setValue("");
                }
                return callTX;
            }
        });
        TableColumn qrgTXerCol = new TableColumn("Last QRG TX");
        qrgTXerCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty qrg = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getSender() != null) {
                    qrg = ((ChatMessage)cellDataFeatures.getValue()).getSender().getFrequency();
                } else {
                    qrg.setValue("");
                }
                return qrg;
            }
        });
        TableColumn qrgRXerCol = new TableColumn("Last QRG RX");
        qrgRXerCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty qrg = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getReceiver() != null) {
                    qrg = ((ChatMessage)cellDataFeatures.getValue()).getReceiver().getFrequency();
                } else {
                    qrg.setValue("");
                }
                return qrg;
            }
        });
        TableColumn msgCol = new TableColumn("Message");
        msgCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty msg = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getMessageText() != null) {
                    msg.setValue(((ChatMessage)cellDataFeatures.getValue()).getMessageText());
                } else {
                    msg.setValue("");
                }
                return msg;
            }
        });
        msgCol.prefWidthProperty().bind((ObservableValue)tbl_toOtherMSGTable.widthProperty().divide(2));
        TableColumn workedRXCol = new TableColumn("wkd RX?");
        workedRXCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getReceiver().isWorked()) {
                    wkd.setValue("X");
                } else {
                    wkd.setValue("");
                }
                return wkd;
            }
        });
        TableColumn workedTXCol = new TableColumn("wkd TX?");
        workedRXCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getSender().isWorked()) {
                    wkd.setValue("X");
                } else {
                    wkd.setValue("");
                }
                return wkd;
            }
        });
        TableColumn categoryCol = new TableColumn("Category");
        categoryCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMessage, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMessage, String> cellDataFeatures) {
                SimpleStringProperty category = new SimpleStringProperty();
                if (((ChatMessage)cellDataFeatures.getValue()).getSender() != null) {
                    category.setValue(((ChatMessage)cellDataFeatures.getValue()).getSender().getChatCategory().getChatCategoryName(((ChatMessage)cellDataFeatures.getValue()).getSender().getChatCategory().getCategoryNumber()));
                } else {
                    category.setValue("UNKNOWN! Report BUG!");
                }
                return category;
            }
        });
        tbl_toOtherMSGTable.getColumns().addAll((Object[])new TableColumn[]{timeCol, callSignTRCVCol, qrgTXerCol, workedTXCol, callSignRCVRCol, qrgRXerCol, workedRXCol, msgCol, categoryCol});
        ObservableList<ChatMessage> toOtherMSGList = this.chatcontroller.getLst_toOtherMessageList();
        tbl_toOtherMSGTable.setItems(toOtherMSGList);
        return tbl_toOtherMSGTable;
    }

    private TableView<String> initShortcutTable() {
        TableView tbl_txtShorts = new TableView();
        tbl_txtShorts.setTooltip(new Tooltip("Personalize your shortcut-buttons here"));
        TableColumn ShortCol = new TableColumn("Shortcut-Buttontext");
        ShortCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<String, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<String, String> cellDataFeatures) {
                SimpleStringProperty shortCT = new SimpleStringProperty();
                shortCT.setValue((String)cellDataFeatures.getValue());
                return shortCT;
            }
        });
        ShortCol.setCellFactory(TextFieldTableCell.forTableColumn());
        ShortCol.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<String, String>>(){

            public void handle(TableColumn.CellEditEvent<String, String> t) {
                String newValue = (String)t.getNewValue();
                t.getTableView().getItems().set(t.getTablePosition().getRow(), (Object)newValue);
                if (newValue == "") {
                    t.getTableView().getItems().remove(t.getTablePosition().getRow());
                }
                Kst4ContestApplication.this.flwPane_textSnippets.getChildren().clear();
                Kst4ContestApplication.this.flwPane_textSnippets.getChildren().addAll((Object[])Kst4ContestApplication.this.buttonFactory(Kst4ContestApplication.this.chatcontroller.getChatPreferences().getLst_txtShortCutBtnList()));
            }
        });
        tbl_txtShorts.getColumns().addAll((Object[])new TableColumn[]{ShortCol});
        tbl_txtShorts.setEditable(true);
        tbl_txtShorts.setItems(this.chatcontroller.getChatPreferences().getLst_txtShortCutBtnList());
        return tbl_txtShorts;
    }

    private TableView<String> initNotifyAtCallSignTable() {
        TableView tbl_notifyTxtCallSign = new TableView();
        tbl_notifyTxtCallSign.setTooltip(new Tooltip("Add Callsigns which you want to observe. Their Communcation will added to your PM Table"));
        TableColumn callSignCol = new TableColumn("Sniff QSO of Callsign");
        callSignCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<String, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<String, String> cellDataFeatures) {
                SimpleStringProperty callSign = new SimpleStringProperty();
                callSign.setValue((String)cellDataFeatures.getValue());
                return callSign;
            }
        });
        callSignCol.setCellFactory(TextFieldTableCell.forTableColumn());
        callSignCol.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<String, String>>(){

            public void handle(TableColumn.CellEditEvent<String, String> t) {
                String newValue = ((String)t.getNewValue()).toUpperCase();
                t.getTableView().getItems().set(t.getTablePosition().getRow(), (Object)newValue);
                if (newValue == "") {
                    t.getTableView().getItems().remove(t.getTablePosition().getRow());
                } else if (!GuiUtils.isCallSignSyntax(newValue)) {
                    Kst4ContestApplication.alertWindowEvent("Please try again with correct callsign syntax");
                    t.getTableView().getItems().remove(t.getTablePosition().getRow());
                }
            }
        });
        tbl_notifyTxtCallSign.getColumns().addAll((Object[])new TableColumn[]{callSignCol});
        tbl_notifyTxtCallSign.setEditable(true);
        return tbl_notifyTxtCallSign;
    }

    private TableView<String> initTextSnippetsTable() {
        TableView tbl_txtSnips = new TableView();
        tbl_txtSnips.setTooltip(new Tooltip("Personalize your textsnippets here"));
        TableColumn snipCol = new TableColumn("Snippet");
        snipCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<String, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<String, String> cellDataFeatures) {
                SimpleStringProperty snippet = new SimpleStringProperty();
                snippet.setValue((String)cellDataFeatures.getValue());
                return snippet;
            }
        });
        snipCol.setCellFactory(TextFieldTableCell.forTableColumn());
        snipCol.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<String, String>>(){

            public void handle(TableColumn.CellEditEvent<String, String> t) {
                String newValue = (String)t.getNewValue();
                t.getTableView().getItems().set(t.getTablePosition().getRow(), (Object)newValue);
                if (newValue == "") {
                    t.getTableView().getItems().remove(t.getTablePosition().getRow());
                }
                Kst4ContestApplication.this.chatMessageContextMenu = Kst4ContestApplication.this.initChatMemberTableContextMenu(Kst4ContestApplication.this.chatcontroller.getChatPreferences().getLst_txtSnipList());
                Kst4ContestApplication.this.chatMemberContextMenu = Kst4ContestApplication.this.initChatMemberTableContextMenu(Kst4ContestApplication.this.chatcontroller.getChatPreferences().getLst_txtSnipList());
            }
        });
        tbl_txtSnips.getColumns().addAll((Object[])new TableColumn[]{snipCol});
        tbl_txtSnips.setEditable(true);
        tbl_txtSnips.setItems(this.chatcontroller.getChatPreferences().getLst_txtSnipList());
        return tbl_txtSnips;
    }

    private TableView<ChatMember> initWkdStnTable() {
        TableView tbl_chatMemberWkdDBTable = new TableView();
        tbl_chatMemberWkdDBTable.setTooltip(new Tooltip("worked info DB"));
        TableColumn callSignCol = new TableColumn("Callsign");
        callSignCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty callsgn = new SimpleStringProperty();
                callsgn.setValue(((ChatMember)cellDataFeatures.getValue()).getCallSign());
                return callsgn;
            }
        });
        TableColumn workedCol = new TableColumn("worked");
        workedCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                if (((ChatMember)cellDataFeatures.getValue()).isWorked()) {
                    wkd.setValue("X");
                } else {
                    wkd.setValue("");
                }
                return wkd;
            }
        });
        TableColumn wkdAny_subcol = new TableColumn("wkd");
        wkdAny_subcol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                if (((ChatMember)cellDataFeatures.getValue()).isWorked()) {
                    wkd.setValue("X");
                } else {
                    wkd.setValue("");
                }
                return wkd;
            }
        });
        wkdAny_subcol.prefWidthProperty().bind((ObservableValue)tbl_chatMemberWkdDBTable.widthProperty().divide(28));
        TableColumn vhfCol_subcol = new TableColumn("144");
        vhfCol_subcol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                if (((ChatMember)cellDataFeatures.getValue()).isWorked144()) {
                    wkd.setValue("X");
                } else {
                    wkd.setValue("");
                }
                return wkd;
            }
        });
        vhfCol_subcol.prefWidthProperty().bind((ObservableValue)tbl_chatMemberWkdDBTable.widthProperty().divide(28));
        TableColumn uhfCol_subcol = new TableColumn("432");
        uhfCol_subcol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                if (((ChatMember)cellDataFeatures.getValue()).isWorked432()) {
                    wkd.setValue("X");
                } else {
                    wkd.setValue("");
                }
                return wkd;
            }
        });
        uhfCol_subcol.prefWidthProperty().bind((ObservableValue)tbl_chatMemberWkdDBTable.widthProperty().divide(28));
        TableColumn shf23_subcol = new TableColumn("23");
        shf23_subcol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                if (((ChatMember)cellDataFeatures.getValue()).isWorked1240()) {
                    wkd.setValue("X");
                } else {
                    wkd.setValue("");
                }
                return wkd;
            }
        });
        shf23_subcol.prefWidthProperty().bind((ObservableValue)tbl_chatMemberWkdDBTable.widthProperty().divide(30));
        TableColumn shf13_subcol = new TableColumn("13");
        shf13_subcol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                if (((ChatMember)cellDataFeatures.getValue()).isWorked2300()) {
                    wkd.setValue("X");
                } else {
                    wkd.setValue("");
                }
                return wkd;
            }
        });
        shf13_subcol.prefWidthProperty().bind((ObservableValue)tbl_chatMemberWkdDBTable.widthProperty().divide(30));
        TableColumn shf9_subcol = new TableColumn("9");
        shf9_subcol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                if (((ChatMember)cellDataFeatures.getValue()).isWorked3400()) {
                    wkd.setValue("X");
                } else {
                    wkd.setValue("");
                }
                return wkd;
            }
        });
        shf9_subcol.prefWidthProperty().bind((ObservableValue)tbl_chatMemberWkdDBTable.widthProperty().divide(32));
        TableColumn shf6_subcol = new TableColumn("6");
        shf6_subcol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                if (((ChatMember)cellDataFeatures.getValue()).isWorked5600()) {
                    wkd.setValue("X");
                } else {
                    wkd.setValue("");
                }
                return wkd;
            }
        });
        shf6_subcol.prefWidthProperty().bind((ObservableValue)tbl_chatMemberWkdDBTable.widthProperty().divide(32));
        TableColumn shf3_subcol = new TableColumn("3");
        shf3_subcol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ChatMember, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ChatMember, String> cellDataFeatures) {
                SimpleStringProperty wkd = new SimpleStringProperty();
                if (((ChatMember)cellDataFeatures.getValue()).isWorked10G()) {
                    wkd.setValue("X");
                } else {
                    wkd.setValue("");
                }
                return wkd;
            }
        });
        shf3_subcol.prefWidthProperty().bind((ObservableValue)tbl_chatMemberWkdDBTable.widthProperty().divide(32));
        workedCol.getColumns().addAll((Object[])new TableColumn[]{wkdAny_subcol, vhfCol_subcol, uhfCol_subcol, shf23_subcol, shf13_subcol, shf9_subcol, shf6_subcol, shf3_subcol});
        tbl_chatMemberWkdDBTable.getColumns().addAll((Object[])new TableColumn[]{callSignCol, workedCol});
        tbl_chatMemberWkdDBTable.setItems(this.chatcontroller.getLst_DBBasedWkdCallSignList());
        tbl_chatMemberWkdDBTable.setEditable(true);
        return tbl_chatMemberWkdDBTable;
    }

    private MenuBar initMenuBar() {
        Menu fileMenu = new Menu("File");
        this.menuItemFileDisconnect = new MenuItem("Disconnect");
        this.menuItemFileDisconnect.setDisable(true);
        if (this.chatcontroller.isConnectedAndLoggedIn() || this.chatcontroller.isConnectedAndNOTLoggedIn()) {
            this.menuItemFileDisconnect.setDisable(false);
        }
        if (this.chatcontroller.isDisconnected()) {
            this.menuItemFileDisconnect.setDisable(true);
        }
        this.menuItemFileDisconnect.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Kst4ContestApplication.this.chatcontroller.disconnect("ONLYDISCONNECT");
                Kst4ContestApplication.this.menuItemFileDisconnect.setDisable(true);
            }
        });
        MenuItem m10 = new MenuItem("Exit + disconnect");
        m10.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Kst4ContestApplication.this.closeWindowEvent(null);
            }
        });
        fileMenu.getItems().add((Object)this.menuItemFileDisconnect);
        fileMenu.getItems().add((Object)m10);
        Menu optionsMenu = new Menu("Options");
        this.menuItemOptionsSetFrequencyAsName = new MenuItem("Set QRG as name in Chat (main category)");
        this.menuItemOptionsSetFrequencyAsName.setDisable(true);
        this.menuItemOptionsSetFrequencyAsName.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ChatMessage sendMe = new ChatMessage();
                sendMe.setMessageDirectedToServer(false);
                sendMe.setMessageText("/SETNAME " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().getMYQRGFirstCat().getValue());
                Kst4ContestApplication.this.chatcontroller.getMessageTXBus().add(sendMe);
            }
        });
        this.menuItemOptionsAwayBack = new MenuItem("Show me as away in chat");
        MenuItem options10 = new MenuItem("Show options");
        this.menuItemOptionsAwayBack.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ChatMessage sendMe = new ChatMessage();
                sendMe.setMessageDirectedToServer(false);
                if (Kst4ContestApplication.this.chatcontroller.getChatPreferences().isStn_loginAFKState()) {
                    Kst4ContestApplication.this.menuItemOptionsAwayBack.setText("Show me as AWAY FROM chat!");
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setStn_loginAFKState(false);
                    sendMe.setMessageText("/BACK");
                } else {
                    Kst4ContestApplication.this.menuItemOptionsAwayBack.setText("Show me as ACTIVE in chat!");
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setStn_loginAFKState(true);
                    sendMe.setMessageText("/AWAY");
                }
                Kst4ContestApplication.this.chatcontroller.getMessageTXBus().add(sendMe);
            }
        });
        options10.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (Kst4ContestApplication.this.settingsStage.isShowing()) {
                    Kst4ContestApplication.this.settingsStage.hide();
                } else {
                    Kst4ContestApplication.this.settingsStage.show();
                }
            }
        });
        optionsMenu.getItems().addAll((Object[])new MenuItem[]{this.menuItemOptionsSetFrequencyAsName, this.menuItemOptionsAwayBack, options10});
        Menu macroMenu = new Menu("Macros");
        MenuItem macro1 = new MenuItem("Pse Sked?");
        MenuItem macro10 = new MenuItem("Pse qrg 2m?");
        MenuItem macro20 = new MenuItem("Pse Call at ");
        MenuItem macro30 = new MenuItem("In qso nw, pse qrx, I will meep you");
        MenuItem macro40 = new MenuItem("Pse qrg 70cm?");
        MenuItem macro50 = new MenuItem("pse qrg 23cm?");
        macroMenu.getItems().addAll((Object[])new MenuItem[]{macro1, macro10, macro20, macro30, macro40, macro50});
        Menu windowMenu = new Menu("Windows");
        final MenuItem window1 = new MenuItem("Hide cluster / stranger QSOs");
        window1.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (Kst4ContestApplication.this.clusterAndQSOMonStage.isShowing()) {
                    Kst4ContestApplication.this.clusterAndQSOMonStage.hide();
                    window1.setText("Show cluster / stranger QSOs");
                } else {
                    Kst4ContestApplication.this.clusterAndQSOMonStage.show();
                    window1.setText("Hide cluster / stranger QSOs");
                }
            }
        });
        final MenuItem window20 = new MenuItem("hide options");
        window20.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (Kst4ContestApplication.this.settingsStage.isShowing()) {
                    window20.setText("show options");
                    Kst4ContestApplication.this.settingsStage.hide();
                } else {
                    Kst4ContestApplication.this.settingsStage.show();
                    window20.setText("hide options");
                }
            }
        });
        MenuItem window30 = new MenuItem("Use dark mode design");
        window30.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                System.out.println("KST4ContestApp, info: switching to dark mode");
                Kst4ContestApplication.this.scn_ChatwindowMainScene.getStylesheets().clear();
                Kst4ContestApplication.this.clusterAndQSOMonScene.getStylesheets().clear();
                Kst4ContestApplication.this.settingsScene.getStylesheets().clear();
                Application.setUserAgentStylesheet(null);
                Kst4ContestApplication.this.scn_ChatwindowMainScene.getStylesheets().add((Object)Kst4ContestApplication.STYLE_DEFAULTCSSEVENING_FILE);
                Kst4ContestApplication.this.clusterAndQSOMonScene.getStylesheets().add((Object)Kst4ContestApplication.STYLE_DEFAULTCSSEVENING_FILE);
                Kst4ContestApplication.this.settingsScene.getStylesheets().add((Object)Kst4ContestApplication.STYLE_DEFAULTCSSEVENING_FILE);
            }
        });
        MenuItem window40 = new MenuItem("Use default mode design");
        window40.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                System.out.println("KST4ContestApp, info: switching to default mode");
                Kst4ContestApplication.this.scn_ChatwindowMainScene.getStylesheets().clear();
                Kst4ContestApplication.this.clusterAndQSOMonScene.getStylesheets().clear();
                Kst4ContestApplication.this.settingsScene.getStylesheets().clear();
                Application.setUserAgentStylesheet(null);
                Kst4ContestApplication.this.scn_ChatwindowMainScene.getStylesheets().add((Object)Kst4ContestApplication.STYLE_DEFAULTCSSDAY_FILE);
                Kst4ContestApplication.this.clusterAndQSOMonScene.getStylesheets().add((Object)Kst4ContestApplication.STYLE_DEFAULTCSSDAY_FILE);
                Kst4ContestApplication.this.settingsScene.getStylesheets().add((Object)Kst4ContestApplication.STYLE_DEFAULTCSSDAY_FILE);
            }
        });
        windowMenu.getItems().addAll((Object[])new MenuItem[]{window1, window20, window30, window40});
        Menu helpMenu = new Menu("Info");
        MenuItem help1 = new MenuItem("No help here.");
        MenuItem help2 = new MenuItem("Donate for kst4Contest development via PayPal");
        MenuItem help3 = new MenuItem("_______________________");
        help3.setDisable(true);
        MenuItem help4 = new MenuItem("Visit DARC X08-Homepage");
        MenuItem menuItmDonateON4KST = new MenuItem("Donate for ON4KST Chatservers with PayPal to on4kst@skynet.be");
        MenuItem menuItmDonateOV3T = new MenuItem("Donate for OV3T\u00b4s plane feed service");
        MenuItem help6 = new MenuItem("Contact the author using default mail app");
        MenuItem help8 = new MenuItem("Join kst4Contest newsgroup");
        help2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Kst4ContestApplication.this.getHostServices().showDocument("https://www.paypal.com/paypalme/do5amf");
            }
        });
        help4.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Kst4ContestApplication.this.getHostServices().showDocument("http://www.x08.de");
            }
        });
        help6.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Kst4ContestApplication.this.getHostServices().showDocument("mailto:praktimarc+kst4contest@gmail.com");
            }
        });
        help8.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Kst4ContestApplication.this.getHostServices().showDocument("https://groups.google.com/g/kst4contest/about");
            }
        });
        menuItmDonateOV3T.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Kst4ContestApplication.this.getHostServices().showDocument("https://www.paypal.me/ov3t");
            }
        });
        MenuItem help10 = new MenuItem("About...");
        help10.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Alert a = new Alert(Alert.AlertType.INFORMATION);
                a.setTitle("About kst4contest");
                a.setHeaderText("kst4Contest 1.31: ON4KST Chatclient by DO5AMF");
                a.setContentText(Kst4ContestApplication.this.chatcontroller.getChatPreferences().getProgramVersion());
                a.show();
            }
        });
        helpMenu.getItems().addAll((Object[])new MenuItem[]{help2, help3, help4, menuItmDonateOV3T, menuItmDonateON4KST, help6, help8, help10});
        MenuBar menubar = new MenuBar();
        menubar.getMenus().addAll((Object[])new Menu[]{fileMenu, optionsMenu, windowMenu, helpMenu});
        return menubar;
    }

    private Node[] buttonFactory(ObservableList<String> shortcuts) {
        Button[] txMessageButtons = new Button[shortcuts.size()];
        for (int i = 0; i < shortcuts.size(); ++i) {
            txMessageButtons[i] = new Button((String)shortcuts.get(i));
            if (((String)shortcuts.get(i)).equals("MYQRG")) {
                txMessageButtons[i].setTooltip(new Tooltip("MYQRG"));
                txMessageButtons[i].getStyleClass().clear();
                txMessageButtons[i].getStyleClass().add((Object)"button");
                txMessageButtons[i].getStyleClass().add((Object)"buttonMyQrg1");
                this.MYQRGButton = txMessageButtons[i];
            }
            if (((String)shortcuts.get(i)).equals("SECONDQRG")) {
                txMessageButtons[i].setTooltip(new Tooltip("SECONDQRG"));
                txMessageButtons[i].getStyleClass().clear();
                txMessageButtons[i].getStyleClass().add((Object)"button");
                txMessageButtons[i].getStyleClass().add((Object)"buttonMyQrg1");
                txMessageButtons[i].setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent actionEvent) {
                        Kst4ContestApplication.this.txt_chatMessageUserInput.setText(Kst4ContestApplication.this.txt_chatMessageUserInput.getText() + Kst4ContestApplication.this.txt_ownqrgSecondCategory.getText() + " ");
                        System.out.println("2nd click");
                    }
                });
            }
            if (((String)shortcuts.get(i)).equals("/SETNAME MYQRG")) {
                txMessageButtons[i].getStyleClass().clear();
                txMessageButtons[i].getStyleClass().add((Object)"button");
                txMessageButtons[i].getStyleClass().add((Object)"buttonMyQrg1");
                this.MYCALLSetQRGButton = txMessageButtons[i];
            }
            txMessageButtons[i].setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent arg0) {
                    if (((Button)arg0.getSource()).getText().equals("MYQRG")) {
                        ((Button)arg0.getSource()).setTooltip(new Tooltip("MYQRG"));
                    }
                    if (((Button)arg0.getSource()).getTooltip() != null) {
                        if (((Button)arg0.getSource()).getText().equals("MYQRG") || ((Button)arg0.getSource()).getTooltip().getText().equals("MYQRG")) {
                            ((Button)arg0.getSource()).setTooltip(new Tooltip("MYQRG"));
                            if (((Button)arg0.getSource()).getTooltip().getText().equals("MYQRG")) {
                                Kst4ContestApplication.this.txt_chatMessageUserInput.setText(Kst4ContestApplication.this.txt_chatMessageUserInput.getText() + Kst4ContestApplication.this.txt_ownqrgMainCategory.getText() + " ");
                            }
                        }
                        if (((Button)arg0.getSource()).getText().equals("SECONDQRG") || ((Button)arg0.getSource()).getTooltip().getText().equals("SECONDQRG")) {
                            ((Button)arg0.getSource()).setTooltip(new Tooltip("SECONDQRG"));
                            if (((Button)arg0.getSource()).getTooltip().getText().equals("SECONDQRG")) {
                                Kst4ContestApplication.this.txt_chatMessageUserInput.setText(Kst4ContestApplication.this.txt_chatMessageUserInput.getText() + Kst4ContestApplication.this.txt_ownqrgSecondCategory.getText() + " ");
                            }
                        }
                    } else {
                        Kst4ContestApplication.this.txt_chatMessageUserInput.setText(Kst4ContestApplication.this.txt_chatMessageUserInput.getText() + ((Button)arg0.getSource()).getText() + " ");
                    }
                }
            });
        }
        return txMessageButtons;
    }

    public void stop() {
        System.out.println("[Main.java, Info:] Stage is closing, killing all resources");
        this.timer_buildWindowTitle.purge();
        this.timer_buildWindowTitle.cancel();
        this.timer_chatMemberTableSortTimer.purge();
        this.timer_chatMemberTableSortTimer.cancel();
        this.timer_updatePrivatemessageTable.purge();
        this.timer_updatePrivatemessageTable.cancel();
        this.chatcontroller.disconnect("CLOSEALL");
    }

    private void playCWLauncher(String playThisChars) {
        char[] playThisInCW;
        block40: for (char letterToPlay : playThisInCW = playThisChars.toUpperCase().toCharArray()) {
            switch (letterToPlay) {
                case 'A': {
                    this.musicList.add(new Media(new File("LTTRA.mp3").toURI().toString()));
                    continue block40;
                }
                case 'B': {
                    this.musicList.add(new Media(new File("LTTRB.mp3").toURI().toString()));
                    continue block40;
                }
                case 'C': {
                    this.musicList.add(new Media(new File("LTTRC.mp3").toURI().toString()));
                    continue block40;
                }
                case 'D': {
                    this.musicList.add(new Media(new File("LTTRD.mp3").toURI().toString()));
                    continue block40;
                }
                case 'E': {
                    this.musicList.add(new Media(new File("LTTRE.mp3").toURI().toString()));
                    continue block40;
                }
                case 'F': {
                    this.musicList.add(new Media(new File("LTTRF.mp3").toURI().toString()));
                    continue block40;
                }
                case 'G': {
                    this.musicList.add(new Media(new File("LTTRG.mp3").toURI().toString()));
                    continue block40;
                }
                case 'H': {
                    this.musicList.add(new Media(new File("LTTRH.mp3").toURI().toString()));
                    continue block40;
                }
                case 'I': {
                    this.musicList.add(new Media(new File("LTTRI.mp3").toURI().toString()));
                    continue block40;
                }
                case 'J': {
                    this.musicList.add(new Media(new File("LTTRJ.mp3").toURI().toString()));
                    continue block40;
                }
                case 'K': {
                    this.musicList.add(new Media(new File("LTTRK.mp3").toURI().toString()));
                    continue block40;
                }
                case 'L': {
                    this.musicList.add(new Media(new File("LTTRL.mp3").toURI().toString()));
                    continue block40;
                }
                case 'M': {
                    this.musicList.add(new Media(new File("LTTRM.mp3").toURI().toString()));
                    continue block40;
                }
                case 'N': {
                    this.musicList.add(new Media(new File("LTTRN.mp3").toURI().toString()));
                    continue block40;
                }
                case 'O': {
                    this.musicList.add(new Media(new File("LTTRO.mp3").toURI().toString()));
                    continue block40;
                }
                case 'P': {
                    this.musicList.add(new Media(new File("LTTRP.mp3").toURI().toString()));
                    continue block40;
                }
                case 'Q': {
                    this.musicList.add(new Media(new File("LTTRQ.mp3").toURI().toString()));
                    continue block40;
                }
                case 'R': {
                    this.musicList.add(new Media(new File("LTTRR.mp3").toURI().toString()));
                    continue block40;
                }
                case 'S': {
                    this.musicList.add(new Media(new File("LTTRS.mp3").toURI().toString()));
                    continue block40;
                }
                case 'T': {
                    this.musicList.add(new Media(new File("LTTRT.mp3").toURI().toString()));
                    continue block40;
                }
                case 'U': {
                    this.musicList.add(new Media(new File("LTTRU.mp3").toURI().toString()));
                    continue block40;
                }
                case 'V': {
                    this.musicList.add(new Media(new File("LTTRV.mp3").toURI().toString()));
                    continue block40;
                }
                case 'W': {
                    this.musicList.add(new Media(new File("LTTRW.mp3").toURI().toString()));
                    continue block40;
                }
                case 'X': {
                    this.musicList.add(new Media(new File("LTTRX.mp3").toURI().toString()));
                    continue block40;
                }
                case 'Y': {
                    this.musicList.add(new Media(new File("LTTRY.mp3").toURI().toString()));
                    continue block40;
                }
                case 'Z': {
                    this.musicList.add(new Media(new File("LTTRZ.mp3").toURI().toString()));
                    continue block40;
                }
                case '1': {
                    this.musicList.add(new Media(new File("LTTR1.mp3").toURI().toString()));
                    continue block40;
                }
                case '2': {
                    this.musicList.add(new Media(new File("LTTR2.mp3").toURI().toString()));
                    continue block40;
                }
                case '3': {
                    this.musicList.add(new Media(new File("LTTR3.mp3").toURI().toString()));
                    continue block40;
                }
                case '4': {
                    this.musicList.add(new Media(new File("LTTR4.mp3").toURI().toString()));
                    continue block40;
                }
                case '5': {
                    this.musicList.add(new Media(new File("LTTR5.mp3").toURI().toString()));
                    continue block40;
                }
                case '6': {
                    this.musicList.add(new Media(new File("LTTR6.mp3").toURI().toString()));
                    continue block40;
                }
                case '7': {
                    this.musicList.add(new Media(new File("LTTR7.mp3").toURI().toString()));
                    continue block40;
                }
                case '8': {
                    this.musicList.add(new Media(new File("LTTR8.mp3").toURI().toString()));
                    continue block40;
                }
                case '9': {
                    this.musicList.add(new Media(new File("LTTR9.mp3").toURI().toString()));
                    continue block40;
                }
                case '0': {
                    this.musicList.add(new Media(new File("LTTR0.mp3").toURI().toString()));
                    continue block40;
                }
                case '/': {
                    this.musicList.add(new Media(new File("LTTRSTROKE.mp3").toURI().toString()));
                    continue block40;
                }
                case ' ': {
                    this.musicList.add(new Media(new File("LTTRSPACE.mp3").toURI().toString()));
                    continue block40;
                }
                default: {
                    System.out.println("[KST4ContestApp, warning, letter not defined:] cwLetters = " + Arrays.toString(playThisInCW));
                }
            }
        }
        this.playMusic();
    }

    private void playVoiceLauncher(String playThisChars) {
        char[] playThisInCW;
        block44: for (char letterToPlay : playThisInCW = playThisChars.toUpperCase().toCharArray()) {
            switch (letterToPlay) {
                case '!': {
                    this.musicList.add(new Media(new File("VOICEBELL.mp3").toURI().toString()));
                    continue block44;
                }
                case '?': {
                    this.musicList.add(new Media(new File("VOICEYOUGOTMAIL.mp3").toURI().toString()));
                    continue block44;
                }
                case '#': {
                    this.musicList.add(new Media(new File("VOICEHELLO.mp3").toURI().toString()));
                    continue block44;
                }
                case '*': {
                    this.musicList.add(new Media(new File("VOICE73.mp3").toURI().toString()));
                    continue block44;
                }
                case '$': {
                    this.musicList.add(new Media(new File("VOICESTROKEPORTABLE.mp3").toURI().toString()));
                    continue block44;
                }
                case 'A': {
                    this.musicList.add(new Media(new File("VOICEA.mp3").toURI().toString()));
                    continue block44;
                }
                case 'B': {
                    this.musicList.add(new Media(new File("VOICEB.mp3").toURI().toString()));
                    continue block44;
                }
                case 'C': {
                    this.musicList.add(new Media(new File("VOICEC.mp3").toURI().toString()));
                    continue block44;
                }
                case 'D': {
                    this.musicList.add(new Media(new File("VOICED.mp3").toURI().toString()));
                    continue block44;
                }
                case 'E': {
                    this.musicList.add(new Media(new File("VOICEE.mp3").toURI().toString()));
                    continue block44;
                }
                case 'F': {
                    this.musicList.add(new Media(new File("VOICEF.mp3").toURI().toString()));
                    continue block44;
                }
                case 'G': {
                    this.musicList.add(new Media(new File("VOICEG.mp3").toURI().toString()));
                    continue block44;
                }
                case 'H': {
                    this.musicList.add(new Media(new File("VOICEH.mp3").toURI().toString()));
                    continue block44;
                }
                case 'I': {
                    this.musicList.add(new Media(new File("VOICEI.mp3").toURI().toString()));
                    continue block44;
                }
                case 'J': {
                    this.musicList.add(new Media(new File("VOICEJ.mp3").toURI().toString()));
                    continue block44;
                }
                case 'K': {
                    this.musicList.add(new Media(new File("VOICEK.mp3").toURI().toString()));
                    continue block44;
                }
                case 'L': {
                    this.musicList.add(new Media(new File("VOICEL.mp3").toURI().toString()));
                    continue block44;
                }
                case 'M': {
                    this.musicList.add(new Media(new File("VOICEM.mp3").toURI().toString()));
                    continue block44;
                }
                case 'N': {
                    this.musicList.add(new Media(new File("VOICEN.mp3").toURI().toString()));
                    continue block44;
                }
                case 'O': {
                    this.musicList.add(new Media(new File("VOICEO.mp3").toURI().toString()));
                    continue block44;
                }
                case 'P': {
                    this.musicList.add(new Media(new File("VOICEP.mp3").toURI().toString()));
                    continue block44;
                }
                case 'Q': {
                    this.musicList.add(new Media(new File("VOICEQ.mp3").toURI().toString()));
                    continue block44;
                }
                case 'R': {
                    this.musicList.add(new Media(new File("VOICER.mp3").toURI().toString()));
                    continue block44;
                }
                case 'S': {
                    this.musicList.add(new Media(new File("VOICES.mp3").toURI().toString()));
                    continue block44;
                }
                case 'T': {
                    this.musicList.add(new Media(new File("VOICET.mp3").toURI().toString()));
                    continue block44;
                }
                case 'U': {
                    this.musicList.add(new Media(new File("VOICEU.mp3").toURI().toString()));
                    continue block44;
                }
                case 'V': {
                    this.musicList.add(new Media(new File("VOICEV.mp3").toURI().toString()));
                    continue block44;
                }
                case 'W': {
                    this.musicList.add(new Media(new File("VOICEW.mp3").toURI().toString()));
                    continue block44;
                }
                case 'X': {
                    this.musicList.add(new Media(new File("VOICEX.mp3").toURI().toString()));
                    continue block44;
                }
                case 'Y': {
                    this.musicList.add(new Media(new File("VOICEY.mp3").toURI().toString()));
                    continue block44;
                }
                case 'Z': {
                    this.musicList.add(new Media(new File("VOICEZ.mp3").toURI().toString()));
                    continue block44;
                }
                case '1': {
                    this.musicList.add(new Media(new File("VOICE1.mp3").toURI().toString()));
                    continue block44;
                }
                case '2': {
                    this.musicList.add(new Media(new File("VOICE2.mp3").toURI().toString()));
                    continue block44;
                }
                case '3': {
                    this.musicList.add(new Media(new File("VOICE3.mp3").toURI().toString()));
                    continue block44;
                }
                case '4': {
                    this.musicList.add(new Media(new File("VOICE4.mp3").toURI().toString()));
                    continue block44;
                }
                case '5': {
                    this.musicList.add(new Media(new File("VOICE5.mp3").toURI().toString()));
                    continue block44;
                }
                case '6': {
                    this.musicList.add(new Media(new File("VOICE6.mp3").toURI().toString()));
                    continue block44;
                }
                case '7': {
                    this.musicList.add(new Media(new File("VOICE7.mp3").toURI().toString()));
                    continue block44;
                }
                case '8': {
                    this.musicList.add(new Media(new File("VOICE8.mp3").toURI().toString()));
                    continue block44;
                }
                case '9': {
                    this.musicList.add(new Media(new File("VOICE9.mp3").toURI().toString()));
                    continue block44;
                }
                case '0': {
                    this.musicList.add(new Media(new File("VOICE0.mp3").toURI().toString()));
                    continue block44;
                }
                case '/': {
                    this.musicList.add(new Media(new File("VOICESTROKE.mp3").toURI().toString()));
                    continue block44;
                }
                default: {
                    System.out.println("[KST4ContestApp, warning, letter not defined:] cwLetters = " + Arrays.toString(playThisInCW));
                }
            }
        }
        this.playMusic();
    }

    private void playMusic() {
        if (this.musicList.peek() == null) {
            return;
        }
        this.mediaPlayer = new MediaPlayer(this.musicList.poll());
        this.mediaPlayer.setRate(1.0);
        this.mediaPlayer.setOnReady(() -> {
            this.mediaPlayer.play();
            this.mediaPlayer.setOnEndOfMedia(() -> {
                this.playMusic();
                if (this.musicList.isEmpty()) {
                    // empty if block
                }
            });
        });
    }

    public void start(final Stage primaryStage) throws InterruptedException, IOException, URISyntaxException {
        ApplicationFileUtils.copyResourceIfRequired("praktiKST", STYLE_DEFAULTCSSDAY_RESOURCE, STYLE_DEFAULTCSSDAY_FILE);
        ApplicationFileUtils.copyResourceIfRequired("praktiKST", STYLE_DEFAULTCSSEVENING_RESOURCE, STYLE_DEFAULTCSSEVENING_FILE);
        ChatMember ownChatMemberObject = new ChatMember();
        this.chatcontroller = new ChatController(ownChatMemberObject);
        this.chatcontroller.setStatusListener(this);
        try {
            this.txt_ownqrgMainCategory.getStyleClass().clear();
            this.txt_ownqrgMainCategory.getStyleClass().add((Object)"text-input");
            this.txt_ownqrgMainCategory.getStyleClass().add((Object)"text-input-MYQRG1");
            this.txt_ownqrgMainCategory.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                    if (!newPropertyValue.booleanValue()) {
                        System.out.println("[Main.java, Info]: Set the frequency1 property by hand to: " + Kst4ContestApplication.this.txt_ownqrgMainCategory.getText());
                        Kst4ContestApplication.this.chatcontroller.getChatPreferences().getMYQRGFirstCat().set((Object)Kst4ContestApplication.this.txt_ownqrgMainCategory.getText());
                    }
                }
            });
            this.txt_ownqrgSecondCategory.getStyleClass().clear();
            this.txt_ownqrgSecondCategory.getStyleClass().add((Object)"text-input");
            this.txt_ownqrgSecondCategory.getStyleClass().add((Object)"text-input-MYQRG1");
            this.txt_ownqrgSecondCategory.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                    if (!newPropertyValue.booleanValue()) {
                        System.out.println("[Main.java, Info]: Set the frequency2 property by hand to: " + Kst4ContestApplication.this.txt_ownqrgSecondCategory.getText());
                        Kst4ContestApplication.this.chatcontroller.getChatPreferences().getMYQRGSecondCat().set((Object)Kst4ContestApplication.this.txt_ownqrgSecondCategory.getText());
                    }
                }
            });
            this.txt_myQTF.getStyleClass().clear();
            this.txt_myQTF.getStyleClass().add((Object)"text-input");
            this.txt_myQTF.getStyleClass().add((Object)"text-input-MYQRG1");
            this.txt_myQTF.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> Double.toString(this.chatcontroller.getChatPreferences().getActualQTF().get()), (Observable[])new Observable[]{this.chatcontroller.getChatPreferences().getActualQTF()}));
            this.txt_myQTF.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                    if (!newPropertyValue.booleanValue()) {
                        try {
                            System.out.println("[Main.java, Info]: Set the MYQTF property by hand to: " + Kst4ContestApplication.this.txt_myQTF.getText());
                            Kst4ContestApplication.this.chatcontroller.getChatPreferences().getActualQTF().set((double)Integer.parseInt(Kst4ContestApplication.this.txt_myQTF.getText()));
                        }
                        catch (Exception exception) {
                            System.out.println("bullshit entered in myqtf");
                            Kst4ContestApplication.this.txt_myQTF.setText("0");
                        }
                    }
                }
            });
            this.txt_myQTF.setPrefSize(40.0, 0.0);
            this.txt_myQTF.setAlignment(Pos.BASELINE_RIGHT);
            this.txt_myQTF.setTooltip(new Tooltip("This is your current QTF, read out at PSTRotator"));
            this.txt_myQTF.setFocusTraversable(false);
            final SplitPane mainWindowLeftSplitPane = new SplitPane();
            mainWindowLeftSplitPane.setOrientation(Orientation.HORIZONTAL);
            Iterator bPaneChatWindow = new BorderPane();
            this.scn_ChatwindowMainScene = new Scene((Parent)bPaneChatWindow, this.chatcontroller.getChatPreferences().getGUIscn_ChatwindowMainSceneSizeHW()[1], this.chatcontroller.getChatPreferences().getGUIscn_ChatwindowMainSceneSizeHW()[0]);
            this.scn_ChatwindowMainScene.getStylesheets().add((Object)STYLE_DEFAULTCSSDAY_FILE);
            this.scn_ChatwindowMainScene.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observableValue, Number number, Number newWidthValue) {
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().getGUIscn_ChatwindowMainSceneSizeHW()[1] = newWidthValue.doubleValue();
                }
            });
            this.scn_ChatwindowMainScene.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observableValue, Number number, Number newHeightValue) {
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().getGUIscn_ChatwindowMainSceneSizeHW()[0] = newHeightValue.doubleValue();
                }
            });
            this.scn_ChatwindowMainScene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){
                KeyCombination keyComboSTRGplus1 = new KeyCodeCombination(KeyCode.DIGIT1, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});
                KeyCombination keyComboSTRGplus2 = new KeyCodeCombination(KeyCode.DIGIT2, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});
                KeyCombination keyComboSTRGplus3 = new KeyCodeCombination(KeyCode.DIGIT3, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});
                KeyCombination keyComboSTRGplus4 = new KeyCodeCombination(KeyCode.DIGIT4, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});
                KeyCombination keyComboSTRGplus5 = new KeyCodeCombination(KeyCode.DIGIT5, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});
                KeyCombination keyComboSTRGplus6 = new KeyCodeCombination(KeyCode.DIGIT6, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});
                KeyCombination keyComboSTRGplus7 = new KeyCodeCombination(KeyCode.DIGIT7, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});
                KeyCombination keyComboSTRGplus8 = new KeyCodeCombination(KeyCode.DIGIT8, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});
                KeyCombination keyComboSTRGplus9 = new KeyCodeCombination(KeyCode.DIGIT9, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});
                KeyCombination keyComboSTRGplus0 = new KeyCodeCombination(KeyCode.DIGIT0, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});

                public void handle(KeyEvent keyEvent) {
                    try {
                        if (keyEvent.getCode() == KeyCode.ENTER) {
                            Kst4ContestApplication.this.sendButton.fire();
                        } else if (keyEvent.getCode() == KeyCode.ESCAPE) {
                            Kst4ContestApplication.this.txt_chatMessageUserInput.clear();
                        } else if (Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getCallSign() != null) {
                            if (this.keyComboSTRGplus1.match(keyEvent)) {
                                Kst4ContestApplication.this.txt_chatMessageUserInput.setText("/cq " + Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getCallSign() + " " + (String)Kst4ContestApplication.this.chatcontroller.getChatPreferences().getLst_txtSnipList().get(0));
                            } else if (this.keyComboSTRGplus2.match(keyEvent)) {
                                Kst4ContestApplication.this.txt_chatMessageUserInput.setText("/cq " + Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getCallSign() + " " + (String)Kst4ContestApplication.this.chatcontroller.getChatPreferences().getLst_txtSnipList().get(1));
                            } else if (this.keyComboSTRGplus3.match(keyEvent)) {
                                Kst4ContestApplication.this.txt_chatMessageUserInput.setText("/cq " + Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getCallSign() + " " + (String)Kst4ContestApplication.this.chatcontroller.getChatPreferences().getLst_txtSnipList().get(2));
                            } else if (this.keyComboSTRGplus4.match(keyEvent)) {
                                Kst4ContestApplication.this.txt_chatMessageUserInput.setText("/cq " + Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getCallSign() + " " + (String)Kst4ContestApplication.this.chatcontroller.getChatPreferences().getLst_txtSnipList().get(3));
                            } else if (this.keyComboSTRGplus5.match(keyEvent)) {
                                Kst4ContestApplication.this.txt_chatMessageUserInput.setText("/cq " + Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getCallSign() + " " + (String)Kst4ContestApplication.this.chatcontroller.getChatPreferences().getLst_txtSnipList().get(4));
                            } else if (this.keyComboSTRGplus6.match(keyEvent)) {
                                Kst4ContestApplication.this.txt_chatMessageUserInput.setText("/cq " + Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getCallSign() + " " + (String)Kst4ContestApplication.this.chatcontroller.getChatPreferences().getLst_txtSnipList().get(5));
                            } else if (this.keyComboSTRGplus7.match(keyEvent)) {
                                Kst4ContestApplication.this.txt_chatMessageUserInput.setText("/cq " + Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getCallSign() + " " + (String)Kst4ContestApplication.this.chatcontroller.getChatPreferences().getLst_txtSnipList().get(6));
                            } else if (this.keyComboSTRGplus8.match(keyEvent)) {
                                Kst4ContestApplication.this.txt_chatMessageUserInput.setText("/cq " + Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getCallSign() + " " + (String)Kst4ContestApplication.this.chatcontroller.getChatPreferences().getLst_txtSnipList().get(7));
                            } else if (this.keyComboSTRGplus9.match(keyEvent)) {
                                Kst4ContestApplication.this.txt_chatMessageUserInput.setText("/cq " + Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getCallSign() + " " + (String)Kst4ContestApplication.this.chatcontroller.getChatPreferences().getLst_txtSnipList().get(8));
                            } else if (this.keyComboSTRGplus0.match(keyEvent)) {
                                Kst4ContestApplication.this.txt_chatMessageUserInput.setText("/cq " + Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getCallSign() + " " + (String)Kst4ContestApplication.this.chatcontroller.getChatPreferences().getLst_txtSnipList().get(9));
                            }
                            Kst4ContestApplication.this.txt_chatMessageUserInput.requestFocus();
                            Kst4ContestApplication.this.txt_chatMessageUserInput.selectEnd();
                        }
                    }
                    catch (Exception nullPointerExc) {
                        System.out.println("There are no predifined textsnippets for this keycombo! -> " + nullPointerExc.getMessage());
                    }
                }
            });
            MenuBar mainScreenMenuBar = this.initMenuBar();
            this.flwpne_StatusBar = new FlowPane();
            this.flwpne_StatusBar.getChildren().add((Object)mainScreenMenuBar);
            bPaneChatWindow.setTop((Node)this.flwpne_StatusBar);
            final SplitPane messageSectionSplitpane = new SplitPane();
            messageSectionSplitpane.setOrientation(Orientation.VERTICAL);
            HBox textInputFlowPane = new HBox();
            this.sendButton = new Button("TX");
            this.sendButton.setMinSize(20.0, 0.0);
            this.sendButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    ChatMessage sendMe = new ChatMessage();
                    String categoryNumber = "" + Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getChatCategory().getCategoryNumber();
                    ChatCategory sendMeInThisCat = categoryNumber.equals("" + Kst4ContestApplication.this.chatcontroller.getChatCategoryMain().getCategoryNumber()) ? Kst4ContestApplication.this.chatcontroller.getChatCategoryMain() : (categoryNumber.equals("" + Kst4ContestApplication.this.chatcontroller.getChatCategorySecondChat().getCategoryNumber()) ? Kst4ContestApplication.this.chatcontroller.getChatCategorySecondChat() : Kst4ContestApplication.this.chatcontroller.getChatCategoryMain());
                    System.out.println("<<<<<<<<<<<<<<<<<<<<< detected Category for sending message is " + sendMeInThisCat + " // selected member: " + Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getChatCategory() + " evt " + event.isConsumed());
                    sendMe.setChatCategory(sendMeInThisCat);
                    sendMe.setMessageText(Kst4ContestApplication.this.txt_chatMessageUserInput.getText());
                    sendMe.setMessageDirectedToServer(false);
                    Kst4ContestApplication.this.chatcontroller.getMessageTXBus().add(sendMe);
                    Kst4ContestApplication.this.txt_chatMessageUserInput.clear();
                }
            });
            Button btn_clear = new Button("clear");
            btn_clear.setMinSize(20.0, 0.0);
            btn_clear.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    Kst4ContestApplication.this.txt_chatMessageUserInput.clear();
                }
            });
            this.txt_chatMessageUserInput.setFocusTraversable(false);
            this.txt_chatMessageUserInput.setPrefSize(500.0, 0.0);
            this.txt_chatMessageUserInput.setText("");
            this.txt_chatMessageUserInput.setTooltip(new Tooltip("Textmessage to Chat"));
            this.txt_chatMessageUserInput.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    if (event.getCode().equals((Object)KeyCode.ENTER)) {
                        event.consume();
                        Kst4ContestApplication.this.sendButton.fire();
                    }
                }
            });
            this.txt_chatMessageUserInput.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    AirPlane airPlane;
                    if (Kst4ContestApplication.this.txt_chatMessageUserInput.getText().contains("MYQRGSHORT")) {
                        System.out.println("MYQRGSHORT erkannt");
                        Kst4ContestApplication.this.txt_chatMessageUserInput.setText(Kst4ContestApplication.this.txt_chatMessageUserInput.getText().replaceAll("MYQRGSHORT", Kst4ContestApplication.this.chatcontroller.getChatPreferences().getMYQRGFirstCat().getValue().substring(0, 7)));
                    }
                    if (Kst4ContestApplication.this.txt_chatMessageUserInput.getText().contains("MYQRG") && !Kst4ContestApplication.this.txt_chatMessageUserInput.getText().contains("MYQRGSHORT")) {
                        System.out.println("MYQRG erkannt");
                        Kst4ContestApplication.this.txt_chatMessageUserInput.setText(Kst4ContestApplication.this.txt_chatMessageUserInput.getText().replaceAll("MYQRG", Kst4ContestApplication.this.chatcontroller.getChatPreferences().getMYQRGFirstCat().getValue()));
                    }
                    if (Kst4ContestApplication.this.txt_chatMessageUserInput.getText().contains("SECONDQRG")) {
                        System.out.println("MYQRG2 erkannt");
                        Kst4ContestApplication.this.txt_chatMessageUserInput.setText(Kst4ContestApplication.this.txt_chatMessageUserInput.getText().replaceAll("SECONDQRG", Kst4ContestApplication.this.chatcontroller.getChatPreferences().getMYQRGSecondCat().getValue()));
                    }
                    if (Kst4ContestApplication.this.txt_chatMessageUserInput.getText().contains("MYLOCATORSHORT")) {
                        System.out.println("MYLOCATORSHORT erkannt");
                        Kst4ContestApplication.this.txt_chatMessageUserInput.setText(Kst4ContestApplication.this.txt_chatMessageUserInput.getText().replaceAll("MYLOCATORSHORT", Kst4ContestApplication.this.chatcontroller.getChatPreferences().getStn_loginLocatorMainCat().substring(0, 4)));
                    }
                    if (Kst4ContestApplication.this.txt_chatMessageUserInput.getText().contains("MYLOCATOR") && !Kst4ContestApplication.this.txt_chatMessageUserInput.getText().contains("MYLOCATORSHORT")) {
                        System.out.println("MYLOCATOR erkannt");
                        Kst4ContestApplication.this.txt_chatMessageUserInput.setText(Kst4ContestApplication.this.txt_chatMessageUserInput.getText().replaceAll("MYLOCATOR", Kst4ContestApplication.this.chatcontroller.getChatPreferences().getStn_loginLocatorMainCat()));
                    }
                    boolean noAirplaneHere = false;
                    if (Kst4ContestApplication.this.txt_chatMessageUserInput.getText().contains("FIRSTAP")) {
                        if (Kst4ContestApplication.this.selectedCallSignInfoStageChatMember != null && Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getCallSign() != Kst4ContestApplication.this.chatcontroller.getChatPreferences().getStn_loginCallSign()) {
                            if (Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getAirPlaneReflectInfo() != null) {
                                if (Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getAirPlaneReflectInfo().getRisingAirplanes() != null) {
                                    if (Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getAirPlaneReflectInfo().getRisingAirplanes().size() != 0) {
                                        noAirplaneHere = false;
                                        airPlane = (AirPlane)Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getAirPlaneReflectInfo().getRisingAirplanes().get(0);
                                        Kst4ContestApplication.this.txt_chatMessageUserInput.setText(Kst4ContestApplication.this.txt_chatMessageUserInput.getText().replaceAll("FIRSTAP", "a " + airPlane.getPotencialDescriptionAsWord() + " in " + airPlane.getArrivingDurationMinutes() + " min"));
                                    } else {
                                        noAirplaneHere = true;
                                    }
                                } else {
                                    noAirplaneHere = true;
                                }
                            } else {
                                noAirplaneHere = true;
                            }
                        }
                        if (noAirplaneHere) {
                            Kst4ContestApplication.this.txt_chatMessageUserInput.setText(Kst4ContestApplication.this.txt_chatMessageUserInput.getText().replaceAll("FIRSTAP", "no ap available"));
                        }
                    }
                    if (Kst4ContestApplication.this.txt_chatMessageUserInput.getText().contains("SECONDAP")) {
                        if (Kst4ContestApplication.this.selectedCallSignInfoStageChatMember != null && Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getCallSign() != Kst4ContestApplication.this.chatcontroller.getChatPreferences().getStn_loginCallSign()) {
                            if (Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getAirPlaneReflectInfo() != null) {
                                if (Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getAirPlaneReflectInfo().getRisingAirplanes() != null) {
                                    if (Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getAirPlaneReflectInfo().getRisingAirplanes().size() >= 2) {
                                        System.out.println("RISINGAP : " + Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getAirPlaneReflectInfo().getRisingAirplanes().size());
                                        airPlane = (AirPlane)Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getAirPlaneReflectInfo().getRisingAirplanes().get(1);
                                        if (!airPlane.getPotencialDescriptionAsWord().isEmpty()) {
                                            noAirplaneHere = false;
                                            Kst4ContestApplication.this.txt_chatMessageUserInput.setText(Kst4ContestApplication.this.txt_chatMessageUserInput.getText().replaceAll("SECONDAP", "Next " + airPlane.getPotencialDescriptionAsWord() + " in " + airPlane.getArrivingDurationMinutes() + " min"));
                                        } else {
                                            noAirplaneHere = true;
                                        }
                                    } else {
                                        noAirplaneHere = true;
                                    }
                                } else {
                                    noAirplaneHere = true;
                                }
                            } else {
                                noAirplaneHere = true;
                            }
                        }
                        if (noAirplaneHere) {
                            Kst4ContestApplication.this.txt_chatMessageUserInput.setText(Kst4ContestApplication.this.txt_chatMessageUserInput.getText().replaceAll("SECONDAP", ""));
                        }
                    }
                    if (Kst4ContestApplication.this.txt_chatMessageUserInput.getText().contains("QRZNAME") && Kst4ContestApplication.this.selectedCallSignInfoStageChatMember != null) {
                        Kst4ContestApplication.this.txt_chatMessageUserInput.setText(Kst4ContestApplication.this.txt_chatMessageUserInput.getText().replaceAll("QRZNAME", Kst4ContestApplication.this.selectedCallSignInfoStageChatMember.getName()));
                    }
                    if (Kst4ContestApplication.this.txt_chatMessageUserInput.getText().startsWith("/cq " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().getStn_loginCallSign())) {
                        Kst4ContestApplication.this.txt_chatMessageUserInput.setText(" ");
                    }
                }
            });
            Separator sepVert1 = new Separator();
            sepVert1.setOrientation(Orientation.VERTICAL);
            sepVert1.setValignment(VPos.CENTER);
            sepVert1.setPrefWidth(30.0);
            this.txt_ownqrgMainCategory.setText("MYQRG");
            this.txt_ownqrgMainCategory.setPrefSize(70.0, 0.0);
            this.txt_ownqrgMainCategory.setAlignment(Pos.BASELINE_LEFT);
            this.txt_ownqrgMainCategory.setFocusTraversable(false);
            this.txt_ownqrgSecondCategory.setText(this.chatcontroller.getChatPreferences().getMYQRGSecondCat().getValue());
            this.txt_ownqrgSecondCategory.setPrefSize(70.0, 0.0);
            this.txt_ownqrgSecondCategory.setAlignment(Pos.BASELINE_CENTER);
            this.txt_ownqrgSecondCategory.setFocusTraversable(false);
            this.txt_ownqrgSecondCategory.setTooltip(new Tooltip("Enter frequency for second chat-category here by hand! <fixme>"));
            primaryStage.setTitle(this.chatcontroller.getChatPreferences().getChatState());
            this.timer_buildWindowTitle = new Timer();
            this.timer_buildWindowTitle.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    Thread.currentThread().setName("buildWindowTitleTimer");
                    Platform.runLater(() -> {
                        Object chatState = "";
                        if (Kst4ContestApplication.this.chatcontroller.isConnectedAndLoggedIn()) {
                            chatState = "Connected to: " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().getLoginChatCategoryMain();
                            if (Kst4ContestApplication.this.chatcontroller.getChatPreferences().isLoginToSecondChatEnabled()) {
                                chatState = (String)chatState + " and " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().getLoginChatCategorySecond();
                            }
                            chatState = (String)chatState + "  as " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().getStn_loginCallSign() + " (" + Kst4ContestApplication.this.chatcontroller.getChatPreferences().getStn_loginNameMainCat() + ") in " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().getStn_loginLocatorMainCat() + " (" + Kst4ContestApplication.this.chatcontroller.getLst_chatMemberList().size() + " users online, " + Kst4ContestApplication.this.chatcontroller.getLst_chatMemberSortedFilteredList().size() + " shown), " + Kst4ContestApplication.this.chatcontroller.getLst_globalChatMessageList().size() + " messages total.";
                            Kst4ContestApplication.this.chatcontroller.getChatPreferences().setChatState((String)chatState);
                        } else {
                            chatState = "DISCONNECTED!";
                            Kst4ContestApplication.this.chatcontroller.getChatPreferences().setChatState((String)chatState);
                        }
                        if (Kst4ContestApplication.this.chatcontroller.isDisconnected()) {
                            chatState = "DISCONNECTED!";
                            Kst4ContestApplication.this.chatcontroller.getChatPreferences().setChatState((String)chatState);
                        }
                        primaryStage.setTitle(Kst4ContestApplication.this.chatcontroller.getChatPreferences().getChatState());
                    });
                }
            }, new Date(), 5000L);
            textInputFlowPane.getChildren().addAll((Object[])new Node[]{this.txt_chatMessageUserInput, this.sendButton, btn_clear, sepVert1, this.txt_ownqrgMainCategory, this.txt_ownqrgSecondCategory, this.txt_myQTF});
            this.flwPane_textSnippets = new FlowPane();
            this.flwPane_textSnippets.getChildren().addAll((Object[])this.buttonFactory(this.chatcontroller.getChatPreferences().getLst_txtShortCutBtnList()));
            final TableView<ChatMessage> privateMessageTable = this.initChatprivateMSGTable();
            this.chatMessageContextMenu = this.initChatMemberTableContextMenu(this.chatcontroller.getChatPreferences().getLst_txtSnipList());
            privateMessageTable.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent t) {
                    if (t.getButton() == MouseButton.SECONDARY) {
                        Kst4ContestApplication.this.chatMessageContextMenu.show((Window)primaryStage, t.getScreenX(), t.getScreenY());
                    }
                }
            });
            final TableView.TableViewSelectionModel privateChatselectionModelChatMessage = privateMessageTable.getSelectionModel();
            privateChatselectionModelChatMessage.setSelectionMode(SelectionMode.SINGLE);
            ObservableList selectedChatMessageList = privateChatselectionModelChatMessage.getSelectedItems();
            selectedChatMessageList.addListener((ListChangeListener)new ListChangeListener<ChatMessage>(){

                public void onChanged(ListChangeListener.Change<? extends ChatMessage> selectedChatMemberPrivateChat) {
                    if (!privateChatselectionModelChatMessage.getSelectedItems().isEmpty()) {
                        if (((ChatMessage)selectedChatMemberPrivateChat.getList().get(0)).getSender().getCallSign().equals(Kst4ContestApplication.this.chatcontroller.getChatPreferences().getStn_loginCallSign())) {
                            System.out.println("////////////////////////////// rx in orginal message: " + ((ChatMessage)selectedChatMemberPrivateChat.getList().get(0)).getReceiver().getCallSign());
                            System.out.println("privChat selected ChatMember: was own object...!rx was: " + ((ChatMessage)selectedChatMemberPrivateChat.getList().get(0)).getMessageText().substring(2, ((ChatMessage)selectedChatMemberPrivateChat.getList().get(0)).getMessageText().indexOf(")")));
                            Kst4ContestApplication.this.txt_chatMessageUserInput.clear();
                            Kst4ContestApplication.this.txt_chatMessageUserInput.setText("/cq " + ((ChatMessage)selectedChatMemberPrivateChat.getList().get(0)).getMessageText().substring(2, ((ChatMessage)selectedChatMemberPrivateChat.getList().get(0)).getMessageText().indexOf(")")) + " ");
                            Kst4ContestApplication.this.txt_chatMessageUserInput.requestFocus();
                            Kst4ContestApplication.this.txt_chatMessageUserInput.selectEnd();
                        } else {
                            Kst4ContestApplication.this.txt_chatMessageUserInput.clear();
                            Kst4ContestApplication.this.txt_chatMessageUserInput.setText("/cq " + ((ChatMessage)selectedChatMemberPrivateChat.getList().get(0)).getSender().getCallSign() + " ");
                            Kst4ContestApplication.this.txt_chatMessageUserInput.requestFocus();
                            Kst4ContestApplication.this.txt_chatMessageUserInput.selectEnd();
                            try {
                                Kst4ContestApplication.this.selectedCallSignFurtherInfoPane.getChildren().clear();
                                Kst4ContestApplication.this.selectedCallSignInfoStageChatMember = ((ChatMessage)selectedChatMemberPrivateChat.getList().get(0)).getSender();
                                Kst4ContestApplication.this.selectedCallSignFurtherInfoPane.getChildren().add((Object)Kst4ContestApplication.this.generateFurtherInfoAbtSelectedCallsignBP(Kst4ContestApplication.this.selectedCallSignInfoStageChatMember));
                                Kst4ContestApplication.this.txt_chatMessageUserInput.requestFocus();
                                Kst4ContestApplication.this.txt_chatMessageUserInput.selectEnd();
                            }
                            catch (Exception exception) {
                                System.out.println("KST4CApp, <<<catched error>>>>: message sender is not in the userlist any more!");
                            }
                            System.out.println("privChat selected ChatMember: " + ((ChatMessage)selectedChatMemberPrivateChat.getList().get(0)).getSender());
                        }
                    }
                }
            });
            this.timer_updatePrivatemessageTable = new Timer();
            this.timer_updatePrivatemessageTable.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    Thread.currentThread().setName("UpdatePrivateMessageTableTimer");
                    Platform.runLater(() -> privateMessageTable.refresh());
                }
            }, new Date(), 5000L);
            TableView tbl_generalMessageTable = new TableView();
            tbl_generalMessageTable = this.initChatGeneralMSGTable();
            tbl_generalMessageTable.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent t) {
                    if (t.getButton() == MouseButton.SECONDARY) {
                        Kst4ContestApplication.this.chatMemberContextMenu.show((Window)primaryStage, t.getScreenX(), t.getScreenY());
                    }
                }
            });
            final TableView.TableViewSelectionModel generalChatselectionModelChatMessage = tbl_generalMessageTable.getSelectionModel();
            privateChatselectionModelChatMessage.setSelectionMode(SelectionMode.SINGLE);
            ObservableList selectedChatMessageListGeneralChat = generalChatselectionModelChatMessage.getSelectedItems();
            selectedChatMessageListGeneralChat.addListener((ListChangeListener)new ListChangeListener<ChatMessage>(){

                public void onChanged(ListChangeListener.Change<? extends ChatMessage> selectedChatMemberGeneralChat) {
                    if (!generalChatselectionModelChatMessage.getSelectedItems().isEmpty()) {
                        Kst4ContestApplication.this.txt_chatMessageUserInput.clear();
                        Kst4ContestApplication.this.txt_chatMessageUserInput.setText("/cq " + ((ChatMessage)selectedChatMemberGeneralChat.getList().get(0)).getSender().getCallSign() + " ");
                        Kst4ContestApplication.this.txt_chatMessageUserInput.requestFocus();
                        Kst4ContestApplication.this.txt_chatMessageUserInput.selectEnd();
                        System.out.println("privChat selected ChatMember: " + ((ChatMessage)selectedChatMemberGeneralChat.getList().get(0)).getSender());
                        try {
                            Kst4ContestApplication.this.selectedCallSignFurtherInfoPane.getChildren().clear();
                            Kst4ContestApplication.this.selectedCallSignInfoStageChatMember = ((ChatMessage)selectedChatMemberGeneralChat.getList().get(0)).getSender();
                            Kst4ContestApplication.this.selectedCallSignFurtherInfoPane.getChildren().add((Object)Kst4ContestApplication.this.generateFurtherInfoAbtSelectedCallsignBP(Kst4ContestApplication.this.selectedCallSignInfoStageChatMember));
                            Kst4ContestApplication.this.txt_chatMessageUserInput.requestFocus();
                            Kst4ContestApplication.this.txt_chatMessageUserInput.selectEnd();
                        }
                        catch (Exception exception) {
                            System.out.println("KST4CApp, <<<catched error>>>>: message sender is not in the userlist any more!");
                        }
                    }
                }
            });
            messageSectionSplitpane.getItems().addAll((Object[])new Node[]{privateMessageTable, this.flwPane_textSnippets, textInputFlowPane, tbl_generalMessageTable});
            messageSectionSplitpane.setDividerPositions(this.chatcontroller.getChatPreferences().getGUImessageSectionSplitpane_dividerposition());
            for (final SplitPane.Divider divider : messageSectionSplitpane.getDividers()) {
                divider.positionProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                    public void changed(ObservableValue<? extends Number> observableValue, Number oldDividerPos, Number newDividerPosition) {
                        System.out.println("<<<<<<<<<<<<<<<<<<<<<<<<< devider>>>>>> " + messageSectionSplitpane.getDividers().indexOf((Object)divider) + " position change, new position: " + newDividerPosition + " // size dev: " + messageSectionSplitpane.getDividers().size());
                        Kst4ContestApplication.this.chatcontroller.getChatPreferences().getGUImessageSectionSplitpane_dividerposition()[messageSectionSplitpane.getDividers().indexOf((Object)divider)] = newDividerPosition.doubleValue();
                    }
                });
            }
            bPaneChatWindow.setCenter((Node)mainWindowLeftSplitPane);
            TableView<ChatMember> tbl_chatMember = new TableView<ChatMember>();
            tbl_chatMember = this.initChatMemberTable();
            final TableView.TableViewSelectionModel selectionModelChatMember = tbl_chatMember.getSelectionModel();
            selectionModelChatMember.setSelectionMode(SelectionMode.SINGLE);
            tbl_chatMember.autosize();
            ObservableList selectedChatMemberList = selectionModelChatMember.getSelectedItems();
            selectedChatMemberList.addListener((ListChangeListener)new ListChangeListener<ChatMember>(){

                public void onChanged(ListChangeListener.Change<? extends ChatMember> selectedChatMember) {
                    block6: {
                        try {
                            if (selectionModelChatMember.getSelectedItems().isEmpty()) break block6;
                            Kst4ContestApplication.this.selectedCallSignInfoStageChatMember = (ChatMember)selectionModelChatMember.getSelectedItems().get(0);
                            try {
                                Kst4ContestApplication.this.selectedCallSignFurtherInfoPane.getChildren().clear();
                            }
                            catch (Exception exception) {
                                System.out.println("KST4CApp: ERROR: " + exception.getMessage());
                            }
                            try {
                                Kst4ContestApplication.this.selectedCallSignFurtherInfoPane.getChildren().add((Object)Kst4ContestApplication.this.generateFurtherInfoAbtSelectedCallsignBP(Kst4ContestApplication.this.selectedCallSignInfoStageChatMember));
                            }
                            catch (Exception exception) {
                                System.out.println("KST4CApp: ERROR, selected member disappeared: " + exception.getStackTrace());
                                exception.printStackTrace();
                            }
                            Kst4ContestApplication.this.txt_chatMessageUserInput.clear();
                            Kst4ContestApplication.this.txt_chatMessageUserInput.setText("/cq " + ((ChatMember)selectedChatMember.getList().get(0)).getCallSign() + " ");
                            Kst4ContestApplication.this.txt_chatMessageUserInput.requestFocus();
                            Kst4ContestApplication.this.txt_chatMessageUserInput.selectEnd();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Kst4ContestApplication.this.selectedCallSignFurtherInfoPane.getChildren().clear();
                            Kst4ContestApplication.this.txt_chatMessageUserInput.clear();
                            System.out.println("KST4ContestApp <<<catched ERROR>>>, selected user left chat!");
                        }
                    }
                }
            });
            this.chatMemberContextMenu = this.initChatMemberTableContextMenu(this.chatcontroller.getChatPreferences().getLst_txtSnipList());
            tbl_chatMember.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent t) {
                    if (t.getButton() == MouseButton.SECONDARY) {
                        Kst4ContestApplication.this.chatMemberContextMenu.show((Window)primaryStage, t.getScreenX(), t.getScreenY());
                    }
                }
            });
            final SplitPane mainWindowRightSplitPane = new SplitPane();
            mainWindowRightSplitPane.setOrientation(Orientation.VERTICAL);
            mainWindowRightSplitPane.setDividerPositions(this.chatcontroller.getChatPreferences().getGUImainWindowRightSplitPane_dividerposition());
            BorderPane chatMemberTableBorderPane = new BorderPane();
            chatMemberTableBorderPane.setCenter(tbl_chatMember);
            this.chatMemberTableFilterQTFAndQRBHbox = new HBox();
            this.chatMemberTableFilterQTFAndQRBHbox.setSpacing(10.0);
            VBox chatMemberTableFilterVBoxForAllFilters = new VBox();
            chatMemberTableFilterVBoxForAllFilters.setSpacing(1.0);
            chatMemberTableFilterVBoxForAllFilters.setStyle("-fx-padding: 1;-fx-border-style: solid inside;-fx-border-width: 1;-fx-border-insets: 1;-fx-border-radius: 1;-fx-border-color: lightgreen;");
            FlowPane chatMemberTableFilterQRBHBox = new FlowPane();
            chatMemberTableFilterQRBHBox.setAlignment(Pos.CENTER_LEFT);
            chatMemberTableFilterQRBHBox.setHgap(2.0);
            chatMemberTableFilterQRBHBox.setPrefWidth(210.0);
            final TextField chatMemberTableFilterMaxQrbTF = new TextField("" + this.chatcontroller.getChatPreferences().getStn_maxQRBDefault());
            chatMemberTableFilterMaxQrbTF.setFocusTraversable(false);
            final ToggleButton tglBtnQRBEnable = new ToggleButton("Show only QRB [km] <= ");
            tglBtnQRBEnable.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){
                Predicate<ChatMember> maxQrbPredicate = new Predicate<ChatMember>(){

                    @Override
                    public boolean test(ChatMember chatMember) {
                        return chatMember.getQrb() < Double.parseDouble(chatMemberTableFilterMaxQrbTF.getText());
                    }
                };

                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean aBoolean, Boolean t1) {
                    if (tglBtnQRBEnable.isSelected()) {
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().add(this.maxQrbPredicate);
                    } else {
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().remove(this.maxQrbPredicate);
                    }
                }
            });
            chatMemberTableFilterQRBHBox.getChildren().add((Object)tglBtnQRBEnable);
            chatMemberTableFilterMaxQrbTF.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observableValue, String oldValue, String newValue) {
                    if (!newValue.matches("\\d*")) {
                        chatMemberTableFilterMaxQrbTF.setText(newValue.replaceAll("[^\\d]", ""));
                    }
                }
            });
            chatMemberTableFilterMaxQrbTF.setPrefSize(50.0, 0.0);
            chatMemberTableFilterQRBHBox.getChildren().add((Object)chatMemberTableFilterMaxQrbTF);
            chatMemberTableFilterQRBHBox.setStyle("-fx-padding: 1;-fx-border-style: solid inside;-fx-border-width: 1;-fx-border-insets: 1;-fx-border-radius: 1;-fx-border-color: lightgrey;");
            this.chatMemberTableFilterQTFAndQRBHbox.setFillHeight(true);
            this.chatMemberTableFilterQTFAndQRBHbox.setAlignment(Pos.CENTER_LEFT);
            this.chatMemberTableFilterQTFAndQRBHbox.getChildren().add((Object)chatMemberTableFilterQRBHBox);
            FlowPane chatMemberTableFilterQTFHBox = new FlowPane();
            chatMemberTableFilterQTFHBox.setAlignment(Pos.CENTER_LEFT);
            chatMemberTableFilterQTFHBox.setPrefWidth(490.0);
            chatMemberTableFilterQTFHBox.setHgap(2.0);
            final CheckBox chatMemberTableFilterQtfEnableChkbx = new CheckBox("Show only QTF:");
            final TextField chatMemberTableFilterQtfTF = new TextField("" + this.chatcontroller.getChatPreferences().getStn_qtfDefault());
            chatMemberTableFilterQtfTF.setFocusTraversable(false);
            chatMemberTableFilterQtfTF.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observableValue, String oldValue, String newValue) {
                    if (newValue.equals("")) {
                        chatMemberTableFilterQtfTF.setText("0");
                    }
                    if (!newValue.matches("\\d*")) {
                        chatMemberTableFilterQtfTF.setText(newValue.replaceAll("[^\\d]", ""));
                    }
                    chatMemberTableFilterQtfEnableChkbx.setSelected(false);
                    chatMemberTableFilterQtfEnableChkbx.setSelected(true);
                }
            });
            chatMemberTableFilterQtfEnableChkbx.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){
                Predicate<ChatMember> qtfCheckPredicate = new Predicate<ChatMember>(){

                    @Override
                    public boolean test(ChatMember chatMember) {
                        return DirectionUtils.isAngleInRange(chatMember.getQTFdirection(), Double.parseDouble(chatMemberTableFilterQtfTF.getText()), Kst4ContestApplication.this.chatcontroller.getChatPreferences().getStn_antennaBeamWidthDeg());
                    }
                };

                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean aBoolean, Boolean t1) {
                    if (chatMemberTableFilterQtfEnableChkbx.isSelected()) {
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().add(this.qtfCheckPredicate);
                    } else {
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().remove(this.qtfCheckPredicate);
                    }
                }
            });
            chatMemberTableFilterQTFHBox.getChildren().add((Object)chatMemberTableFilterQtfEnableChkbx);
            chatMemberTableFilterQtfTF.setPrefSize(50.0, 0.0);
            chatMemberTableFilterQTFHBox.setStyle("-fx-padding: 1;-fx-border-style: solid inside;-fx-border-width: 1;-fx-border-insets: 1;-fx-border-radius: 1;-fx-border-color: lightgrey;");
            ToggleGroup tglGrpQTF = new ToggleGroup();
            tglGrpQTF.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

                public void changed(ObservableValue<? extends Toggle> observableValue, Toggle toggle, Toggle t1) {
                    if (t1 == null) {
                        chatMemberTableFilterQtfEnableChkbx.setSelected(false);
                    } else {
                        chatMemberTableFilterQtfEnableChkbx.setSelected(true);
                    }
                }
            });
            ToggleButton qtfNorth = new ToggleButton("N");
            qtfNorth.setToggleGroup(tglGrpQTF);
            this.btnQtfButtonsAvl[0] = qtfNorth;
            qtfNorth.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    chatMemberTableFilterQtfTF.textProperty().set((Object)"0");
                }
            });
            ToggleButton qtfNorthEast = new ToggleButton("NE");
            qtfNorthEast.setToggleGroup(tglGrpQTF);
            this.btnQtfButtonsAvl[1] = qtfNorthEast;
            qtfNorthEast.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    chatMemberTableFilterQtfTF.textProperty().set((Object)"45");
                }
            });
            ToggleButton qtfEast = new ToggleButton("E");
            qtfEast.setToggleGroup(tglGrpQTF);
            this.btnQtfButtonsAvl[2] = qtfEast;
            qtfEast.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    chatMemberTableFilterQtfTF.textProperty().set((Object)"90");
                }
            });
            ToggleButton qtfSouthEast = new ToggleButton("SE");
            qtfSouthEast.setToggleGroup(tglGrpQTF);
            this.btnQtfButtonsAvl[3] = qtfSouthEast;
            qtfSouthEast.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    chatMemberTableFilterQtfTF.textProperty().set((Object)"135");
                }
            });
            ToggleButton qtfSouth = new ToggleButton("S");
            qtfSouth.setToggleGroup(tglGrpQTF);
            this.btnQtfButtonsAvl[4] = qtfSouth;
            qtfSouth.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    chatMemberTableFilterQtfTF.textProperty().set((Object)"180");
                }
            });
            ToggleButton qtfSouthWest = new ToggleButton("SW");
            qtfSouthWest.setToggleGroup(tglGrpQTF);
            this.btnQtfButtonsAvl[5] = qtfSouthWest;
            qtfSouthWest.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    chatMemberTableFilterQtfTF.textProperty().set((Object)"225");
                }
            });
            ToggleButton qtfWest = new ToggleButton("W");
            qtfWest.setToggleGroup(tglGrpQTF);
            this.btnQtfButtonsAvl[6] = qtfWest;
            qtfWest.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    chatMemberTableFilterQtfTF.textProperty().set((Object)"270");
                }
            });
            ToggleButton qtfNorthWest = new ToggleButton("NW");
            qtfNorthWest.setToggleGroup(tglGrpQTF);
            this.btnQtfButtonsAvl[7] = qtfNorthWest;
            qtfNorthWest.setToggleGroup(tglGrpQTF);
            qtfNorthWest.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    chatMemberTableFilterQtfTF.textProperty().set((Object)"315");
                }
            });
            chatMemberTableFilterQTFHBox.getChildren().addAll((Object[])new Node[]{chatMemberTableFilterQtfTF, new Label("deg +/- " + this.chatcontroller.getChatPreferences().getStn_antennaBeamWidthDeg()), qtfNorth, qtfNorthEast, qtfEast, qtfSouthEast, qtfSouth, qtfSouthWest, qtfWest, qtfNorthWest});
            this.chatMemberTableFilterQTFAndQRBHbox.getChildren().add((Object)chatMemberTableFilterQTFHBox);
            chatMemberTableFilterVBoxForAllFilters.getChildren().add((Object)this.chatMemberTableFilterQTFAndQRBHbox);
            HBox chatMemberTableFilterTextFieldBox = new HBox();
            chatMemberTableFilterTextFieldBox.setAlignment(Pos.CENTER_LEFT);
            chatMemberTableFilterTextFieldBox.setStyle("-fx-padding: 1;-fx-border-style: solid inside;-fx-border-width: 1;-fx-border-insets: 1;-fx-border-radius: 1;-fx-border-color: lightgrey;");
            this.chatcontroller.getLst_chatMemberListFiltered().predicateProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> this.chatcontroller.getLst_chatMemberListFilterPredicates().stream().reduce(x -> true, Predicate::and), (Observable[])new Observable[]{this.chatcontroller.getLst_chatMemberListFilterPredicates()}));
            final TextField chatMemberTableFilterTextField = new TextField("Find...");
            chatMemberTableFilterTextField.setFocusTraversable(false);
            chatMemberTableFilterTextField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean aBoolean, Boolean t1) {
                    if (chatMemberTableFilterTextField.focusedProperty().getValue().booleanValue()) {
                        chatMemberTableFilterTextField.clear();
                    } else if (!chatMemberTableFilterTextField.focusedProperty().getValue().booleanValue() && chatMemberTableFilterTextField.textProperty().equals("")) {
                        chatMemberTableFilterTextField.setText("Find...");
                    }
                }
            });
            chatMemberTableFilterTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){
                Predicate<ChatMember> searchTextPredicate = new Predicate<ChatMember>(){

                    @Override
                    public boolean test(ChatMember chatMember) {
                        return chatMember.getCallSign().toUpperCase().contains(chatMemberTableFilterTextField.getText().toUpperCase()) || chatMember.getCallSign().toUpperCase().contains(chatMemberTableFilterTextField.getText().toLowerCase());
                    }
                };

                public void changed(ObservableValue<? extends String> observableValue, String s, String t1) {
                    if (chatMemberTableFilterTextField.textProperty().getValue().equals("") && !chatMemberTableFilterTextField.focusedProperty().getValue().booleanValue()) {
                        chatMemberTableFilterTextField.setText("Find...");
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().remove(this.searchTextPredicate);
                    } else {
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().add(this.searchTextPredicate);
                    }
                    System.out.println("KST4CApp " + chatMemberTableFilterTextField.textProperty().getValue().equals("") + " / " + (chatMemberTableFilterTextField.focusedProperty().getValue() == false));
                }
            });
            HBox chatMemberTableFilterWorkedBandFiltersHbx = new HBox();
            final ToggleButton btnTglwkd = new ToggleButton("wkd");
            final Predicate<ChatMember> wkdPredicate = new Predicate<ChatMember>(){

                @Override
                public boolean test(ChatMember chatMember) {
                    return !chatMember.isWorked();
                }
            };
            btnTglwkd.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    if (btnTglwkd.isSelected()) {
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().add((Object)wkdPredicate);
                    } else {
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().remove((Object)wkdPredicate);
                    }
                }
            });
            final ToggleButton btnTglwkd144 = new ToggleButton("144");
            final Predicate<ChatMember> wkd144Predicate = new Predicate<ChatMember>(){

                @Override
                public boolean test(ChatMember chatMember) {
                    return !chatMember.isWorked144() && chatMember.isQrv144();
                }
            };
            btnTglwkd144.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    if (btnTglwkd144.isSelected()) {
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().add((Object)wkd144Predicate);
                    } else {
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().remove((Object)wkd144Predicate);
                    }
                }
            });
            final ToggleButton btnTglwkd432 = new ToggleButton("432");
            final Predicate<ChatMember> wkd432Predicate = new Predicate<ChatMember>(){

                @Override
                public boolean test(ChatMember chatMember) {
                    return !chatMember.isWorked432() && chatMember.isQrv432();
                }
            };
            btnTglwkd432.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    if (btnTglwkd432.isSelected()) {
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().add((Object)wkd432Predicate);
                    } else {
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().remove((Object)wkd432Predicate);
                    }
                }
            });
            final ToggleButton btnTglwkd23 = new ToggleButton("23");
            final Predicate<ChatMember> wkd23Predicate = new Predicate<ChatMember>(){

                @Override
                public boolean test(ChatMember chatMember) {
                    return !chatMember.isWorked1240() && chatMember.isQrv1240();
                }
            };
            btnTglwkd23.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    if (btnTglwkd23.isSelected()) {
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().add((Object)wkd23Predicate);
                    } else {
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().remove((Object)wkd23Predicate);
                    }
                }
            });
            final ToggleButton btnTglwkd13 = new ToggleButton("13");
            final Predicate<ChatMember> wkd13Predicate = new Predicate<ChatMember>(){

                @Override
                public boolean test(ChatMember chatMember) {
                    return !chatMember.isWorked2300() && chatMember.isQrv2300();
                }
            };
            btnTglwkd13.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    if (btnTglwkd13.isSelected()) {
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().add((Object)wkd13Predicate);
                    } else {
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().remove((Object)wkd13Predicate);
                    }
                }
            });
            final ToggleButton btnTglwkd9 = new ToggleButton("9");
            final Predicate<ChatMember> wkd9Predicate = new Predicate<ChatMember>(){

                @Override
                public boolean test(ChatMember chatMember) {
                    return !chatMember.isWorked3400() && chatMember.isQrv3400();
                }
            };
            btnTglwkd9.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    if (btnTglwkd9.isSelected()) {
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().add((Object)wkd9Predicate);
                    } else {
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().remove((Object)wkd9Predicate);
                    }
                }
            });
            final ToggleButton btnTglwkd6 = new ToggleButton("6");
            final Predicate<ChatMember> wkd6Predicate = new Predicate<ChatMember>(){

                @Override
                public boolean test(ChatMember chatMember) {
                    return !chatMember.isWorked5600() && chatMember.isQrv5600();
                }
            };
            btnTglwkd6.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    if (btnTglwkd6.isSelected()) {
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().add((Object)wkd6Predicate);
                    } else {
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().remove((Object)wkd6Predicate);
                    }
                }
            });
            final ToggleButton btnTglwkd3 = new ToggleButton("3");
            final Predicate<ChatMember> wkd3Predicate = new Predicate<ChatMember>(){

                @Override
                public boolean test(ChatMember chatMember) {
                    return !chatMember.isWorked10G() && chatMember.isQrv10G();
                }
            };
            btnTglwkd3.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    if (btnTglwkd3.isSelected()) {
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().add((Object)wkd3Predicate);
                    } else {
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().remove((Object)wkd3Predicate);
                    }
                }
            });
            final ToggleButton btnTglInactive = new ToggleButton("Inactive stations");
            final Predicate<ChatMember> inactivePredicate = new Predicate<ChatMember>(){

                @Override
                public boolean test(ChatMember chatMember) {
                    return Utils4KST.time_getSecondsBetweenEpochAndNow("" + chatMember.getActivityTimeLastInEpoch()) / 60L % 60L <= 20L;
                }
            };
            btnTglInactive.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    if (btnTglInactive.isSelected()) {
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().add((Object)inactivePredicate);
                    } else {
                        Kst4ContestApplication.this.chatcontroller.getLst_chatMemberListFilterPredicates().remove((Object)inactivePredicate);
                    }
                }
            });
            btnTglInactive.setTooltip(new Tooltip("Hide inactive stations"));
            chatMemberTableFilterWorkedBandFiltersHbx.getChildren().add((Object)new Label("Hide worked:\nHide un-QRV: "));
            chatMemberTableFilterWorkedBandFiltersHbx.getChildren().add((Object)btnTglwkd);
            if (this.chatcontroller.getChatPreferences().isStn_bandActive144()) {
                chatMemberTableFilterWorkedBandFiltersHbx.getChildren().add((Object)btnTglwkd144);
            }
            if (this.chatcontroller.getChatPreferences().isStn_bandActive432()) {
                chatMemberTableFilterWorkedBandFiltersHbx.getChildren().add((Object)btnTglwkd432);
            }
            if (this.chatcontroller.getChatPreferences().isStn_bandActive1240()) {
                chatMemberTableFilterWorkedBandFiltersHbx.getChildren().add((Object)btnTglwkd23);
            }
            if (this.chatcontroller.getChatPreferences().isStn_bandActive2300()) {
                chatMemberTableFilterWorkedBandFiltersHbx.getChildren().add((Object)btnTglwkd13);
            }
            if (this.chatcontroller.getChatPreferences().isStn_bandActive3400()) {
                chatMemberTableFilterWorkedBandFiltersHbx.getChildren().add((Object)btnTglwkd9);
            }
            if (this.chatcontroller.getChatPreferences().isStn_bandActive5600()) {
                chatMemberTableFilterWorkedBandFiltersHbx.getChildren().add((Object)btnTglwkd6);
            }
            if (this.chatcontroller.getChatPreferences().isStn_bandActive10G()) {
                chatMemberTableFilterWorkedBandFiltersHbx.getChildren().add((Object)btnTglwkd3);
            }
            chatMemberTableFilterWorkedBandFiltersHbx.getChildren().add((Object)btnTglInactive);
            chatMemberTableFilterWorkedBandFiltersHbx.setAlignment(Pos.CENTER_LEFT);
            chatMemberTableFilterWorkedBandFiltersHbx.setSpacing(5.0);
            chatMemberTableFilterWorkedBandFiltersHbx.setStyle("-fx-padding: 1;-fx-border-style: solid inside;-fx-border-width: 1;-fx-border-insets: 1;-fx-border-radius: 1;-fx-border-color: lightgrey;");
            chatMemberTableFilterTextFieldBox.getChildren().addAll((Object[])new Node[]{chatMemberTableFilterTextField});
            FlowPane chatMemberTableFilterTextFieldAndWorkedBandsHbx = new FlowPane();
            chatMemberTableFilterTextFieldAndWorkedBandsHbx.getChildren().addAll((Object[])new Node[]{chatMemberTableFilterTextFieldBox, chatMemberTableFilterWorkedBandFiltersHbx});
            chatMemberTableFilterTextFieldAndWorkedBandsHbx.setHgap(2.0);
            chatMemberTableFilterVBoxForAllFilters.getChildren().add((Object)chatMemberTableFilterTextFieldAndWorkedBandsHbx);
            Tooltip filterTextBoxTooltip = new Tooltip("Free text search");
            Tooltip.install((Node)chatMemberTableFilterTextField, (Tooltip)filterTextBoxTooltip);
            chatMemberTableBorderPane.setTop((Node)chatMemberTableFilterVBoxForAllFilters);
            mainWindowRightSplitPane.getItems().add((Object)chatMemberTableBorderPane);
            mainWindowLeftSplitPane.getItems().addAll((Object[])new Node[]{messageSectionSplitpane, mainWindowRightSplitPane});
            mainWindowLeftSplitPane.setDividerPositions(this.chatcontroller.getChatPreferences().getGUImainWindowLeftSplitPane_dividerposition());
            for (final SplitPane.Divider divider : mainWindowLeftSplitPane.getDividers()) {
                divider.positionProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                    public void changed(ObservableValue<? extends Number> observableValue, Number oldDividerPos, Number newDividerPosition) {
                        System.out.println("<<<<<<<<<<<<<<<<<<< mainWindowLeftSplitPanedevider " + mainWindowLeftSplitPane.getDividers().indexOf((Object)divider) + " position change, new position: " + newDividerPosition + " // size dev: " + mainWindowLeftSplitPane.getDividers().size());
                        Kst4ContestApplication.this.chatcontroller.getChatPreferences().getGUImainWindowLeftSplitPane_dividerposition()[mainWindowLeftSplitPane.getDividers().indexOf((Object)divider)] = newDividerPosition.doubleValue();
                    }
                });
            }
            mainWindowRightSplitPane.getItems().add((Object)this.selectedCallSignFurtherInfoPane);
            for (final SplitPane.Divider divider : mainWindowRightSplitPane.getDividers()) {
                divider.positionProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                    public void changed(ObservableValue<? extends Number> observableValue, Number oldDividerPos, Number newDividerPosition) {
                        System.out.println("<<<<<<<<<<<<<<<<<<<>>>>>> devider mainwindowRIGHTsplitpane " + mainWindowRightSplitPane.getDividers().indexOf((Object)divider) + " position change, new position: " + newDividerPosition + " // size dev: " + mainWindowRightSplitPane.getDividers().size());
                        Kst4ContestApplication.this.chatcontroller.getChatPreferences().getGUImainWindowRightSplitPane_dividerposition()[mainWindowRightSplitPane.getDividers().indexOf((Object)divider)] = newDividerPosition.doubleValue();
                    }
                });
            }
            primaryStage.setScene(this.scn_ChatwindowMainScene);
            primaryStage.show();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.clusterAndQSOMonStage = new Stage();
        this.clusterAndQSOMonStage.setTitle("Cluster & QSO of the other");
        final SplitPane pnl_directedMSGWin = new SplitPane();
        pnl_directedMSGWin.setOrientation(Orientation.VERTICAL);
        pnl_directedMSGWin.setDividerPositions(this.chatcontroller.getChatPreferences().getGUIpnl_directedMSGWin_dividerpositionDefault());
        pnl_directedMSGWin.getItems().addAll((Object[])new Node[]{this.initDXClusterTable(), this.initChatToOtherMSGTable()});
        for (final SplitPane.Divider divider : pnl_directedMSGWin.getDividers()) {
            divider.positionProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observableValue, Number oldDividerPos, Number newDividerPosition) {
                    System.out.println("<<<<<<<<<<<<<<<<<<<|||||||||||||||||||| devider " + pnl_directedMSGWin.getDividers().indexOf((Object)divider) + " position change, new position: " + newDividerPosition + " // size dev: " + pnl_directedMSGWin.getDividers().size());
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().getGUIpnl_directedMSGWin_dividerpositionDefault()[pnl_directedMSGWin.getDividers().indexOf((Object)divider)] = newDividerPosition.doubleValue();
                }
            });
        }
        this.clusterAndQSOMonScene = new Scene((Parent)pnl_directedMSGWin, this.chatcontroller.getChatPreferences().getGUIclusterAndQSOMonStage_SceneSizeHW()[0], this.chatcontroller.getChatPreferences().getGUIclusterAndQSOMonStage_SceneSizeHW()[1]);
        this.clusterAndQSOMonScene.getStylesheets().add((Object)STYLE_DEFAULTCSSDAY_FILE);
        this.clusterAndQSOMonScene.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number newHeightValue) {
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().getGUIclusterAndQSOMonStage_SceneSizeHW()[1] = newHeightValue.doubleValue();
            }
        });
        this.clusterAndQSOMonScene.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number newWidthValue) {
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().getGUIclusterAndQSOMonStage_SceneSizeHW()[0] = newWidthValue.doubleValue();
            }
        });
        this.clusterAndQSOMonStage.setScene(this.clusterAndQSOMonScene);
        this.clusterAndQSOMonStage.show();
        this.stage_updateStage = new Stage();
        this.stage_updateStage.setTitle("Update information");
        try {
            this.stage_updateStage.setAlwaysOnTop(true);
            Label lblUpdateInfo = new Label("Update aviable!");
            Label lblUpdateInfo2 = new Label("Your Software version: ");
            Label lblUpdateInfo3 = new Label("Newest Software version: ");
            Label lblUpdateInfoChanges = new Label("Major Changes: ");
            Label lblUpdateInfoAdminMessage = new Label("Admin Message: ");
            Label lblUpdateInfoDownload = new Label("Downloadable here: ");
            TreeView treeView = new TreeView();
            GridPane upd_gridPaneUpd = new GridPane();
            upd_gridPaneUpd.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            upd_gridPaneUpd.setVgap(5.0);
            upd_gridPaneUpd.setHgap(5.0);
            VBox vbxUpdateWindow = new VBox();
            vbxUpdateWindow.setSpacing(30.0);
            vbxUpdateWindow.getChildren().add((Object)upd_gridPaneUpd);
            upd_gridPaneUpd.add((Node)lblUpdateInfo, 0, 0, 1, 1);
            upd_gridPaneUpd.add((Node)lblUpdateInfo2, 0, 1, 1, 1);
            upd_gridPaneUpd.add((Node)new Label("kst4Contest 1.31"), 1, 1, 1, 1);
            upd_gridPaneUpd.add((Node)lblUpdateInfo3, 0, 2, 1, 1);
            upd_gridPaneUpd.add((Node)new Label("kst4Contest " + this.chatcontroller.getUpdateInformation().getLatestVersionNumberOnServer()), 1, 2, 1, 1);
            upd_gridPaneUpd.add((Node)lblUpdateInfoChanges, 0, 3, 1, 1);
            upd_gridPaneUpd.add((Node)new Label(this.chatcontroller.getUpdateInformation().getMajorChanges()), 1, 3, 1, 1);
            upd_gridPaneUpd.add((Node)lblUpdateInfoAdminMessage, 0, 4, 1, 1);
            upd_gridPaneUpd.add((Node)new Label(this.chatcontroller.getUpdateInformation().getAdminMessage()), 1, 4, 1, 1);
            upd_gridPaneUpd.add((Node)lblUpdateInfoDownload, 0, 5, 1, 1);
            Hyperlink link = new Hyperlink("Download here");
            link.setOnAction(e -> this.getHostServices().showDocument(this.chatcontroller.getUpdateInformation().getLatestVersionPathOnWebserver()));
            upd_gridPaneUpd.add((Node)link, 1, 5, 1, 1);
            vbxUpdateWindow.getChildren().add((Object)treeView);
            TreeItem rootItem = new TreeItem((Object)"praktiKST");
            TreeItem changeLog = new TreeItem((Object)"ChangeLog");
            ArrayList<String[]> changeLogArrayWith7Fiels = this.chatcontroller.getUpdateInformation().getChangeLog();
            for (String[] aSubversionArray : changeLogArrayWith7Fiels) {
                TreeItem aSubversionEntry = new TreeItem((Object)aSubversionArray[0]);
                for (int i = 1; i < aSubversionArray.length; ++i) {
                    aSubversionEntry.getChildren().add((Object)new TreeItem((Object)aSubversionArray[i]));
                }
                changeLog.getChildren().add((Object)aSubversionEntry);
            }
            rootItem.getChildren().add((Object)changeLog);
            TreeItem knownBugs = new TreeItem((Object)"Known bugs");
            ArrayList<String[]> BugArrayWith2Fiels = this.chatcontroller.getUpdateInformation().getBugList();
            for (String[] aBugArray : BugArrayWith2Fiels) {
                TreeItem aBugEntry = new TreeItem((Object)aBugArray[0]);
                for (int i = 1; i < aBugArray.length; ++i) {
                    aBugEntry.getChildren().add((Object)new TreeItem((Object)aBugArray[i]));
                }
                knownBugs.getChildren().add((Object)aBugEntry);
            }
            rootItem.getChildren().add((Object)knownBugs);
            treeView.setRoot(rootItem);
            treeView.setShowRoot(false);
            System.out.println("SRVR Version: " + this.chatcontroller.getUpdateInformation().getLatestVersionNumberOnServer() + " // installed version 1.31");
            this.stage_updateStage.setScene(new Scene((Parent)vbxUpdateWindow, this.chatcontroller.getChatPreferences().getGUIstage_updateStage_SceneSizeHW()[0], this.chatcontroller.getChatPreferences().getGUIstage_updateStage_SceneSizeHW()[1]));
            if (this.chatcontroller.getUpdateInformation().getLatestVersionNumberOnServer() > 1.31) {
                this.stage_updateStage.show();
            }
        }
        catch (Exception excOnUpdateFileProcessing) {
            System.out.println("[KST4ContestApp, ERROR]: Problem on Updateservice! " + excOnUpdateFileProcessing.getMessage());
            excOnUpdateFileProcessing.printStackTrace();
        }
        this.settingsStage = new Stage();
        this.settingsStage.setTitle("Change Client seetings");
        BorderPane optionsPanel = new BorderPane();
        TabPane tabPaneOptions = new TabPane();
        GridPane grdPnlStation = new GridPane();
        grdPnlStation.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grdPnlStation.setVgap(5.0);
        grdPnlStation.setHgap(5.0);
        Label lblCallSign = new Label("Login-Callsign:");
        final TextField txtFldCallSign = new TextField(this.chatcontroller.getChatPreferences().getStn_loginCallSign());
        txtFldCallSign.setFocusTraversable(false);
        txtFldCallSign.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observed, String oldString, String newString) {
                txtFldCallSign.setText(txtFldCallSign.getText().toUpperCase());
                System.out.println("[Main.java, Info]: Setted the Login Callsign: " + txtFldCallSign.getText().toUpperCase());
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setStn_loginCallSign(txtFldCallSign.getText().toUpperCase());
            }
        });
        Label lblPassword = new Label("Login-Password:");
        final PasswordField txtFldPassword = new PasswordField();
        txtFldPassword.setText(this.chatcontroller.getChatPreferences().getStn_loginPassword());
        txtFldPassword.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observed, String oldString, String newString) {
                System.out.println("[Main.java, Info]: Setted the Login password... ");
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setStn_loginPassword(txtFldPassword.getText());
            }
        });
        Label lblNameMainCat = new Label("Name in Chat:");
        final TextField txtFldNameInChatMainCat = new TextField(this.chatcontroller.getChatPreferences().getStn_loginNameMainCat());
        txtFldNameInChatMainCat.setFocusTraversable(false);
        txtFldNameInChatMainCat.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observed, String oldString, String newString) {
                System.out.println("[Main.java, Info]: Setted the Login name (main chat): " + txtFldNameInChatMainCat.getText());
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setStn_loginNameMainCat(txtFldNameInChatMainCat.getText());
            }
        });
        final Label lblNameSecondCat = new Label("Name in Chat 2:");
        lblNameSecondCat.setVisible(false);
        final TextField txtFldNameInChatSecondCat = new TextField(this.chatcontroller.getChatPreferences().getStn_loginNameSecondCat());
        txtFldNameInChatSecondCat.setFocusTraversable(false);
        txtFldNameInChatSecondCat.setVisible(false);
        txtFldNameInChatSecondCat.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observed, String oldString, String newString) {
                System.out.println("[Main.java, Info]: Setted the Login name at second channel: " + txtFldNameInChatSecondCat.getText());
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setStn_loginNameSecondCat(txtFldNameInChatSecondCat.getText());
            }
        });
        Label lblLocator = new Label("Locator in Chat:");
        final TextField txtFldLocator = new TextField(this.chatcontroller.getChatPreferences().getStn_loginLocatorMainCat());
        txtFldLocator.setFocusTraversable(false);
        txtFldLocator.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observed, String oldString, String newString) {
                System.out.println("[Main.java, Info]: Setted the Login locator: " + txtFldLocator.getText());
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setStn_loginLocatorMainCat(txtFldLocator.getText());
            }
        });
        Label lblChatCategory = new Label("Chatcategory:");
        final ChoiceBox choiceBxChatChategory = new ChoiceBox();
        ChatCategory chatCategoryChoice = new ChatCategory(0);
        choiceBxChatChategory.setValue((Object)this.chatcontroller.getChatPreferences().getLoginChatCategoryMain());
        for (int i = 0; i < chatCategoryChoice.getPossibleCategoryNumbers().length; ++i) {
            ChatCategory temp = new ChatCategory(i + 1);
            choiceBxChatChategory.getItems().add((Object)temp);
        }
        this.stn_choiceBxChatChategorySecond = new ChoiceBox();
        ChatCategory chatCategoryChoiceSecond = new ChatCategory(0);
        this.stn_choiceBxChatChategorySecond.setValue((Object)this.chatcontroller.getChatPreferences().getLoginChatCategorySecond());
        for (int i = 0; i < chatCategoryChoiceSecond.getPossibleCategoryNumbers().length; ++i) {
            ChatCategory temp = new ChatCategory(i + 1);
            if (temp.getCategoryNumber() == ((ChatCategory)choiceBxChatChategory.getSelectionModel().getSelectedItem()).getCategoryNumber()) continue;
            this.stn_choiceBxChatChategorySecond.getItems().add((Object)temp);
        }
        this.stn_choiceBxChatChategorySecond.getSelectionModel().selectedItemProperty().addListener((ov, old, newval) -> {
            ChatCategory idx = (ChatCategory)newval;
            System.out.println("Changed second Choice: " + this.stn_choiceBxChatChategorySecond.getSelectionModel().selectedItemProperty().toString());
            try {
                ChatCategory secondChatCat = new ChatCategory(idx.getCategoryNumber());
                this.chatcontroller.getChatPreferences().setLoginChatCategorySecond(secondChatCat);
                this.chatcontroller.setChatCategorySecondChat(secondChatCat);
                this.btnOptionspnlConnect.setText(this.btnOptionspnlConnect.getText() + " and " + ((ChatCategory)this.stn_choiceBxChatChategorySecond.getSelectionModel().selectedItemProperty().get()).getChatCategoryName(((ChatCategory)this.stn_choiceBxChatChategorySecond.getSelectionModel().getSelectedItem()).getCategoryNumber()));
            }
            catch (NullPointerException e) {
                this.chatcontroller.getChatPreferences().setLoginChatCategorySecond(null);
            }
        });
        choiceBxChatChategory.getSelectionModel().selectedItemProperty().addListener((ov, old, newval) -> {
            int i;
            ChatCategory idx = (ChatCategory)newval;
            System.out.println("Changed Choice: " + choiceBxChatChategory.getSelectionModel().selectedItemProperty().toString());
            ChatCategory firstChatCat = new ChatCategory(idx.getCategoryNumber());
            this.chatcontroller.getChatPreferences().setLoginChatCategoryMain(firstChatCat);
            this.chatcontroller.setChatCategoryMain(firstChatCat);
            this.btnOptionspnlConnect.setText("Connect to " + ((ChatCategory)choiceBxChatChategory.getSelectionModel().selectedItemProperty().get()).getChatCategoryName(((ChatCategory)choiceBxChatChategory.getSelectionModel().getSelectedItem()).getCategoryNumber()));
            this.stn_choiceBxChatChategorySecond.getSelectionModel().clearSelection();
            for (i = 0; i < this.stn_choiceBxChatChategorySecond.getItems().size(); ++i) {
                if (("" + ((ChatCategory)this.stn_choiceBxChatChategorySecond.getItems().get(i)).getCategoryNumber()).equals(((ChatCategory)choiceBxChatChategory.getSelectionModel().getSelectedItem()).getCategoryNumber())) continue;
                System.out.println("laberraba TODO: here is something to do");
            }
            this.stn_choiceBxChatChategorySecond.getItems().clear();
            for (i = 0; i < chatCategoryChoiceSecond.getPossibleCategoryNumbers().length; ++i) {
                ChatCategory temp = new ChatCategory(i + 1);
                if (temp.getCategoryNumber() == ((ChatCategory)choiceBxChatChategory.getSelectionModel().getSelectedItem()).getCategoryNumber()) continue;
                this.stn_choiceBxChatChategorySecond.getItems().add((Object)temp);
            }
        });
        final CheckBox station_chkBxEnableSecondChat = new CheckBox("2nd Chat: ");
        station_chkBxEnableSecondChat.setSelected(this.chatcontroller.getChatPreferences().isLoginToSecondChatEnabled());
        this.stn_choiceBxChatChategorySecond.setDisable(true);
        station_chkBxEnableSecondChat.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                Kst4ContestApplication.this.stn_choiceBxChatChategorySecond.setDisable(newValue == false);
                txtFldNameInChatSecondCat.setDisable(newValue == false);
                lblNameSecondCat.setDisable(newValue == false);
                txtFldNameInChatSecondCat.setVisible(newValue.booleanValue());
                lblNameSecondCat.setVisible(newValue.booleanValue());
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setLoginToSecondChatEnabled(newValue);
                if (!newValue.booleanValue()) {
                    Kst4ContestApplication.this.btnOptionspnlConnect.setText("Connect to " + ((ChatCategory)choiceBxChatChategory.getSelectionModel().selectedItemProperty().get()).getChatCategoryName(((ChatCategory)choiceBxChatChategory.getSelectionModel().getSelectedItem()).getCategoryNumber()));
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setLoginToSecondChatEnabled(false);
                } else {
                    Kst4ContestApplication.this.btnOptionspnlConnect.setText("Connect to " + ((ChatCategory)choiceBxChatChategory.getSelectionModel().selectedItemProperty().get()).getChatCategoryName(((ChatCategory)choiceBxChatChategory.getSelectionModel().getSelectedItem()).getCategoryNumber()) + " & " + ((ChatCategory)Kst4ContestApplication.this.stn_choiceBxChatChategorySecond.getSelectionModel().selectedItemProperty().get()).getChatCategoryName(((ChatCategory)Kst4ContestApplication.this.stn_choiceBxChatChategorySecond.getSelectionModel().getSelectedItem()).getCategoryNumber()));
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setLoginToSecondChatEnabled(true);
                }
            }
        });
        if (this.chatcontroller.getChatPreferences().isLoginToSecondChatEnabled()) {
            this.stn_choiceBxChatChategorySecond.setVisible(this.chatcontroller.getChatPreferences().isLoginToSecondChatEnabled());
            this.stn_choiceBxChatChategorySecond.setDisable(!this.chatcontroller.getChatPreferences().isLoginToSecondChatEnabled());
            txtFldNameInChatSecondCat.setVisible(this.chatcontroller.getChatPreferences().isLoginToSecondChatEnabled());
        }
        final TextField txtFldstn_antennaBeamWidthDeg = new TextField("" + this.chatcontroller.getChatPreferences().getStn_antennaBeamWidthDeg());
        txtFldstn_antennaBeamWidthDeg.setFocusTraversable(false);
        txtFldstn_antennaBeamWidthDeg.setTooltip(new Tooltip("Your antenna beamwidth in DEG\n\nEnter correct values here due it\u00b4s used for path suggestions!!!"));
        txtFldstn_antennaBeamWidthDeg.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observed, String oldString, String newString) {
                if (newString.equals("")) {
                    txtFldstn_antennaBeamWidthDeg.setText("0");
                }
                if (!newString.matches("\\d*")) {
                    txtFldstn_antennaBeamWidthDeg.setText(newString.replaceAll("[^\\d]", ""));
                }
                System.out.println("[Main.java, Info]: Setted the beam: " + txtFldstn_antennaBeamWidthDeg.getText());
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setStn_antennaBeamWidthDeg(Double.parseDouble(txtFldstn_antennaBeamWidthDeg.getText()));
            }
        });
        final TextField txtFldstn_maxQRBDefault = new TextField("" + this.chatcontroller.getChatPreferences().getStn_maxQRBDefault());
        txtFldstn_maxQRBDefault.setFocusTraversable(false);
        txtFldstn_maxQRBDefault.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observed, String oldString, String newString) {
                if (newString.equals("")) {
                    txtFldstn_maxQRBDefault.setText("0");
                }
                if (!newString.matches("\\d*")) {
                    txtFldstn_maxQRBDefault.setText(newString.replaceAll("[^\\d]", ""));
                }
                System.out.println("[Main.java, Info]: Setted the QRB: " + txtFldstn_maxQRBDefault.getText());
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setStn_maxQRBDefault(Double.parseDouble(txtFldstn_maxQRBDefault.getText()));
            }
        });
        final TextField txtFldstn_qtfDefault = new TextField("" + this.chatcontroller.getChatPreferences().getStn_qtfDefault());
        txtFldstn_qtfDefault.setFocusTraversable(false);
        txtFldstn_qtfDefault.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observed, String oldString, String newString) {
                if (newString.equals("")) {
                    txtFldstn_qtfDefault.setText("0");
                }
                if (!newString.matches("\\d*")) {
                    txtFldstn_qtfDefault.setText(newString.replaceAll("[^\\d]", ""));
                }
                System.out.println("[Main.java, Info]: Setted the QRB: " + txtFldstn_qtfDefault.getText());
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setStn_antennaBeamWidthDeg(Double.parseDouble(txtFldstn_qtfDefault.getText()));
            }
        });
        grdPnlStation.add((Node)lblCallSign, 0, 0);
        grdPnlStation.add((Node)txtFldCallSign, 1, 0);
        grdPnlStation.add((Node)lblPassword, 0, 1);
        grdPnlStation.add((Node)txtFldPassword, 1, 1);
        grdPnlStation.add((Node)lblNameMainCat, 0, 2);
        grdPnlStation.add((Node)lblNameSecondCat, 2, 2);
        grdPnlStation.add((Node)txtFldNameInChatMainCat, 1, 2);
        grdPnlStation.add((Node)txtFldNameInChatSecondCat, 3, 2);
        grdPnlStation.add((Node)lblLocator, 0, 3);
        grdPnlStation.add((Node)txtFldLocator, 1, 3);
        grdPnlStation.add((Node)station_chkBxEnableSecondChat, 2, 4);
        grdPnlStation.add((Node)lblChatCategory, 0, 4);
        grdPnlStation.add(this.stn_choiceBxChatChategorySecond, 3, 4);
        grdPnlStation.add((Node)choiceBxChatChategory, 1, 4);
        grdPnlStation.add((Node)new Label("Antenna beamwidth:"), 0, 5);
        grdPnlStation.add((Node)txtFldstn_antennaBeamWidthDeg, 1, 5);
        grdPnlStation.add((Node)new Label("Default maximum QRB:"), 0, 6);
        grdPnlStation.add((Node)txtFldstn_maxQRBDefault, 1, 6);
        grdPnlStation.add((Node)new Label("Default filter QTF:"), 0, 7);
        grdPnlStation.add((Node)txtFldstn_qtfDefault, 1, 7);
        VBox vbxStation = new VBox();
        vbxStation.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        GridPane grdPanelServerHostName = new GridPane();
        TextField stn_txtServerDNS = new TextField(this.chatcontroller.getChatPreferences().getStn_on4kstServersDns());
        grdPanelServerHostName.add((Node)new Label("ON4KST Server [www.on4kst.org]: "), 0, 1);
        grdPanelServerHostName.add((Node)stn_txtServerDNS, 1, 1);
        TextField stn_txtServerPort = new TextField("" + this.chatcontroller.getChatPreferences().getStn_on4kstServersPort());
        grdPanelServerHostName.add((Node)new Label(" Port [23001]: "), 2, 1);
        grdPanelServerHostName.add((Node)stn_txtServerPort, 3, 1);
        vbxStation.getChildren().addAll((Object[])new Node[]{grdPanelServerHostName});
        vbxStation.getChildren().addAll((Object[])new Node[]{this.generateLabeledSeparator(100, "Set your Login Credentials and Station Parameters here"), grdPnlStation});
        vbxStation.getChildren().addAll((Object[])new Node[]{this.generateLabeledSeparator(50, "! ! ! ! Don\u00b4t forget to reset the worked stations information before starting a new contest ! ! ! !")});
        final CheckBox settings_chkbx_QRV144 = new CheckBox("My station uses 2m band");
        settings_chkbx_QRV144.setSelected(this.chatcontroller.getChatPreferences().isStn_bandActive144());
        settings_chkbx_QRV144.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setStn_bandActive144(settings_chkbx_QRV144.isSelected());
                System.out.println("[Main.java, Info]: setted my 144 qrv setting to: " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().isStn_bandActive144());
                Kst4ContestApplication.this.chatMemberTableFilterQTFAndQRBHbox.setVisible(false);
                Kst4ContestApplication.this.chatMemberTableFilterQTFAndQRBHbox.setVisible(true);
            }
        });
        final CheckBox settings_chkbx_QRV432 = new CheckBox("My station uses 70cm band");
        settings_chkbx_QRV432.setSelected(this.chatcontroller.getChatPreferences().isStn_bandActive432());
        settings_chkbx_QRV432.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setStn_bandActive432(settings_chkbx_QRV432.isSelected());
                System.out.println("[Main.java, Info]: setted my 432 qrv setting to: " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().isStn_bandActive432());
            }
        });
        final CheckBox settings_chkbx_QRV1240 = new CheckBox("My station uses 23cm band");
        settings_chkbx_QRV1240.setSelected(this.chatcontroller.getChatPreferences().isStn_bandActive1240());
        settings_chkbx_QRV1240.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setStn_bandActive1240(settings_chkbx_QRV1240.isSelected());
                System.out.println("[Main.java, Info]: setted my 1240 qrv setting to: " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().isStn_bandActive1240());
            }
        });
        final CheckBox settings_chkbx_QRV2300 = new CheckBox("My station uses 13cm band");
        settings_chkbx_QRV2300.setSelected(this.chatcontroller.getChatPreferences().isStn_bandActive2300());
        settings_chkbx_QRV2300.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setStn_bandActive2300(settings_chkbx_QRV2300.isSelected());
                System.out.println("[Main.java, Info]: setted my 2300 qrv setting to: " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().isStn_bandActive2300());
            }
        });
        final CheckBox settings_chkbx_QRV3400 = new CheckBox("My station uses 9cm band");
        settings_chkbx_QRV3400.setSelected(this.chatcontroller.getChatPreferences().isStn_bandActive3400());
        settings_chkbx_QRV3400.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setStn_bandActive3400(settings_chkbx_QRV3400.isSelected());
                System.out.println("[Main.java, Info]: setted my 3400 qrv setting to: " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().isStn_bandActive3400());
            }
        });
        final CheckBox settings_chkbx_QRV5600 = new CheckBox("My station uses 6cm band");
        settings_chkbx_QRV5600.setSelected(this.chatcontroller.getChatPreferences().isStn_bandActive5600());
        settings_chkbx_QRV5600.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setStn_bandActive5600(settings_chkbx_QRV5600.isSelected());
                System.out.println("[Main.java, Info]: setted my 5600 qrv setting to: " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().isStn_bandActive5600());
            }
        });
        final CheckBox settings_chkbx_QRV10G = new CheckBox("My station uses 3cm band");
        settings_chkbx_QRV10G.setSelected(this.chatcontroller.getChatPreferences().isStn_bandActive10G());
        settings_chkbx_QRV10G.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setStn_bandActive10G(settings_chkbx_QRV10G.isSelected());
                System.out.println("[Main.java, Info]: setted my 10G qrv setting to: " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().isStn_bandActive10G());
            }
        });
        GridPane grdPnlStation_bands = new GridPane();
        grdPnlStation_bands.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grdPnlStation_bands.setVgap(5.0);
        grdPnlStation_bands.setHgap(5.0);
        grdPnlStation_bands.add((Node)new Label("Define on which bands you will be qrv today (changes UI a bit ... click save, then restart!)"), 0, 0, 3, 1);
        grdPnlStation_bands.add((Node)settings_chkbx_QRV144, 0, 1);
        grdPnlStation_bands.add((Node)settings_chkbx_QRV432, 1, 1);
        grdPnlStation_bands.add((Node)settings_chkbx_QRV1240, 2, 1);
        grdPnlStation_bands.add((Node)settings_chkbx_QRV2300, 0, 2);
        grdPnlStation_bands.add((Node)settings_chkbx_QRV3400, 1, 2);
        grdPnlStation_bands.add((Node)settings_chkbx_QRV5600, 2, 2);
        grdPnlStation_bands.add((Node)settings_chkbx_QRV10G, 0, 3);
        grdPnlStation_bands.setMaxWidth(555.0);
        grdPnlStation_bands.setStyle("   -fx-border-color: lightgray;\n    -fx-vgap: 5;\n    -fx-hgap: 5;\n    -fx-padding: 5;");
        vbxStation.getChildren().add((Object)new Label("    "));
        vbxStation.getChildren().add((Object)grdPnlStation_bands);
        GridPane grdPnlLog = new GridPane();
        grdPnlLog.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grdPnlLog.setVgap(5.0);
        grdPnlLog.setHgap(5.0);
        Label lblEnableFileBased = new Label("Use universal File based callsign Interpreter (readOnly!)");
        final CheckBox chkBxEnableFileBasedInterpreterUCX = new CheckBox();
        chkBxEnableFileBasedInterpreterUCX.setSelected(this.chatcontroller.getChatPreferences().isLogsynch_fileBasedWkdCallInterpreterEnabled());
        chkBxEnableFileBasedInterpreterUCX.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setLogsynch_fileBasedWkdCallInterpreterEnabled(chkBxEnableFileBasedInterpreterUCX.isSelected());
                System.out.println("[Main.java, Info]: setted the file based worked-station-list to: " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().isLogsynch_fileBasedWkdCallInterpreterEnabled());
            }
        });
        Label lblWkdInterpreterPathToFileTitle = new Label("Worked stations will be read there: ");
        final Label lblWkdInterpreterPathToFile = new Label(this.chatcontroller.getChatPreferences().getLogsynch_fileBasedWkdCallInterpreterFileNameReadOnly());
        Label lblUDPbyUCXLogBackupFilePathAndNameTitle = new Label("Backup UDP msgs to");
        Label lblUDPbyUCXLogBackupFilePathAndName = new Label(this.chatcontroller.getChatPreferences().getLogSynch_storeWorkedCallSignsFileNameUDPMessageBackup());
        Label lblEnableUDPbyUCX = new Label("Receive UCXLog network based UDP log messages");
        final CheckBox chkBxEnableUCXLogUDPReceiver = new CheckBox();
        chkBxEnableUCXLogUDPReceiver.setSelected(this.chatcontroller.getChatPreferences().isLogsynch_ucxUDPWkdCallListenerEnabled());
        chkBxEnableUCXLogUDPReceiver.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setLogsynch_ucxUDPWkdCallListenerEnabled(chkBxEnableUCXLogUDPReceiver.isSelected());
                System.out.println("[Main.java, Info]: setted the udp worked-station receiver to: " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().isLogsynch_ucxUDPWkdCallListenerEnabled());
            }
        });
        Label lblUDPByUCX = new Label("UDP-Port for message-listener (default is 12060)");
        final TextField txtFldUDPPortforUCX = new TextField("");
        txtFldUDPPortforUCX.setFocusTraversable(false);
        txtFldUDPPortforUCX.setText("" + this.chatcontroller.getChatPreferences().getLogsynch_ucxUDPWkdCallListenerPort());
        txtFldUDPPortforUCX.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                if (!newPropertyValue.booleanValue()) {
                    if (GuiUtils.isNumeric(txtFldUDPPortforUCX.getText())) {
                        System.out.println("[Main.java, Info]: Set the ucx-listener port property by hand to: " + txtFldUDPPortforUCX.getText());
                        Kst4ContestApplication.this.chatcontroller.getChatPreferences().setLogsynch_ucxUDPWkdCallListenerPort(Integer.parseInt(txtFldUDPPortforUCX.getText()));
                    } else {
                        txtFldUDPPortforUCX.setText(txtFldUDPPortforUCX.getText() + " is an invalid Port");
                    }
                }
            }
        });
        HBox labeledSeparatorLogSynch = new HBox();
        Button btn_changeFilePathAndName = new Button("Choose...");
        btn_changeFilePathAndName.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                File filechooserSelectedfile;
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle("Choose Readonly-Loginterpreter-File");
                fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
                try {
                    filechooserSelectedfile = fileChooser.showOpenDialog((Window)primaryStage);
                }
                catch (NullPointerException e) {
                    filechooserSelectedfile = new File(Kst4ContestApplication.this.chatcontroller.getChatPreferences().getLogsynch_fileBasedWkdCallInterpreterFileNameReadOnly());
                }
                System.out.println("KST4CApp: Filechooser got " + filechooserSelectedfile.getAbsolutePath());
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setLogsynch_fileBasedWkdCallInterpreterFileNameReadOnly(filechooserSelectedfile.getAbsolutePath());
                lblWkdInterpreterPathToFile.setText(Kst4ContestApplication.this.chatcontroller.getChatPreferences().getLogsynch_fileBasedWkdCallInterpreterFileNameReadOnly());
            }
        });
        grdPnlLog.add((Node)this.generateLabeledSeparator(100, "File polling for worked callsigns"), 0, 0, 2, 1);
        grdPnlLog.add((Node)lblEnableFileBased, 0, 1);
        grdPnlLog.add((Node)chkBxEnableFileBasedInterpreterUCX, 1, 1);
        grdPnlLog.add((Node)lblWkdInterpreterPathToFileTitle, 0, 2);
        grdPnlLog.add((Node)lblWkdInterpreterPathToFile, 1, 2);
        grdPnlLog.add((Node)btn_changeFilePathAndName, 2, 2);
        grdPnlLog.add((Node)this.generateLabeledSeparator(100, "N1MM/QARTEST/UCXLog/DXLog.net Network-Listener"), 0, 3, 2, 1);
        grdPnlLog.add((Node)lblEnableUDPbyUCX, 0, 4);
        grdPnlLog.add((Node)chkBxEnableUCXLogUDPReceiver, 1, 4);
        grdPnlLog.add((Node)lblUDPByUCX, 0, 5);
        grdPnlLog.add((Node)txtFldUDPPortforUCX, 1, 5);
        VBox vbxLog = new VBox();
        vbxLog.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        vbxLog.getChildren().addAll((Object[])new Node[]{grdPnlLog});
        GridPane grdPnltrx = new GridPane();
        grdPnltrx.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grdPnltrx.setVgap(5.0);
        grdPnltrx.setHgap(5.0);
        Label lblEnableTRXMsgbyUCX = new Label("Receive UCXLog network based UDP trx messages at Port 12060");
        final CheckBox chkBxEnableTRXMsgbyUCX = new CheckBox();
        CheckBox chkBxEnableXVTRUsage = new CheckBox();
        Label lblXVTRRFQrg = new Label("XVTR RF QRG in kHz, e.g. \"144000\" for 144 MHz), default = 144000");
        lblXVTRRFQrg.setTooltip(new Tooltip("Where will your xvtr send?"));
        Label lblTRXIFQrg = new Label("TRX IF QRG in kHz, e.g. \"28000\" for 28 MHz), default = 28000");
        lblXVTRRFQrg.setTooltip(new Tooltip("Where will your TRX IF be?"));
        chkBxEnableTRXMsgbyUCX.setSelected(this.chatcontroller.getChatPreferences().isTrxSynch_ucxLogUDPListenerEnabled());
        chkBxEnableTRXMsgbyUCX.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setTrxSynch_ucxLogUDPListenerEnabled(chkBxEnableTRXMsgbyUCX.isSelected());
                    Kst4ContestApplication.this.txt_ownqrgMainCategory.textProperty().unbind();
                    Kst4ContestApplication.this.txt_ownqrgMainCategory.setTooltip(new Tooltip("Your cq qrg will be updated by hand (watch prefs!)"));
                    System.out.println("[Main.java, Info]: MYQRG will be changed only by User input");
                    System.out.println("[Main.java, Info]: setted the trx-frequency updated by ucxlog to: " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().isTrxSynch_ucxLogUDPListenerEnabled());
                } else {
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setTrxSynch_ucxLogUDPListenerEnabled(chkBxEnableTRXMsgbyUCX.isSelected());
                    Kst4ContestApplication.this.txt_ownqrgMainCategory.textProperty().bind((ObservableValue)Kst4ContestApplication.this.chatcontroller.getChatPreferences().getMYQRGFirstCat());
                    Kst4ContestApplication.this.txt_ownqrgMainCategory.setTooltip(new Tooltip("Your cq qrg will be updated by the log program (watch prefs!)"));
                    System.out.println("[Main.java, Info]: setted the trx-frequency updated by ucxlog to: " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().isTrxSynch_ucxLogUDPListenerEnabled());
                }
            }
        });
        if (this.chatcontroller.getChatPreferences().isTrxSynch_ucxLogUDPListenerEnabled()) {
            this.txt_ownqrgMainCategory.setTooltip(new Tooltip("Your cq qrg will be updated by the log program (watch prefs!)"));
            this.txt_ownqrgMainCategory.textProperty().bind((ObservableValue)this.chatcontroller.getChatPreferences().getMYQRGFirstCat());
        } else {
            this.txt_ownqrgMainCategory.setTooltip(new Tooltip("enter your cq qrg here"));
            this.txt_ownqrgMainCategory.textProperty().addListener((observable, oldValue, newValue) -> {
                System.out.println("[Main.java, Info]: MYQRG  Text changed from " + oldValue + " to " + newValue + " by hand");
                this.MYQRGButton.textProperty().set(newValue);
            });
        }
        grdPnltrx.add((Node)this.generateLabeledSeparator(100, "Receive UCXLog TRX info"), 0, 0, 2, 1);
        grdPnltrx.add((Node)lblEnableTRXMsgbyUCX, 0, 1);
        grdPnltrx.add((Node)chkBxEnableTRXMsgbyUCX, 1, 1);
        VBox vbxTRXSynch = new VBox();
        vbxTRXSynch.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        vbxTRXSynch.getChildren().addAll((Object[])new Node[]{grdPnltrx});
        GridPane grdPnlAirScout = new GridPane();
        grdPnlAirScout.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grdPnlAirScout.setVgap(5.0);
        grdPnlAirScout.setHgap(5.0);
        Label lblASEnableUDPMsgbyAS = new Label("Enable Airscout integration (needs AirScout >= V 0.9.9.5)");
        Label lblASServerName = new Label("Servername (AS options>network>UDP Server settings) [AS]:");
        Label lblASChatClientName = new Label("ChatClient name for returning server answers [KST]:");
        Label lblASUdpPort = new Label("Network-UDP-Port for Airscout-Server communication [9872]:");
        Label lblASBandName = new Label("Band-Setting for Airscout-Queries [1440000]:");
        final CheckBox chkBxEnableUDPMsgbyAS = new CheckBox();
        chkBxEnableUDPMsgbyAS.setSelected(this.chatcontroller.getChatPreferences().isAirScout_asUDPListenerEnabled());
        chkBxEnableUDPMsgbyAS.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setAirScout_asUDPListenerEnabled(chkBxEnableUDPMsgbyAS.isSelected());
                System.out.println("[Main.java, Info]: AS communication enabled: " + newValue);
            }
        });
        final TextField txtFld_asServerNameString = new TextField(this.chatcontroller.getChatPreferences().getAirScout_asServerNameString());
        txtFld_asServerNameString.setFocusTraversable(false);
        txtFld_asServerNameString.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                if (!newPropertyValue.booleanValue()) {
                    System.out.println("[Main.java, Info]: AS server name resetted to: " + txtFld_asServerNameString.getText());
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setAirScout_asServerNameString(txtFld_asServerNameString.getText());
                }
            }
        });
        final TextField txtFld_asClientNameString = new TextField(this.chatcontroller.getChatPreferences().getAirScout_asClientNameString());
        txtFld_asClientNameString.setFocusTraversable(false);
        txtFld_asClientNameString.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                if (!newPropertyValue.booleanValue()) {
                    System.out.println("[Main.java, Info]: AS client name resetted to: " + txtFld_asClientNameString.getText());
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setAirScout_asClientNameString(txtFld_asClientNameString.getText());
                }
            }
        });
        final TextField txtFld_asUDPPortInt = new TextField("" + this.chatcontroller.getChatPreferences().getAirScout_asCommunicationPort());
        txtFld_asUDPPortInt.setFocusTraversable(false);
        txtFld_asUDPPortInt.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                if (!newPropertyValue.booleanValue()) {
                    if (GuiUtils.isNumeric(txtFld_asUDPPortInt.getText())) {
                        System.out.println("[Main.java, Info]: AS port resetted to: " + txtFld_asUDPPortInt.getText());
                        Kst4ContestApplication.this.chatcontroller.getChatPreferences().setAirScout_asCommunicationPort(Integer.parseInt(txtFld_asUDPPortInt.getText()));
                    } else {
                        txtFld_asUDPPortInt.setText(txtFld_asUDPPortInt.getText() + " is an invalid Port");
                    }
                }
            }
        });
        final TextField txtFld_asQRGInt = new TextField(this.chatcontroller.getChatPreferences().getAirScout_asBandString());
        txtFld_asQRGInt.setFocusTraversable(false);
        txtFld_asQRGInt.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                if (!newPropertyValue.booleanValue()) {
                    if (GuiUtils.isNumeric(txtFld_asQRGInt.getText())) {
                        System.out.println("[Main.java, Info]: AS qrg resetted to: " + txtFld_asQRGInt.getText());
                        Kst4ContestApplication.this.chatcontroller.getChatPreferences().setAirScout_asBandString("" + Integer.parseInt(txtFld_asQRGInt.getText()));
                    } else {
                        txtFld_asQRGInt.setText(txtFld_asQRGInt.getText() + " is an invalid bandvalue");
                    }
                }
            }
        });
        grdPnlAirScout.add((Node)this.generateLabeledSeparator(100, "Settings for Airscout-network-communication"), 0, 0, 2, 1);
        grdPnlAirScout.add((Node)lblASEnableUDPMsgbyAS, 0, 1);
        grdPnlAirScout.add((Node)chkBxEnableUDPMsgbyAS, 1, 1);
        grdPnlAirScout.add((Node)lblASServerName, 0, 2);
        grdPnlAirScout.add((Node)txtFld_asServerNameString, 1, 2);
        grdPnlAirScout.add((Node)lblASChatClientName, 0, 3);
        grdPnlAirScout.add((Node)txtFld_asClientNameString, 1, 3);
        grdPnlAirScout.add((Node)lblASUdpPort, 0, 4);
        grdPnlAirScout.add((Node)txtFld_asUDPPortInt, 1, 4);
        grdPnlAirScout.add((Node)lblASBandName, 0, 5);
        grdPnlAirScout.add((Node)txtFld_asQRGInt, 1, 5);
        VBox vbxAirScout = new VBox();
        vbxAirScout.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        vbxAirScout.getChildren().addAll((Object[])new Node[]{grdPnlAirScout});
        GridPane grdPnlNotify = new GridPane();
        grdPnlNotify.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grdPnlNotify.setVgap(5.0);
        grdPnlNotify.setHgap(5.0);
        grdPnlNotify.add((Node)this.generateLabeledSeparator(100, "Notification settings"), 0, 0, 2, 1);
        Label lblNotifyEnableSimpleSounds = new Label("Enable simple audio notifications at: new personal message, new sked in ur dir, other");
        Label lblNotifyEnableCWSounds = new Label("Enable CW callsign spelling for new personal messages");
        Label lblNotifyEnableVoiceSounds = new Label("Enable phonetic callsign spelling for new personal messages");
        final CheckBox chkBxEnableNotifySimpleSounds = new CheckBox();
        chkBxEnableNotifySimpleSounds.setSelected(this.chatcontroller.getChatPreferences().isNotify_playSimpleSounds());
        chkBxEnableNotifySimpleSounds.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setNotify_playSimpleSounds(chkBxEnableNotifySimpleSounds.isSelected());
                System.out.println("[Main.java, Info]: Notification simplesounds enabled: " + newValue);
            }
        });
        final CheckBox chkBxEnableNotifyCWSounds = new CheckBox();
        chkBxEnableNotifyCWSounds.setSelected(this.chatcontroller.getChatPreferences().isNotify_playCWCallsignsOnRxedPMs());
        chkBxEnableNotifyCWSounds.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setNotify_playCWCallsignsOnRxedPMs(chkBxEnableNotifyCWSounds.isSelected());
                System.out.println("[Main.java, Info]: Notification CW Callsigns enabled: " + newValue);
            }
        });
        final CheckBox chkBxEnableNotifyVoiceSounds = new CheckBox();
        chkBxEnableNotifyVoiceSounds.setSelected(this.chatcontroller.getChatPreferences().isNotify_playVoiceCallsignsOnRxedPMs());
        chkBxEnableNotifyVoiceSounds.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setNotify_playVoiceCallsignsOnRxedPMs(chkBxEnableNotifyVoiceSounds.isSelected());
                System.out.println("[Main.java, Info]: Notification Voice Callsigns enabled: " + newValue);
            }
        });
        Label lblNotifyEnableDXClusterServer = new Label("Enable DXCluster server");
        final CheckBox chkBxNotifyEnableDXClusterServer = new CheckBox();
        chkBxNotifyEnableDXClusterServer.setSelected(this.chatcontroller.getChatPreferences().isLogsynch_ucxUDPWkdCallListenerEnabled());
        chkBxNotifyEnableDXClusterServer.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setNotify_dxClusterServerEnabled(chkBxNotifyEnableDXClusterServer.isSelected());
                System.out.println("[Main.java, Info]: setted the DXCluster server to: " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().isNotify_dxClusterServerEnabled());
            }
        });
        final TextField txtFld_notify_DXclusterServerPortSetting = new TextField();
        txtFld_notify_DXclusterServerPortSetting.setText("" + this.chatcontroller.getChatPreferences().getNotify_dxclusterServerPort());
        txtFld_notify_DXclusterServerPortSetting.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                if (!newPropertyValue.booleanValue()) {
                    if (GuiUtils.isNumeric(txtFld_notify_DXclusterServerPortSetting.getText())) {
                        Kst4ContestApplication.this.chatcontroller.getChatPreferences().setNotify_dxclusterServerPort(Integer.parseInt(txtFld_notify_DXclusterServerPortSetting.getText()));
                        System.out.println("[Main.java, Info]: setted DXCluster server port to: " + txtFld_notify_DXclusterServerPortSetting.getText());
                    } else {
                        txtFld_notify_DXclusterServerPortSetting.setText(txtFld_notify_DXclusterServerPortSetting.getText() + " is an invalid port value");
                    }
                }
            }
        });
        final TextField txtFld_notify_DXclusterServerFrequencyPrefix = new TextField();
        txtFld_notify_DXclusterServerFrequencyPrefix.setDisable(false);
        txtFld_notify_DXclusterServerFrequencyPrefix.setText(this.chatcontroller.getChatPreferences().getNotify_optionalFrequencyPrefix().getValue());
        txtFld_notify_DXclusterServerFrequencyPrefix.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                if (!newPropertyValue.booleanValue()) {
                    if (GuiUtils.isNumeric(txtFld_notify_DXclusterServerFrequencyPrefix.getText())) {
                        Kst4ContestApplication.this.chatcontroller.getChatPreferences().setNotify_optionalFrequencyPrefix(new SimpleStringProperty(txtFld_notify_DXclusterServerFrequencyPrefix.getText()));
                        System.out.println("[Main.java, Info]: setted QRG prefix value to: " + txtFld_notify_DXclusterServerFrequencyPrefix.getText());
                    } else {
                        Kst4ContestApplication.showUserInputErrorWindow("\"" + txtFld_notify_DXclusterServerFrequencyPrefix.getText() + "\" is an invalid Band prefix! Try again.");
                        txtFld_notify_DXclusterServerFrequencyPrefix.setText(Kst4ContestApplication.this.chatcontroller.getChatPreferences().getNotify_optionalFrequencyPrefix().getValue());
                    }
                }
            }
        });
        final TextField txtFld_notify_DXclusterServerSpottersCallSign = new TextField();
        txtFld_notify_DXclusterServerSpottersCallSign.setDisable(false);
        txtFld_notify_DXclusterServerSpottersCallSign.setText(this.chatcontroller.getChatPreferences().getNotify_DXCSrv_SpottersCallSign().getValue());
        txtFld_notify_DXclusterServerSpottersCallSign.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                if (!newPropertyValue.booleanValue()) {
                    if (GuiUtils.isCallSignSyntax(txtFld_notify_DXclusterServerSpottersCallSign.getText())) {
                        Kst4ContestApplication.this.chatcontroller.getChatPreferences().setNotify_DXCSrv_SpottersCallSign(new SimpleStringProperty(txtFld_notify_DXclusterServerSpottersCallSign.getText()));
                        System.out.println("[Main.java, Info]: setted Spotters Callsign value to: " + txtFld_notify_DXclusterServerSpottersCallSign.getText());
                    } else {
                        Kst4ContestApplication.showUserInputErrorWindow("\"" + txtFld_notify_DXclusterServerSpottersCallSign.getText() + "\" is an invalid CallSign-Value! Try again.");
                        txtFld_notify_DXclusterServerSpottersCallSign.setText(Kst4ContestApplication.this.chatcontroller.getChatPreferences().getNotify_DXCSrv_SpottersCallSign().getValue());
                    }
                }
            }
        });
        Button btn_notify_clusterServerTestMessage = new Button("Send a testmessage to your log");
        btn_notify_clusterServerTestMessage.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ChatMember dummy = new ChatMember();
                dummy.setFrequency((StringProperty)new SimpleStringProperty("144300"));
                dummy.setQra("Congrats, you donated $100");
                dummy.setCallSign("DO5AMF");
                try {
                    Kst4ContestApplication.this.chatcontroller.getDxClusterServer().broadcastSingleDXClusterEntryToLoggers(dummy);
                }
                catch (Exception ex) {
                    System.out.println("DXC sending failed");
                    Alert a = new Alert(Alert.AlertType.INFORMATION);
                    a.setTitle("Testmessage");
                    a.setHeaderText("Something went wrong, maybe you did not click connect first? --> \n\n" + ex.getMessage());
                    a.show();
                }
            }
        });
        Label lblNotifyDXClusterServerTriggerBearing = new Label("Trigger DXCluster message if someone is bearing to me");
        final CheckBox chkBxNotifyDXClusterServerTriggerBearing = new CheckBox();
        chkBxNotifyDXClusterServerTriggerBearing.setSelected(true);
        Label lblNotifyDXClusterServerTriggerOnEveryQRGDetect = new Label("Trigger DXCluster message on every frequency detect (SPAMMY!)");
        final CheckBox chkBxNotifyDXClusterServerTriggerOnEveryQRGDetect = new CheckBox();
        chkBxNotifyDXClusterServerTriggerOnEveryQRGDetect.setSelected(false);
        chkBxNotifyDXClusterServerTriggerOnEveryQRGDetect.setDisable(true);
        chkBxNotifyDXClusterServerTriggerBearing.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setNotify_DXClusterServerTriggerBearing(true);
                    chkBxNotifyDXClusterServerTriggerOnEveryQRGDetect.setSelected(true);
                } else {
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setNotify_DXClusterServerTriggerBearing(false);
                    chkBxNotifyDXClusterServerTriggerOnEveryQRGDetect.setSelected(false);
                }
            }
        });
        chkBxNotifyDXClusterServerTriggerOnEveryQRGDetect.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setNotify_DXClusterServerTriggerOnQRGDetect(true);
                    chkBxNotifyDXClusterServerTriggerBearing.setSelected(true);
                } else {
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setNotify_DXClusterServerTriggerOnQRGDetect(false);
                    chkBxNotifyDXClusterServerTriggerBearing.setSelected(false);
                }
            }
        });
        grdPnlNotify.add((Node)lblNotifyEnableSimpleSounds, 0, 1);
        grdPnlNotify.add((Node)chkBxEnableNotifySimpleSounds, 1, 1);
        grdPnlNotify.add((Node)lblNotifyEnableCWSounds, 0, 2);
        grdPnlNotify.add((Node)chkBxEnableNotifyCWSounds, 1, 2);
        grdPnlNotify.add((Node)lblNotifyEnableVoiceSounds, 0, 3);
        grdPnlNotify.add((Node)chkBxEnableNotifyVoiceSounds, 1, 3);
        grdPnlNotify.add((Node)new Label(""), 0, 4);
        grdPnlNotify.add((Node)this.generateLabeledSeparator(100, "KST4Contest DXCluster Server settings (sending detected QRG to your log)"), 0, 5, 2, 1);
        grdPnlNotify.add((Node)lblNotifyEnableDXClusterServer, 0, 6);
        grdPnlNotify.add((Node)chkBxNotifyEnableDXClusterServer, 1, 6);
        grdPnlNotify.add((Node)new Label("DXCluster Server port [default 8000]: "), 0, 7);
        grdPnlNotify.add((Node)txtFld_notify_DXclusterServerPortSetting, 1, 7);
        grdPnlNotify.add((Node)new Label("DXCluster Band MHz-value if unknown [default 144]: "), 0, 8);
        grdPnlNotify.add((Node)txtFld_notify_DXclusterServerFrequencyPrefix, 1, 8);
        grdPnlNotify.add((Node)new Label("DXCluster Spotters CallSign [default DO5AMF], should not be the contest callsign!: "), 0, 9);
        grdPnlNotify.add((Node)txtFld_notify_DXclusterServerSpottersCallSign, 1, 9);
        grdPnlNotify.add((Node)btn_notify_clusterServerTestMessage, 1, 10);
        grdPnlNotify.add((Node)lblNotifyDXClusterServerTriggerBearing, 0, 11);
        grdPnlNotify.add((Node)chkBxNotifyDXClusterServerTriggerBearing, 1, 11);
        grdPnlNotify.add((Node)lblNotifyDXClusterServerTriggerOnEveryQRGDetect, 0, 12);
        grdPnlNotify.add((Node)chkBxNotifyDXClusterServerTriggerOnEveryQRGDetect, 1, 12);
        grdPnlNotify.add((Node)this.generateLabeledSeparator(100, "QSO Sniffing tool"), 0, 14, 2, 1);
        TableView<String> tblVw_notify_sniffCallSigns = new TableView<String>();
        tblVw_notify_sniffCallSigns = this.initNotifyAtCallSignTable();
        tblVw_notify_sniffCallSigns.setItems(this.chatcontroller.getLstNotify_QSOSniffer_sniffedCallSignList());
        Button btn_notifySniffCall_addLine = new Button("Add new CallSign");
        btn_notifySniffCall_addLine.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                String newTextSnippet = "Pse change (DOUBLECLICK)";
                Kst4ContestApplication.this.chatcontroller.getLstNotify_QSOSniffer_sniffedCallSignList().add(0, (Object)newTextSnippet);
            }
        });
        grdPnlNotify.add(tblVw_notify_sniffCallSigns, 0, 15);
        grdPnlNotify.add((Node)btn_notifySniffCall_addLine, 0, 16);
        VBox vbxNotify = new VBox();
        vbxNotify.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        vbxNotify.getChildren().addAll((Object[])new Node[]{grdPnlNotify});
        GridPane grdPnlShorts = new GridPane();
        grdPnlShorts.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grdPnlShorts.setVgap(5.0);
        grdPnlShorts.setHgap(5.0);
        grdPnlShorts.add((Node)this.generateLabeledSeparator(100, "Set the shortcut-Buttons (above Sendtext-field)"), 0, 0, 2, 1);
        TableView<String> tblVw_shortcuts = new TableView<String>();
        tblVw_shortcuts = this.initShortcutTable();
        tblVw_shortcuts.setItems(this.chatcontroller.getChatPreferences().getLst_txtShortCutBtnList());
        Button btn_Short_addLine = new Button("Add new shorcut-button");
        btn_Short_addLine.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                String newTextSnippet = "CHANGE THIS TEXT VIA DOUBLECLICK or remove by deleting all text. Then hit enter key";
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().getLst_txtShortCutBtnList().add(0, (Object)newTextSnippet);
            }
        });
        Button btn_Short_changePosPlus = new Button("move marked down");
        btn_Short_changePosPlus.setDisable(true);
        Button btn_Short_changePosMinus = new Button("move marked up");
        btn_Short_changePosMinus.setDisable(true);
        HBox hbxTxtShortBtnBox = new HBox();
        grdPnlShorts.add((Node)hbxTxtShortBtnBox, 0, 2, 2, 1);
        hbxTxtShortBtnBox.getChildren().addAll((Object[])new Node[]{btn_Short_addLine, btn_Short_changePosPlus, btn_Short_changePosMinus});
        grdPnlShorts.add(tblVw_shortcuts, 0, 1, 2, 1);
        TableView<String> tblVw_textsnippets = new TableView<String>();
        tblVw_textsnippets = this.initTextSnippetsTable();
        tblVw_textsnippets.setItems(this.chatcontroller.getChatPreferences().getLst_txtSnipList());
        grdPnlShorts.add(tblVw_textsnippets, 0, 4, 2, 1);
        Button btn_Snip_addLine = new Button("Add new snippet");
        btn_Snip_addLine.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                String newTextSnippet = "CHANGE THIS TEXT VIA DOUBLECLICK or remove by deleting all text. Then hit enter key";
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().getLst_txtSnipList().add(0, (Object)newTextSnippet);
            }
        });
        Button btn_Snbip_changePosPlus = new Button("move marked down");
        btn_Snbip_changePosPlus.setDisable(true);
        Button btn_Snip_changePosMinus = new Button("move marked up");
        btn_Snip_changePosMinus.setDisable(true);
        HBox hbxTxtSnipBtnBox = new HBox();
        grdPnlShorts.add((Node)hbxTxtSnipBtnBox, 0, 5, 2, 1);
        hbxTxtSnipBtnBox.getChildren().addAll((Object[])new Node[]{btn_Snip_addLine, btn_Snbip_changePosPlus, btn_Snip_changePosMinus});
        grdPnlShorts.add((Node)this.generateLabeledSeparator(100, "Set the Text-snippets (First 10 are accessible by pressing <strg> + <nr>!)"), 0, 3, 2, 1);
        VBox vbxShorts = new VBox();
        vbxShorts.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        vbxShorts.getChildren().addAll((Object[])new Node[]{grdPnlShorts});
        GridPane grdPnlBeacon = new GridPane();
        grdPnlBeacon.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grdPnlBeacon.setVgap(5.0);
        grdPnlBeacon.setHgap(5.0);
        grdPnlBeacon.add((Node)this.generateLabeledSeparator(100, "Set the Beacon (autointervalled CQ messages to public chat)"), 0, 0, 2, 1);
        grdPnlBeacon.add((Node)new Label("[" + this.chatcontroller.getChatCategoryMain().getChatCategoryName(this.chatcontroller.getChatCategoryMain().getCategoryNumber()) + "] Enable CQ-like beacons:"), 0, 1);
        grdPnlBeacon.add((Node)new Label("[" + this.chatcontroller.getChatCategoryMain().getChatCategoryName(this.chatcontroller.getChatCategorySecondChat().getCategoryNumber()) + "] Enable CQ-like beacons:"), 0, 4);
        final CheckBox chkBxBeaconsEnabledMainCategory = new CheckBox();
        chkBxBeaconsEnabledMainCategory.setSelected(this.chatcontroller.getChatPreferences().isBcn_beaconsEnabledMainCat());
        chkBxBeaconsEnabledMainCategory.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setBcn_beaconsEnabledMainCat(chkBxBeaconsEnabledMainCategory.isSelected());
                System.out.println("[Main.java, Info]: Beacons 1st category turned on: " + newValue);
            }
        });
        grdPnlBeacon.add((Node)chkBxBeaconsEnabledMainCategory, 1, 1);
        final CheckBox chkBxBeaconsEnabledSecondCategory = new CheckBox();
        chkBxBeaconsEnabledSecondCategory.setSelected(this.chatcontroller.getChatPreferences().isBcn_beaconsEnabledSecondCat());
        chkBxBeaconsEnabledSecondCategory.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setBcn_beaconsEnabledSecondCat(chkBxBeaconsEnabledSecondCategory.isSelected());
                System.out.println("[Main.java, Info]: Beacons 2st category turned on: " + newValue);
            }
        });
        grdPnlBeacon.add((Node)chkBxBeaconsEnabledSecondCategory, 1, 4);
        grdPnlBeacon.add((Node)new Label("Beacon message [<100 Chars]:"), 0, 2);
        final TextField txtFldBeaconText = new TextField(this.chatcontroller.getChatPreferences().getBcn_beaconTextMainCat());
        txtFldBeaconText.setFocusTraversable(false);
        grdPnlBeacon.add((Node)txtFldBeaconText, 1, 2);
        txtFldBeaconText.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                if (!newPropertyValue.booleanValue()) {
                    System.out.println("[Main.java, Info]: Set the 1st cat beacon text to: " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().getBcn_beaconTextMainCat());
                    if (txtFldBeaconText.getText().length() <= 120) {
                        Kst4ContestApplication.this.chatcontroller.getChatPreferences().setBcn_beaconTextMainCat(txtFldBeaconText.getText());
                    } else {
                        txtFldBeaconText.setText("That was too long, setting " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().getBcn_beaconTextMainCat());
                    }
                }
            }
        });
        grdPnlBeacon.add((Node)new Label("Beacon-interval [minutes, >=5]:"), 0, 3);
        final TextField txtFldBeaconInterval = new TextField();
        txtFldBeaconInterval.setText("" + this.chatcontroller.getChatPreferences().getBcn_beaconIntervalInMinutesMainCat());
        txtFldBeaconInterval.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                if (!newPropertyValue.booleanValue()) {
                    if (GuiUtils.isNumeric(txtFldBeaconInterval.getText())) {
                        Kst4ContestApplication.this.chatcontroller.getChatPreferences().setBcn_beaconIntervalInMinutesMainCat(Integer.parseInt(txtFldBeaconInterval.getText()));
                        System.out.println("[Main.java, Info]: resetted the beacon-interval to: " + txtFldBeaconInterval.getText());
                    } else {
                        txtFldBeaconInterval.setText(txtFldBeaconInterval.getText() + " is an invalid time value");
                    }
                }
            }
        });
        grdPnlBeacon.add((Node)txtFldBeaconInterval, 1, 3);
        grdPnlBeacon.add((Node)new Label("Beacon message [<100 Chars]:"), 0, 5);
        final TextField txtFldBeaconTextSecondCat = new TextField(this.chatcontroller.getChatPreferences().getBcn_beaconTextSecondCat());
        txtFldBeaconTextSecondCat.setFocusTraversable(false);
        grdPnlBeacon.add((Node)txtFldBeaconTextSecondCat, 1, 5);
        txtFldBeaconTextSecondCat.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                if (!newPropertyValue.booleanValue()) {
                    System.out.println("[Main.java, Info]: Set the 2nd cat beacon text to: " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().getBcn_beaconTextSecondCat());
                    if (txtFldBeaconTextSecondCat.getText().length() <= 120) {
                        Kst4ContestApplication.this.chatcontroller.getChatPreferences().setBcn_beaconTextSecondCat(txtFldBeaconTextSecondCat.getText());
                    } else {
                        txtFldBeaconTextSecondCat.setText("That was too long, setting " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().getBcn_beaconTextSecondCat());
                    }
                }
            }
        });
        grdPnlBeacon.add((Node)new Label("Beacon-interval [minutes, >=5]:"), 0, 6);
        final TextField txtFldBeaconIntervalSecondCat = new TextField();
        txtFldBeaconIntervalSecondCat.setText("" + this.chatcontroller.getChatPreferences().getBcn_beaconIntervalInMinutesSecondCat());
        txtFldBeaconIntervalSecondCat.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                if (!newPropertyValue.booleanValue()) {
                    if (GuiUtils.isNumeric(txtFldBeaconIntervalSecondCat.getText())) {
                        Kst4ContestApplication.this.chatcontroller.getChatPreferences().setBcn_beaconIntervalInMinutesSecondCat(Integer.parseInt(txtFldBeaconIntervalSecondCat.getText()));
                        System.out.println("[Main.java, Info]: resetted the beacon-interval (2nd) to: " + txtFldBeaconIntervalSecondCat.getText());
                    } else {
                        txtFldBeaconIntervalSecondCat.setText(txtFldBeaconIntervalSecondCat.getText() + " is an invalid time value");
                    }
                }
            }
        });
        grdPnlBeacon.add((Node)txtFldBeaconIntervalSecondCat, 1, 6);
        VBox vbxBeacon = new VBox();
        vbxBeacon.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        vbxBeacon.getChildren().addAll((Object[])new Node[]{grdPnlBeacon});
        GridPane grdPnlMessageHandlingBeacon = new GridPane();
        grdPnlMessageHandlingBeacon.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grdPnlMessageHandlingBeacon.setVgap(5.0);
        grdPnlMessageHandlingBeacon.setHgap(5.0);
        grdPnlMessageHandlingBeacon.add((Node)this.generateLabeledSeparator(100, "Set the unworked penetrator Beacons (intervalled PM to unworked stations)"), 0, 0, 2, 1);
        grdPnlMessageHandlingBeacon.add((Node)this.generateLabeledSeparator(100, "Automatic answering options)"), 0, 1, 2, 1);
        final CheckBox chkbx_msgHandlingAutoAnswerEnabled = new CheckBox("Auto-reply (to all queries): ");
        chkbx_msgHandlingAutoAnswerEnabled.setTooltip(new Tooltip("KST4Contest will answer for you with your pre-definied text to all PMs"));
        chkbx_msgHandlingAutoAnswerEnabled.setSelected(this.chatcontroller.getChatPreferences().isMsgHandling_autoAnswerEnabled());
        chkbx_msgHandlingAutoAnswerEnabled.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setMessageHandling_autoAnswerEnabled(chkbx_msgHandlingAutoAnswerEnabled.isSelected());
                System.out.println("[Main.java, Info]: Autoreply turned on: " + newValue);
            }
        });
        final CheckBox chkbx_messageHandlingAutoQRGInfoEnabled = new CheckBox("Enable auto-reply with my QRG on QRG-request");
        Object changeMeToPreferences = "";
        changeMeToPreferences = (String)changeMeToPreferences + "ur qrg?\n";
        changeMeToPreferences = (String)changeMeToPreferences + "your qrg?\n";
        changeMeToPreferences = (String)changeMeToPreferences + "qrg?\n";
        changeMeToPreferences = (String)changeMeToPreferences + "freq?\n";
        changeMeToPreferences = (String)changeMeToPreferences + "pse QRG\n";
        chkbx_messageHandlingAutoQRGInfoEnabled.setTooltip(new Tooltip("KST4Contest can answer with your QRG automatically. Following Strings causing reaction: \n " + (String)changeMeToPreferences));
        chkbx_messageHandlingAutoQRGInfoEnabled.setSelected(this.chatcontroller.getChatPreferences().isMessageHandling_autoAnswerToQRGRequestEnabled());
        chkbx_messageHandlingAutoQRGInfoEnabled.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setMessageHandling_autoAnswerToQRGRequestEnabled(chkbx_messageHandlingAutoQRGInfoEnabled.isSelected());
                System.out.println("[Main.java, Info]: Autoreply (QRG) turned on: " + newValue);
            }
        });
        TextField txtFld_messageHandlingAutoAnswer = new TextField();
        txtFld_messageHandlingAutoAnswer.setText(this.chatcontroller.getChatPreferences().getMessageHandling_autoAnswerTextMainCat());
        grdPnlMessageHandlingBeacon.add((Node)txtFld_messageHandlingAutoAnswer, 1, 2);
        grdPnlMessageHandlingBeacon.add((Node)chkbx_msgHandlingAutoAnswerEnabled, 0, 2);
        grdPnlMessageHandlingBeacon.add((Node)chkbx_messageHandlingAutoQRGInfoEnabled, 0, 4, 2, 1);
        VBox vbxMsgHandlBeacon = new VBox();
        vbxMsgHandlBeacon.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        vbxMsgHandlBeacon.getChildren().addAll((Object[])new Node[]{grdPnlMessageHandlingBeacon});
        GridPane grdPnlInternalDBPane = new GridPane();
        grdPnlInternalDBPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grdPnlInternalDBPane.setVgap(5.0);
        grdPnlInternalDBPane.setHgap(5.0);
        grdPnlInternalDBPane.add((Node)this.generateLabeledSeparator(100, "Change the settings of the internal database (worked stations, reset before a new contest!)"), 0, 0, 2, 1);
        VBox vbxInternalDB = new VBox();
        vbxInternalDB.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        vbxInternalDB.getChildren().addAll((Object[])new Node[]{grdPnlInternalDBPane});
        TableView<ChatMember> tblVw_worked = new TableView<ChatMember>();
        tblVw_worked = this.initWkdStnTable();
        Button btn_wkdDB_reset = new Button("Reset worked-tags and NOT-QRV-tags");
        btn_wkdDB_reset.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                int affectedLines = Kst4ContestApplication.this.chatcontroller.getDbHandler().resetWorkedDataInDB();
                Kst4ContestApplication.this.chatcontroller.resetWorkedInfoInGuiLists();
                if (affectedLines >= 0) {
                    Alert a = new Alert(Alert.AlertType.INFORMATION);
                    a.setTitle("Worked data");
                    a.setHeaderText("All worked data had been resetted." + affectedLines + " worked callsign entries resetted.");
                    a.show();
                } else {
                    Alert a = new Alert(Alert.AlertType.INFORMATION);
                    a.setTitle("Worked data");
                    a.setHeaderText("Something went wrong, DB have to be rebuilt or other error!");
                    a.show();
                }
            }
        });
        HBox hbxwkdShortBtnBox = new HBox();
        grdPnlInternalDBPane.add((Node)hbxwkdShortBtnBox, 0, 2, 2, 1);
        hbxwkdShortBtnBox.getChildren().addAll((Object[])new Node[]{btn_wkdDB_reset});
        grdPnlInternalDBPane.add(tblVw_worked, 0, 1, 2, 1);
        GridPane grdPnlGuiOptions = new GridPane();
        grdPnlGuiOptions.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grdPnlGuiOptions.setVgap(5.0);
        grdPnlGuiOptions.setHgap(5.0);
        grdPnlGuiOptions.add((Node)this.generateLabeledSeparator(100, "Set selected user default message-filtering"), 0, 0, 2, 1);
        grdPnlGuiOptions.add((Node)new Label("By default show...:"), 0, 1);
        HBox guiOptions_hbxUserInfoMessageFilter = new HBox();
        guiOptions_hbxUserInfoMessageFilter.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grdPnlGuiOptions.add((Node)guiOptions_hbxUserInfoMessageFilter, 1, 1);
        grdPnlGuiOptions.add((Node)this.generateLabeledSeparator(100, "Bring color to the people (SM6VTZ wish for next subversion! Pse patience)"), 0, 2, 2, 1);
        grdPnlGuiOptions.add((Node)new Label("Coloring mode:"), 0, 3);
        final ToggleGroup guiOptions_tglGrpSelectedCallsignFilter = new ToggleGroup();
        final RadioButton selectedCallSignFilterToMeMsgRB = new RadioButton("...pm to me ");
        selectedCallSignFilterToMeMsgRB.setToggleGroup(guiOptions_tglGrpSelectedCallsignFilter);
        final RadioButton selectedCallSignFilterMsgToOtherRB = new RadioButton("...pm to other ");
        selectedCallSignFilterMsgToOtherRB.setToggleGroup(guiOptions_tglGrpSelectedCallsignFilter);
        final RadioButton selectedCallSignFilterMsgpublic = new RadioButton("...public msgs ");
        selectedCallSignFilterMsgpublic.setToggleGroup(guiOptions_tglGrpSelectedCallsignFilter);
        final RadioButton selectedCallSignNoFilterRB = new RadioButton("...all messages ");
        selectedCallSignNoFilterRB.setToggleGroup(guiOptions_tglGrpSelectedCallsignFilter);
        guiOptions_tglGrpSelectedCallsignFilter.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> observableValue, Toggle toggle, Toggle t1) {
                RadioButton radioButton = (RadioButton)guiOptions_tglGrpSelectedCallsignFilter.getSelectedToggle();
                if (radioButton.equals(selectedCallSignFilterToMeMsgRB)) {
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setGuiOptions_defaultFilterPmToMe(true);
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setGuiOptions_defaultFilterPmToOther(false);
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setGuiOptions_defaultFilterPublicMsgs(false);
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setGuiOptions_defaultFilterNothing(false);
                    System.out.println(t1 + " filter to me was selected ");
                } else if (radioButton.equals(selectedCallSignFilterMsgToOtherRB)) {
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setGuiOptions_defaultFilterPmToOther(true);
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setGuiOptions_defaultFilterPublicMsgs(false);
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setGuiOptions_defaultFilterNothing(false);
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setGuiOptions_defaultFilterPmToMe(false);
                    System.out.println(t1 + " filter to other was selected ");
                } else if (radioButton.equals(selectedCallSignFilterMsgpublic)) {
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setGuiOptions_defaultFilterPublicMsgs(true);
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setGuiOptions_defaultFilterPmToOther(false);
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setGuiOptions_defaultFilterNothing(false);
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setGuiOptions_defaultFilterPmToMe(false);
                    System.out.println(t1 + " Gui options: filter to public was selected");
                } else if (radioButton.equals(selectedCallSignNoFilterRB)) {
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setGuiOptions_defaultFilterNothing(true);
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setGuiOptions_defaultFilterPublicMsgs(false);
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setGuiOptions_defaultFilterPmToOther(false);
                    Kst4ContestApplication.this.chatcontroller.getChatPreferences().setGuiOptions_defaultFilterPmToMe(false);
                    System.out.println(t1 + " Gui options: no filter was selected");
                }
            }
        });
        guiOptions_hbxUserInfoMessageFilter.getChildren().add((Object)selectedCallSignNoFilterRB);
        guiOptions_hbxUserInfoMessageFilter.getChildren().add((Object)selectedCallSignFilterToMeMsgRB);
        guiOptions_hbxUserInfoMessageFilter.getChildren().add((Object)selectedCallSignFilterMsgToOtherRB);
        guiOptions_hbxUserInfoMessageFilter.getChildren().add((Object)selectedCallSignFilterMsgpublic);
        if (this.chatcontroller.getChatPreferences().isGuiOptions_defaultFilterNothing()) {
            selectedCallSignNoFilterRB.setSelected(true);
        } else if (this.chatcontroller.getChatPreferences().isGuiOptions_defaultFilterPmToMe()) {
            selectedCallSignFilterToMeMsgRB.setSelected(true);
        } else if (this.chatcontroller.getChatPreferences().isGuiOptions_defaultFilterPmToOther()) {
            selectedCallSignFilterMsgToOtherRB.setSelected(true);
        } else if (this.chatcontroller.getChatPreferences().isGuiOptions_defaultFilterPublicMsgs()) {
            selectedCallSignFilterMsgpublic.setSelected(true);
        }
        VBox vbxGuiOptions = new VBox();
        vbxGuiOptions.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        vbxGuiOptions.getChildren().addAll((Object[])new Node[]{grdPnlGuiOptions});
        Tab tbStationSettings = new Tab("Station", (Node)vbxStation);
        Tab tbLogSynchSet = new Tab("Log synch", (Node)vbxLog);
        Tab tbTRXSynchSet = new Tab("TRX synch", (Node)vbxTRXSynch);
        Tab tbAirScoutSettings = new Tab("Airscout", (Node)vbxAirScout);
        Tab tbNotify = new Tab("Notification", (Node)vbxNotify);
        Tab tbShorts = new Tab("Shortcuts", (Node)vbxShorts);
        Tab tbBeacon = new Tab("Beacon", (Node)vbxBeacon);
        Tab tbMsgHandling = new Tab("Messagehandling", (Node)vbxMsgHandlBeacon);
        Tab tbInternalDB = new Tab("Workedstn database", (Node)vbxInternalDB);
        Tab tbGui = new Tab("GUI", (Node)vbxGuiOptions);
        tabPaneOptions.getTabs().addAll((Object[])new Tab[]{tbStationSettings, tbLogSynchSet, tbTRXSynchSet, tbAirScoutSettings, tbNotify, tbShorts, tbBeacon, tbMsgHandling, tbInternalDB, tbGui});
        optionsPanel.setLeft((Node)tabPaneOptions);
        HBox vbxButtons = new HBox();
        vbxButtons.setPadding(new Insets(20.0, 20.0, 20.0, 20.0));
        Button btnOptionsPnlApply = new Button("Apply/Close prefs");
        btnOptionsPnlApply.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Kst4ContestApplication.this.settingsStage.hide();
            }
        });
        final Button btnOptionspnlDisconnect = new Button("Disconnect & close Chat");
        btnOptionspnlDisconnect.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Kst4ContestApplication.this.closeWindowEvent(null);
            }
        });
        final Button btnOptionspnlDisconnectOnly = new Button("Disconnect");
        btnOptionspnlDisconnectOnly.setDisable(true);
        this.menuItemFileDisconnect.setDisable(true);
        this.menuItemOptionsAwayBack.setDisable(true);
        if (this.chatcontroller.isDisconnected()) {
            btnOptionspnlDisconnectOnly.setDisable(true);
            this.menuItemFileDisconnect.setDisable(true);
            this.menuItemOptionsAwayBack.setDisable(true);
        } else if (this.chatcontroller.isConnectedAndNOTLoggedIn()) {
            btnOptionspnlDisconnectOnly.setDisable(true);
            this.menuItemFileDisconnect.setDisable(true);
            this.menuItemOptionsAwayBack.setDisable(true);
        } else if (this.chatcontroller.isConnectedAndLoggedIn()) {
            btnOptionspnlDisconnectOnly.setDisable(false);
            this.menuItemFileDisconnect.setDisable(false);
            this.menuItemOptionsAwayBack.setDisable(false);
        }
        btnOptionspnlDisconnectOnly.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Kst4ContestApplication.this.chatcontroller.disconnect("ONLYDISCONNECT");
                txtFldCallSign.setDisable(false);
                txtFldPassword.setDisable(false);
                txtFldNameInChatMainCat.setDisable(false);
                txtFldLocator.setDisable(false);
                choiceBxChatChategory.setDisable(false);
                Kst4ContestApplication.this.btnOptionspnlConnect.setDisable(false);
                btnOptionspnlDisconnect.setDisable(false);
                btnOptionspnlDisconnectOnly.setDisable(true);
                txtFldstn_antennaBeamWidthDeg.setDisable(false);
                txtFldstn_qtfDefault.setDisable(false);
                txtFldstn_maxQRBDefault.setDisable(false);
                Kst4ContestApplication.this.menuItemOptionsSetFrequencyAsName.setDisable(true);
                Kst4ContestApplication.this.menuItemOptionsAwayBack.setDisable(true);
                station_chkBxEnableSecondChat.setDisable(false);
                Kst4ContestApplication.this.stn_choiceBxChatChategorySecond.setDisable(false);
            }
        });
        this.btnOptionspnlConnect = new Button("Connect to " + this.chatcontroller.getChatPreferences().getLoginChatCategoryMain().getChatCategoryName(((ChatCategory)choiceBxChatChategory.getSelectionModel().getSelectedItem()).getCategoryNumber()));
        this.btnOptionspnlConnect.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setStn_loginCallSign(txtFldCallSign.getText());
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setStn_loginPassword(txtFldPassword.getText());
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setStn_loginLocatorMainCat(txtFldLocator.getText());
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setStn_loginNameMainCat(txtFldNameInChatMainCat.getText());
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setLoginChatCategoryMain((ChatCategory)choiceBxChatChategory.getSelectionModel().getSelectedItem());
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().setStn_loginNameSecondCat(txtFldNameInChatSecondCat.getText());
                System.out.println("[Info] Main.java: connect clicked, using " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().getStn_loginCallSign() + " / " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().getStn_loginPassword() + " / " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().getStn_loginNameMainCat() + " / " + Kst4ContestApplication.this.chatcontroller.getChatPreferences().getStn_loginLocatorMainCat() + " at category " + choiceBxChatChategory.getSelectionModel().getSelectedItem());
                try {
                    Kst4ContestApplication.this.chatcontroller.execute();
                    btnOptionspnlDisconnectOnly.setDisable(false);
                    Kst4ContestApplication.this.menuItemFileDisconnect.setDisable(false);
                    Kst4ContestApplication.this.menuItemOptionsAwayBack.setDisable(false);
                    Kst4ContestApplication.this.menuItemOptionsSetFrequencyAsName.setDisable(false);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Kst4ContestApplication.this.btnOptionspnlConnect.setDisable(false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Kst4ContestApplication.this.btnOptionspnlConnect.setDisable(false);
                }
                txtFldCallSign.setDisable(true);
                txtFldPassword.setDisable(true);
                txtFldNameInChatMainCat.setDisable(true);
                txtFldNameInChatSecondCat.setDisable(true);
                txtFldLocator.setDisable(true);
                choiceBxChatChategory.setDisable(true);
                txtFldstn_antennaBeamWidthDeg.setDisable(true);
                txtFldstn_qtfDefault.setDisable(true);
                txtFldstn_maxQRBDefault.setDisable(true);
                Kst4ContestApplication.this.btnOptionspnlConnect.setDisable(true);
                btnOptionspnlDisconnect.setDisable(false);
                Kst4ContestApplication.this.chatcontroller.setConnectedAndLoggedIn(true);
                Kst4ContestApplication.this.chatcontroller.setDisconnected(false);
                station_chkBxEnableSecondChat.setDisable(true);
                Kst4ContestApplication.this.stn_choiceBxChatChategorySecond.setDisable(true);
            }
        });
        Button btn_preferences_saveAsDefault = new Button("Save settings");
        btn_preferences_saveAsDefault.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                System.out.println("saved");
                Kst4ContestApplication.this.chatcontroller.getChatPreferences().writePreferencesToXmlFile();
                Alert a = new Alert(Alert.AlertType.INFORMATION);
                a.setTitle("Info");
                a.setHeaderText("Settings are stored as default to the xml config file:");
                a.setContentText(Kst4ContestApplication.this.chatcontroller.getChatPreferences().getStoreAndRestorePreferencesFileName());
                a.show();
            }
        });
        vbxButtons.getChildren().addAll((Object[])new Node[]{this.btnOptionspnlConnect, btn_preferences_saveAsDefault, btnOptionsPnlApply, btnOptionspnlDisconnect, btnOptionspnlDisconnectOnly});
        AnchorPane anchorPaneOkAndSave = new AnchorPane();
        AnchorPane.setRightAnchor((Node)vbxButtons, (Double)10.0);
        AnchorPane.setBottomAnchor((Node)vbxButtons, (Double)10.0);
        anchorPaneOkAndSave.getChildren().addAll((Object[])new Node[]{vbxButtons});
        optionsPanel.setBottom((Node)anchorPaneOkAndSave);
        this.settingsScene = new Scene((Parent)optionsPanel, this.chatcontroller.getChatPreferences().getGUIsettingsStageSceneSizeHW()[0], this.chatcontroller.getChatPreferences().getGUIsettingsStageSceneSizeHW()[1]);
        this.settingsScene.getStylesheets().add((Object)STYLE_DEFAULTCSSDAY_FILE);
        this.settingsStage.setScene(this.settingsScene);
        this.settingsStage.show();
    }

    public boolean uiHelper_recolorQtfDirectionButtonsExceptThisOne(Button exceptThisButton) {
        for (int i = 0; i < this.btnQtfButtonsAvl.length; ++i) {
        }
        return true;
    }

    public HBox generateLabeledSeparator(int width, String labelofSeperator) {
        HBox labeledSeparator = new HBox();
        Label lblInfo = new Label(labelofSeperator);
        Separator leftSeparator = new Separator();
        leftSeparator.setPrefWidth((double)width);
        Separator rightSeparator = new Separator();
        rightSeparator.setPrefWidth((double)width);
        labeledSeparator.getChildren().add((Object)leftSeparator);
        labeledSeparator.getChildren().add((Object)lblInfo);
        labeledSeparator.getChildren().add((Object)rightSeparator);
        labeledSeparator.setAlignment(Pos.CENTER);
        return labeledSeparator;
    }

    private void closeWindowEvent(WindowEvent event) {
        System.out.println("Window close request ...");
        Alert alert = new Alert(Alert.AlertType.WARNING);
        alert.getButtonTypes().remove((Object)ButtonType.OK);
        alert.getButtonTypes().add((Object)ButtonType.CANCEL);
        alert.getButtonTypes().add((Object)ButtonType.YES);
        alert.setTitle("Quit application");
        alert.setContentText(String.format("Do you want to disconnect from the Chat?", new Object[0]));
        Optional res = alert.showAndWait();
        if (res.isPresent() && !((ButtonType)res.get()).equals(ButtonType.CANCEL)) {
            System.out.println("closewindowevent: Platform.exit");
            Platform.exit();
        }
    }

    public static void alertWindowEvent(String warning) {
        System.out.println("Alert due to ... " + warning);
        Alert alert = new Alert(Alert.AlertType.WARNING);
        alert.setTitle("WARNING");
        alert.setContentText(String.format(warning, new Object[0]));
        alert.show();
    }

    public static void main(String[] args) {
        Kst4ContestApplication.launch((String[])args);
    }

    @Override
    public void onThreadStatusChanged(String key, ThreadStateMessage threadStateMessage) {
        Platform.runLater(() -> this.updateStatusButton(key, threadStateMessage));
    }
}

