/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.controller;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kst4contest.controller.ChatController;
import kst4contest.controller.ThreadStatusCallback;
import kst4contest.controller.Utils4KST;
import kst4contest.model.ChatMember;
import kst4contest.model.ThreadStateMessage;
import kst4contest.view.GuiUtils;

public class ReadUDPByWintestThread
extends Thread {
    private DatagramSocket socket;
    private ChatController client;
    private volatile boolean running = true;
    private int PORT = 9871;
    private static final int BUFFER_SIZE = 4096;
    private final Map<Integer, String> receivedQsos = new ConcurrentHashMap<Integer, String>();
    private long lastPacketTime = 0L;
    private String myStation = "DO5AMF";
    private String targetStation = "";
    private String stationID = "";
    private int lastKnownQso = 0;
    private ThreadStatusCallback callBackToController;
    private String ThreadNickName = "Wintest-msg";

    public ReadUDPByWintestThread(ChatController client, ThreadStatusCallback callback) {
        this.callBackToController = callback;
        this.client = client;
        this.myStation = client.getChatPreferences().getStn_loginCallSignRaw();
        this.PORT = client.getChatPreferences().getLogsynch_wintestNetworkPort();
    }

    @Override
    public void interrupt() {
        this.running = false;
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
        super.interrupt();
    }

    @Override
    public void run() {
        ThreadStateMessage threadStateMessage = new ThreadStateMessage(this.ThreadNickName, true, "initialized", false);
        this.callBackToController.onThreadStatus(this.ThreadNickName, threadStateMessage);
        Thread.currentThread().setName("ReadUDPByWintestThread");
        byte[] buffer = new byte[4096];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        try {
            this.socket = new DatagramSocket(null);
            this.socket.setReuseAddress(true);
            this.socket.bind(new InetSocketAddress(this.client.getChatPreferences().getLogsynch_wintestNetworkPort()));
            this.socket.setSoTimeout(3000);
            System.out.println("[WinTest UDP listener] started at port: " + this.PORT);
        }
        catch (SocketException e) {
            e.printStackTrace();
            return;
        }
        while (this.running) {
            try {
                this.socket.receive(packet);
                String msg = new String(packet.getData(), 0, packet.getLength(), StandardCharsets.US_ASCII).trim();
                this.processWinTestMessage(msg);
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (IOException iOException) {}
        }
    }

    private void processWinTestMessage(String msg) {
        this.lastPacketTime = System.currentTimeMillis();
        if (msg.startsWith("HELLO:")) {
            this.parseHello(msg);
        } else if (msg.startsWith("ADDQSO:")) {
            try {
                this.parseAddQso(msg);
            }
            catch (Exception e) {
                ThreadStateMessage threadStateMessage = new ThreadStateMessage(this.ThreadNickName, true, "Parsing ERROR: " + Arrays.toString(e.getStackTrace()), true);
                this.callBackToController.onThreadStatus(this.ThreadNickName, threadStateMessage);
            }
        } else if (!msg.startsWith("IHAVE:") && msg.contains("POISONPILL_KILLTHREAD")) {
            System.out.println("ReadUdpByWintest, Info: got poison, now dieing....");
            this.socket.close();
            this.running = false;
        }
        ThreadStateMessage threadStateMessage = new ThreadStateMessage(this.ThreadNickName, true, "message received\n" + msg, false);
        this.callBackToController.onThreadStatus(this.ThreadNickName, threadStateMessage);
    }

    private void parseHello(String msg) {
        try {
            String[] tokens = msg.split("\"");
            if (tokens.length >= 2) {
                this.targetStation = tokens[1];
                System.out.println("[WinTest rcv: found logger instance: " + this.targetStation);
            }
        }
        catch (Exception e) {
            System.out.println("[WinTest] ERROR on HELLO-Parsing: " + e.getMessage());
        }
    }

    private byte util_calculateChecksum(byte[] bytes) {
        int sum = 0;
        for (byte b : bytes) {
            sum += b;
        }
        return (byte)((sum | 0x80) & 0xFF);
    }

    private void parseAddQso(String msg) {
        ChatMember modifyThat = null;
        try {
            boolean isInChat;
            String callSignCatched = msg.split("\"")[7];
            ChatMember workedCall = new ChatMember();
            workedCall.setCallSign(callSignCatched);
            workedCall.setWorked(true);
            ArrayList<Integer> markTheseChattersAsWorked = this.client.checkListForChatMemberIndexesByCallSign(workedCall);
            String bandId = msg.split("\"")[6].split(" ")[4].trim();
            switch (bandId) {
                case "10": {
                    workedCall.setWorked50(true);
                    break;
                }
                case "11": {
                    workedCall.setWorked70(true);
                    break;
                }
                case "12": {
                    workedCall.setWorked144(true);
                    break;
                }
                case "14": {
                    workedCall.setWorked432(true);
                    break;
                }
                case "16": {
                    workedCall.setWorked1240(true);
                    break;
                }
                case "17": {
                    workedCall.setWorked2300(true);
                    break;
                }
                case "18": {
                    workedCall.setWorked3400(true);
                    break;
                }
                case "19": {
                    workedCall.setWorked5600(true);
                    break;
                }
                case "20": {
                    workedCall.setWorked10G(true);
                    break;
                }
                case "21": {
                    workedCall.setWorked24G(true);
                    break;
                }
                case "22": {
                    workedCall.setWorked47G(true);
                    break;
                }
                case "23": {
                    workedCall.setWorked76G(true);
                    break;
                }
                default: {
                    System.out.println("[WinTestUDPRcvr: warning] Unbekannte Band-ID: " + bandId);
                }
            }
            if (!markTheseChattersAsWorked.isEmpty()) {
                Object object = markTheseChattersAsWorked.iterator();
                while (object.hasNext()) {
                    int index = (Integer)object.next();
                    modifyThat = (ChatMember)this.client.getLst_chatMemberList().get(index);
                    modifyThat.setWorked(true);
                    if (workedCall.isWorked50()) {
                        modifyThat.setWorked50(true);
                    } else if (workedCall.isWorked70()) {
                        modifyThat.setWorked70(true);
                    } else if (workedCall.isWorked144()) {
                        modifyThat.setWorked144(true);
                    } else if (workedCall.isWorked432()) {
                        modifyThat.setWorked432(true);
                    } else if (workedCall.isWorked1240()) {
                        modifyThat.setWorked1240(true);
                    } else if (workedCall.isWorked2300()) {
                        modifyThat.setWorked2300(true);
                    } else if (workedCall.isWorked3400()) {
                        modifyThat.setWorked3400(true);
                    } else if (workedCall.isWorked5600()) {
                        modifyThat.setWorked5600(true);
                    } else if (workedCall.isWorked10G()) {
                        modifyThat.setWorked10G(true);
                    } else if (workedCall.isWorked24G()) {
                        modifyThat.setWorked24G(true);
                    } else if (workedCall.isWorked()) {
                        modifyThat.setWorked50(true);
                    } else if (workedCall.isWorked50()) {
                        modifyThat.setWorked50(true);
                    } else {
                        modifyThat.setWorked50(workedCall.isWorked50());
                    }
                    modifyThat.setWorked70(workedCall.isWorked70());
                    modifyThat.setWorked144(workedCall.isWorked144());
                    modifyThat.setWorked432(workedCall.isWorked432());
                    modifyThat.setWorked1240(workedCall.isWorked1240());
                    modifyThat.setWorked2300(workedCall.isWorked2300());
                    modifyThat.setWorked3400(workedCall.isWorked3400());
                    modifyThat.setWorked5600(workedCall.isWorked5600());
                    modifyThat.setWorked10G(workedCall.isWorked10G());
                    modifyThat.setWorked24G(workedCall.isWorked24G());
                    modifyThat.setWorked47G(workedCall.isWorked47G());
                    modifyThat.setWorked76G(workedCall.isWorked76G());
                }
                try {
                    GuiUtils.triggerGUIFilteredChatMemberListChange(this.client);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!(isInChat = this.client.getDbHandler().updateWkdInfoOnChatMember(workedCall))) {
                workedCall.setName("unknown");
                workedCall.setQra("unknown");
                workedCall.setLastActivity(new Utils4KST().time_generateActualTimeInDateFormat());
                this.client.getDbHandler().storeChatMember(workedCall);
            }
            File logUDPMessageToThisFile = new File(this.client.getChatPreferences().getLogSynch_storeWorkedCallSignsFileNameUDPMessageBackup());
            FileWriter fileWriterPersistUDPToFile = null;
            try {
                fileWriterPersistUDPToFile = new FileWriter(logUDPMessageToThisFile, true);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            BufferedWriter bufwrtrRawMSGOut = new BufferedWriter(fileWriterPersistUDPToFile);
            if (modifyThat != null) {
                bufwrtrRawMSGOut.write("\n" + modifyThat.toString());
                bufwrtrRawMSGOut.flush();
                bufwrtrRawMSGOut.close();
            } else {
                bufwrtrRawMSGOut.write("\n" + workedCall.toString());
                bufwrtrRawMSGOut.flush();
                bufwrtrRawMSGOut.close();
            }
            System.out.println("[WinTest, Info: Marking Chatmember as worked: " + workedCall.toString());
        }
        catch (Exception e) {
            System.out.println("[WinTest] Fehler beim ADDQSO-Parsing: " + e.getMessage());
        }
    }
}

