/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.controller;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import kst4contest.controller.ChatController;
import kst4contest.controller.ThreadStatusCallback;
import kst4contest.controller.Utils4KST;
import kst4contest.locatorUtils.DirectionUtils;
import kst4contest.locatorUtils.Location;
import kst4contest.model.AirPlaneReflectionInfo;
import kst4contest.model.ChatCategory;
import kst4contest.model.ChatMember;
import kst4contest.model.ChatMessage;
import kst4contest.model.ClusterMessage;
import kst4contest.model.ThreadStateMessage;

public class MessageBusManagementThread
extends Thread {
    int index;
    private String ThreadNickName = "MessageBus";
    private ThreadStatusCallback callBackToController;
    private PrintWriter writer;
    private ChatController client;
    private boolean serverReady = true;
    private Hashtable<String, ChatMember> chatMemberTable;
    private final String PTRN_USERLISTENTRY = "([a-zA-Z0-9]{2}/{1})?([a-zA-Z0-9]{1,3}[0-9][a-zA-Z0-9]{0,3}[a-zA-Z]{0,3})(/p)? [a-zA-Z]{2}[0-9]{2}[a-zA-Z]{2} [ -~]{1,20}";
    private final String PTRN_QRG_CAT2 = "(([0-9]{3,4}[\\.|,| ]?[0-9]{3})([\\.|,][\\d]{1,2})?)|(([a-zA-Z][0-4]{1}[\\d]{2}\\b)([\\.|,][\\d]{1,2}\\b)?)|((\\b[0-4]{1}[\\d]{2}\\b)([\\.|,][\\d]{1,2}\\b)?)";
    private final String PTRN_QRG_CAT3 = "(([0-9]{3,5}[\\.|,| ]?[0-9]{3})([\\.|,][\\d]{1,2})?)|(([a-zA-Z][0-4]{1}[\\d]{2}\\b)([\\.|,][\\d]{1,2}\\b)?)|((\\b[0-4]{1}[\\d]{2}\\b)([\\.|,][\\d]{1,2}\\b)?)";

    public boolean isServerready() {
        return this.serverReady;
    }

    public void setServerready(boolean serverReady) {
        this.serverReady = serverReady;
    }

    public MessageBusManagementThread(ChatController client, ThreadStatusCallback callBack) {
        this.callBackToController = callBack;
        this.client = client;
        ThreadStateMessage threadStateMessage = new ThreadStateMessage(this.ThreadNickName, true, "initialized", false);
        this.callBackToController.onThreadStatus(this.ThreadNickName, threadStateMessage);
    }

    private void checkIfItsUserListEntry(ChatMessage messageToProcess) {
        Pattern pattern = Pattern.compile("([a-zA-Z0-9]{2}/{1})?([a-zA-Z0-9]{1,3}[0-9][a-zA-Z0-9]{0,3}[a-zA-Z]{0,3})(/p)? [a-zA-Z]{2}[0-9]{2}[a-zA-Z]{2} [ -~]{1,20}");
        Matcher matcher = pattern.matcher(messageToProcess.getMessageText());
        while (matcher.find()) {
            ChatMember member = new ChatMember();
            String matchedString = matcher.group();
            String[] splittedUserString = matchedString.split(" ");
            member.setCallSign(splittedUserString[0]);
            member.setQra(splittedUserString[1]);
            Object stringAggregation = "";
            for (int i = 2; i < splittedUserString.length; ++i) {
                stringAggregation = (String)stringAggregation + splittedUserString[i] + " ";
            }
            member.setName((String)stringAggregation);
        }
    }

    private void checkIfItsUserListEntry23001(ChatMessage messageToProcess) {
        Pattern pattern = Pattern.compile("([a-zA-Z0-9]{2}/{1})?([a-zA-Z0-9]{1,3}[0-9][a-zA-Z0-9]{0,3}[a-zA-Z]{0,3})(/p)? [a-zA-Z]{2}[0-9]{2}[a-zA-Z]{2} [ -~]{1,20}");
        Matcher matcher = pattern.matcher(messageToProcess.getMessageText());
        while (matcher.find()) {
            ChatMember member = new ChatMember();
            String matchedString = matcher.group();
            String[] splittedUserString = matchedString.split(" ");
            member.setCallSign(splittedUserString[0]);
            member.setQra(splittedUserString[1]);
            Object stringAggregation = "";
            for (int i = 2; i < splittedUserString.length; ++i) {
                stringAggregation = (String)stringAggregation + splittedUserString[i] + " ";
            }
            member.setName((String)stringAggregation);
        }
    }

    private String checkIfMessageInhibitsFrequency(ChatMessage messageToProcess) {
        Pattern pattern = Pattern.compile("(([0-9]{3,4}[\\.|,| ]?[0-9]{3})([\\.|,][\\d]{1,2})?)|(([a-zA-Z][0-4]{1}[\\d]{2}\\b)([\\.|,][\\d]{1,2}\\b)?)|((\\b[0-4]{1}[\\d]{2}\\b)([\\.|,][\\d]{1,2}\\b)?)");
        Matcher matcher = pattern.matcher(messageToProcess.getMessageText());
        Object stringAggregation = "";
        while (matcher.find()) {
            String[] splittedQRGString;
            String matchedString = matcher.group();
            for (String s : splittedQRGString = matchedString.split(" ")) {
                stringAggregation = (String)stringAggregation + s + " ";
            }
            System.out.println("[MSGBUSMGT:] Processed qrg info: " + (String)stringAggregation);
        }
        return stringAggregation;
    }

    private void processRXMessage23000(ChatMessage messageToProcess) {
        String reduce = new String(messageToProcess.getMessageText());
        reduce = reduce.replaceAll("\\s+", " ");
        messageToProcess.setMessageText(reduce);
        if (!messageToProcess.getMessageText().isEmpty()) {
            if (reduce.length() >= 14 && reduce.length() <= 40) {
                this.checkIfItsUserListEntry(messageToProcess);
            }
            this.checkIfMessageInhibitsFrequency(messageToProcess);
        }
    }

    private int checkListForChatMemberIndexByCallSign(ObservableList<ChatMember> list, ChatMember lookForThis) {
        if (lookForThis == null) {
            System.out.println("[ChecklistForChatMemberIndexByCallsign] ERROR: null Value for Chatmember detected! Member cannot be in the list!");
            return -1;
        }
        if (lookForThis.getCallSign() == null) {
            System.out.println("[ChecklistForChatMemberIndexByCallsign] ERROR: null Value in Callsign detected! Member cannot be in the list!");
            return -1;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!((ChatMember)list.get(i)).getCallSign().equals(lookForThis.getCallSign())) continue;
            System.out.println("MSGBUSMGT, DEBUG: Checking Chatcategories of found list member " + ((ChatMember)list.get(i)).getCallSign() + " / " + ((ChatMember)list.get(i)).getChatCategory() + " against " + lookForThis.getCallSign() + " / " + lookForThis.getChatCategory());
            if (((ChatMember)list.get(i)).getChatCategory().equals(lookForThis.getChatCategory())) {
                return list.indexOf(list.get(i));
            }
            System.out.println("MSGBUSMGT, DEBUG: Category does not match");
            System.out.println("--------------------------- chatcategory of lookforthisChatMember = " + lookForThis.getChatCategory().getCategoryNumber());
        }
        return -1;
    }

    private void processRXMessage23001(ChatMessage messageToProcess) throws IOException, SQLException {
        ThreadStateMessage threadStateMessage = new ThreadStateMessage(this.ThreadNickName, true, "Last message processed:\n" + messageToProcess.getMessageText(), false);
        this.callBackToController.onThreadStatus(this.ThreadNickName, threadStateMessage);
        String INITIALUSERLISTENTRY = "UA0";
        String USERENTEREDCHAT = "UA5";
        String USERENTEREDCHAT2 = "UA2";
        String initialChatHistoryEntry = "CR";
        String SERVERMESSAGE = "CR";
        String USERLEFTCHAT = "UR6";
        String USERLEFTCHAT2 = "UR7";
        String CHATCHANNELMESSAGE = "CH";
        String REGISTREDUSERCOUNT = "UE";
        String USERSTATECHANGE = "US4";
        String USERLOCATORCHANGE = "LOC";
        String USERINFOUPDATEORUSERISBACK = "UM3";
        String DXCLUSTERMESSAGE1 = "DM";
        String DXCLUSTERMESSAGE2 = "DL";
        String DXCLUSTERMESSAGE3 = "MA";
        String SRVR_DXCEND = "DF";
        String SRVR_USERLISTEND = "UE";
        String SRVR_COMMUNICATIONK = "CK";
        String SRVR_LOGSTAT = "LOGSTAT";
        String SRVR_LOGSTAT_WRONGPASSWORD = "Wrong password!";
        String SRVR_LOGINOK = "100";
        String SRVR_LOGINWRONGPW = "114";
        String SRVR_LOGINWRONGEMPTYCALL = "102";
        String SRVR_LOGINWRONGCALLSYNTAX = "103";
        String SRVR_LOGINWRONGCALLUNKNOWN = "101";
        HashSet<String> qrgQuestionTexts = new HashSet<String>();
        qrgQuestionTexts.add("ur qrg?");
        qrgQuestionTexts.add("your qrg?");
        qrgQuestionTexts.add("qrg?");
        qrgQuestionTexts.add("freq?");
        qrgQuestionTexts.add("pse QRG");
        if (!messageToProcess.getMessageText().isEmpty()) {
            String[] splittedMessageLine;
            if (messageToProcess.getMessageText().contains("LOGSTAT")) {
                String[] logstatMessage = messageToProcess.getMessageText().split("\\|");
                if (logstatMessage[1].contains("100")) {
                    this.client.setConnectedAndLoggedIn(true);
                } else {
                    this.client.setConnectedAndNOTLoggedIn(true);
                    this.client.setConnectedAndLoggedIn(false);
                }
            }
            if ((splittedMessageLine = messageToProcess.getMessageText().split("\\|"))[0].contains("UA0")) {
                ChatMember newMember = new ChatMember();
                newMember.setAirPlaneReflectInfo(new AirPlaneReflectionInfo());
                newMember.setChatCategory(this.util_getChatCategoryByCategoryNrString(splittedMessageLine[1]));
                newMember.setCallSign(splittedMessageLine[2]);
                newMember.setName(splittedMessageLine[3]);
                newMember.setQra(splittedMessageLine[4]);
                newMember.setState(Integer.parseInt(splittedMessageLine[5]));
                newMember.setQrb(new Location().getDistanceKmByTwoLocatorStrings(this.client.getChatPreferences().getStn_loginLocatorMainCat(), newMember.getQra()));
                newMember.setQTFdirection(new Location(this.client.getChatPreferences().getStn_loginLocatorMainCat()).getBearing(new Location(newMember.getQra())));
                newMember.setLastActivity(new Utils4KST().time_generateActualTimeInDateFormat());
                newMember.setActivityTimeLastInEpoch(new Utils4KST().time_generateCurrentEpochTime());
                if (!this.client.getChatPreferences().getStn_loginCallSign().equals(newMember.getCallSign())) {
                    this.client.getLst_chatMemberList().add((Object)newMember);
                }
                this.client.getDbHandler().storeChatMember(newMember);
            } else if (splittedMessageLine[0].contains("UA5") || splittedMessageLine[0].contains("UA2")) {
                if (!this.client.getChatPreferences().getStn_loginCallSign().equals(splittedMessageLine[2])) {
                    ChatMember newMember = new ChatMember();
                    newMember.setAirPlaneReflectInfo(new AirPlaneReflectionInfo());
                    newMember.setChatCategory(this.util_getChatCategoryByCategoryNrString(splittedMessageLine[1]));
                    newMember.setCallSign(splittedMessageLine[2]);
                    newMember.setName(splittedMessageLine[3]);
                    newMember.setQra(splittedMessageLine[4]);
                    newMember.setState(Integer.parseInt(splittedMessageLine[5]));
                    newMember.setLastActivity(new Utils4KST().time_generateActualTimeInDateFormat());
                    newMember.setActivityTimeLastInEpoch(new Utils4KST().time_generateCurrentEpochTime());
                    newMember.setQrb(new Location().getDistanceKmByTwoLocatorStrings(this.client.getChatPreferences().getStn_loginLocatorMainCat(), newMember.getQra()));
                    newMember.setQTFdirection(new Location(this.client.getChatPreferences().getStn_loginLocatorMainCat()).getBearing(new Location(newMember.getQra())));
                    newMember = this.client.getDbHandler().fetchChatMemberWkdDataForOnlyOneCallsignFromDB(newMember);
                    this.client.getLst_chatMemberList().add((Object)newMember);
                    this.client.getDbHandler().storeChatMember(newMember);
                }
            } else if (splittedMessageLine[0].contains("UR6") || splittedMessageLine[0].contains("UR7")) {
                ChatMember newMember = new ChatMember();
                newMember.setChatCategory(this.util_getChatCategoryByCategoryNrString(splittedMessageLine[1]));
                newMember.setCallSign(splittedMessageLine[2]);
                System.out.println("[MSGBUSMGT, Info:] User left Chat and will be removed from list [" + this.client.getLst_chatMemberList().size() + "] :" + newMember.getCallSign());
                try {
                    this.client.getLst_chatMemberList().remove(this.checkListForChatMemberIndexByCallSign(this.client.getLst_chatMemberList(), newMember));
                }
                catch (Exception e) {
                    System.out.println("[MSGBUSMGT, EXC!, Error:] User sent left chat but had not been there ... [" + this.client.getLst_chatMemberList().size() + "] :" + newMember.getCallSign() + "\n" + e.getStackTrace());
                }
            } else if (splittedMessageLine[0].contains("CH")) {
                ChatCategory chategoryForMessageAndMessageSender;
                ChatMessage newMessageArrived;
                block76: {
                    int index;
                    ChatMember dummy;
                    newMessageArrived = new ChatMessage();
                    newMessageArrived.setChatCategory(this.util_getChatCategoryByCategoryNrString(splittedMessageLine[1]));
                    chategoryForMessageAndMessageSender = newMessageArrived.getChatCategory();
                    newMessageArrived.setMessageGeneratedTime(splittedMessageLine[2]);
                    if (splittedMessageLine[3].equals("SERVER")) {
                        dummy = new ChatMember();
                        dummy.setCallSign("SERVER");
                        dummy.setName("Sysop");
                        newMessageArrived.setSender(dummy);
                        newMessageArrived.setChatCategory(this.util_getChatCategoryByCategoryNrString(splittedMessageLine[1]));
                        dummy.setChatCategory(this.util_getChatCategoryByCategoryNrString(splittedMessageLine[1]));
                    } else {
                        ChatMember sender = new ChatMember();
                        sender.setCallSign(splittedMessageLine[3]);
                        sender.setChatCategory(chategoryForMessageAndMessageSender);
                        index = this.checkListForChatMemberIndexByCallSign(this.client.getLst_chatMemberList(), sender);
                        if (index != -1) {
                            try {
                                newMessageArrived.setSender((ChatMember)this.client.getLst_chatMemberList().get(index));
                                ((ChatMember)this.client.getLst_chatMemberList().get(index)).setActivityTimeLastInEpoch(new Utils4KST().time_generateCurrentEpochTime());
                            }
                            catch (Exception exc) {
                                ChatMember aSenderDummy = new ChatMember();
                                aSenderDummy.setCallSign(splittedMessageLine[3] + "[n/a]");
                                aSenderDummy.setAirPlaneReflectInfo(new AirPlaneReflectionInfo());
                                newMessageArrived.setSender(aSenderDummy);
                                System.out.println("MsgBusmgtT: Catched Error! " + exc.getMessage() + " // " + splittedMessageLine[3] + " is not in the list! Faking sender!");
                                exc.printStackTrace();
                            }
                        } else if (!sender.getCallSign().equals(this.client.getChatPreferences().getStn_loginCallSign().toUpperCase())) {
                            sender.setCallSign("[n/a]" + sender.getCallSign());
                        } else {
                            ChatMember dummy2 = new ChatMember();
                            dummy2.setCallSign("ALL");
                            newMessageArrived.setReceiver(dummy2);
                            AirPlaneReflectionInfo preventNullpointerExc = new AirPlaneReflectionInfo();
                            preventNullpointerExc.setAirPlanesReachableCntr(0);
                            sender.setAirPlaneReflectInfo(preventNullpointerExc);
                            newMessageArrived.setSender(sender);
                        }
                    }
                    newMessageArrived.setMessageSenderName(splittedMessageLine[4]);
                    newMessageArrived.setMessageText(splittedMessageLine[6]);
                    if (splittedMessageLine[7].equals("0")) {
                        dummy = new ChatMember();
                        dummy.setCallSign("ALL");
                        newMessageArrived.setReceiver(dummy);
                        this.client.getLst_globalChatMessageList().add(0, (Object)newMessageArrived);
                    } else {
                        ChatMember receiver = new ChatMember();
                        receiver.setChatCategory(chategoryForMessageAndMessageSender);
                        receiver.setCallSign(splittedMessageLine[7]);
                        index = this.checkListForChatMemberIndexByCallSign(this.client.getLst_chatMemberList(), receiver);
                        if (index != -1) {
                            newMessageArrived.setReceiver((ChatMember)this.client.getLst_chatMemberList().get(index));
                        } else if (receiver.getCallSign().equals(this.client.getChatPreferences().getStn_loginCallSign())) {
                            receiver.setCallSign(this.client.getChatPreferences().getStn_loginCallSign());
                            newMessageArrived.setReceiver(receiver);
                        } else {
                            receiver.setCallSign(receiver.getCallSign() + "(left)");
                            newMessageArrived.setReceiver(receiver);
                        }
                        try {
                            if (newMessageArrived.getReceiver().getCallSign().equals(this.client.getChatPreferences().getStn_loginCallSign())) {
                                this.client.getLst_globalChatMessageList().add(0, (Object)newMessageArrived);
                                if (this.client.getChatPreferences().isNotify_playSimpleSounds()) {
                                    this.client.getPlayAudioUtils().playNoiseLauncher('P');
                                }
                                if (this.client.getChatPreferences().isNotify_playCWCallsignsOnRxedPMs()) {
                                    this.client.getPlayAudioUtils().playCWLauncher("  " + newMessageArrived.getSender().getCallSign().toUpperCase());
                                }
                                if (this.client.getChatPreferences().isNotify_playVoiceCallsignsOnRxedPMs()) {
                                    this.client.getPlayAudioUtils().playVoiceLauncher("?" + newMessageArrived.getSender().getCallSign().toUpperCase());
                                }
                                if (this.client.getChatPreferences().isNotify_playSimpleSounds() && newMessageArrived.getMessageText().toUpperCase().contains("//BELL")) {
                                    this.client.getPlayAudioUtils().playVoiceLauncher("!");
                                }
                                if (this.client.getChatPreferences().isMsgHandling_autoAnswerEnabled()) {
                                    ChatMessage automaticAnswer = new ChatMessage();
                                    ChatMember itsMe = new ChatMember();
                                    itsMe.setCallSign(this.client.getChatPreferences().getStn_loginCallSign());
                                    automaticAnswer.setSender(itsMe);
                                    automaticAnswer.setReceiver(newMessageArrived.getSender());
                                    automaticAnswer.setMessageText("/CQ " + newMessageArrived.getSender().getCallSign() + " " + this.client.getChatPreferences().getMessageHandling_autoAnswerTextMainCat());
                                    this.client.getMessageTXBus().add(automaticAnswer);
                                }
                                if (this.client.getChatPreferences().isMessageHandling_autoAnswerToQRGRequestEnabled()) {
                                    for (String lookForQRGString : qrgQuestionTexts) {
                                        if (!newMessageArrived.getMessageText().contains(lookForQRGString)) continue;
                                        ChatMessage automaticAnswer = new ChatMessage();
                                        ChatMember itsMe = new ChatMember();
                                        itsMe.setCallSign(this.client.getChatPreferences().getStn_loginCallSign());
                                        automaticAnswer.setSender(itsMe);
                                        automaticAnswer.setReceiver(newMessageArrived.getSender());
                                        automaticAnswer.setMessageText("/CQ " + newMessageArrived.getSender().getCallSign() + " KST4Contest Auto: QRG is: " + this.client.getChatPreferences().getMYQRGFirstCat().getValue());
                                        if (this.client.getChatPreferences().isLoginToSecondChatEnabled()) {
                                            automaticAnswer.setMessageText("/CQ " + newMessageArrived.getSender().getCallSign() + " KST4Contest Auto: QRGs: " + this.client.getChatPreferences().getMYQRGFirstCat().getValue() + " / " + this.client.getChatPreferences().getMYQRGSecondCat().getValue());
                                        } else {
                                            automaticAnswer.setMessageText("/CQ " + newMessageArrived.getSender().getCallSign() + " KST4Contest Auto: QRG is: " + this.client.getChatPreferences().getMYQRGFirstCat().getValue());
                                        }
                                        this.client.getMessageTXBus().add(automaticAnswer);
                                    }
                                }
                                System.out.println("message directed to me: " + newMessageArrived.getReceiver().getCallSign() + ".");
                                break block76;
                            }
                            if (newMessageArrived.getSender().getCallSign().toUpperCase().equals(this.client.getChatPreferences().getStn_loginCallSign().toUpperCase())) {
                                String originalMessage = newMessageArrived.getMessageText();
                                newMessageArrived.setMessageText("(>" + newMessageArrived.getReceiver().getCallSign() + ")" + originalMessage);
                                this.client.getLst_globalChatMessageList().add(0, (Object)newMessageArrived);
                                break block76;
                            }
                            if (DirectionUtils.isInAngleAndRange(this.client.getChatPreferences().getStn_loginLocatorMainCat(), newMessageArrived.getSender().getQra(), newMessageArrived.getReceiver().getQra(), this.client.getChatPreferences().getStn_maxQRBDefault(), this.client.getChatPreferences().getStn_antennaBeamWidthDeg())) {
                                if (this.client.getChatPreferences().isNotify_playSimpleSounds() && !newMessageArrived.getSender().isInAngleAndRange()) {
                                    this.client.getPlayAudioUtils().playNoiseLauncher('-');
                                }
                                newMessageArrived.getSender().setInAngleAndRange(true);
                                if (this.client.getChatPreferences().isNotify_dxClusterServerEnabled()) {
                                    try {
                                        if (newMessageArrived.getSender().getFrequency() != null) {
                                            this.client.getDxClusterServer().broadcastSingleDXClusterEntryToLoggers(newMessageArrived.getSender());
                                        }
                                    }
                                    catch (Exception exception) {
                                        System.out.println("[MSGBUSMGT, ERROR:] DXCluster messageserver error while processing spot for 0" + newMessageArrived.getSender().getCallSign() + " // " + exception.getMessage());
                                    }
                                }
                                System.out.println(">>>>>>>>>> Anglewarning <<<<<<<<<< " + newMessageArrived.getSender().getCallSign() + ", " + newMessageArrived.getSender().getQra() + " -> " + newMessageArrived.getReceiver().getCallSign() + ", " + newMessageArrived.getReceiver().getQra() + " = " + new Location(newMessageArrived.getSender().getQra()).getBearing(new Location(newMessageArrived.getReceiver().getQra())) + " / sender bearing to me: " + new Location(newMessageArrived.getSender().getQra()).getBearing(new Location(this.client.getChatPreferences().getStn_loginLocatorMainCat())));
                            } else {
                                System.out.println("-notinangle- " + newMessageArrived.getSender().getCallSign() + ", " + newMessageArrived.getSender().getQra() + " -> " + newMessageArrived.getReceiver().getCallSign() + ", " + newMessageArrived.getReceiver().getQra() + " = " + new Location(newMessageArrived.getSender().getQra()).getBearing(new Location(newMessageArrived.getReceiver().getQra())) + " ; sender bearing to me: " + new Location(newMessageArrived.getSender().getQra()).getBearing(new Location(this.client.getChatPreferences().getStn_loginLocatorMainCat())));
                                newMessageArrived.getSender().setInAngleAndRange(false);
                            }
                            this.client.getLst_globalChatMessageList().add(0, (Object)newMessageArrived);
                        }
                        catch (NullPointerException referenceDeletedByUserLeftChatDuringMessageprocessing) {
                            System.out.println("MSGBS bgfx, <<<catched error>>>: referenced user left the chat during messageprocessing or message got before user entered chat message: " + referenceDeletedByUserLeftChatDuringMessageprocessing.getStackTrace());
                        }
                    }
                }
                try {
                    System.out.println("[MSGBUSMGT:] processed message: " + newMessageArrived.getChatCategory().getCategoryNumber() + " " + newMessageArrived.getSender().getCallSign() + ", " + newMessageArrived.getMessageSenderName() + " -> " + newMessageArrived.getReceiver().getCallSign() + ": " + newMessageArrived.getMessageText());
                }
                catch (Exception exceptionOccured) {
                    System.out.println("[MSGMgtBus: ERROR CHATCHED ON MAYBE NULL ISSUE]: " + exceptionOccured.getMessage() + "\n" + exceptionOccured.getStackTrace());
                }
                String locatedFrequencies = this.checkIfMessageInhibitsFrequency(newMessageArrived);
                SimpleStringProperty qrg = new SimpleStringProperty(locatedFrequencies);
                if (!splittedMessageLine[3].equals("SERVER") && !locatedFrequencies.equals("")) {
                    ChatMember temp3 = new ChatMember();
                    temp3.setCallSign(splittedMessageLine[3]);
                    temp3.setChatCategory(chategoryForMessageAndMessageSender);
                    int index = this.checkListForChatMemberIndexByCallSign(this.client.getLst_chatMemberList(), temp3);
                    if (index == -1) {
                        System.out.println("[MSGBUSMGT <<<catched ERROR>>>]:, Frequency for " + splittedMessageLine[3] + " is not settable, Callsign is not in the Member-list!");
                        ChatMember newMember = new ChatMember();
                        newMember.setCallSign(splittedMessageLine[3]);
                        newMember.setName(splittedMessageLine[4]);
                        newMember.setFrequency((StringProperty)qrg);
                    } else {
                        ((ChatMember)this.client.getLst_chatMemberList().get(index)).setFrequency((StringProperty)qrg);
                        System.out.println("[MSGBUSMGT:] Frequency for " + splittedMessageLine[3] + " setted: " + locatedFrequencies);
                    }
                }
            } else if (splittedMessageLine[0].contains("LOC")) {
                ChatMember temp4 = new ChatMember();
                temp4.setChatCategory(this.client.getChatCategoryMain());
                temp4.setCallSign(splittedMessageLine[2]);
                temp4.setQra(splittedMessageLine[3]);
                temp4.setLastActivity(new Utils4KST().time_generateActualTimeInDateFormat());
                int index = this.checkListForChatMemberIndexByCallSign(this.client.getLst_chatMemberList(), temp4);
                if (index != -1) {
                    System.out.println("[MSGBUSMGT:] Locator Change of [" + splittedMessageLine[2] + "], old was: " + ((ChatMember)this.client.getLst_chatMemberList().get(index)).getQra() + " new is: " + splittedMessageLine[3]);
                    ChatMember foundThisInChatMemberList = (ChatMember)this.client.getLst_chatMemberList().get(index);
                    foundThisInChatMemberList.setQra(splittedMessageLine[3]);
                    foundThisInChatMemberList.setQrb(new Location().getDistanceKmByTwoLocatorStrings(this.client.getChatPreferences().getStn_loginLocatorMainCat(), splittedMessageLine[3]));
                    foundThisInChatMemberList.setQTFdirection(new Location(this.client.getChatPreferences().getStn_loginLocatorMainCat()).getBearing(new Location(splittedMessageLine[3])));
                } else {
                    System.out.println("[MSGBUSMGT:] ERROR! Locator Change of [" + splittedMessageLine[2] + "] is not possible, user is not in the Table!");
                }
                this.client.getDbHandler().storeChatMember(temp4);
            } else if (splittedMessageLine[0].contains("DM")) {
                ClusterMessage dxcMsg = new ClusterMessage();
                dxcMsg.setTimeGenerated(splittedMessageLine[2]);
                ChatMember newDXCListSender = new ChatMember();
                newDXCListSender.setCallSign(splittedMessageLine[4]);
                newDXCListSender.setQra(splittedMessageLine[8]);
                ChatMember newDXCListReceiver = new ChatMember();
                newDXCListReceiver.setFrequency((StringProperty)new SimpleStringProperty(splittedMessageLine[5]));
                newDXCListReceiver.setCallSign(splittedMessageLine[6]);
                newDXCListReceiver.setQra(splittedMessageLine[9]);
                dxcMsg.setSender(newDXCListSender);
                dxcMsg.setReceiver(newDXCListReceiver);
                dxcMsg.setMessageInhibited(splittedMessageLine[7]);
                dxcMsg.setQrgSpotted(splittedMessageLine[5]);
                this.client.getLst_clusterMemberList().add(0, (Object)dxcMsg);
            } else if (splittedMessageLine[0].contains("DL")) {
                ClusterMessage dxcMsg2 = new ClusterMessage();
                dxcMsg2.setTimeGenerated(splittedMessageLine[1]);
                ChatMember newDXCListSender2 = new ChatMember();
                newDXCListSender2.setCallSign(splittedMessageLine[3]);
                newDXCListSender2.setQra(splittedMessageLine[7]);
                ChatMember newDXCListReceiver2 = new ChatMember();
                newDXCListReceiver2.setFrequency((StringProperty)new SimpleStringProperty(splittedMessageLine[4]));
                newDXCListReceiver2.setCallSign(splittedMessageLine[5]);
                newDXCListReceiver2.setQra(splittedMessageLine[8]);
                dxcMsg2.setSender(newDXCListSender2);
                dxcMsg2.setReceiver(newDXCListReceiver2);
                dxcMsg2.setMessageInhibited(splittedMessageLine[6]);
                dxcMsg2.setQrgSpotted(splittedMessageLine[4]);
                this.client.getLst_clusterMemberList().add(0, (Object)dxcMsg2);
            } else if (splittedMessageLine[0].contains("MA")) {
                ClusterMessage dxcMsg3 = new ClusterMessage();
                dxcMsg3.setTimeGenerated(splittedMessageLine[2]);
                ChatMember newDXCListSender3 = new ChatMember();
                newDXCListSender3.setCallSign(splittedMessageLine[3]);
                newDXCListSender3.setQra(splittedMessageLine[5]);
                ChatMember newDXCListReceiver3 = new ChatMember();
                newDXCListReceiver3.setCallSign(splittedMessageLine[4]);
                newDXCListReceiver3.setQra(splittedMessageLine[5]);
                dxcMsg3.setSender(newDXCListSender3);
                dxcMsg3.setReceiver(newDXCListReceiver3);
                dxcMsg3.setMessageInhibited("");
                dxcMsg3.setQrgSpotted("");
                this.client.getLst_clusterMemberList().add(0, (Object)dxcMsg3);
            } else if (splittedMessageLine[0].contains("US4")) {
                ChatMember stateChangeMember = new ChatMember();
                stateChangeMember.setCallSign(splittedMessageLine[2]);
                stateChangeMember.setState(Integer.parseInt(splittedMessageLine[3]));
                stateChangeMember.setChatCategory(this.util_getChatCategoryByCategoryNrString(splittedMessageLine[1]));
                int index = this.checkListForChatMemberIndexByCallSign(this.client.getLst_chatMemberList(), stateChangeMember);
                if (index != -1 && index != 0) {
                    ((ChatMember)this.client.getLst_chatMemberList().get(index)).setState(stateChangeMember.getState());
                }
            } else if (splittedMessageLine[0].contains("UM3")) {
                ChatMember stateChangeMember = new ChatMember();
                stateChangeMember.setChatCategory(this.util_getChatCategoryByCategoryNrString(splittedMessageLine[1]));
                stateChangeMember.setCallSign(splittedMessageLine[2]);
                stateChangeMember.setName(splittedMessageLine[3]);
                stateChangeMember.setQra(splittedMessageLine[4]);
                stateChangeMember.setState(Integer.parseInt(splittedMessageLine[5]));
                stateChangeMember.setLastActivity(new Utils4KST().time_generateActualTimeInDateFormat());
                stateChangeMember.setQrb(new Location().getDistanceKmByTwoLocatorStrings(this.client.getChatPreferences().getStn_loginLocatorMainCat(), stateChangeMember.getQra()));
                stateChangeMember.setQTFdirection(new Location(this.client.getChatPreferences().getStn_loginLocatorMainCat()).getBearing(new Location(stateChangeMember.getQra())));
                this.client.getDbHandler().storeChatMember(stateChangeMember);
                int index = this.checkListForChatMemberIndexByCallSign(this.client.getLst_chatMemberList(), stateChangeMember);
                if (index != -1) {
                    ((ChatMember)this.client.getLst_chatMemberList().get(index)).setName(stateChangeMember.getName());
                    ((ChatMember)this.client.getLst_chatMemberList().get(index)).setQra(stateChangeMember.getQra());
                    ((ChatMember)this.client.getLst_chatMemberList().get(index)).setState(stateChangeMember.getState());
                }
            } else if (!(splittedMessageLine[0].contains("UE") || splittedMessageLine[0].contains("DF") || splittedMessageLine[0].contains("CK"))) {
                if (splittedMessageLine[0].contains("LOGSTAT") && splittedMessageLine.length <= 5) {
                    System.out.println("Passwort falsch!");
                    if (splittedMessageLine[2].contains("password")) {
                        splittedMessageLine[2] = splittedMessageLine[2] + " pse disc- and reconnect";
                    }
                    ChatMember server = new ChatMember();
                    server.setCallSign("SERVER");
                    server.setName("SERVER");
                    ChatMessage pwErrorMsg = new ChatMessage();
                    pwErrorMsg.setMessageGeneratedTime("" + this.client.getCurrentEpochTime());
                    pwErrorMsg.setSender(server);
                    pwErrorMsg.setMessageText(splittedMessageLine[2]);
                    ChatMember receiverDummy = new ChatMember();
                    receiverDummy.setCallSign(this.client.getChatPreferences().getStn_loginCallSign());
                    receiverDummy.setQrb(0.0);
                    receiverDummy.setQTFdirection(0.0);
                    pwErrorMsg.setReceiver(receiverDummy);
                    for (int i = 0; i < 10; ++i) {
                        this.client.getLst_globalChatMessageList().add((Object)pwErrorMsg);
                    }
                    this.client.disconnect("ONLYDISCONNECT");
                } else {
                    System.out.print(new Utils4KST().time_generateCurrentMMDDhhmmTimeString() + " [MSGBUSMGT:] Critical, detected unhandled Chatmessage -> " + messageToProcess.getMessageText() + "\n");
                }
            }
        }
    }

    private ChatCategory util_getChatCategoryByCategoryNrString(String categoryNumber) {
        if (categoryNumber.equals("" + this.client.getChatCategoryMain().getCategoryNumber())) {
            return this.client.getChatCategoryMain();
        }
        if (categoryNumber.equals("" + this.client.getChatCategorySecondChat().getCategoryNumber())) {
            return this.client.getChatCategorySecondChat();
        }
        System.out.println("Msgbusmgt: ERROR!!! -> category for this message does not exist!");
        return this.client.getChatCategoryMain();
    }

    @Override
    public void interrupt() {
        super.interrupt();
    }

    @Override
    public void run() {
        ChatMessage messageTextRaw = new ChatMessage();
        block5: while (true) {
            try {
                while (true) {
                    if ((messageTextRaw = this.client.getMessageRXBus().take()).getMessageText().equals("POISONPILL_KILLTHREAD") && messageTextRaw.getMessageSenderName().equals("POISONPILL_KILLTHREAD")) {
                        this.client.getMessageRXBus().clear();
                        break block5;
                    }
                    String messageLine = messageTextRaw.getMessageText();
                    if (messageTextRaw.getMessageText() == null) {
                        System.out.println("[MSGBUSMGT:] ERROR! got NULL message! BYE!");
                    }
                    messageLine = messageTextRaw.getMessageText();
                    System.out.println(messageTextRaw.getMessageText() + " <- RXed");
                    try {
                        this.processRXMessage23001(messageTextRaw);
                        continue block5;
                    }
                    catch (IOException e) {
                        System.out.println("MsgBusMgt: process23001 went wrong / IO Error");
                        e.printStackTrace();
                        continue;
                    }
                    catch (SQLException e) {
                        System.out.println("MsgBusMgt: process23001 went wrong / SQL Error");
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e1) {
                this.interrupt();
                e1.printStackTrace();
                break;
            }
        }
        System.out.println("Msgbusmgt: interrupt");
        this.interrupt();
    }
}

