/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.controller;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.sql.SQLException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import kst4contest.controller.AirScoutPeriodicalAPReflectionInquirerTask;
import kst4contest.controller.BeaconTask;
import kst4contest.controller.DBController;
import kst4contest.controller.DXClusterThreadPooledServer;
import kst4contest.controller.InputReaderThread;
import kst4contest.controller.MessageBusManagementThread;
import kst4contest.controller.PstRotatorClient;
import kst4contest.controller.ReadThread;
import kst4contest.controller.ReadUDPByWintestThread;
import kst4contest.controller.ReadUDPbyAirScoutMessageThread;
import kst4contest.controller.ReadUDPbyUCXMessageThread;
import kst4contest.controller.StatusUpdateListener;
import kst4contest.controller.ThreadStatusCallback;
import kst4contest.controller.UpdateChecker;
import kst4contest.controller.UserActualizationTask;
import kst4contest.controller.WriteThread;
import kst4contest.controller.interfaces.PstRotatorEventListener;
import kst4contest.controller.keepAliveMessageSenderTask;
import kst4contest.model.ChatCategory;
import kst4contest.model.ChatMember;
import kst4contest.model.ChatMessage;
import kst4contest.model.ChatPreferences;
import kst4contest.model.ClusterMessage;
import kst4contest.model.ThreadStateMessage;
import kst4contest.model.UpdateInformation;
import kst4contest.utils.PlayAudioUtils;
import kst4contest.view.Kst4ContestApplication;

public class ChatController
implements ThreadStatusCallback,
PstRotatorEventListener {
    private PstRotatorClient rotatorClient;
    private Consumer<Double> viewRotorCallback;
    private Kst4ContestApplication view;
    private StatusUpdateListener statusListener;
    private UpdateInformation updateInformation;
    private ChatPreferences chatPreferences;
    private ChatCategory chatCategoryMain;
    private ChatCategory chatCategorySecondChat;
    boolean connectedAndLoggedIn;
    boolean connectedAndNOTLoggedIn;
    boolean disconnected;
    boolean disconnectionPerformedByUser = false;
    private String userName;
    private String password;
    private String showedName;
    private String qra;
    private String chatState;
    private String hostname = "109.90.0.130";
    private String praktiKSTVersionInfo = "2022-10 - 2022-12\ndeveloped by DO5AMF, Marc\nContact: praktimarc@gmail.com\nDonations via paypal are welcome";
    private int port = 23001;
    private ReadUDPbyUCXMessageThread readUDPbyUCXThread;
    private ReadUDPByWintestThread readUDPByWintestThread;
    private WriteThread writeThread;
    private ReadThread readThread;
    private InputReaderThread consoleReader;
    private ChatMember ownChatMemberObject;
    private ChatController chatController;
    private MessageBusManagementThread messageProcessor;
    private ReadUDPbyAirScoutMessageThread airScoutUDPReaderThread;
    private DXClusterThreadPooledServer dxClusterServer;
    private PlayAudioUtils playAudioUtils = new PlayAudioUtils();
    private TimerTask userActualizationTask;
    private TimerTask keepAliveMessageSenderTask;
    private LinkedBlockingQueue<ChatMessage> messageRXBus;
    private LinkedBlockingQueue<ChatMessage> messageTXBus;
    private String observedSendThisMessageString;
    private DBController dbHandler;
    private Socket socket;
    private ServerSocket cluster_telnetServerSocket;
    private Timer userActualizationtimer;
    private Timer keepAliveTimer;
    private Timer beaconTimer;
    private Timer ASQueryTimer;
    private Timer socketCheckTimer;
    private ObservableList<ChatMessage> lst_globalChatMessageList = FXCollections.observableArrayList();
    private FilteredList<ChatMessage> lst_toAllMessageList = new FilteredList(this.lst_globalChatMessageList);
    private FilteredList<ChatMessage> lst_toMeMessageList = new FilteredList(this.lst_globalChatMessageList);
    private FilteredList<ChatMessage> lst_selectedCallSignInfofilteredMessageList = new FilteredList(this.lst_globalChatMessageList);
    private FilteredList<ChatMessage> lst_toOtherMessageList = new FilteredList(this.lst_globalChatMessageList);
    private ObservableList<String> lstNotify_QSOSniffer_sniffedCallSignList = FXCollections.observableArrayList();
    private ObservableList<ChatMember> chatMemberList = FXCollections.observableArrayList();
    private ObservableList<ChatMember> lst_chatMemberList = FXCollections.synchronizedObservableList(this.chatMemberList);
    private FilteredList<ChatMember> lst_chatMemberListFiltered = new FilteredList(this.chatMemberList);
    private SortedList<ChatMember> lst_chatMemberSortedFilteredList = new SortedList(this.lst_chatMemberListFiltered);
    private ObservableList<Predicate<ChatMember>> lst_chatMemberListFilterPredicates = FXCollections.observableArrayList();
    private ObservableList<ClusterMessage> lst_clusterMemberList = FXCollections.observableArrayList();
    private ObservableList<ChatMember> lst_DBBasedWkdCallSignList = FXCollections.observableArrayList();

    public void setView(Kst4ContestApplication view) {
        this.view = view;
    }

    public boolean isDisconnectionPerformedByUser() {
        return this.disconnectionPerformedByUser;
    }

    public void setDisconnectionPerformedByUser(boolean disconnectionPerformedByUser) {
        this.disconnectionPerformedByUser = disconnectionPerformedByUser;
    }

    public ChatCategory getChatCategorySecondChat() {
        return this.chatCategorySecondChat;
    }

    public void setChatCategorySecondChat(ChatCategory chatCategorySecondChat) {
        this.chatCategorySecondChat = chatCategorySecondChat;
    }

    public UpdateInformation getUpdateInformation() {
        return this.updateInformation;
    }

    public void setUpdateInformation(UpdateInformation updateInformation) {
        this.updateInformation = updateInformation;
    }

    public String getChatState() {
        return this.chatState;
    }

    public void setChatState(String chatState) {
        this.chatState = chatState;
    }

    public boolean isConnectedAndLoggedIn() {
        return this.connectedAndLoggedIn;
    }

    public void setConnectedAndLoggedIn(boolean connectedAndLoggedIn) {
        this.connectedAndLoggedIn = connectedAndLoggedIn;
    }

    public boolean isConnectedAndNOTLoggedIn() {
        return this.connectedAndNOTLoggedIn;
    }

    public void setConnectedAndNOTLoggedIn(boolean connectedAndNOTLoggedIn) {
        this.connectedAndNOTLoggedIn = connectedAndNOTLoggedIn;
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public void setDisconnected(boolean disconnected) {
        this.disconnected = disconnected;
    }

    public StatusUpdateListener getStatusListener() {
        return this.statusListener;
    }

    public void setStatusListener(StatusUpdateListener statusListener) {
        this.statusListener = statusListener;
    }

    @Override
    public void onThreadStatus(String threadName, ThreadStateMessage threadStateMessage) {
        if (this.statusListener != null) {
            this.statusListener.onThreadStatusChanged(threadName, threadStateMessage);
        } else {
            System.out.println("ERRRRRRRRRRRRRRRRRRRRRRRRRRR\u00d6RRRRRRRRRRRRRRRRRRR");
        }
    }

    public void initRotor() {
        this.rotatorClient = new PstRotatorClient("127.0.0.1", 12000, this, this);
        this.rotatorClient.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotateTo(double azimuth) {
        double beforeRotateAzWas = this.chatPreferences.getActualQTF().getValue();
        if (this.rotatorClient != null) {
            Object lockDelay;
            this.rotatorClient.setTrackingMode(false);
            System.out.println("Chatcontroller, Info: turning ant to " + azimuth + " by user request");
            this.rotatorClient.setAzimuth(azimuth);
            Object object = lockDelay = new Object();
            synchronized (object) {
                try {
                    TimeUnit.SECONDS.sleep(2L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.chatPreferences.getActualQTF().getValue() == beforeRotateAzWas) {
                this.rotatorClient.setAzimuth(0.0);
                this.rotatorClient.setAzimuth(azimuth);
            }
        }
    }

    public void stopRotator() {
        if (this.rotatorClient != null) {
            this.rotatorClient.stop();
        }
    }

    @Override
    public void onAzimuthUpdate(double azimuth) {
        System.out.println("Ctrl: AZ update: " + azimuth);
        this.chatPreferences.getActualQTF().setValue((Number)azimuth);
    }

    @Override
    public void onElevationUpdate(double elevation) {
    }

    @Override
    public void onModeUpdate(boolean isTracking) {
    }

    @Override
    public void onMessageReceived(String raw) {
    }

    public void airScout_SendAsShowPathPacket(ChatMember remoteChatMember) {
        String prefix_asSetpath = "ASSHOWPATH: \"KST\" \"AS\" ";
        String bandString = "1440000";
        String remoteCallAndLocString = remoteChatMember.getCallSign() + "," + remoteChatMember.getQra();
        String ownCallSign = "";
        try {
            ownCallSign = this.chatPreferences.getStn_loginCallSign().contains("-") ? this.chatPreferences.getStn_loginCallSign().split("-")[0] : this.chatPreferences.getStn_loginCallSign();
        }
        catch (Exception e) {
            System.out.println("[ASPERIODICAL, Error]: " + e.getMessage());
        }
        String myCallAndMyLocString = ownCallSign + "," + this.chatPreferences.getStn_loginLocatorMainCat();
        String host = "255.255.255.255";
        int port = this.chatPreferences.getAirScout_asCommunicationPort();
        Object queryStringToAirScout = "";
        queryStringToAirScout = (String)queryStringToAirScout + prefix_asSetpath + bandString + "," + myCallAndMyLocString + "," + remoteCallAndLocString + "\u00c5";
        byte[] queryStringToAirScoutMSG = ((String)queryStringToAirScout).getBytes();
        try {
            InetAddress address = InetAddress.getByName("255.255.255.255");
            DatagramPacket packet = new DatagramPacket(queryStringToAirScoutMSG, queryStringToAirScoutMSG.length, address, port);
            DatagramSocket dsocket = new DatagramSocket();
            dsocket.setBroadcast(true);
            dsocket.send(packet);
            dsocket.close();
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        catch (NoRouteToHostException e) {
            e.printStackTrace();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void disconnect(String action) {
        DatagramSocket dsocket;
        DatagramPacket packet;
        InetAddress address;
        int port;
        String host;
        this.dxClusterServer.stop();
        this.setDisconnectionPerformedByUser(true);
        try {
            host = "255.255.255.255";
            port = this.chatPreferences.getLogsynch_ucxUDPWkdCallListenerPort();
            address = InetAddress.getByName("255.255.255.255");
            packet = new DatagramPacket("POISONPILL_KILLTHREAD".getBytes(), "POISONPILL_KILLTHREAD".length(), address, port);
            DatagramPacket killWintestReaderPacket = new DatagramPacket("POISONPILL_KILLTHREAD".getBytes(), "POISONPILL_KILLTHREAD".length(), address, this.chatPreferences.getLogsynch_wintestNetworkPort());
            dsocket = new DatagramSocket();
            dsocket.setBroadcast(true);
            dsocket.send(packet);
            dsocket.close();
            dsocket = new DatagramSocket();
            dsocket.setBroadcast(true);
            dsocket.send(killWintestReaderPacket);
            dsocket.close();
            this.readUDPbyUCXThread.interrupt();
            this.readUDPByWintestThread.interrupt();
        }
        catch (Exception error) {
            System.out.println("Chatcrontroller, ERROR: unable to send poison pill to ucxThread");
        }
        try {
            host = "255.255.255.255";
            port = this.chatPreferences.getAirScout_asCommunicationPort();
            address = InetAddress.getByName("255.255.255.255");
            packet = new DatagramPacket("POISONPILL_KILLTHREAD".getBytes(), "POISONPILL_KILLTHREAD".length(), address, port);
            dsocket = new DatagramSocket();
            dsocket.setBroadcast(true);
            dsocket.send(packet);
            dsocket.close();
        }
        catch (Exception error) {
            System.out.println("Chatcrontroller, ERROR: unable to send poison pill to ucxThread");
        }
        if (action.equals("CLOSEALL")) {
            this.lst_chatMemberList.clear();
            this.lst_clusterMemberList.clear();
            this.setDisconnected(true);
            this.setConnectedAndLoggedIn(false);
            this.setConnectedAndNOTLoggedIn(false);
            this.keepAliveTimer.cancel();
            this.keepAliveTimer.purge();
            killThreadPoisonPillMsg = new ChatMessage();
            killThreadPoisonPillMsg.setMessageText("POISONPILL_KILLTHREAD");
            killThreadPoisonPillMsg.setMessageSenderName("POISONPILL_KILLTHREAD");
            this.messageRXBus.clear();
            this.messageTXBus.clear();
            this.messageRXBus.add(killThreadPoisonPillMsg);
            this.messageTXBus.add(killThreadPoisonPillMsg);
            this.beaconTimer.purge();
            this.beaconTimer.cancel();
            this.ASQueryTimer.purge();
            this.ASQueryTimer.cancel();
            this.socketCheckTimer.purge();
            this.socketCheckTimer.cancel();
            this.userActualizationtimer.purge();
            this.userActualizationtimer.cancel();
            this.userActualizationtimer.purge();
            this.userActualizationtimer.cancel();
            this.messageProcessor.interrupt();
            this.readUDPbyUCXThread.interrupt();
            this.readUDPByWintestThread.interrupt();
            this.airScoutUDPReaderThread.interrupt();
            this.dbHandler.closeDBConnection();
            this.dxClusterServer.stop();
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        } else if (action.equals("ONLYDISCONNECT")) {
            this.lst_chatMemberList.clear();
            this.lst_clusterMemberList.clear();
            this.setDisconnected(true);
            this.setConnectedAndLoggedIn(false);
            this.setConnectedAndNOTLoggedIn(false);
            this.keepAliveTimer.cancel();
            this.keepAliveTimer.purge();
            killThreadPoisonPillMsg = new ChatMessage();
            killThreadPoisonPillMsg.setMessageText("POISONPILL_KILLTHREAD");
            killThreadPoisonPillMsg.setMessageSenderName("POISONPILL_KILLTHREAD");
            this.messageRXBus.clear();
            this.messageTXBus.clear();
            this.messageRXBus.add(killThreadPoisonPillMsg);
            this.messageTXBus.add(killThreadPoisonPillMsg);
            this.writeThread.interrupt();
            this.readThread.interrupt();
            this.beaconTimer.purge();
            this.beaconTimer.cancel();
            this.ASQueryTimer.purge();
            this.ASQueryTimer.cancel();
            this.socketCheckTimer.purge();
            this.socketCheckTimer.cancel();
            this.userActualizationtimer.purge();
            this.userActualizationtimer.cancel();
            this.readUDPbyUCXThread.interrupt();
            this.readUDPByWintestThread.interrupt();
            this.airScoutUDPReaderThread.interrupt();
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public PlayAudioUtils getPlayAudioUtils() {
        return this.playAudioUtils;
    }

    public ArrayList<Integer> checkListForChatMemberIndexesByCallSign(ChatMember lookForThis) {
        ArrayList<Integer> resultingIndexes = new ArrayList<Integer>();
        if (lookForThis == null) {
            return resultingIndexes;
        }
        if (lookForThis.getCallSign() == null) {
            System.out.println("[ChatCtrl] ERROR: null Value in Callsign detected! Member cannot be in the list!");
            return resultingIndexes;
        }
        for (ChatMember chatMember : this.lst_chatMemberList) {
            if (!chatMember.getCallSignRaw().equals(lookForThis.getCallSignRaw())) continue;
            System.out.println("chtctrlr: Found raw " + chatMember.getCallSignRaw() + " //  " + lookForThis.getCallSign());
            resultingIndexes.add(this.lst_chatMemberList.indexOf((Object)chatMember));
        }
        return resultingIndexes;
    }

    public int checkListForChatMemberIndexByCallSign(ChatMember lookForThis) {
        if (lookForThis == null) {
            return -1;
        }
        if (lookForThis.getCallSign() == null) {
            System.out.println("[ChatCtrl] ERROR: null Value in Callsign detected! Member cannot be in the list!");
            return -1;
        }
        for (ChatMember chatMember : this.lst_chatMemberList) {
            if (!chatMember.getCallSignRaw().equals(lookForThis.getCallSignRaw())) continue;
            return this.lst_chatMemberList.indexOf((Object)chatMember);
        }
        return -1;
    }

    public FilteredList<ChatMessage> getLst_selectedCallSignInfofilteredMessageList() {
        return this.lst_selectedCallSignInfofilteredMessageList;
    }

    public void setLst_selectedCallSignInfofilteredMessageList(FilteredList<ChatMessage> lst_selectedCallSignInfofilteredMessageList) {
        this.lst_selectedCallSignInfofilteredMessageList = lst_selectedCallSignInfofilteredMessageList;
    }

    public ObservableList<ChatMessage> getLst_globalChatMessageList() {
        return this.lst_globalChatMessageList;
    }

    public void setLst_globalChatMessageList(ObservableList<ChatMessage> lst_globalChatMessageList) {
        this.lst_globalChatMessageList = lst_globalChatMessageList;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public void setMessageTXBus(LinkedBlockingQueue<ChatMessage> messageTXBus) {
        this.messageTXBus = messageTXBus;
    }

    public String getPraktiKSTVersionInfo() {
        return this.praktiKSTVersionInfo;
    }

    public void setPraktiKSTVersionInfo(String praktiKSTVersionInfo) {
        this.praktiKSTVersionInfo = praktiKSTVersionInfo;
    }

    public ObservableList<ChatMember> getLst_chatMemberList() {
        return this.lst_chatMemberList;
    }

    public ObservableList<ChatMember> getLst_DBBasedWkdCallSignList() {
        return this.lst_DBBasedWkdCallSignList;
    }

    public void setLst_DBBasedWkdCallSignList(ObservableList<ChatMember> lst_DBBasedWkdCallSignList) {
        this.lst_DBBasedWkdCallSignList = lst_DBBasedWkdCallSignList;
    }

    public void setLst_chatMemberList(ObservableList<ChatMember> lst_chatMemberList) {
        this.lst_chatMemberList = lst_chatMemberList;
    }

    public FilteredList<ChatMember> getLst_chatMemberListFiltered() {
        return this.lst_chatMemberListFiltered;
    }

    public SortedList<ChatMember> getLst_chatMemberSortedFilteredList() {
        return this.lst_chatMemberSortedFilteredList;
    }

    public ObservableList<Predicate<ChatMember>> getLst_chatMemberListFilterPredicates() {
        return this.lst_chatMemberListFilterPredicates;
    }

    public void setLst_chatMemberListFilterPredicates(ObservableList<Predicate<ChatMember>> lst_chatMemberListFilterPredicates) {
        this.lst_chatMemberListFilterPredicates = lst_chatMemberListFilterPredicates;
    }

    public ObservableList<ClusterMessage> getLst_clusterMemberList() {
        return this.lst_clusterMemberList;
    }

    public void setLst_clusterMemberList(ObservableList<ClusterMessage> lst_clusterMemberList) {
        this.lst_clusterMemberList = lst_clusterMemberList;
    }

    public ObservableList<ChatMessage> getLst_toAllMessageList() {
        return this.lst_toAllMessageList;
    }

    public void setLst_toAllMessageList(FilteredList<ChatMessage> lst_toAllMessageList) {
        this.lst_toAllMessageList = lst_toAllMessageList;
    }

    public ObservableList<ChatMessage> getLst_toMeMessageList() {
        return this.lst_toMeMessageList;
    }

    public void setLst_toMeMessageList(FilteredList<ChatMessage> lst_toMeMessageList) {
        this.lst_toMeMessageList = lst_toMeMessageList;
    }

    public ObservableList<ChatMessage> getLst_toOtherMessageList() {
        return this.lst_toOtherMessageList;
    }

    public void setLst_toOtherMessageList(FilteredList<ChatMessage> lst_toOtherMessageList) {
        this.lst_toOtherMessageList = lst_toOtherMessageList;
    }

    public LinkedBlockingQueue<ChatMessage> getMessageTXBus() {
        return this.messageTXBus;
    }

    public ChatController() {
        this.chatCategoryMain = new ChatCategory(2);
        this.chatCategorySecondChat = new ChatCategory(3);
        this.ownChatMemberObject = new ChatMember();
        this.ownChatMemberObject.setCallSign(this.userName);
        this.ownChatMemberObject.setName(this.showedName);
        this.ownChatMemberObject.setQra(this.qra);
        this.userName = this.ownChatMemberObject.getName();
        this.hostname = "www.on4kst.org";
        this.port = this.port;
    }

    public ChatController(ChatMember setOwnChatMemberObject) {
        UpdateChecker checkForUpdates = new UpdateChecker(this);
        if (checkForUpdates.downloadLatestVersionInfoXML()) {
            this.updateInformation = checkForUpdates.parseUpdateXMLFile();
        }
        this.initLst_toMeMessageList();
        this.lst_toAllMessageList.setPredicate((Predicate)new Predicate<ChatMessage>(){

            @Override
            public boolean test(ChatMessage chatMessage) {
                try {
                    return chatMessage.getReceiver().getCallSign().equals("ALL");
                }
                catch (Exception nullPointerExc) {
                    nullPointerExc.printStackTrace();
                    System.out.println("ChatController, ERROR: maybe the receiver was null, mostly like a cq message!");
                    return true;
                }
            }
        });
        this.lst_toOtherMessageList.setPredicate((Predicate)new Predicate<ChatMessage>(){

            @Override
            public boolean test(ChatMessage chatMessage) {
                try {
                    return !chatMessage.getSender().getCallSign().equals(ChatController.this.getChatPreferences().getStn_loginCallSign()) && !chatMessage.getReceiver().getCallSign().equals(ChatController.this.getChatPreferences().getStn_loginCallSign()) && !chatMessage.getReceiver().getCallSign().equals("ALL");
                }
                catch (Exception nullPointerExc) {
                    nullPointerExc.printStackTrace();
                    System.out.println("ChatController, <<<catched ERROR>>>: maybe the receiver was null!");
                    return false;
                }
            }
        });
        this.dbHandler = new DBController();
        this.chatPreferences = new ChatPreferences();
        this.chatPreferences.readPreferencesFromXmlFile();
        this.chatCategoryMain = this.chatPreferences.getLoginChatCategoryMain();
        this.chatCategorySecondChat = this.chatPreferences.getLoginChatCategorySecond();
        this.userName = this.chatPreferences.getStn_loginCallSign();
        this.password = this.chatPreferences.getStn_loginPassword();
        this.ownChatMemberObject = setOwnChatMemberObject;
        this.hostname = this.getChatPreferences().getStn_on4kstServersDns();
    }

    private void initLst_toMeMessageList() {
        Predicate<ChatMessage> chatFilterPredicate = chatMessage -> {
            if (chatMessage == null || chatMessage.getSender() == null || chatMessage.getReceiver() == null) {
                return false;
            }
            String myCallSign = this.getChatPreferences().getStn_loginCallSign();
            String senderCall = chatMessage.getSender().getCallSign();
            String receiverCall = chatMessage.getReceiver().getCallSign();
            Object msgText = chatMessage.getMessageText();
            if ((this.lstNotify_QSOSniffer_sniffedCallSignList.contains((Object)senderCall) || this.lstNotify_QSOSniffer_sniffedCallSignList.contains((Object)receiverCall)) && !receiverCall.equals(this.getChatPreferences().getStn_loginCallSignRaw())) {
                msgText = "Sniffed: (" + senderCall + " > " + receiverCall + ") " + (String)msgText;
                chatMessage.setMessageText((String)msgText);
                return true;
            }
            if (receiverCall.equals(myCallSign)) {
                return true;
            }
            if (senderCall.equals(myCallSign) && !receiverCall.equals("ALL")) {
                return true;
            }
            return msgText != null && !senderCall.equals(myCallSign) && ((String)msgText).toLowerCase().contains(myCallSign.toLowerCase());
        };
        this.lstNotify_QSOSniffer_sniffedCallSignList.addListener(c -> {
            this.lst_toMeMessageList.setPredicate(null);
            this.lst_toMeMessageList.setPredicate(chatFilterPredicate);
        });
        this.lstNotify_QSOSniffer_sniffedCallSignList.add((Object)"DF0GEB");
        this.lst_toMeMessageList.setPredicate(chatFilterPredicate);
    }

    public ObservableList<String> getLstNotify_QSOSniffer_sniffedCallSignList() {
        return this.lstNotify_QSOSniffer_sniffedCallSignList;
    }

    public void setLstNotify_QSOSniffer_sniffedCallSignList(ObservableList<String> lstNotify_QSOSniffer_sniffedCallSignList) {
        this.lstNotify_QSOSniffer_sniffedCallSignList = lstNotify_QSOSniffer_sniffedCallSignList;
    }

    public ChatPreferences getChatPreferences() {
        return this.chatPreferences;
    }

    public void setChatPreferences(ChatPreferences chatPreferences) {
        this.chatPreferences = chatPreferences;
    }

    public ChatMember getownChatMemberObject() {
        return this.ownChatMemberObject;
    }

    public void setOwnCall(ChatMember ownCall) {
        this.ownChatMemberObject = ownCall;
    }

    public LinkedBlockingQueue<ChatMessage> getMessageRXBus() {
        return this.messageRXBus;
    }

    public void setMessageRXBus(LinkedBlockingQueue<ChatMessage> messageBus) {
        this.messageRXBus = messageBus;
    }

    public WriteThread getWriteThread() {
        return this.writeThread;
    }

    public void setWriteThread(WriteThread writeThread) {
        this.writeThread = writeThread;
    }

    public ReadThread getReadThread() {
        return this.readThread;
    }

    public void setReadThread(ReadThread readThread) {
        this.readThread = readThread;
    }

    public ChatCategory getChatCategoryMain() {
        return this.chatCategoryMain;
    }

    public void setChatCategoryMain(ChatCategory chatCategoryMain) {
        this.chatCategoryMain = chatCategoryMain;
    }

    public DXClusterThreadPooledServer getDxClusterServer() {
        return this.dxClusterServer;
    }

    public DBController getDbHandler() {
        return this.dbHandler;
    }

    public void setDbHandler(DBController dbHandler) {
        this.dbHandler = dbHandler;
    }

    public void execute() throws InterruptedException, IOException {
        this.chatController = this;
        try {
            this.setDisconnectionPerformedByUser(false);
            this.messageRXBus = new LinkedBlockingQueue();
            this.messageTXBus = new LinkedBlockingQueue();
            this.socket = new Socket(this.hostname, this.port);
            System.out.println("Connected to the chat server: " + this.socket.isConnected());
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            Selector selector = Selector.open();
            this.readThread = new ReadThread(this.socket, this);
            this.readThread.setName("ReadThread-telnetreader");
            this.readThread.start();
            this.writeThread = new WriteThread(this.socket, this);
            this.writeThread.setName("Writethread-telnetwriter");
            this.writeThread.start();
            this.readUDPbyUCXThread = new ReadUDPbyUCXMessageThread(this.chatPreferences.getLogsynch_ucxUDPWkdCallListenerPort(), this, this);
            this.readUDPbyUCXThread.setName("readUDPbyUCXThread");
            this.readUDPbyUCXThread.start();
            this.readUDPByWintestThread = new ReadUDPByWintestThread(this, this);
            this.readUDPByWintestThread.setName("readUDPByWintestThread");
            this.readUDPByWintestThread.start();
            this.messageProcessor = new MessageBusManagementThread(this, this);
            this.messageProcessor.setName("messagebusManagementThread");
            this.messageProcessor.start();
            this.airScoutUDPReaderThread = new ReadUDPbyAirScoutMessageThread(this.chatPreferences.getAirScout_asCommunicationPort(), this, this.getChatPreferences().getAirScout_asServerNameString(), this.getChatPreferences().getAirScout_asServerNameString(), this);
            this.airScoutUDPReaderThread.setName("airscoutudpreaderThread");
            this.airScoutUDPReaderThread.start();
            this.userActualizationtimer = new Timer();
            this.userActualizationtimer.schedule((TimerTask)new UserActualizationTask(this), 4000L, 60000L);
            this.keepAliveTimer = new Timer();
            this.keepAliveTimer.schedule((TimerTask)new keepAliveMessageSenderTask(this), 4000L, 60000L);
            this.initRotor();
            this.dxClusterServer = new DXClusterThreadPooledServer(this.getChatPreferences().getNotify_dxclusterServerPort(), this, this);
            new Thread(this.dxClusterServer).start();
            this.setConnectedAndLoggedIn(true);
            this.beaconTimer = new Timer();
            this.beaconTimer.schedule((TimerTask)new BeaconTask(this, this), 10000L, (long)(this.getChatPreferences().getBcn_beaconIntervalInMinutesMainCat() * 60000));
            this.ASQueryTimer = new Timer();
            this.ASQueryTimer.schedule((TimerTask)new AirScoutPeriodicalAPReflectionInquirerTask(this), 10000L, 60000L);
            this.socketCheckTimer = new Timer();
            this.socketCheckTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Thread.currentThread().setName("SocketcheckTimer");
                    if (!ChatController.this.socket.isConnected() || ChatController.this.socket.isClosed()) {
                        try {
                            ChatController.this.messageRXBus.clear();
                            ChatController.this.messageTXBus.clear();
                            ChatController.this.socket.close();
                            ChatController.this.chatController.setConnectedAndLoggedIn(false);
                            ChatController.this.chatController.getLst_chatMemberList().clear();
                            System.out.println("[Chatcontroller, Warning: ] Socket closed or disconnected");
                            ChatMessage killThreadPoisonPillMsg = new ChatMessage();
                            killThreadPoisonPillMsg.setMessageText("POISONPILL_KILLTHREAD");
                            killThreadPoisonPillMsg.setMessageSenderName("POISONPILL_KILLTHREAD");
                            ChatMessage killThreadPoisonPillMsg2 = new ChatMessage();
                            killThreadPoisonPillMsg2.setMessageText("POISONPILL_KILLTHREAD");
                            killThreadPoisonPillMsg2.setMessageSenderName("POISONPILL_KILLTHREAD");
                            ChatController.this.messageRXBus.add(killThreadPoisonPillMsg);
                            ChatController.this.messageTXBus.add(killThreadPoisonPillMsg2);
                            ChatController.this.chatController.getReadThread().interrupt();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            if (!ChatController.this.disconnectionPerformedByUser) {
                                ChatController.this.messageRXBus.clear();
                                ChatController.this.messageTXBus.clear();
                                ChatController.this.socket = new Socket(ChatController.this.hostname, ChatController.this.port);
                                ChatController.this.chatController.setReadThread(new ReadThread(ChatController.this.socket, ChatController.this.chatController));
                                ChatController.this.chatController.readThread.start();
                                ChatController.this.chatController.setWriteThread(new WriteThread(ChatController.this.socket, ChatController.this.chatController));
                                ChatController.this.chatController.writeThread.start();
                                ChatController.this.messageProcessor = new MessageBusManagementThread(ChatController.this.chatController, ChatController.this.chatController);
                                ChatController.this.messageProcessor.start();
                                System.out.println("[Chatcontroller, info: initialized new socket, is connected? ] " + ChatController.this.socket.isConnected() + " " + ChatController.this.socket.isClosed());
                                ChatController.this.initialize23001();
                                Timer waitABit = new Timer();
                                ChatController.this.socketCheckTimer.schedule(new TimerTask(){

                                    @Override
                                    public void run() {
                                        Thread.currentThread().setName("waiting");
                                        if (ChatController.this.socket.isConnected()) {
                                            ChatController.this.chatController.setConnectedAndLoggedIn(true);
                                        }
                                    }
                                }, 5000L);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }, 10000L, 10000L);
        }
        catch (UnknownHostException ex) {
            System.out.println("Server not found: " + ex.getMessage());
        }
        catch (IOException ex) {
            System.out.println("I/O Error: " + ex.getMessage());
        }
        while (this.readThread == null) {
            System.out.println("Reader not ready.");
        }
        this.initialize23001();
    }

    public long getCurrentEpochTime() {
        OffsetDateTime currentTimeInUtc = OffsetDateTime.now(ZoneOffset.UTC);
        long millisecondsSinceEpoch = currentTimeInUtc.toInstant().toEpochMilli() / 1000L;
        return millisecondsSinceEpoch;
    }

    public void initialize23001() throws InterruptedException, IOException {
        this.messageTXBus.clear();
        ChatMessage message = new ChatMessage();
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                Thread.currentThread().setName("LoginStringTimer");
                Object loginString = "";
                loginString = "LOGINC|" + ChatController.this.chatPreferences.getStn_loginCallSign() + "|" + ChatController.this.chatPreferences.getStn_loginPassword() + "|" + ChatController.this.chatPreferences.getLoginChatCategoryMain().getCategoryNumber() + "|praktiKST v1.31|25|0|1|" + ChatController.this.getCurrentEpochTime() + "|0|";
                ChatMessage message = new ChatMessage();
                message.setMessageText((String)loginString);
                message.setMessageDirectedToServer(true);
                ChatController.this.getMessageTXBus().add(message);
            }
        }, 2000L);
        if (this.chatController.getChatPreferences().isLoginToSecondChatEnabled()) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    Thread.currentThread().setName("LoginStringTimerSecond");
                    Object loginString = "";
                    loginString = "ACHAT|" + ChatController.this.chatController.getChatPreferences().getLoginChatCategorySecond().getCategoryNumber() + "|25|10|2|" + ChatController.this.getCurrentEpochTime() + "|" + ChatController.this.getCurrentEpochTime();
                    ChatMessage message = new ChatMessage();
                    message.setMessageText((String)loginString);
                    message.setMessageDirectedToServer(true);
                    ChatController.this.getMessageTXBus().add(message);
                }
            }, 5000L);
        }
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                Thread.currentThread().setName("SDONEStringTimer");
                ChatMessage message = new ChatMessage();
                message.setMessageText("SDONE|" + ChatController.this.chatPreferences.getLoginChatCategoryMain().getCategoryNumber() + "|\r");
                message.setMessageDirectedToServer(true);
                ChatController.this.getMessageTXBus().add(message);
            }
        }, 3000L);
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                Thread.currentThread().setName("SETLOCTIMER");
                ChatMessage message = new ChatMessage();
                message.setMessageText("MSG|" + ChatController.this.chatPreferences.getLoginChatCategoryMain().getCategoryNumber() + "|0|/SETLOC " + ChatController.this.chatPreferences.getStn_loginLocatorMainCat() + "|0|\r");
                message.setMessageDirectedToServer(true);
                ChatController.this.getMessageTXBus().add(message);
            }
        }, 4000L);
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                Thread.currentThread().setName("SETNAMETIMER");
                ChatMessage message = new ChatMessage();
                message.setMessageText("MSG|" + ChatController.this.chatPreferences.getLoginChatCategoryMain().getCategoryNumber() + "|0|/SETNAME " + ChatController.this.chatPreferences.getStn_loginNameMainCat() + "|0|\r");
                message.setMessageDirectedToServer(true);
                ChatController.this.getMessageTXBus().add(message);
            }
        }, 5000L);
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                Thread.currentThread().setName("SETHereTimerMain");
                ChatMessage message = new ChatMessage();
                message.setMessageText("MSG|" + ChatController.this.chatPreferences.getLoginChatCategoryMain().getCategoryNumber() + "|0|/BACK|0|\r");
                message.setMessageDirectedToServer(true);
                ChatController.this.getMessageTXBus().add(message);
            }
        }, 6500L);
        if (this.chatPreferences.isLoginToSecondChatEnabled()) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    Thread.currentThread().setName("SETNAMETIMER2nd");
                    ChatMessage message = new ChatMessage();
                    message.setMessageText("MSG|" + ChatController.this.chatPreferences.getLoginChatCategorySecond().getCategoryNumber() + "|0|/SETNAME " + ChatController.this.chatPreferences.getStn_loginNameSecondCat() + "|0|\r");
                    message.setMessageDirectedToServer(true);
                    ChatController.this.getMessageTXBus().add(message);
                }
            }, 5500L);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    Thread.currentThread().setName("SETHereTimerSecond");
                    ChatMessage message = new ChatMessage();
                    message.setMessageText("MSG|" + ChatController.this.chatPreferences.getLoginChatCategorySecond().getCategoryNumber() + "|0|/BACK|0|\r");
                    message.setMessageDirectedToServer(true);
                    ChatController.this.getMessageTXBus().add(message);
                }
            }, 7000L);
        }
        new Timer().schedule(new TimerTask(){
            HashMap<String, ChatMember> getWorkedDataFromDb;

            @Override
            public void run() {
                Thread.currentThread().setName("fetchWorkedFromDBTimer");
                try {
                    this.getWorkedDataFromDb = ChatController.this.dbHandler.fetchChatMemberWkdDataFromDB();
                }
                catch (SQLException e) {
                    System.out.println("[Chatctrl, Error: ] got no worked data from DB due to communication error");
                }
                for (ChatMember chatMember : ChatController.this.getLst_chatMemberList()) {
                    System.out.println("[Chatctrl]: Marking ChatMembers wkd information: " + this.getWorkedDataFromDb.get(chatMember.getCallSign()).getCallSign());
                    chatMember.setWorked(this.getWorkedDataFromDb.get(chatMember.getCallSign()).isWorked());
                    chatMember.setWorked144(this.getWorkedDataFromDb.get(chatMember.getCallSign()).isWorked144());
                    chatMember.setWorked432(this.getWorkedDataFromDb.get(chatMember.getCallSign()).isWorked432());
                    chatMember.setWorked1240(this.getWorkedDataFromDb.get(chatMember.getCallSign()).isWorked1240());
                    chatMember.setWorked2300(this.getWorkedDataFromDb.get(chatMember.getCallSign()).isWorked2300());
                    chatMember.setWorked3400(this.getWorkedDataFromDb.get(chatMember.getCallSign()).isWorked3400());
                    chatMember.setWorked5600(this.getWorkedDataFromDb.get(chatMember.getCallSign()).isWorked5600());
                    chatMember.setWorked10G(this.getWorkedDataFromDb.get(chatMember.getCallSign()).isWorked10G());
                    chatMember.setQrv144(this.getWorkedDataFromDb.get(chatMember.getCallSign()).isQrv144());
                    chatMember.setQrv432(this.getWorkedDataFromDb.get(chatMember.getCallSign()).isQrv432());
                    chatMember.setQrv1240(this.getWorkedDataFromDb.get(chatMember.getCallSign()).isQrv1240());
                    chatMember.setQrv2300(this.getWorkedDataFromDb.get(chatMember.getCallSign()).isQrv2300());
                    chatMember.setQrv3400(this.getWorkedDataFromDb.get(chatMember.getCallSign()).isQrv3400());
                    chatMember.setQrv5600(this.getWorkedDataFromDb.get(chatMember.getCallSign()).isQrv5600());
                    chatMember.setQrv10G(this.getWorkedDataFromDb.get(chatMember.getCallSign()).isQrv10G());
                }
                this.getWorkedDataFromDb.forEach((key, value) -> ChatController.this.chatController.getLst_DBBasedWkdCallSignList().add(value));
            }
        }, 10000L);
    }

    public void resetWorkedInfoInGuiLists() {
        this.chatController.getLst_chatMemberList().forEach(chatMember -> chatMember.resetWorkedInformationAtAllBands());
    }

    public void resetQRVInfoInGuiLists() {
        this.chatController.getLst_chatMemberList().forEach(chatMember -> chatMember.resetQRVInformationAtAllBands());
    }

    public void initialize23000() throws InterruptedException, IOException {
        ChatMessage message = new ChatMessage();
        message.setMessageText(this.ownChatMemberObject.getCallSign());
        this.getMessageTXBus().add(message);
        message = new ChatMessage();
        message.setMessageText(this.password);
        this.getMessageTXBus().add(message);
        message = new ChatMessage();
        message.setMessageText("" + this.chatCategoryMain);
        this.getMessageTXBus().add(message);
        message = new ChatMessage();
        message.setMessageText("/set qra " + this.ownChatMemberObject.getQra());
        this.getMessageTXBus().add(message);
        message = new ChatMessage();
        message.setMessageText("/set name " + this.ownChatMemberObject.getName());
        this.getMessageTXBus().add(message);
        message = new ChatMessage();
        message.setMessageText("/set here");
        this.getMessageTXBus().add(message);
    }
}

