/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.locatorUtils;

import kst4contest.locatorUtils.Location;

public class DirectionUtils {
    public static boolean isInAngleAndRange(String myLocator, String locatorOfSkedSender, String locatorOfSekdReceiver, double maxRangeKm, double hisAntennaBeamWidth) {
        double bearingOfSekdSenderToMe;
        Location myLocation = new Location(myLocator);
        Location skedSenderLocation = new Location(locatorOfSkedSender);
        Location skedReceiverLocation = new Location(locatorOfSekdReceiver);
        double distanceFromMeToLocSender = new Location(myLocator).getDistanceKm(new Location(locatorOfSkedSender));
        if (distanceFromMeToLocSender > maxRangeKm) {
            System.out.println("too far, " + distanceFromMeToLocSender + " km");
            return false;
        }
        double bearingOfSekdSenderToSkedReceiver = skedSenderLocation.getBearing(skedReceiverLocation);
        return DirectionUtils.isAngleInRange(bearingOfSekdSenderToSkedReceiver, bearingOfSekdSenderToMe = skedSenderLocation.getBearing(myLocation), hisAntennaBeamWidth);
    }

    public static boolean isAngleInRange(double toForeignAngle, double mySelectedQTFAngle, double antennaBeamwidth) {
        double beamwidth = antennaBeamwidth / 2.0;
        double startAngle = mySelectedQTFAngle - beamwidth;
        double endAngle = mySelectedQTFAngle + beamwidth;
        toForeignAngle = DirectionUtils.normalizeAngle(toForeignAngle);
        if ((startAngle = DirectionUtils.normalizeAngle(startAngle)) <= (endAngle = DirectionUtils.normalizeAngle(endAngle))) {
            return toForeignAngle >= startAngle && toForeignAngle <= endAngle;
        }
        return toForeignAngle >= startAngle || toForeignAngle <= endAngle;
    }

    private static double normalizeAngle(double angle) {
        if (angle < 0.0) {
            angle += 360.0;
        }
        if (angle >= 360.0) {
            angle -= 360.0;
        }
        return angle;
    }
}

