/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.controller;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kst4contest.controller.ChatController;
import kst4contest.model.UpdateInformation;
import kst4contest.utils.ApplicationFileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UpdateChecker {
    String versionInfoDownloadedFromServerFileName = ApplicationFileUtils.getFilePath("praktiKST", "kst4ContestVersionInfo.xml");
    String versionInfoXMLURLAtServer = "https://do5amf.funkerportal.de/kst4ContestVersionInfo.xml";

    public static void main(String[] args) {
        if (new UpdateChecker(null).downloadLatestVersionInfoXML()) {
            // empty if block
        }
        new UpdateChecker(null).parseUpdateXMLFile();
    }

    public UpdateChecker(ChatController chatController) {
        System.out.println("[Updatechecker: checking for updates...]");
    }

    public boolean downloadLatestVersionInfoXML() {
        try {
            InputStream in = new URL(this.versionInfoXMLURLAtServer).openStream();
            Files.copy(in, Paths.get(ApplicationFileUtils.getFilePath("praktiKST", "/kst4ContestVersionInfo.xml"), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            in.close();
        }
        catch (Exception e) {
            System.out.println("ERROR DOWNLOADING!" + e);
            return false;
        }
        return true;
    }

    public UpdateInformation parseUpdateXMLFile() {
        UpdateInformation updateInfos = new UpdateInformation();
        ApplicationFileUtils.copyResourceIfRequired("praktiKST", "/kst4ContestVersionInfo.xml", "kst4ContestVersionInfo.xml");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        try {
            File xmlConfigFile = new File(this.versionInfoDownloadedFromServerFileName);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(xmlConfigFile);
            NodeList list = doc.getElementsByTagName("latestVersion");
            if (list.getLength() != 0) {
                for (int temp = 0; temp < list.getLength(); ++temp) {
                    Node node = list.item(temp);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    updateInfos.setLatestVersionNumberOnServer(Double.parseDouble(element.getElementsByTagName("versionNumber").item(0).getTextContent()));
                    updateInfos.setAdminMessage(element.getElementsByTagName("adminMessage").item(0).getTextContent());
                    updateInfos.setMajorChanges(element.getElementsByTagName("majorChanges").item(0).getTextContent());
                    updateInfos.setLatestVersionPathOnWebserver(element.getElementsByTagName("latestVersionPathOnWebserver").item(0).getTextContent());
                }
            }
            list = doc.getElementsByTagName("changeLog");
            ArrayList<String[]> changeLogArrayList = new ArrayList<String[]>();
            if (list.getLength() != 0) {
                for (int temp = 0; temp < list.getLength(); ++temp) {
                    Node node = list.item(temp);
                    Element element = (Element)node;
                    int childNodeCounter = 0;
                    String[] aChangeLogEntry = new String[]{"", "Date: ", "Desc: ", "Added: ", "Changed: ", "Fixed: ", "Removed: "};
                    for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
                        if (element.getChildNodes().item(i).getNodeType() != 1) continue;
                        aChangeLogEntry[childNodeCounter] = aChangeLogEntry[childNodeCounter] + element.getChildNodes().item(i).getTextContent();
                        ++childNodeCounter;
                    }
                    changeLogArrayList.add(aChangeLogEntry);
                }
                updateInfos.setChangeLog(changeLogArrayList);
            }
            list = doc.getElementsByTagName("bug");
            ArrayList<String[]> bugFixArrayList = new ArrayList<String[]>();
            if (list.getLength() != 0) {
                for (int temp = 0; temp < list.getLength(); ++temp) {
                    Node node = list.item(temp);
                    Element element = (Element)node;
                    int childNodeCounter = 0;
                    String[] aChangeLogEntry = new String[3];
                    aChangeLogEntry[0] = "";
                    aChangeLogEntry[1] = "State: ";
                    for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
                        if (element.getChildNodes().item(i).getNodeType() != 1) continue;
                        aChangeLogEntry[childNodeCounter] = aChangeLogEntry[childNodeCounter] + element.getChildNodes().item(i).getTextContent();
                        ++childNodeCounter;
                    }
                    bugFixArrayList.add(aChangeLogEntry);
                }
                updateInfos.setBugList(bugFixArrayList);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        String[] testEntry = new String[]{"0.99", "2022-09", "researched the Chatprotocol", "addednothing", "changedsome", "fixedxed", "removedYourMom"};
        String[] testEntry2 = new String[]{"0.29", "2033-09", "tested", "addednotashing", "changeasdsome", "fixedxeds", "removedYosssurMom"};
        return updateInfos;
    }

    public String toString() {
        String toString = "";
        return toString;
    }
}

