/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.controller;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import kst4contest.controller.Utils4KST;
import kst4contest.model.ChatMember;
import kst4contest.utils.ApplicationFileUtils;

public class DBController {
    public static final String DATABASE_FILE = "praktiKST.db";
    public static final String DATABASE_RESOURCE = "/praktiKST.db";
    private static final DBController dbcontroller = new DBController();
    private static Connection connection;
    private static String DB_PATH;

    public DBController() {
        this.initDBConnection();
    }

    public static DBController getInstance() {
        return dbcontroller;
    }

    public void closeDBConnection() {
        try {
            connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void initDBConnection() {
        System.out.println("DBH: initiate new db connection");
        try {
            ApplicationFileUtils.copyResourceIfRequired("praktiKST", DATABASE_RESOURCE, DATABASE_FILE);
            if (connection != null) {
                return;
            }
            System.out.println("Creating Connection to Database...");
            DB_PATH = ApplicationFileUtils.getFilePath("praktiKST", DATABASE_FILE);
            connection = DriverManager.getConnection("jdbc:sqlite:" + DB_PATH);
            System.out.println("[DBH, Info]: Path = " + DB_PATH);
            if (!connection.isClosed()) {
                System.out.println("...Connection established");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    if (!connection.isClosed() && connection != null) {
                        connection.close();
                        if (connection.isClosed()) {
                            System.out.println("Connection to Database closed");
                        }
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
        this.versionUpdateOfDBCheckAndChangeV11ToV12();
    }

    public void versionUpdateOfDBCheckAndChangeV11ToV12() {
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * FROM ChatMember where notQRV144 != 0;");
            stmt.close();
        }
        catch (SQLException ex) {
            System.out.println("DBH, Info: updating DB fields for version change v1.1 -> v1.2");
            try {
                PreparedStatement ps = connection.prepareStatement("ALTER TABLE ChatMember ADD notQRV144 BOOLEAN DEFAULT 0;");
                ps.addBatch();
                ps.executeBatch();
                ps = connection.prepareStatement("ALTER TABLE ChatMember ADD notQRV432 BOOLEAN DEFAULT 0;");
                ps.addBatch();
                ps.executeBatch();
                ps = connection.prepareStatement("ALTER TABLE ChatMember ADD notQRV1240 BOOLEAN DEFAULT 0;");
                ps.addBatch();
                ps.executeBatch();
                ps = connection.prepareStatement("ALTER TABLE ChatMember ADD notQRV2300 BOOLEAN DEFAULT 0;");
                ps.addBatch();
                ps.executeBatch();
                ps = connection.prepareStatement("ALTER TABLE ChatMember ADD notQRV3400 BOOLEAN DEFAULT 0;");
                ps.addBatch();
                ps.executeBatch();
                ps = connection.prepareStatement("ALTER TABLE ChatMember ADD notQRV5600 BOOLEAN DEFAULT 0;");
                ps.addBatch();
                ps.executeBatch();
                ps = connection.prepareStatement("ALTER TABLE ChatMember ADD notQRV10G BOOLEAN DEFAULT 0;");
                ps.addBatch();
                ps.executeBatch();
                connection.setAutoCommit(false);
                connection.setAutoCommit(true);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void storeChatMember(ChatMember chatMemberToStore) throws SQLException {
        try {
            Statement stmt = connection.createStatement();
            PreparedStatement ps = connection.prepareStatement("INSERT OR IGNORE INTO ChatMember VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ON CONFLICT(callsign) DO UPDATE SET qra = '" + chatMemberToStore.getQra() + "', name = '" + chatMemberToStore.getName() + "', lastActivityDateTime = '" + chatMemberToStore.getLastActivity() + "' where callsign = '" + chatMemberToStore.getCallSign() + "';");
            ps.setString(1, chatMemberToStore.getCallSign());
            ps.setString(2, chatMemberToStore.getQra());
            ps.setString(3, chatMemberToStore.getName());
            ps.setString(4, chatMemberToStore.getLastActivity().toString());
            ps.setInt(5, this.helper_booleanIntConverter(chatMemberToStore.isWorked()));
            ps.setInt(6, this.helper_booleanIntConverter(chatMemberToStore.isWorked144()));
            ps.setInt(7, this.helper_booleanIntConverter(chatMemberToStore.isWorked432()));
            ps.setInt(8, this.helper_booleanIntConverter(chatMemberToStore.isWorked1240()));
            ps.setInt(9, this.helper_booleanIntConverter(chatMemberToStore.isWorked2300()));
            ps.setInt(10, this.helper_booleanIntConverter(chatMemberToStore.isWorked3400()));
            ps.setInt(11, this.helper_booleanIntConverter(chatMemberToStore.isWorked5600()));
            ps.setInt(12, this.helper_booleanIntConverter(chatMemberToStore.isWorked10G()));
            ps.setInt(13, this.helper_booleanIntConverter(!chatMemberToStore.isQrv144()));
            ps.setInt(14, this.helper_booleanIntConverter(!chatMemberToStore.isQrv432()));
            ps.setInt(15, this.helper_booleanIntConverter(!chatMemberToStore.isQrv1240()));
            ps.setInt(16, this.helper_booleanIntConverter(!chatMemberToStore.isQrv2300()));
            ps.setInt(17, this.helper_booleanIntConverter(!chatMemberToStore.isQrv3400()));
            ps.setInt(18, this.helper_booleanIntConverter(!chatMemberToStore.isQrv5600()));
            ps.setInt(19, this.helper_booleanIntConverter(!chatMemberToStore.isQrv10G()));
            ps.addBatch();
            connection.setAutoCommit(false);
            ps.executeBatch();
            connection.setAutoCommit(true);
            stmt.close();
        }
        catch (SQLException e) {
            System.err.println("[DBH, ERROR:] Chatmember could not been stored.");
            e.printStackTrace();
        }
    }

    public HashMap<String, ChatMember> fetchChatMemberWkdDataFromDB() throws SQLException {
        HashMap<String, ChatMember> fetchedWorkeddata = new HashMap<String, ChatMember>();
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * FROM ChatMember;");
            while (rs.next()) {
                ChatMember updateWkdData = new ChatMember();
                updateWkdData.setCallSign(rs.getString("callsign"));
                updateWkdData.setWorked(this.helper_IntToBooleanConverter(rs.getInt("worked")));
                updateWkdData.setWorked144(this.helper_IntToBooleanConverter(rs.getInt("worked144")));
                updateWkdData.setWorked432(this.helper_IntToBooleanConverter(rs.getInt("worked432")));
                updateWkdData.setWorked1240(this.helper_IntToBooleanConverter(rs.getInt("worked1240")));
                updateWkdData.setWorked2300(this.helper_IntToBooleanConverter(rs.getInt("worked2300")));
                updateWkdData.setWorked3400(this.helper_IntToBooleanConverter(rs.getInt("worked3400")));
                updateWkdData.setWorked5600(this.helper_IntToBooleanConverter(rs.getInt("worked5600")));
                updateWkdData.setWorked10G(this.helper_IntToBooleanConverter(rs.getInt("worked10G")));
                updateWkdData.setQrv144(!this.helper_IntToBooleanConverter(rs.getInt("notQRV144")));
                updateWkdData.setQrv432(!this.helper_IntToBooleanConverter(rs.getInt("notQRV432")));
                updateWkdData.setQrv1240(!this.helper_IntToBooleanConverter(rs.getInt("notQRV1240")));
                updateWkdData.setQrv2300(!this.helper_IntToBooleanConverter(rs.getInt("notQRV2300")));
                updateWkdData.setQrv3400(!this.helper_IntToBooleanConverter(rs.getInt("notQRV3400")));
                updateWkdData.setQrv5600(!this.helper_IntToBooleanConverter(rs.getInt("notQRV5600")));
                updateWkdData.setQrv10G(!this.helper_IntToBooleanConverter(rs.getInt("notQRV10G")));
                fetchedWorkeddata.put(updateWkdData.getCallSign(), updateWkdData);
            }
            stmt.close();
            rs.close();
            return fetchedWorkeddata;
        }
        catch (SQLException e) {
            System.err.println("[DBH, ERROR:] Couldn't handle DB-Query");
            e.printStackTrace();
            connection.close();
            return fetchedWorkeddata;
        }
    }

    public ChatMember fetchChatMemberWkdDataForOnlyOneCallsignFromDB(ChatMember checkForThis) {
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * FROM ChatMember where callsign = '" + checkForThis.getCallSign() + "' ;");
            while (rs.next()) {
                checkForThis.setWorked(this.helper_IntToBooleanConverter(rs.getInt("worked")));
                checkForThis.setWorked144(this.helper_IntToBooleanConverter(rs.getInt("worked144")));
                checkForThis.setWorked432(this.helper_IntToBooleanConverter(rs.getInt("worked432")));
                checkForThis.setWorked1240(this.helper_IntToBooleanConverter(rs.getInt("worked1240")));
                checkForThis.setWorked2300(this.helper_IntToBooleanConverter(rs.getInt("worked2300")));
                checkForThis.setWorked3400(this.helper_IntToBooleanConverter(rs.getInt("worked3400")));
                checkForThis.setWorked5600(this.helper_IntToBooleanConverter(rs.getInt("worked5600")));
                checkForThis.setWorked10G(this.helper_IntToBooleanConverter(rs.getInt("worked10G")));
                checkForThis.setQrv144(!this.helper_IntToBooleanConverter(rs.getInt("notQRV144")));
                checkForThis.setQrv432(!this.helper_IntToBooleanConverter(rs.getInt("notQRV432")));
                checkForThis.setQrv1240(!this.helper_IntToBooleanConverter(rs.getInt("notQRV1240")));
                checkForThis.setQrv2300(!this.helper_IntToBooleanConverter(rs.getInt("notQRV2300")));
                checkForThis.setQrv3400(!this.helper_IntToBooleanConverter(rs.getInt("notQRV3400")));
                checkForThis.setQrv5600(!this.helper_IntToBooleanConverter(rs.getInt("notQRV5600")));
                checkForThis.setQrv10G(!this.helper_IntToBooleanConverter(rs.getInt("notQRV10G")));
            }
            rs.close();
            stmt.close();
            return checkForThis;
        }
        catch (SQLException e) {
            System.err.println("[DBH, ERROR:] Couldn't handle DB-Query");
            e.printStackTrace();
            try {
                connection.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            return checkForThis;
        }
    }

    public int resetWorkedDataInDB() {
        try {
            Statement stmt = connection.createStatement();
            int affected = stmt.executeUpdate("update ChatMember set worked = 0, worked144 = 0, worked432 = 0, worked1240 = 0, worked2300 = 0, worked3400 = 0, worked5600 = 0, worked10G = 0, notQrv144 = 0, notQrv432 = 0, notQrv1240 = 0, notQrv2300 = 0, notQrv3400 = 0, notQrv5600 = 0, notQrv10G = 0;");
            stmt.close();
            return affected;
        }
        catch (SQLException e) {
            System.err.println("[DBH, ERROR:] Couldn't reset the worked data");
            e.printStackTrace();
            try {
                connection.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
                return -1;
            }
            return -1;
        }
    }

    public boolean updateWkdInfoOnChatMember(ChatMember chatMemberToStore) throws SQLException {
        try {
            Statement stmt = connection.createStatement();
            PreparedStatement ps = connection.prepareStatement("UPDATE ChatMember set worked = ? WHERE CallSign = ?");
            ps.setInt(1, 1);
            ps.setString(2, chatMemberToStore.getCallSign());
            ps.addBatch();
            connection.setAutoCommit(false);
            ps.executeBatch();
            connection.setAutoCommit(true);
            String bandVariable = "worked";
            if (chatMemberToStore.isWorked144()) {
                bandVariable = "worked144";
            } else if (chatMemberToStore.isWorked432()) {
                bandVariable = "worked432";
            } else if (chatMemberToStore.isWorked1240()) {
                bandVariable = "worked1240";
            } else if (chatMemberToStore.isWorked2300()) {
                bandVariable = "worked2300";
            } else if (chatMemberToStore.isWorked3400()) {
                bandVariable = "worked3400";
            } else if (chatMemberToStore.isWorked5600()) {
                bandVariable = "worked5600";
            } else if (chatMemberToStore.isWorked10G()) {
                bandVariable = "worked10G";
            } else {
                System.out.println("[DBCtrl, Error]: unknown at which band the qso had been!");
            }
            PreparedStatement ps2 = connection.prepareStatement("UPDATE ChatMember set " + bandVariable + " = ? WHERE CallSign = ?");
            ps2.setInt(1, 1);
            ps2.setString(2, chatMemberToStore.getCallSign());
            ps2.addBatch();
            connection.setAutoCommit(false);
            ps2.executeBatch();
            connection.setAutoCommit(true);
            stmt.close();
            System.out.println("updated count of cols: " + ps2.getUpdateCount());
            return ps2.getUpdateCount() != 0;
        }
        catch (SQLException e) {
            System.err.println("[DBH, ERROR:] Couldn't handle DB-Query");
            e.printStackTrace();
            connection.close();
            return false;
        }
    }

    public boolean updateNotQRVInfoOnChatMember(ChatMember chatMemberToStore) throws SQLException {
        try {
            Statement stmt = connection.createStatement();
            PreparedStatement ps = connection.prepareStatement("UPDATE ChatMember set notQrv144 = ? WHERE CallSign = ?");
            ps.setInt(1, this.helper_booleanIntConverter(!chatMemberToStore.isQrv144()));
            ps.setString(2, chatMemberToStore.getCallSign());
            ps.addBatch();
            ps.executeBatch();
            ps = connection.prepareStatement("UPDATE ChatMember set notQrv432 = ? WHERE CallSign = ?");
            ps.setInt(1, this.helper_booleanIntConverter(!chatMemberToStore.isQrv432()));
            ps.setString(2, chatMemberToStore.getCallSign());
            ps.addBatch();
            ps.executeBatch();
            ps = connection.prepareStatement("UPDATE ChatMember set notQrv1240 = ? WHERE CallSign = ?");
            ps.setInt(1, this.helper_booleanIntConverter(!chatMemberToStore.isQrv1240()));
            ps.setString(2, chatMemberToStore.getCallSign());
            ps.addBatch();
            ps.executeBatch();
            ps = connection.prepareStatement("UPDATE ChatMember set notQrv2300 = ? WHERE CallSign = ?");
            ps.setInt(1, this.helper_booleanIntConverter(!chatMemberToStore.isQrv2300()));
            ps.setString(2, chatMemberToStore.getCallSign());
            ps.addBatch();
            ps.executeBatch();
            ps = connection.prepareStatement("UPDATE ChatMember set notQrv3400 = ? WHERE CallSign = ?");
            ps.setInt(1, this.helper_booleanIntConverter(!chatMemberToStore.isQrv3400()));
            ps.setString(2, chatMemberToStore.getCallSign());
            ps.addBatch();
            ps.executeBatch();
            ps = connection.prepareStatement("UPDATE ChatMember set notQrv5600 = ? WHERE CallSign = ?");
            ps.setInt(1, this.helper_booleanIntConverter(!chatMemberToStore.isQrv5600()));
            ps.setString(2, chatMemberToStore.getCallSign());
            ps.addBatch();
            ps.executeBatch();
            ps = connection.prepareStatement("UPDATE ChatMember set notQrv10G = ? WHERE CallSign = ?");
            ps.setInt(1, this.helper_booleanIntConverter(!chatMemberToStore.isQrv10G()));
            ps.setString(2, chatMemberToStore.getCallSign());
            ps.addBatch();
            ps.executeBatch();
            connection.setAutoCommit(false);
            connection.setAutoCommit(true);
            stmt.close();
        }
        catch (SQLException e) {
            System.err.println("[DBH, ERROR:] Couldn't handle DB-Query");
            e.printStackTrace();
            connection.close();
            return false;
        }
        return true;
    }

    private int helper_booleanIntConverter(boolean convertToInt) {
        if (convertToInt) {
            return 1;
        }
        return 0;
    }

    private boolean helper_IntToBooleanConverter(int valueFromDBField) {
        if (valueFromDBField != 0) {
            System.out.println("true");
            return true;
        }
        System.out.println("false");
        return false;
    }

    public static void main(String[] args) throws SQLException {
        DBController dbc = DBController.getInstance();
        ChatMember dummy = new ChatMember();
        dummy.setCallSign("DM5M");
        dummy.setQra("jo51ij");
        dummy.setName("Team Test");
        dummy.setLastActivity(new Utils4KST().time_generateActualTimeInDateFormat());
        dummy.setWorked5600(true);
    }

    static {
        DB_PATH = ApplicationFileUtils.getFilePath("praktiKST", DATABASE_FILE);
    }
}

