/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.controller;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kst4contest.model.ChatMember;

public class UCXLogFileToHashsetParser {
    public BufferedReader fileReader;
    private final String PTRN_CallSign = "(([a-zA-Z]{1,2}[\\d]{1}?\\/)?(\\d{1}[a-zA-Z][\\d]{1}[a-zA-Z]{1,3})((\\/p)|(\\/\\d))?)|(([a-zA-Z0-9]{1,2}[\\d]{1}?\\/)?(([a-zA-Z]{1,2}(\\d{1}[a-zA-Z]{1,4})))((\\/p)|(\\/\\d))?)|([A-Z]\\d{2}[A-Z]{1,3})";

    public UCXLogFileToHashsetParser(String filePathAndName) {
        try {
            this.fileReader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(filePathAndName))));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private ChatMember checkIfLineInhibitsCallSign(String line) {
        Pattern pattern = Pattern.compile("(([a-zA-Z]{1,2}[\\d]{1}?\\/)?(\\d{1}[a-zA-Z][\\d]{1}[a-zA-Z]{1,3})((\\/p)|(\\/\\d))?)|(([a-zA-Z0-9]{1,2}[\\d]{1}?\\/)?(([a-zA-Z]{1,2}(\\d{1}[a-zA-Z]{1,4})))((\\/p)|(\\/\\d))?)|([A-Z]\\d{2}[A-Z]{1,3})");
        Matcher matcher = pattern.matcher(line);
        String matchedString = "";
        while (matcher.find()) {
            matchedString = matcher.group();
        }
        ChatMember newChatMember = new ChatMember();
        newChatMember.setCallSign(matchedString.toUpperCase());
        return newChatMember;
    }

    public HashMap<String, String> parse() throws IOException {
        String line;
        HashMap<String, String> chatMemberMap = new HashMap<String, String>();
        while ((line = this.fileReader.readLine()) != null) {
            ChatMember temp = this.checkIfLineInhibitsCallSign(line);
            if (temp.getCallSign() == "") continue;
            chatMemberMap.put(temp.getCallSign(), temp.getCallSign());
        }
        return chatMemberMap;
    }
}

