/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;

public class ApplicationFileUtils {
    public static String getFilePath(String applicationName, String fileName) {
        return Path.of(System.getProperty("user.home"), "." + applicationName, fileName).toString();
    }

    public static void copyResourceIfRequired(String applicationName, String resourcePath, String fileName) {
        File file = new File(ApplicationFileUtils.getFilePath(applicationName, fileName));
        if (file.exists()) {
            return;
        }
        File parentDir = file.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        ApplicationFileUtils.copyResourceToFile(resourcePath, file.getPath());
    }

    public static void copyResourceToFile(String resourcePath, String filePath) {
        try (InputStream resourceStream = ApplicationFileUtils.class.getResourceAsStream(resourcePath);
             FileOutputStream fileOutputStream = new FileOutputStream(filePath);){
            if (resourceStream == null) {
                throw new IllegalArgumentException("Resource not found: " + resourcePath);
            }
            resourceStream.transferTo(fileOutputStream);
        }
        catch (IOException ex) {
            System.err.println("Exception when copying Application file: " + ex.getMessage());
            ex.printStackTrace(System.err);
        }
    }
}

