/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.controller;

import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.property.SimpleStringProperty;

public class Utils4KST {
    public long time_generateCurrentEpochTime() {
        OffsetDateTime currentTimeInUtc = OffsetDateTime.now(ZoneOffset.UTC);
        long millisecondsSinceEpoch = currentTimeInUtc.toInstant().toEpochMilli() / 1000L;
        return millisecondsSinceEpoch;
    }

    public String time_generateCurrenthhmmZTimeStringForClusterMessage() {
        OffsetDateTime currentTimeInUtc = OffsetDateTime.now(ZoneOffset.UTC);
        System.out.println("Utils generated current time " + currentTimeInUtc + " --> " + currentTimeInUtc.format(DateTimeFormatter.ofPattern("HHmm")) + "Z");
        return currentTimeInUtc.format(DateTimeFormatter.ofPattern("HHmm")) + "Z";
    }

    public String time_generateCurrentMMDDhhmmTimeString() {
        OffsetDateTime currentTimeInUtc = OffsetDateTime.now(ZoneOffset.UTC);
        return currentTimeInUtc.format(DateTimeFormatter.ofPattern("MM-dd hh:mm"));
    }

    public String time_generateCurrentMMddString() {
        OffsetDateTime currentTimeInUtc = OffsetDateTime.now(ZoneOffset.UTC);
        return currentTimeInUtc.format(DateTimeFormatter.ofPattern("MM-dd"));
    }

    public String time_convertEpochToReadable(String epochFromServer) {
        long epoch = Long.parseLong(epochFromServer);
        Date date = new Date(epoch * 1000L);
        SimpleDateFormat format = new SimpleDateFormat("dd.MM HH:mm:ss");
        format.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
        String formatted = format.format(date);
        return formatted;
    }

    public static long time_getSecondsBetweenEpochAndNow(String epoch1) {
        long epoch1Long = Long.parseLong(epoch1);
        long epoch2Long = new Utils4KST().time_generateCurrentEpochTime();
        Date date = new Date(epoch1Long * 1000L);
        Date date2 = new Date(epoch2Long * 1000L);
        long seconds = Math.abs(date.getTime() - date2.getTime()) / 1000L;
        return seconds;
    }

    public Date time_generateActualTimeInDateFormat() {
        Date date = new Date(this.time_generateCurrentEpochTime() * 1000L);
        return date;
    }

    private static boolean testPattern(String testString, String regExPattern) {
        Pattern pattern = Pattern.compile(regExPattern);
        Matcher matcher = pattern.matcher(testString);
        return matcher.find();
    }

    public static String normalizeFrequencyString(String qrgString, SimpleStringProperty optionalPrefix) {
        try {
            qrgString = qrgString.replace(" ", "");
        }
        catch (Exception e) {
            System.out.println("UTILS: QRG NULL, nothing to convert");
        }
        String PTRN_QRG_CAT2_wholeQRGMHz4Digits = "(([0-9]{4}[\\.|,| ]?[0-9]{3})([\\.|,][\\d]{1,2})?)";
        String PTRN_QRG_CAT2_wholeQRGMHz3Digits = "(([0-9]{3}[\\.|,| ]?[0-9]{3})([\\.][\\d]{1,2})?)";
        String PTRN_QRG_CAT2_QRGwithoutPrefix = "((\\b[0-4]{1}[\\d]{2}\\b)([\\.|,][\\d]{1,2}\\b)?)";
        Object stringAggregation = "";
        if (Utils4KST.testPattern(qrgString, "(([0-9]{4}[\\.|,| ]?[0-9]{3})([\\.|,][\\d]{1,2})?)")) {
            stringAggregation = qrgString;
            stringAggregation = ((String)stringAggregation).replace(".", "");
            stringAggregation = ((String)stringAggregation).replace(",", "");
            if (((String)(stringAggregation = ((String)stringAggregation).replace(" ", ""))).length() == 8) {
                String stringAggregationNew = ((String)stringAggregation).substring(0, ((String)stringAggregation).length() - 1) + "." + ((String)stringAggregation).substring(((String)stringAggregation).length() - 1, ((String)stringAggregation).length());
                stringAggregation = stringAggregationNew + ".0";
                return stringAggregation;
            }
            if (((String)stringAggregation).length() == 9) {
                String stringAggregationNew = ((String)stringAggregation).substring(0, ((String)stringAggregation).length() - 2) + "." + ((String)stringAggregation).substring(((String)stringAggregation).length() - 2, ((String)stringAggregation).length());
                stringAggregation = stringAggregationNew;
                return stringAggregation;
            }
        } else if (Utils4KST.testPattern(qrgString, "(([0-9]{3}[\\.|,| ]?[0-9]{3})([\\.][\\d]{1,2})?)")) {
            stringAggregation = qrgString;
            stringAggregation = ((String)stringAggregation).replace(".", "");
            stringAggregation = ((String)stringAggregation).replace(",", "");
            if (((String)(stringAggregation = ((String)stringAggregation).replace(" ", ""))).length() == 6) {
                stringAggregation = (String)stringAggregation + ".0";
                return stringAggregation;
            }
            if (((String)stringAggregation).length() == 7) {
                String stringAggregationNew = ((String)stringAggregation).substring(0, ((String)stringAggregation).length() - 1) + "." + ((String)stringAggregation).substring(((String)stringAggregation).length() - 1, ((String)stringAggregation).length());
                stringAggregation = stringAggregationNew + ".0";
                return stringAggregation;
            }
            if (((String)stringAggregation).length() == 8) {
                String stringAggregationNew = ((String)stringAggregation).substring(0, ((String)stringAggregation).length() - 2) + "." + ((String)stringAggregation).substring(((String)stringAggregation).length() - 2, ((String)stringAggregation).length());
                stringAggregation = stringAggregationNew;
                return stringAggregation;
            }
        } else if (Utils4KST.testPattern(qrgString, "((\\b[0-4]{1}[\\d]{2}\\b)([\\.|,][\\d]{1,2}\\b)?)")) {
            stringAggregation = qrgString;
            stringAggregation = ((String)stringAggregation).replace(".", "");
            stringAggregation = ((String)stringAggregation).replace(",", "");
            if (((String)(stringAggregation = ((String)stringAggregation).replace(" ", ""))).length() == 3) {
                String stringAggregationNew = optionalPrefix.getValue() + (String)stringAggregation;
                stringAggregation = stringAggregationNew + ".0";
                return stringAggregation;
            }
            if (((String)stringAggregation).length() == 4) {
                stringAggregation = optionalPrefix.getValue() + (String)stringAggregation;
                String stringAggregationNew = ((String)stringAggregation).substring(0, ((String)stringAggregation).length() - 1) + "." + ((String)stringAggregation).substring(((String)stringAggregation).length() - 1, ((String)stringAggregation).length());
                stringAggregation = stringAggregationNew;
                return stringAggregation;
            }
            if (((String)stringAggregation).length() == 5) {
                stringAggregation = optionalPrefix.getValue() + (String)stringAggregation;
                String stringAggregationNew = ((String)stringAggregation).substring(0, ((String)stringAggregation).length() - 2) + "." + ((String)stringAggregation).substring(((String)stringAggregation).length() - 2, ((String)stringAggregation).length());
                stringAggregation = stringAggregationNew;
                return stringAggregation;
            }
        }
        return stringAggregation;
    }
}

