/*
 * Decompiled with CFR 0.152.
 */
package kst4contest.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kst4contest.controller.ChatController;
import kst4contest.controller.DXClusterServerWorkerRunnable;
import kst4contest.controller.Utils4KST;
import kst4contest.model.ChatMember;

public class DXClusterThreadPooledServer
implements Runnable {
    private List<Socket> clientSockets = Collections.synchronizedList(new ArrayList());
    ChatController chatController = null;
    protected int serverPort = 8080;
    protected ServerSocket serverSocket = null;
    protected boolean isStopped = false;
    protected Thread runningThread = null;
    protected ExecutorService threadPool = Executors.newFixedThreadPool(10);
    Socket clientSocket;

    public DXClusterThreadPooledServer(int port, ChatController chatController) {
        this.serverPort = port;
        this.chatController = chatController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this;
        synchronized (object) {
            this.runningThread = Thread.currentThread();
            this.runningThread.setName("DXCluster-thread-pooled-server");
        }
        this.openServerSocket();
        while (!this.isStopped()) {
            this.clientSocket = null;
            try {
                this.clientSocket = this.serverSocket.accept();
                object = this.clientSockets;
                synchronized (object) {
                    this.clientSockets.add(this.clientSocket);
                }
            }
            catch (IOException e) {
                if (this.isStopped()) {
                    System.out.println("Server Stopped.");
                    break;
                }
                throw new RuntimeException("Error accepting client connection", e);
            }
            DXClusterServerWorkerRunnable worker = new DXClusterServerWorkerRunnable(this.clientSocket, "Thread Pooled DXCluster Server ", this.chatController, this.clientSockets);
            this.threadPool.execute(worker);
        }
        this.threadPool.shutdown();
        System.out.println("Server Stopped.");
    }

    private synchronized boolean isStopped() {
        return this.isStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        this.isStopped = true;
        try {
            this.serverSocket.close();
            List<Socket> list = this.clientSockets;
            synchronized (list) {
                for (Socket socket : this.clientSockets) {
                    socket.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("DXCCSERVER Error closing server", e);
        }
    }

    private void openServerSocket() {
        try {
            this.serverSocket = new ServerSocket(this.serverPort);
        }
        catch (IOException e) {
            throw new RuntimeException("DXCCSERVER Cannot open port ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean broadcastSingleDXClusterEntryToLoggers(ChatMember aChatMember) {
        List<Socket> list = this.clientSockets;
        synchronized (list) {
            System.out.println("DXClusterSrvr: broadcasting message to clients: " + this.clientSockets.size());
            try {
                System.out.println("-------------> ORIGINALEE VAL: " + aChatMember.getFrequency().getValue());
                System.out.println("-------------> NORMALIZED VAL: " + Utils4KST.normalizeFrequencyString(aChatMember.getFrequency().getValue(), this.chatController.getChatPreferences().getNotify_optionalFrequencyPrefix()) + " ");
            }
            catch (Exception e) {
                System.out.println("DXCThPooledServer: Error accessing value in chatmember object: " + e.getMessage());
            }
            for (Socket socket : this.clientSockets) {
                try {
                    OutputStream output = socket.getOutputStream();
                    Object singleDXClusterMessage = "DX de ";
                    singleDXClusterMessage = (String)singleDXClusterMessage + this.chatController.getChatPreferences().getNotify_DXCSrv_SpottersCallSign().getValue() + ":   ";
                    singleDXClusterMessage = (String)singleDXClusterMessage + Utils4KST.normalizeFrequencyString(aChatMember.getFrequency().getValue(), this.chatController.getChatPreferences().getNotify_optionalFrequencyPrefix()) + "  ";
                    singleDXClusterMessage = (String)singleDXClusterMessage + aChatMember.getCallSign().toUpperCase() + "             ";
                    singleDXClusterMessage = (String)singleDXClusterMessage + aChatMember.getQra().toUpperCase() + "  ";
                    singleDXClusterMessage = (String)singleDXClusterMessage + new Utils4KST().time_generateCurrenthhmmZTimeStringForClusterMessage() + "\u0007\u0007\r\n";
                    output.write(((String)singleDXClusterMessage).getBytes());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.out.println("[DXClusterSrvr, Error:] broadcasting DXC-message to clients went wrong!");
                    return false;
                }
            }
        }
        return true;
    }
}

