/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.webkit.prism.PrismGraphicsManager;
import com.sun.javafx.webkit.prism.PrismImage;
import com.sun.javafx.webkit.prism.PrismInvoker;
import com.sun.prism.CompositeMode;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.PrinterGraphics;
import com.sun.prism.RTTexture;
import com.sun.prism.ResourceFactory;
import com.sun.prism.ResourceFactoryListener;
import com.sun.prism.Texture;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

final class RTImage
extends PrismImage
implements ResourceFactoryListener {
    private RTTexture txt;
    private final int width;
    private final int height;
    private WeakReference<ResourceFactory> registeredWithFactory = null;
    private ByteBuffer pixelBuffer;
    private float pixelScale;
    private static final PlatformLogger log = PlatformLogger.getLogger((String)RTImage.class.getName());

    RTImage(int n, int n2, float f) {
        if (Float.isNaN(f) || f <= 0.0f || Math.ceil(f) >= 2.147483647E9) {
            throw new IllegalArgumentException("pixelScale out of range");
        }
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("image size must be positive");
        }
        int n3 = (int)Math.ceil(f);
        int n4 = Math.max(n3, 4);
        int n5 = Integer.MAX_VALUE / n4;
        if (n5 / n <= n2) {
            throw new IllegalArgumentException("image size out of range");
        }
        this.width = n;
        this.height = n2;
        this.pixelScale = f;
    }

    @Override
    Image getImage() {
        return Image.fromByteBgraPreData((ByteBuffer)this.getPixelBuffer(), (int)this.getWidth(), (int)this.getHeight());
    }

    @Override
    Graphics getGraphics() {
        RTTexture rTTexture = this.getTexture();
        if (rTTexture == null) {
            return null;
        }
        Graphics graphics = rTTexture.createGraphics();
        graphics.transform(PrismGraphicsManager.getPixelScaleTransform());
        return graphics;
    }

    private RTTexture getTexture() {
        ResourceFactory resourceFactory;
        if (this.txt != null && this.txt.isSurfaceLost()) {
            log.fine("RTImage::getTexture : surface lost: " + this);
        }
        if ((resourceFactory = GraphicsPipeline.getDefaultResourceFactory()) == null || resourceFactory.isDisposed()) {
            log.fine("RTImage::getTexture : return null because device disposed or not ready");
            return null;
        }
        if (this.txt == null) {
            this.txt = resourceFactory.createRTTexture((int)Math.ceil((float)this.width * this.pixelScale), (int)Math.ceil((float)this.height * this.pixelScale), Texture.WrapMode.CLAMP_NOT_NEEDED);
            this.txt.contentsUseful();
            this.txt.makePermanent();
            if (this.registeredWithFactory == null || this.registeredWithFactory.get() != resourceFactory) {
                resourceFactory.addFactoryListener((ResourceFactoryListener)this);
                this.registeredWithFactory = new WeakReference<ResourceFactory>(resourceFactory);
            }
        }
        return this.txt;
    }

    @Override
    void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.txt == null && graphics.getCompositeMode() == CompositeMode.SRC_OVER) {
            return;
        }
        if (graphics.getResourceFactory().isDisposed()) {
            log.fine("RTImage::draw : skip because device has been disposed");
            return;
        }
        if (graphics instanceof PrinterGraphics) {
            int n9 = n7 - n5;
            int n10 = n8 - n6;
            IntBuffer intBuffer = IntBuffer.allocate(n9 * n10);
            PrismInvoker.runOnRenderThread(() -> this.getTexture().readPixels((Buffer)intBuffer));
            Image image = Image.fromIntArgbPreData((IntBuffer)intBuffer, (int)n9, (int)n10);
            Texture texture = graphics.getResourceFactory().createTexture(image, Texture.Usage.STATIC, Texture.WrapMode.CLAMP_NOT_NEEDED);
            graphics.drawTexture(texture, (float)n, (float)n2, (float)n3, (float)n4, 0.0f, 0.0f, (float)n9, (float)n10);
            texture.dispose();
        } else if (this.txt == null) {
            Paint paint = graphics.getPaint();
            graphics.setPaint((Paint)Color.TRANSPARENT);
            graphics.fillQuad((float)n, (float)n2, (float)n3, (float)n4);
            graphics.setPaint(paint);
        } else {
            graphics.drawTexture((Texture)this.txt, (float)n, (float)n2, (float)n3, (float)n4, (float)n5 * this.pixelScale, (float)n6 * this.pixelScale, (float)n7 * this.pixelScale, (float)n8 * this.pixelScale);
        }
    }

    @Override
    void dispose() {
        PrismInvoker.invokeOnRenderThread(() -> {
            if (this.txt != null) {
                this.txt.dispose();
                this.txt = null;
            }
        });
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ByteBuffer getPixelBuffer() {
        boolean bl = false;
        if (this.pixelBuffer == null) {
            this.pixelBuffer = ByteBuffer.allocateDirect(this.width * this.height * 4);
            if (this.pixelBuffer != null) {
                this.pixelBuffer.order(ByteOrder.nativeOrder());
                bl = true;
            }
        }
        if (bl || this.isDirty()) {
            PrismInvoker.runOnRenderThread(() -> {
                ResourceFactory resourceFactory = GraphicsPipeline.getDefaultResourceFactory();
                if (resourceFactory == null || resourceFactory.isDisposed()) {
                    log.fine("RTImage::getPixelBuffer : skip because device disposed or not ready");
                    return;
                }
                this.flushRQ();
                if (this.txt != null && this.pixelBuffer != null) {
                    Object object;
                    PixelFormat pixelFormat = this.txt.getPixelFormat();
                    if (pixelFormat != PixelFormat.INT_ARGB_PRE && pixelFormat != PixelFormat.BYTE_BGRA_PRE) {
                        throw new AssertionError((Object)("Unexpected pixel format: " + pixelFormat));
                    }
                    RTTexture rTTexture = this.txt;
                    if (this.pixelScale != 1.0f) {
                        rTTexture = resourceFactory.createRTTexture(this.width, this.height, Texture.WrapMode.CLAMP_NOT_NEEDED);
                        object = rTTexture.createGraphics();
                        object.drawTexture((Texture)this.txt, 0.0f, 0.0f, (float)this.width, (float)this.height, 0.0f, 0.0f, (float)this.width * this.pixelScale, (float)this.height * this.pixelScale);
                    }
                    this.pixelBuffer.rewind();
                    object = rTTexture.getPixels();
                    if (object != null) {
                        this.pixelBuffer.asIntBuffer().put((int[])object);
                    } else {
                        rTTexture.readPixels((Buffer)this.pixelBuffer);
                    }
                    if (rTTexture != this.txt) {
                        rTTexture.dispose();
                    }
                }
            });
        }
        return this.pixelBuffer;
    }

    @Override
    protected void drawPixelBuffer() {
        PrismInvoker.invokeOnRenderThread(new Runnable(){

            @Override
            public void run() {
                Graphics graphics = RTImage.this.getGraphics();
                if (graphics != null && RTImage.this.pixelBuffer != null) {
                    RTImage.this.pixelBuffer.rewind();
                    Image image = Image.fromByteBgraPreData((ByteBuffer)RTImage.this.pixelBuffer, (int)RTImage.this.width, (int)RTImage.this.height);
                    Texture texture = graphics.getResourceFactory().createTexture(image, Texture.Usage.DEFAULT, Texture.WrapMode.CLAMP_NOT_NEEDED);
                    graphics.clear();
                    graphics.drawTexture(texture, 0.0f, 0.0f, (float)RTImage.this.width, (float)RTImage.this.height);
                    texture.dispose();
                }
            }
        });
    }

    public void factoryReset() {
        if (this.txt != null) {
            this.txt.dispose();
            this.txt = null;
        }
    }

    public void factoryReleased() {
        if (this.txt != null) {
            this.txt.dispose();
            this.txt = null;
        }
    }

    @Override
    public float getPixelScale() {
        return this.pixelScale;
    }
}

